/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import java.util.Hashtable;
import org.apache.xerces.utils.QName;
import org.apache.xerces.validators.common.CMAny;
import org.apache.xerces.validators.common.CMBinOp;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.CMLeaf;
import org.apache.xerces.validators.common.CMNode;
import org.apache.xerces.validators.common.CMStateSet;
import org.apache.xerces.validators.common.CMUniOp;
import org.apache.xerces.validators.common.ContentLeafNameTypeVector;
import org.apache.xerces.validators.common.ElementWildcard;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;

public class DFAContentModel
implements XMLContentModel {
    private static final int EPSILON = -2;
    private static final int EOC = -3;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private SubstitutionGroupComparator comparator = null;
    private QName[] fElemMap = null;
    private int[] fElemMapType = null;
    private int fElemMapSize = 0;
    private boolean fDTD;
    private boolean fMixed;
    private int fEOCIndex = 0;
    private int fEOCPos = 0;
    private int fEpsilonIndex = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private CMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private ContentLeafNameTypeVector fLeafNameTypeVector = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private boolean fEmptyContentIsValid = false;
    private QName fQName = new QName();
    private static long time = 0L;
    private byte[][] fConflictTable;

    public DFAContentModel(CMNode syntaxTree, int leafCount) throws CMException {
        this(syntaxTree, leafCount, false, false);
    }

    public DFAContentModel(CMNode syntaxTree, int leafCount, boolean dtd, boolean mixed) throws CMException {
        this.fLeafCount = leafCount;
        this.fEpsilonIndex = -2;
        this.fEOCIndex = -3;
        this.fDTD = dtd;
        this.fMixed = mixed;
        time -= System.currentTimeMillis();
        this.buildDFA(syntaxTree);
        time += System.currentTimeMillis();
    }

    public int validateContent(QName[] children, int offset, int length) throws CMException {
        if (length == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int curState = 0;
        int nextState = 0;
        int childIndex = 0;
        while (childIndex < length) {
            QName curElem = children[offset + childIndex];
            if (!this.fMixed || curElem.localpart != -1) {
                int elemIndex = 0;
                while (elemIndex < this.fElemMapSize) {
                    int type;
                    if (this.fDTD ? this.fElemMap[elemIndex].rawname == curElem.rawname && (nextState = this.fTransTable[curState][elemIndex]) != -1 : ((type = this.fElemMapType[elemIndex] & 0xF) == 0 ? this.fElemMap[elemIndex].uri == curElem.uri && this.fElemMap[elemIndex].localpart == curElem.localpart && (nextState = this.fTransTable[curState][elemIndex]) != -1 : (type == 6 ? (nextState = this.fTransTable[curState][elemIndex]) != -1 : (type == 8 ? curElem.uri == this.fElemMap[elemIndex].uri && (nextState = this.fTransTable[curState][elemIndex]) != -1 : type == 7 && this.fElemMap[elemIndex].uri != curElem.uri && (nextState = this.fTransTable[curState][elemIndex]) != -1)))) break;
                    ++elemIndex;
                }
                if (nextState == -1) {
                    return childIndex;
                }
                if (elemIndex == this.fElemMapSize) {
                    return childIndex;
                }
                curState = nextState;
                nextState = 0;
            }
            ++childIndex;
        }
        if (!this.fFinalStateFlags[curState]) {
            return length;
        }
        return -1;
    }

    private boolean isEqual(QName name1, QName name2) {
        return name1.localpart == name2.localpart && name1.uri == name2.uri;
    }

    public int validateContentSpecial(QName[] children, int offset, int length) throws Exception {
        if (this.comparator == null) {
            return this.validateContent(children, offset, length);
        }
        if (length == 0) {
            return this.fEmptyContentIsValid ? -1 : 0;
        }
        int curState = 0;
        int nextState = 0;
        int childIndex = 0;
        while (childIndex < length) {
            QName curElem = children[offset + childIndex];
            int elemIndex = 0;
            while (elemIndex < this.fElemMapSize) {
                int type = this.fElemMapType[elemIndex] & 0xF;
                if (type == 0 ? this.comparator.isEquivalentTo(curElem, this.fElemMap[elemIndex]) && (nextState = this.fTransTable[curState][elemIndex]) != -1 : (type == 6 ? (nextState = this.fTransTable[curState][elemIndex]) != -1 : (type == 8 ? curElem.uri == this.fElemMap[elemIndex].uri && (nextState = this.fTransTable[curState][elemIndex]) != -1 : type == 7 && this.fElemMap[elemIndex].uri != curElem.uri && (nextState = this.fTransTable[curState][elemIndex]) != -1))) break;
                ++elemIndex;
            }
            if (nextState == -1) {
                return childIndex;
            }
            if (elemIndex == this.fElemMapSize) {
                return childIndex;
            }
            curState = nextState;
            nextState = 0;
            ++childIndex;
        }
        if (!this.fFinalStateFlags[curState]) {
            return length;
        }
        return -1;
    }

    public boolean isFinalState(int state) {
        if (state < 0) {
            return false;
        }
        return this.fFinalStateFlags[state];
    }

    public int oneTransition(QName curElem, int[] stateStack, int curPos) throws Exception {
        int curState = stateStack[curPos];
        if (curState < 0) {
            return -1;
        }
        int nextState = 0;
        int elemIndex = 0;
        while (elemIndex < this.fElemMapSize) {
            int type = this.fElemMapType[elemIndex] & 0xF;
            if (type == 0 ? this.isEqual(curElem, this.fElemMap[elemIndex]) && (nextState = this.fTransTable[curState][elemIndex]) != -1 : (type == 6 ? (nextState = this.fTransTable[curState][elemIndex]) != -1 : (type == 8 ? curElem.uri == this.fElemMap[elemIndex].uri && (nextState = this.fTransTable[curState][elemIndex]) != -1 : type == 7 && this.fElemMap[elemIndex].uri != curElem.uri && (nextState = this.fTransTable[curState][elemIndex]) != -1))) break;
            ++elemIndex;
        }
        if (elemIndex == this.fElemMapSize && this.comparator != null) {
            elemIndex = 0;
            while (elemIndex < this.fElemMapSize) {
                if (this.fElemMapType[elemIndex] == 0 && this.comparator.isEquivalentTo(curElem, this.fElemMap[elemIndex]) && (nextState = this.fTransTable[curState][elemIndex]) != -1) break;
                ++elemIndex;
            }
        }
        if (elemIndex == this.fElemMapSize) {
            stateStack[curPos] = -1;
            return -1;
        }
        stateStack[curPos] = nextState;
        return elemIndex;
    }

    public void setSubstitutionGroupComparator(SubstitutionGroupComparator comparator) {
        this.comparator = comparator;
    }

    public int whatCanGoHere(boolean fullyValid, InsertableElementsInfo info) throws CMException {
        int curState = 0;
        int childIndex = 0;
        while (childIndex < info.insertAt) {
            QName curElem = info.curChildren[childIndex];
            int elemIndex = 0;
            while (elemIndex < this.fElemMapSize) {
                if (this.fElemMap[elemIndex].uri == curElem.uri && this.fElemMap[elemIndex].localpart == curElem.localpart) break;
                ++elemIndex;
            }
            if (elemIndex == this.fElemMapSize) {
                return childIndex;
            }
            if ((curState = this.fTransTable[curState][elemIndex]) == -1) {
                return childIndex;
            }
            ++childIndex;
        }
        int insertState = curState;
        info.canHoldPCData = this.fMixed;
        info.isValidEOC = this.fFinalStateFlags[insertState];
        info.resultsCount = this.fElemMapSize;
        if (info.results == null || info.results.length < info.resultsCount) {
            info.results = new boolean[info.resultsCount];
        }
        if (info.possibleChildren == null || info.possibleChildren.length < info.resultsCount) {
            info.possibleChildren = new QName[info.resultsCount];
            int i = 0;
            while (i < info.possibleChildren.length) {
                info.possibleChildren[i] = new QName();
                ++i;
            }
        }
        int index = 0;
        while (index < this.fElemMapSize) {
            info.possibleChildren[index].setValues(this.fElemMap[index]);
            info.results[index] = this.fTransTable[insertState][index] != -1;
            ++index;
        }
        if (fullyValid) {
            index = 0;
            while (index < info.resultsCount) {
                if (info.results[index]) {
                    info.curChildren[info.insertAt] = info.possibleChildren[index];
                    if (this.validateContent(info.curChildren, 0, info.childCount) != -1) {
                        info.results[index] = false;
                    }
                }
                ++index;
            }
        }
        return -1;
    }

    public ContentLeafNameTypeVector getContentLeafNameTypeVector() {
        return this.fLeafNameTypeVector;
    }

    public void checkUniqueParticleAttribution(SchemaGrammar gram) throws Exception {
        int i = 0;
        while (i < this.fElemMapSize) {
            this.fElemMap[i].uri = gram.getContentSpecOrgUri(this.fElemMap[i].uri);
            ++i;
        }
        this.fConflictTable = new byte[this.fElemMapSize][this.fElemMapSize];
        int j = 0;
        while (j < this.fElemMapSize) {
            int k = j + 1;
            while (k < this.fElemMapSize) {
                this.fConflictTable[j][k] = -1;
                ++k;
            }
            ++j;
        }
        i = 0;
        while (i < this.fTransTable.length && this.fTransTable[i] != null) {
            int j2 = 0;
            while (j2 < this.fElemMapSize) {
                int k = j2 + 1;
                while (k < this.fElemMapSize) {
                    if (this.fTransTable[i][j2] != -1 && this.fTransTable[i][k] != -1 && this.fConflictTable[j2][k] == -1) {
                        this.fConflictTable[j2][k] = ElementWildcard.conflict(this.fElemMapType[j2], this.fElemMap[j2].localpart, this.fElemMap[j2].uri, this.fElemMapType[k], this.fElemMap[k].localpart, this.fElemMap[k].uri, this.comparator) ? (byte)1 : 0;
                    }
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        this.fConflictTable = null;
    }

    private void buildDFA(CMNode syntaxTree) throws CMException {
        this.fQName.setValues(-1, this.fEOCIndex, this.fEOCIndex);
        CMLeaf nodeEOC = new CMLeaf(this.fQName);
        this.fHeadNode = new CMBinOp(5, syntaxTree, nodeEOC);
        this.fEOCPos = this.fLeafCount;
        nodeEOC.setPosition(this.fLeafCount++);
        this.fLeafList = new CMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode, 0);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int index = 0;
        while (index < this.fLeafCount) {
            this.fFollowList[index] = new CMStateSet(this.fLeafCount);
            ++index;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new QName[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        int outIndex = 0;
        while (outIndex < this.fLeafCount) {
            this.fElemMap[outIndex] = new QName();
            if ((this.fLeafListType[outIndex] & 0xF) != 0 && this.fLeafNameTypeVector == null) {
                this.fLeafNameTypeVector = new ContentLeafNameTypeVector();
            }
            QName element = this.fLeafList[outIndex].getElement();
            int inIndex = 0;
            while (inIndex < this.fElemMapSize) {
                if (this.fDTD ? this.fElemMap[inIndex].rawname == element.rawname : this.fElemMapType[inIndex] == this.fLeafListType[outIndex] && this.fElemMap[inIndex].uri == element.uri && this.fElemMap[inIndex].localpart == element.localpart) break;
                ++inIndex;
            }
            if (inIndex == this.fElemMapSize) {
                this.fElemMap[this.fElemMapSize].setValues(element);
                this.fElemMapType[this.fElemMapSize] = this.fLeafListType[outIndex];
                ++this.fElemMapSize;
            }
            ++outIndex;
        }
        if (this.fLeafNameTypeVector != null) {
            this.fLeafNameTypeVector.setValues(this.fElemMap, this.fElemMapType, this.fElemMapSize);
        }
        int[] fLeafSorter = new int[this.fLeafCount + this.fElemMapSize];
        int fSortCount = 0;
        int elemIndex = 0;
        while (elemIndex < this.fElemMapSize) {
            int leafIndex = 0;
            while (leafIndex < this.fLeafCount) {
                QName leaf = this.fLeafList[leafIndex].getElement();
                int leafType = this.fLeafListType[leafIndex];
                QName element = this.fElemMap[elemIndex];
                if (this.fDTD) {
                    if (leaf.rawname == element.rawname) {
                        fLeafSorter[fSortCount++] = leafIndex;
                    }
                } else if (this.fElemMapType[elemIndex] == this.fLeafListType[leafIndex] && leaf.uri == element.uri && leaf.localpart == element.localpart) {
                    fLeafSorter[fSortCount++] = leafIndex;
                }
                ++leafIndex;
            }
            fLeafSorter[fSortCount++] = -1;
            ++elemIndex;
        }
        int curArraySize = this.fLeafCount * 4;
        CMStateSet[] statesToDo = new CMStateSet[curArraySize];
        this.fFinalStateFlags = new boolean[curArraySize];
        this.fTransTable = new int[curArraySize][];
        CMStateSet setT = this.fHeadNode.firstPos();
        int unmarkedState = 0;
        int curState = 0;
        this.fTransTable[curState] = this.makeDefStateList();
        statesToDo[curState] = setT;
        ++curState;
        Hashtable<CMStateSet, Integer> stateTable = new Hashtable<CMStateSet, Integer>();
        while (unmarkedState < curState) {
            setT = statesToDo[unmarkedState];
            int[] transEntry = this.fTransTable[unmarkedState];
            this.fFinalStateFlags[unmarkedState] = setT.getBit(this.fEOCPos);
            ++unmarkedState;
            CMStateSet newSet = null;
            int sorterIndex = 0;
            int elemIndex2 = 0;
            while (elemIndex2 < this.fElemMapSize) {
                if (newSet == null) {
                    newSet = new CMStateSet(this.fLeafCount);
                } else {
                    newSet.zeroBits();
                }
                int leafIndex = fLeafSorter[sorterIndex++];
                while (leafIndex != -1) {
                    if (setT.getBit(leafIndex)) {
                        newSet.union(this.fFollowList[leafIndex]);
                    }
                    leafIndex = fLeafSorter[sorterIndex++];
                }
                if (!newSet.isEmpty()) {
                    int stateIndex;
                    Integer stateObj = (Integer)stateTable.get(newSet);
                    int n = stateIndex = stateObj == null ? curState : stateObj;
                    if (stateIndex == curState) {
                        statesToDo[curState] = newSet;
                        this.fTransTable[curState] = this.makeDefStateList();
                        stateTable.put(newSet, new Integer(curState));
                        ++curState;
                        newSet = null;
                    }
                    transEntry[elemIndex2] = stateIndex;
                    if (curState == curArraySize) {
                        int newSize = (int)((double)curArraySize * 1.5);
                        CMStateSet[] newToDo = new CMStateSet[newSize];
                        boolean[] newFinalFlags = new boolean[newSize];
                        int[][] newTransTable = new int[newSize][];
                        int expIndex = 0;
                        while (expIndex < curArraySize) {
                            newToDo[expIndex] = statesToDo[expIndex];
                            newFinalFlags[expIndex] = this.fFinalStateFlags[expIndex];
                            newTransTable[expIndex] = this.fTransTable[expIndex];
                            ++expIndex;
                        }
                        curArraySize = newSize;
                        statesToDo = newToDo;
                        this.fFinalStateFlags = newFinalFlags;
                        this.fTransTable = newTransTable;
                    }
                }
                ++elemIndex2;
            }
        }
        this.fEmptyContentIsValid = ((CMBinOp)this.fHeadNode).getLeft().isNullable();
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
    }

    private void calcFollowList(CMNode nodeCur) throws CMException {
        if (nodeCur.type() == 4) {
            this.calcFollowList(((CMBinOp)nodeCur).getLeft());
            this.calcFollowList(((CMBinOp)nodeCur).getRight());
        } else if (nodeCur.type() == 5) {
            this.calcFollowList(((CMBinOp)nodeCur).getLeft());
            this.calcFollowList(((CMBinOp)nodeCur).getRight());
            CMStateSet last = ((CMBinOp)nodeCur).getLeft().lastPos();
            CMStateSet first = ((CMBinOp)nodeCur).getRight().firstPos();
            int index = 0;
            while (index < this.fLeafCount) {
                if (last.getBit(index)) {
                    this.fFollowList[index].union(first);
                }
                ++index;
            }
        } else if (nodeCur.type() == 2 || nodeCur.type() == 3) {
            this.calcFollowList(((CMUniOp)nodeCur).getChild());
            CMStateSet first = nodeCur.firstPos();
            CMStateSet last = nodeCur.lastPos();
            int index = 0;
            while (index < this.fLeafCount) {
                if (last.getBit(index)) {
                    this.fFollowList[index].union(first);
                }
                ++index;
            }
        } else if (nodeCur.type() == 1) {
            this.calcFollowList(((CMUniOp)nodeCur).getChild());
        }
    }

    private void dumpTree(CMNode nodeCur, int level) throws CMException {
        int index = 0;
        while (index < level) {
            System.out.print("   ");
            ++index;
        }
        int type = nodeCur.type();
        switch (type & 0xF) {
            case 4: 
            case 5: {
                if (type == 4) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (nodeCur.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                this.dumpTree(((CMBinOp)nodeCur).getLeft(), level + 1);
                this.dumpTree(((CMBinOp)nodeCur).getRight(), level + 1);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                System.out.print("Rep Node ");
                if (nodeCur.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                this.dumpTree(((CMUniOp)nodeCur).getChild(), level + 1);
                break;
            }
            case 0: {
                System.out.print("Leaf: (pos=" + ((CMLeaf)nodeCur).getPosition() + "), " + ((CMLeaf)nodeCur).getElement() + "(elemIndex=" + ((CMLeaf)nodeCur).getElement() + ") ");
                if (nodeCur.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (type == 6) {
                    System.out.print("Any Node: ");
                } else if (type == 22) {
                    System.out.print("Any lax Node: ");
                } else if (type == 38) {
                    System.out.print("Any skip Node: ");
                } else if (type == 7) {
                    System.out.print("Any other Node: ");
                } else if (type == 23) {
                    System.out.print("Any other lax Node: ");
                } else if (type == 39) {
                    System.out.print("Any other skip Node: ");
                } else if (type == 8) {
                    System.out.print("Any namespace Node: ");
                } else if (type == 24) {
                    System.out.print("Any namespace lax Node: ");
                } else if (type == 40) {
                    System.out.print("Any namespace skip Node: ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                break;
            }
            default: {
                throw new CMException(10);
            }
        }
    }

    private int[] makeDefStateList() {
        int[] retArray = new int[this.fElemMapSize];
        int index = 0;
        while (index < this.fElemMapSize) {
            retArray[index] = -1;
            ++index;
        }
        return retArray;
    }

    private int postTreeBuildInit(CMNode nodeCur, int curIndex) throws CMException {
        nodeCur.setMaxStates(this.fLeafCount);
        if ((nodeCur.type() & 0xF) == 6 || (nodeCur.type() & 0xF) == 8 || (nodeCur.type() & 0xF) == 7) {
            QName qname = new QName(-1, -1, -1, ((CMAny)nodeCur).getURI());
            this.fLeafList[curIndex] = new CMLeaf(qname, ((CMAny)nodeCur).getPosition());
            this.fLeafListType[curIndex] = nodeCur.type();
            ++curIndex;
        } else if (nodeCur.type() == 4 || nodeCur.type() == 5) {
            curIndex = this.postTreeBuildInit(((CMBinOp)nodeCur).getLeft(), curIndex);
            curIndex = this.postTreeBuildInit(((CMBinOp)nodeCur).getRight(), curIndex);
        } else if (nodeCur.type() == 2 || nodeCur.type() == 3 || nodeCur.type() == 1) {
            curIndex = this.postTreeBuildInit(((CMUniOp)nodeCur).getChild(), curIndex);
        } else if (nodeCur.type() == 0) {
            QName node = ((CMLeaf)nodeCur).getElement();
            if (node.localpart != this.fEpsilonIndex) {
                this.fLeafList[curIndex] = (CMLeaf)nodeCur;
                this.fLeafListType[curIndex] = 0;
                ++curIndex;
            }
        } else {
            throw new CMException(10);
        }
        return curIndex;
    }
}

