/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;

public class ElementWildcard {
    private ElementWildcard() {
    }

    private static boolean uriInWildcard(QName qname, int wildcard, int wtype, SubstitutionGroupComparator comparator) throws Exception {
        int type = wtype & 0xF;
        if (type == 6) {
            return true;
        }
        return type == 8 ? (comparator != null ? comparator.isAllowedByWildcard(qname, wildcard, false) : qname.uri == wildcard) : type == 7 && (comparator != null ? comparator.isAllowedByWildcard(qname, wildcard, true) : wildcard != qname.uri);
    }

    private static boolean wildcardIntersect(int w1, int t1, int w2, int t2) {
        int type1 = t1 & 0xF;
        int type2 = t2 & 0xF;
        if (type1 == 6 || type2 == 6) {
            return true;
        }
        if (type1 == 8 && type2 == 8 && w1 == w2) {
            return true;
        }
        if (type1 == 7 && type2 == 7) {
            return true;
        }
        return (type1 == 8 && type2 == 7 || type1 == 7 && type2 == 8) && w1 != w2;
    }

    private static boolean conflic(int type1, int local1, int uri1, int type2, int local2, int uri2, SubstitutionGroupComparator comparator) throws Exception {
        QName q1 = new QName();
        QName q2 = new QName();
        q1.localpart = local1;
        q1.uri = uri1;
        q2.localpart = local2;
        q2.uri = uri2;
        return type1 == 0 && type2 == 0 ? (comparator != null ? comparator.isEquivalentTo(q1, q2) || comparator.isEquivalentTo(q2, q1) : q1.localpart == q2.localpart && q1.uri == q2.uri) : (type1 == 0 ? ElementWildcard.uriInWildcard(q1, uri2, type2, comparator) : (type2 == 0 ? ElementWildcard.uriInWildcard(q2, uri1, type1, comparator) : ElementWildcard.wildcardIntersect(uri1, type1, uri2, type2)));
    }

    public static boolean conflict(int type1, int local1, int uri1, int type2, int local2, int uri2, SubstitutionGroupComparator comparator) throws Exception {
        boolean ret = ElementWildcard.conflic(type1, local1, uri1, type2, local2, uri2, comparator);
        if (ret && comparator != null) {
            StringPool stringPool = comparator.getStringPool();
            XMLErrorReporter err = comparator.getErrorReporter();
            err.reportError(err.getLocator(), "http://www.w3.org/TR/xml-schema-1", 52, 0, new Object[]{ElementWildcard.eleString(type1, local1, uri1, stringPool), ElementWildcard.eleString(type2, local2, uri2, stringPool)}, 1);
        }
        return ret;
    }

    private static String eleString(int type, int local, int uri, StringPool stringPool) {
        switch (type & 0xF) {
            case 0: {
                return String.valueOf(stringPool.toString(uri)) + "," + stringPool.toString(local);
            }
            case 6: {
                return "##any,*";
            }
            case 8: {
                return "##any(" + stringPool.toString(uri) + "),*";
            }
            case 7: {
                return "##other(" + stringPool.toString(uri) + "),*";
            }
        }
        return "";
    }
}

