/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import java.util.Vector;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.utils.Hash2intTable;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.AllContentModel;
import org.apache.xerces.validators.common.CMAny;
import org.apache.xerces.validators.common.CMBinOp;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.CMLeaf;
import org.apache.xerces.validators.common.CMNode;
import org.apache.xerces.validators.common.CMUniOp;
import org.apache.xerces.validators.common.DFAContentModel;
import org.apache.xerces.validators.common.MixedContentModel;
import org.apache.xerces.validators.common.SimpleContentModel;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;
import org.w3c.dom.Document;

public class Grammar
implements XMLContentSpec.Provider {
    public static final int TOP_LEVEL_SCOPE = -1;
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private static final int LIST_FLAG = 32768;
    private static final int LIST_MASK = -32769;
    private int fTargetNamespace;
    private Document fGrammarDocument;
    private int fElementDeclCount = 0;
    private QName[][] fElementDeclName = new QName[4][];
    private int[][] fElementDeclType = new int[4][];
    private DatatypeValidator[][] fElementDeclDatatypeValidator = new DatatypeValidator[4][];
    private int[][] fElementDeclContentSpecIndex = new int[4][];
    private int[][] fElementDeclFirstAttributeDeclIndex = new int[4][];
    private int[][] fElementDeclLastAttributeDeclIndex = new int[4][];
    private Vector[][] fElementDeclUnique = new Vector[4][];
    private Vector[][] fElementDeclKey = new Vector[4][];
    private Vector[][] fElementDeclKeyRef = new Vector[4][];
    private int fContentSpecCount = 0;
    private int[][] fContentSpecType = new int[4][];
    private int[][] fContentSpecValue = new int[4][];
    private int[][] fContentSpecOtherValue = new int[4][];
    private XMLContentModel[][] fContentSpecValidator = new XMLContentModel[4][];
    private int fAttributeDeclCount = 0;
    private QName[][] fAttributeDeclName = new QName[4][];
    private int[][] fAttributeDeclType = new int[4][];
    private int[][] fAttributeDeclEnumeration = new int[4][];
    private int[][] fAttributeDeclDefaultType = new int[4][];
    private DatatypeValidator[][] fAttributeDeclDatatypeValidator = new DatatypeValidator[4][];
    private String[][] fAttributeDeclDefaultValue = new String[4][];
    private int[][] fAttributeDeclNextAttributeDeclIndex = new int[4][];
    private Hash2intTable fElementNameAndScopeToElementDeclIndexMapping = new Hash2intTable();
    private QName fQName1 = new QName();
    private QName fQName2 = new QName();
    private int fLeafCount = 0;
    private int fEpsilonIndex = -1;

    public Document getGrammarDocument() {
        return this.fGrammarDocument;
    }

    public int getElementDeclIndex(int localpartIndex, int scopeIndex) {
        if (localpartIndex > -1 && scopeIndex > -2) {
            return this.fElementNameAndScopeToElementDeclIndexMapping.get(0, localpartIndex, scopeIndex);
        }
        return -1;
    }

    public int getElementDeclIndex(int uriIndex, int localpartIndex, int scopeIndex) {
        if (localpartIndex > -1 && scopeIndex > -2) {
            return this.fElementNameAndScopeToElementDeclIndexMapping.get(uriIndex, localpartIndex, scopeIndex);
        }
        return -1;
    }

    public int getElementDeclIndex(QName element, int scopeIndex) {
        if (element.localpart > -1 && scopeIndex > -2) {
            return this.fElementNameAndScopeToElementDeclIndexMapping.get(element.uri, element.localpart, scopeIndex);
        }
        return -1;
    }

    public boolean getElementDecl(int elementDeclIndex, XMLElementDecl elementDecl) {
        if (elementDeclIndex < 0 || elementDeclIndex >= this.fElementDeclCount) {
            return false;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        elementDecl.name.setValues(this.fElementDeclName[chunk][index]);
        if (this.fElementDeclType[chunk][index] == -1) {
            elementDecl.type = -1;
            elementDecl.list = false;
        } else {
            elementDecl.type = this.fElementDeclType[chunk][index] & 0xFFFF7FFF;
            elementDecl.list = (this.fElementDeclType[chunk][index] & 0x8000) != 0;
        }
        elementDecl.datatypeValidator = this.fElementDeclDatatypeValidator[chunk][index];
        elementDecl.contentSpecIndex = this.fElementDeclContentSpecIndex[chunk][index];
        elementDecl.unique.removeAllElements();
        int ucount = this.fElementDeclUnique[chunk][index] != null ? this.fElementDeclUnique[chunk][index].size() : 0;
        int i = 0;
        while (i < ucount) {
            elementDecl.unique.addElement(this.fElementDeclUnique[chunk][index].elementAt(i));
            ++i;
        }
        elementDecl.key.removeAllElements();
        int kcount = this.fElementDeclKey[chunk][index] != null ? this.fElementDeclKey[chunk][index].size() : 0;
        int i2 = 0;
        while (i2 < kcount) {
            elementDecl.key.addElement(this.fElementDeclKey[chunk][index].elementAt(i2));
            ++i2;
        }
        elementDecl.keyRef.removeAllElements();
        int krcount = this.fElementDeclKeyRef[chunk][index] != null ? this.fElementDeclKeyRef[chunk][index].size() : 0;
        int i3 = 0;
        while (i3 < krcount) {
            elementDecl.keyRef.addElement(this.fElementDeclKeyRef[chunk][index].elementAt(i3));
            ++i3;
        }
        return true;
    }

    public int getFirstAttributeDeclIndex(int elementDeclIndex) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fElementDeclFirstAttributeDeclIndex[chunk][index];
    }

    public int getNextAttributeDeclIndex(int attributeDeclIndex) {
        int chunk = attributeDeclIndex >> 8;
        int index = attributeDeclIndex & 0xFF;
        return this.fAttributeDeclNextAttributeDeclIndex[chunk][index];
    }

    public boolean getContentSpec(int contentSpecIndex, XMLContentSpec contentSpec) {
        if (contentSpecIndex < 0 || contentSpecIndex >= this.fContentSpecCount) {
            return false;
        }
        int chunk = contentSpecIndex >> 8;
        int index = contentSpecIndex & 0xFF;
        contentSpec.type = this.fContentSpecType[chunk][index];
        contentSpec.value = this.fContentSpecValue[chunk][index];
        contentSpec.otherValue = this.fContentSpecOtherValue[chunk][index];
        return true;
    }

    protected void clearContentModel(int contentSpecIndex) {
        if (contentSpecIndex < 0 || contentSpecIndex >= this.fContentSpecCount) {
            return;
        }
        int chunk = contentSpecIndex >> 8;
        int index = contentSpecIndex & 0xFF;
        this.fContentSpecValidator[chunk][index] = null;
    }

    protected boolean existContentModel(int contentSpecIndex) {
        if (contentSpecIndex < 0 || contentSpecIndex >= this.fContentSpecCount) {
            return false;
        }
        int chunk = contentSpecIndex >> 8;
        int index = contentSpecIndex & 0xFF;
        return this.fContentSpecValidator[chunk][index] != null;
    }

    public XMLContentModel getElementContentModel(int elementDeclIndex, SubstitutionGroupComparator comparator) throws Exception {
        if (elementDeclIndex < 0 || elementDeclIndex >= this.fElementDeclCount) {
            return null;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        int contentType = this.fElementDeclType[chunk][index];
        return this.getContentModel(this.fElementDeclContentSpecIndex[chunk][index], contentType, comparator);
    }

    public XMLContentModel getContentModel(int contentSpecIndex, int contentType, SubstitutionGroupComparator comparator) throws Exception {
        if (contentSpecIndex < 0 || contentSpecIndex >= this.fContentSpecCount) {
            return null;
        }
        int chunk = contentSpecIndex >> 8;
        int index = contentSpecIndex & 0xFF;
        XMLContentModel contentModel = this.fContentSpecValidator[chunk][index];
        if (contentModel != null) {
            return contentModel;
        }
        if (contentType == 5) {
            return null;
        }
        int expendedIndex = this.convertContentSpecTree(contentSpecIndex);
        XMLContentSpec contentSpec = new XMLContentSpec();
        this.getContentSpec(expendedIndex, contentSpec);
        if (contentType == 2) {
            Vector vQName = new Vector();
            ChildrenList children = new ChildrenList();
            this.contentSpecTree(expendedIndex, contentSpec, children);
            contentModel = new MixedContentModel(children.qname, children.type, 0, children.length, false, this.isDTD());
        } else if (contentType == 3) {
            contentModel = this.createChildModel(expendedIndex, true);
        } else if (contentType == 4) {
            contentModel = this.createChildModel(expendedIndex, false);
        } else {
            throw new CMException(8);
        }
        this.fContentSpecValidator[chunk][index] = contentModel;
        if (contentModel != null) {
            contentModel.setSubstitutionGroupComparator(comparator);
        }
        return contentModel;
    }

    public boolean getAttributeDecl(int attributeDeclIndex, XMLAttributeDecl attributeDecl) {
        if (attributeDeclIndex < 0 || attributeDeclIndex >= this.fAttributeDeclCount) {
            return false;
        }
        int chunk = attributeDeclIndex >> 8;
        int index = attributeDeclIndex & 0xFF;
        attributeDecl.name.setValues(this.fAttributeDeclName[chunk][index]);
        if (this.fAttributeDeclType[chunk][index] == -1) {
            attributeDecl.type = -1;
            attributeDecl.list = false;
        } else {
            attributeDecl.type = this.fAttributeDeclType[chunk][index] & 0xFFFF7FFF;
            attributeDecl.list = (this.fAttributeDeclType[chunk][index] & 0x8000) != 0;
        }
        attributeDecl.datatypeValidator = this.fAttributeDeclDatatypeValidator[chunk][index];
        attributeDecl.enumeration = this.fAttributeDeclEnumeration[chunk][index];
        attributeDecl.defaultType = this.fAttributeDeclDefaultType[chunk][index];
        attributeDecl.defaultValue = this.fAttributeDeclDefaultValue[chunk][index];
        return true;
    }

    protected void setGrammarDocument(Document grammarDocument) {
        this.fGrammarDocument = grammarDocument;
    }

    protected int convertContentSpecTree(int index) {
        return index;
    }

    protected int createElementDecl() {
        int chunk = this.fElementDeclCount >> 8;
        int index = this.fElementDeclCount & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        this.fElementDeclName[chunk][index] = new QName();
        this.fElementDeclType[chunk][index] = -1;
        this.fElementDeclDatatypeValidator[chunk][index] = null;
        this.fElementDeclContentSpecIndex[chunk][index] = -1;
        this.fElementDeclFirstAttributeDeclIndex[chunk][index] = -1;
        this.fElementDeclLastAttributeDeclIndex[chunk][index] = -1;
        return this.fElementDeclCount++;
    }

    protected void setElementDecl(int elementDeclIndex, XMLElementDecl elementDecl) {
        int krcount;
        int kcount;
        if (elementDeclIndex < 0 || elementDeclIndex >= this.fElementDeclCount) {
            return;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.fElementDeclName[chunk][index].setValues(elementDecl.name);
        this.fElementDeclType[chunk][index] = elementDecl.type;
        if (elementDecl.list) {
            int[] nArray = this.fElementDeclType[chunk];
            int n = index;
            nArray[n] = nArray[n] | 0x8000;
        }
        this.fElementDeclDatatypeValidator[chunk][index] = elementDecl.datatypeValidator;
        this.fElementDeclContentSpecIndex[chunk][index] = elementDecl.contentSpecIndex;
        int ucount = elementDecl.unique.size();
        if (ucount > 0) {
            if (this.fElementDeclUnique[chunk][index] == null) {
                this.fElementDeclUnique[chunk][index] = (Vector)elementDecl.unique.clone();
            } else {
                this.fElementDeclUnique[chunk][index].removeAllElements();
                int i = 0;
                while (i < ucount) {
                    this.fElementDeclUnique[chunk][index].addElement(elementDecl.unique.elementAt(i));
                    ++i;
                }
            }
        }
        if ((kcount = elementDecl.key.size()) > 0) {
            if (this.fElementDeclKey[chunk][index] == null) {
                this.fElementDeclKey[chunk][index] = (Vector)elementDecl.key.clone();
            } else {
                this.fElementDeclKey[chunk][index].removeAllElements();
                int i = 0;
                while (i < kcount) {
                    this.fElementDeclKey[chunk][index].addElement(elementDecl.key.elementAt(i));
                    ++i;
                }
            }
        }
        if ((krcount = elementDecl.keyRef.size()) > 0) {
            if (this.fElementDeclKeyRef[chunk][index] == null) {
                this.fElementDeclKeyRef[chunk][index] = (Vector)elementDecl.keyRef.clone();
            } else {
                this.fElementDeclKeyRef[chunk][index].removeAllElements();
                int i = 0;
                while (i < krcount) {
                    this.fElementDeclKeyRef[chunk][index].addElement(elementDecl.keyRef.elementAt(i));
                    ++i;
                }
            }
        }
        this.putElementNameMapping(elementDecl.name, elementDecl.enclosingScope, elementDeclIndex);
    }

    protected void putElementNameMapping(QName name, int scope, int elementDeclIndex) {
        this.fElementNameAndScopeToElementDeclIndexMapping.put(name.uri, name.localpart, scope, elementDeclIndex);
    }

    protected void setFirstAttributeDeclIndex(int elementDeclIndex, int newFirstAttrIndex) {
        if (elementDeclIndex < 0 || elementDeclIndex >= this.fElementDeclCount) {
            return;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.fElementDeclFirstAttributeDeclIndex[chunk][index] = newFirstAttrIndex;
        if (this.fElementDeclLastAttributeDeclIndex[chunk][index] == -1) {
            this.fElementDeclLastAttributeDeclIndex[chunk][index] = newFirstAttrIndex;
        }
    }

    protected int createContentSpec() {
        int chunk = this.fContentSpecCount >> 8;
        int index = this.fContentSpecCount & 0xFF;
        this.ensureContentSpecCapacity(chunk);
        this.fContentSpecType[chunk][index] = -1;
        this.fContentSpecValue[chunk][index] = -1;
        this.fContentSpecOtherValue[chunk][index] = -1;
        this.fContentSpecValidator[chunk][index] = null;
        return this.fContentSpecCount++;
    }

    protected void setContentSpec(int contentSpecIndex, XMLContentSpec contentSpec) {
        int chunk = contentSpecIndex >> 8;
        int index = contentSpecIndex & 0xFF;
        this.fContentSpecType[chunk][index] = contentSpec.type;
        this.fContentSpecValue[chunk][index] = contentSpec.value;
        this.fContentSpecOtherValue[chunk][index] = contentSpec.otherValue;
    }

    protected int createAttributeDecl() {
        int chunk = this.fAttributeDeclCount >> 8;
        int index = this.fAttributeDeclCount & 0xFF;
        this.ensureAttributeDeclCapacity(chunk);
        this.fAttributeDeclName[chunk][index] = new QName();
        this.fAttributeDeclType[chunk][index] = -1;
        this.fAttributeDeclDatatypeValidator[chunk][index] = null;
        this.fAttributeDeclEnumeration[chunk][index] = -1;
        this.fAttributeDeclDefaultType[chunk][index] = 1;
        this.fAttributeDeclDefaultValue[chunk][index] = null;
        this.fAttributeDeclNextAttributeDeclIndex[chunk][index] = -1;
        return this.fAttributeDeclCount++;
    }

    protected void setAttributeDecl(int elementDeclIndex, int attributeDeclIndex, XMLAttributeDecl attributeDecl) {
        int attrChunk = attributeDeclIndex >> 8;
        int attrIndex = attributeDeclIndex & 0xFF;
        this.fAttributeDeclName[attrChunk][attrIndex].setValues(attributeDecl.name);
        this.fAttributeDeclType[attrChunk][attrIndex] = attributeDecl.type;
        if (attributeDecl.list) {
            int[] nArray = this.fAttributeDeclType[attrChunk];
            int n = attrIndex;
            nArray[n] = nArray[n] | 0x8000;
        }
        this.fAttributeDeclEnumeration[attrChunk][attrIndex] = attributeDecl.enumeration;
        this.fAttributeDeclDefaultType[attrChunk][attrIndex] = attributeDecl.defaultType;
        this.fAttributeDeclDatatypeValidator[attrChunk][attrIndex] = attributeDecl.datatypeValidator;
        this.fAttributeDeclDefaultValue[attrChunk][attrIndex] = attributeDecl.defaultValue;
        int elemChunk = elementDeclIndex >> 8;
        int elemIndex = elementDeclIndex & 0xFF;
        int index = this.fElementDeclFirstAttributeDeclIndex[elemChunk][elemIndex];
        while (index != -1) {
            if (index == attributeDeclIndex) break;
            attrChunk = index >> 8;
            attrIndex = index & 0xFF;
            index = this.fAttributeDeclNextAttributeDeclIndex[attrChunk][attrIndex];
        }
        if (index == -1) {
            if (this.fElementDeclFirstAttributeDeclIndex[elemChunk][elemIndex] == -1) {
                this.fElementDeclFirstAttributeDeclIndex[elemChunk][elemIndex] = attributeDeclIndex;
            } else {
                index = this.fElementDeclLastAttributeDeclIndex[elemChunk][elemIndex];
                attrChunk = index >> 8;
                attrIndex = index & 0xFF;
                this.fAttributeDeclNextAttributeDeclIndex[attrChunk][attrIndex] = attributeDeclIndex;
            }
            this.fElementDeclLastAttributeDeclIndex[elemChunk][elemIndex] = attributeDeclIndex;
        }
    }

    protected boolean isDTD() {
        return false;
    }

    public void printElements(StringPool pool) {
        int elementDeclIndex = 0;
        XMLElementDecl elementDecl = new XMLElementDecl();
        while (this.getElementDecl(elementDeclIndex++, elementDecl)) {
            System.out.println("element decl: " + elementDecl.name + ", " + pool.toString(elementDecl.name.rawname) + ", " + XMLContentSpec.toString(this, pool, elementDecl.contentSpecIndex));
        }
    }

    public void printAttributes(int elementDeclIndex) {
        int attributeDeclIndex = this.getFirstAttributeDeclIndex(elementDeclIndex);
        System.out.print(elementDeclIndex);
        System.out.print(" [");
        while (attributeDeclIndex != -1) {
            System.out.print(' ');
            System.out.print(attributeDeclIndex);
            this.printAttribute(attributeDeclIndex);
            attributeDeclIndex = this.getNextAttributeDeclIndex(attributeDeclIndex);
            if (attributeDeclIndex == -1) continue;
            System.out.print(",");
        }
        System.out.println(" ]");
    }

    private void printAttribute(int attributeDeclIndex) {
        XMLAttributeDecl attributeDecl = new XMLAttributeDecl();
        if (this.getAttributeDecl(attributeDeclIndex, attributeDecl)) {
            System.out.print(" { ");
            System.out.print(attributeDecl.name.localpart);
            System.out.print(" }");
        }
    }

    private final XMLContentModel createChildModel(int contentSpecIndex, boolean isMixed) throws CMException {
        XMLContentSpec contentSpec = new XMLContentSpec();
        this.getContentSpec(contentSpecIndex, contentSpec);
        if ((contentSpec.type & 0xF) != 6 && (contentSpec.type & 0xF) != 7 && (contentSpec.type & 0xF) != 8) {
            if (isMixed) {
                if ((contentSpec.type & 0xF) == 9) {
                    AllContentModel allContent = new AllContentModel(false, true);
                    this.gatherAllLeaves(contentSpecIndex, contentSpec, allContent);
                    return allContent;
                }
                if ((contentSpec.type & 0xF) == 1) {
                    int zeroOrOneChildIndex = contentSpec.value;
                    this.getContentSpec(zeroOrOneChildIndex, contentSpec);
                    if ((contentSpec.type & 0xF) == 9) {
                        AllContentModel allContent = new AllContentModel(true, true);
                        this.gatherAllLeaves(zeroOrOneChildIndex, contentSpec, allContent);
                        return new AllContentModel(true);
                    }
                }
            } else {
                if (contentSpec.type == 0) {
                    if (contentSpec.value == -1 && contentSpec.otherValue == -1) {
                        throw new CMException(11);
                    }
                    this.fQName1.setValues(-1, contentSpec.value, contentSpec.value, contentSpec.otherValue);
                    return new SimpleContentModel(this.fQName1, null, contentSpec.type, this.isDTD());
                }
                if (contentSpec.type == 4 || contentSpec.type == 5) {
                    XMLContentSpec contentSpecLeft = new XMLContentSpec();
                    XMLContentSpec contentSpecRight = new XMLContentSpec();
                    this.getContentSpec(contentSpec.value, contentSpecLeft);
                    this.getContentSpec(contentSpec.otherValue, contentSpecRight);
                    if (contentSpecLeft.type == 0 && contentSpecRight.type == 0) {
                        this.fQName1.setValues(-1, contentSpecLeft.value, contentSpecLeft.value, contentSpecLeft.otherValue);
                        this.fQName2.setValues(-1, contentSpecRight.value, contentSpecRight.value, contentSpecRight.otherValue);
                        return new SimpleContentModel(this.fQName1, this.fQName2, contentSpec.type, this.isDTD());
                    }
                } else if (contentSpec.type == 1 || contentSpec.type == 2 || contentSpec.type == 3) {
                    XMLContentSpec contentSpecLeft = new XMLContentSpec();
                    this.getContentSpec(contentSpec.value, contentSpecLeft);
                    if (contentSpecLeft.type == 0) {
                        this.fQName1.setValues(-1, contentSpecLeft.value, contentSpecLeft.value, contentSpecLeft.otherValue);
                        return new SimpleContentModel(this.fQName1, null, contentSpec.type, this.isDTD());
                    }
                    if (contentSpecLeft.type == 9) {
                        AllContentModel allContent = new AllContentModel(true);
                        this.gatherAllLeaves(contentSpec.value, contentSpecLeft, allContent);
                        return allContent;
                    }
                } else {
                    if (contentSpec.type == 9) {
                        AllContentModel allContent = new AllContentModel(false);
                        this.gatherAllLeaves(contentSpecIndex, contentSpec, allContent);
                        return allContent;
                    }
                    throw new CMException(8);
                }
            }
        }
        this.fLeafCount = 0;
        CMNode cmn = this.buildSyntaxTree(contentSpecIndex, contentSpec);
        return new DFAContentModel(cmn, this.fLeafCount, this.isDTD(), isMixed);
    }

    private void printSyntaxTree(CMNode cmn) {
        System.out.println("CMNode : " + cmn.type());
        if (cmn.type() == 0) {
            System.out.println("     Leaf: " + ((CMLeaf)cmn).getElement());
            return;
        }
        if (cmn instanceof CMBinOp) {
            this.printSyntaxTree(((CMBinOp)cmn).getLeft());
            this.printSyntaxTree(((CMBinOp)cmn).getRight());
        }
        if (cmn instanceof CMUniOp) {
            this.printSyntaxTree(((CMUniOp)cmn).getChild());
        }
    }

    private int countLeaves(int contentSpecIndex) {
        return this.countLeaves(contentSpecIndex, new XMLContentSpec());
    }

    private int countLeaves(int contentSpecIndex, XMLContentSpec contentSpec) {
        if (contentSpecIndex == -1) {
            return 0;
        }
        this.getContentSpec(contentSpecIndex, contentSpec);
        if (contentSpec.type == 0) {
            return 1;
        }
        int value = contentSpec.value;
        int otherValue = contentSpec.otherValue;
        return this.countLeaves(value, contentSpec) + this.countLeaves(otherValue, contentSpec);
    }

    private final CMNode buildSyntaxTree(int startNode, XMLContentSpec contentSpec) throws CMException {
        CMNode nodeRet = null;
        this.getContentSpec(startNode, contentSpec);
        if ((contentSpec.type & 0xF) == 6 || (contentSpec.type & 0xF) == 7 || (contentSpec.type & 0xF) == 8) {
            nodeRet = new CMAny(contentSpec.type, contentSpec.otherValue, this.fLeafCount++);
        } else if (contentSpec.type == 0) {
            this.fQName1.setValues(-1, contentSpec.value, contentSpec.value, contentSpec.otherValue);
            nodeRet = new CMLeaf(this.fQName1, this.fLeafCount++);
        } else {
            int leftNode = contentSpec.value;
            int rightNode = contentSpec.otherValue;
            if (contentSpec.type == 4 || contentSpec.type == 5) {
                nodeRet = new CMBinOp(contentSpec.type, this.buildSyntaxTree(leftNode, contentSpec), this.buildSyntaxTree(rightNode, contentSpec));
            } else if (contentSpec.type == 2 || contentSpec.type == 1 || contentSpec.type == 3) {
                nodeRet = new CMUniOp(contentSpec.type, this.buildSyntaxTree(leftNode, contentSpec));
            } else {
                throw new CMException(8);
            }
        }
        return nodeRet;
    }

    private final void gatherAllLeaves(int contentSpecIndex, XMLContentSpec contentSpec, AllContentModel allContent) throws CMException {
        if (contentSpecIndex <= -1) {
            return;
        }
        this.getContentSpec(contentSpecIndex, contentSpec);
        int value = contentSpec.value;
        int otherValue = contentSpec.otherValue;
        int type = contentSpec.type;
        if (type == 9) {
            this.gatherAllLeaves(value, contentSpec, allContent);
            this.gatherAllLeaves(otherValue, contentSpec, allContent);
        } else if (type == 0) {
            allContent.addElement(new QName(-1, value, value, otherValue), false);
        } else if (type == 1) {
            this.getContentSpec(value, contentSpec);
            value = contentSpec.value;
            otherValue = contentSpec.otherValue;
            type = contentSpec.type;
            if (type != 0) {
                throw new CMException(8);
            }
            allContent.addElement(new QName(-1, value, value, otherValue), true);
        } else {
            throw new CMException(8);
        }
    }

    private void contentSpecTree(int contentSpecIndex, XMLContentSpec contentSpec, ChildrenList children) throws CMException {
        this.getContentSpec(contentSpecIndex, contentSpec);
        if (contentSpec.type == 0 || (contentSpec.type & 0xF) == 6 || (contentSpec.type & 0xF) == 8 || (contentSpec.type & 0xF) == 7) {
            if (children.length == children.qname.length) {
                QName[] newQName = new QName[children.length * 2];
                System.arraycopy(children.qname, 0, newQName, 0, children.length);
                children.qname = newQName;
                int[] newType = new int[children.length * 2];
                System.arraycopy(children.type, 0, newType, 0, children.length);
                children.type = newType;
            }
            children.qname[children.length] = new QName(-1, contentSpec.value, contentSpec.value, contentSpec.otherValue);
            children.type[children.length] = contentSpec.type;
            ++children.length;
            return;
        }
        int leftNode = contentSpec.value;
        int rightNode = contentSpec.otherValue;
        if (contentSpec.type == 4 || contentSpec.type == 5) {
            this.contentSpecTree(leftNode, contentSpec, children);
            this.contentSpecTree(rightNode, contentSpec, children);
            return;
        }
        if (contentSpec.type == 1 || contentSpec.type == 2 || contentSpec.type == 3) {
            this.contentSpecTree(leftNode, contentSpec, children);
            return;
        }
        throw new CMException(8);
    }

    private void ensureElementDeclCapacity(int chunk) {
        if (chunk >= this.fElementDeclName.length) {
            this.fElementDeclName = this.resize(this.fElementDeclName, this.fElementDeclName.length * 2);
            this.fElementDeclType = this.resize(this.fElementDeclType, this.fElementDeclType.length * 2);
            this.fElementDeclDatatypeValidator = this.resize(this.fElementDeclDatatypeValidator, this.fElementDeclDatatypeValidator.length * 2);
            this.fElementDeclContentSpecIndex = this.resize(this.fElementDeclContentSpecIndex, this.fElementDeclContentSpecIndex.length * 2);
            this.fElementDeclFirstAttributeDeclIndex = this.resize(this.fElementDeclFirstAttributeDeclIndex, this.fElementDeclFirstAttributeDeclIndex.length * 2);
            this.fElementDeclLastAttributeDeclIndex = this.resize(this.fElementDeclLastAttributeDeclIndex, this.fElementDeclLastAttributeDeclIndex.length * 2);
            this.fElementDeclUnique = this.resize(this.fElementDeclUnique, this.fElementDeclUnique.length * 2);
            this.fElementDeclKey = this.resize(this.fElementDeclKey, this.fElementDeclKey.length * 2);
            this.fElementDeclKeyRef = this.resize(this.fElementDeclKeyRef, this.fElementDeclKeyRef.length * 2);
        } else if (this.fElementDeclName[chunk] != null) {
            return;
        }
        this.fElementDeclName[chunk] = new QName[256];
        this.fElementDeclType[chunk] = new int[256];
        this.fElementDeclDatatypeValidator[chunk] = new DatatypeValidator[256];
        this.fElementDeclContentSpecIndex[chunk] = new int[256];
        this.fElementDeclFirstAttributeDeclIndex[chunk] = new int[256];
        this.fElementDeclLastAttributeDeclIndex[chunk] = new int[256];
        this.fElementDeclUnique[chunk] = new Vector[256];
        this.fElementDeclKey[chunk] = new Vector[256];
        this.fElementDeclKeyRef[chunk] = new Vector[256];
    }

    private void ensureContentSpecCapacity(int chunk) {
        if (chunk >= this.fContentSpecType.length) {
            this.fContentSpecType = this.resize(this.fContentSpecType, this.fContentSpecType.length * 2);
            this.fContentSpecValue = this.resize(this.fContentSpecValue, this.fContentSpecValue.length * 2);
            this.fContentSpecOtherValue = this.resize(this.fContentSpecOtherValue, this.fContentSpecOtherValue.length * 2);
            this.fContentSpecValidator = this.resize(this.fContentSpecValidator, this.fContentSpecValidator.length * 2);
        } else if (this.fContentSpecType[chunk] != null) {
            return;
        }
        this.fContentSpecType[chunk] = new int[256];
        this.fContentSpecValue[chunk] = new int[256];
        this.fContentSpecOtherValue[chunk] = new int[256];
        this.fContentSpecValidator[chunk] = new XMLContentModel[256];
    }

    private void ensureAttributeDeclCapacity(int chunk) {
        if (chunk >= this.fAttributeDeclName.length) {
            this.fAttributeDeclName = this.resize(this.fAttributeDeclName, this.fAttributeDeclName.length * 2);
            this.fAttributeDeclType = this.resize(this.fAttributeDeclType, this.fAttributeDeclType.length * 2);
            this.fAttributeDeclEnumeration = this.resize(this.fAttributeDeclEnumeration, this.fAttributeDeclEnumeration.length * 2);
            this.fAttributeDeclDefaultType = this.resize(this.fAttributeDeclDefaultType, this.fAttributeDeclDefaultType.length * 2);
            this.fAttributeDeclDatatypeValidator = this.resize(this.fAttributeDeclDatatypeValidator, this.fAttributeDeclDatatypeValidator.length * 2);
            this.fAttributeDeclDefaultValue = this.resize(this.fAttributeDeclDefaultValue, this.fAttributeDeclDefaultValue.length * 2);
            this.fAttributeDeclNextAttributeDeclIndex = this.resize(this.fAttributeDeclNextAttributeDeclIndex, this.fAttributeDeclNextAttributeDeclIndex.length * 2);
        } else if (this.fAttributeDeclName[chunk] != null) {
            return;
        }
        this.fAttributeDeclName[chunk] = new QName[256];
        this.fAttributeDeclType[chunk] = new int[256];
        this.fAttributeDeclEnumeration[chunk] = new int[256];
        this.fAttributeDeclDefaultType[chunk] = new int[256];
        this.fAttributeDeclDatatypeValidator[chunk] = new DatatypeValidator[256];
        this.fAttributeDeclDefaultValue[chunk] = new String[256];
        this.fAttributeDeclNextAttributeDeclIndex[chunk] = new int[256];
    }

    private int[][] resize(int[][] array, int newsize) {
        int[][] newarray = new int[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private DatatypeValidator[][] resize(DatatypeValidator[][] array, int newsize) {
        DatatypeValidator[][] newarray = new DatatypeValidator[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private XMLContentModel[][] resize(XMLContentModel[][] array, int newsize) {
        XMLContentModel[][] newarray = new XMLContentModel[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private QName[][] resize(QName[][] array, int newsize) {
        QName[][] newarray = new QName[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private String[][] resize(String[][] array, int newsize) {
        String[][] newarray = new String[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private Vector[][] resize(Vector[][] array, int newsize) {
        Vector[][] newarray = new Vector[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    static class ChildrenList {
        public int length = 0;
        public QName[] qname = new QName[2];
        public int[] type = new int[2];

        ChildrenList() {
        }
    }
}

