/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactory;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;

public class GrammarResolverImpl
implements GrammarResolver {
    private Hashtable fGrammarRegistry = new Hashtable();
    private DatatypeValidatorFactoryImpl fDataTypeReg;

    public Grammar getGrammar(String nameSpaceKey) {
        return (Grammar)this.fGrammarRegistry.get(nameSpaceKey);
    }

    public DatatypeValidatorFactory getDatatypeRegistry() {
        if (this.fDataTypeReg == null) {
            this.fDataTypeReg = new DatatypeValidatorFactoryImpl();
        }
        return this.fDataTypeReg;
    }

    public String[] getNSKeysInPool() {
        int numberOfNSKeysInPool = this.fGrammarRegistry.size();
        String[] NSArray = new String[numberOfNSKeysInPool];
        Enumeration enumOfKeys = this.nameSpaceKeys();
        int i = 0;
        while (i < numberOfNSKeysInPool) {
            NSArray[i] = (String)enumOfKeys.nextElement();
            ++i;
        }
        return NSArray;
    }

    public void putGrammar(String nameSpaceKey, Grammar grammar) {
        this.fGrammarRegistry.put(nameSpaceKey, grammar);
    }

    public int size() {
        return this.fGrammarRegistry.size();
    }

    public Enumeration nameSpaceKeys() {
        return this.fGrammarRegistry.keys();
    }

    public Grammar removeGrammar(String nameSpaceKey) {
        if (this.containsNameSpace(nameSpaceKey)) {
            this.fGrammarRegistry.remove(nameSpaceKey);
        }
        return null;
    }

    public boolean contains(Grammar grammar) {
        return this.fGrammarRegistry.contains(grammar);
    }

    public boolean containsNameSpace(String nameSpaceKey) {
        return this.fGrammarRegistry.containsKey(nameSpaceKey);
    }

    public void clearGrammarResolver() {
        this.fGrammarRegistry.clear();
        if (this.fDataTypeReg != null) {
            this.fDataTypeReg.resetRegistry();
        }
    }
}

