/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.utils.QName;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.ContentLeafNameTypeVector;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;

public class MixedContentModel
implements XMLContentModel {
    private int fCount;
    private QName[] fChildren;
    private int[] fChildrenType;
    private SubstitutionGroupComparator comparator = null;
    private boolean fOrdered;
    private boolean fDTD;

    public MixedContentModel(QName[] childList, int[] childListType, int offset, int length) throws CMException {
        this(childList, childListType, offset, length, false, false);
    }

    public MixedContentModel(QName[] childList, int[] childListType, int offset, int length, boolean ordered) throws CMException {
        this(childList, childListType, offset, length, ordered, false);
    }

    public MixedContentModel(QName[] childList, int[] childListType, int offset, int length, boolean ordered, boolean dtd) throws CMException {
        this.fCount = length;
        this.fChildren = new QName[this.fCount];
        this.fChildrenType = new int[this.fCount];
        int i = 0;
        while (i < this.fCount) {
            this.fChildren[i] = new QName(childList[offset + i]);
            this.fChildrenType[i] = childListType[offset + i];
            ++i;
        }
        this.fOrdered = ordered;
        this.fDTD = dtd;
    }

    public void checkUniqueParticleAttribution(SchemaGrammar gram) {
        int i = 0;
        while (i < this.fCount) {
            this.fChildren[i].uri = gram.getContentSpecOrgUri(this.fChildren[i].uri);
            ++i;
        }
    }

    public int validateContent(QName[] children, int offset, int length) throws Exception {
        if (this.fOrdered) {
            int inIndex = 0;
            int outIndex = 0;
            while (outIndex < length) {
                QName curChild = children[offset + outIndex];
                if (curChild.localpart != -1) {
                    int type = this.fChildrenType[inIndex];
                    if (type == 0 && (this.fDTD ? this.fChildren[inIndex].rawname != children[offset + outIndex].rawname : this.fChildren[inIndex].uri != children[offset + outIndex].uri && this.fChildren[inIndex].localpart != children[offset + outIndex].localpart)) {
                        return outIndex;
                    }
                    ++inIndex;
                }
                ++outIndex;
            }
        } else {
            int outIndex = 0;
            while (outIndex < length) {
                QName curChild = children[offset + outIndex];
                if (curChild.localpart != -1) {
                    int inIndex = 0;
                    while (inIndex < this.fCount) {
                        int type = this.fChildrenType[inIndex];
                        if (type == 0 && (this.fDTD ? curChild.rawname == this.fChildren[inIndex].rawname : curChild.uri == this.fChildren[inIndex].uri && curChild.localpart == this.fChildren[inIndex].localpart)) break;
                        ++inIndex;
                    }
                    if (inIndex == this.fCount) {
                        return outIndex;
                    }
                }
                ++outIndex;
            }
        }
        return -1;
    }

    public int validateContentSpecial(QName[] children, int offset, int length) throws Exception {
        return this.validateContent(children, offset, length);
    }

    public void setSubstitutionGroupComparator(SubstitutionGroupComparator comparator) {
        this.comparator = comparator;
    }

    public int whatCanGoHere(boolean fullyValid, InsertableElementsInfo info) throws Exception {
        int index = info.insertAt;
        while (index < info.childCount - 1) {
            info.curChildren[index] = info.curChildren[index + 1];
            ++index;
        }
        --info.childCount;
        int failedIndex = this.validateContent(info.curChildren, 0, info.childCount);
        if (failedIndex != -1 && failedIndex < info.insertAt) {
            return failedIndex;
        }
        info.canHoldPCData = true;
        info.isValidEOC = true;
        info.resultsCount = this.fCount;
        if (info.results == null || info.results.length < info.resultsCount) {
            info.results = new boolean[info.resultsCount];
        }
        if (info.possibleChildren == null || info.possibleChildren.length < info.resultsCount) {
            info.possibleChildren = new QName[info.resultsCount];
            int i = 0;
            while (i < info.possibleChildren.length) {
                info.possibleChildren[i] = new QName();
                ++i;
            }
        }
        boolean bStatus = true;
        if (fullyValid && failedIndex < info.childCount) {
            bStatus = false;
        }
        int index2 = 0;
        while (index2 < this.fCount) {
            info.possibleChildren[index2].setValues(this.fChildren[index2]);
            info.results[index2] = bStatus;
            ++index2;
        }
        return -1;
    }

    public ContentLeafNameTypeVector getContentLeafNameTypeVector() {
        return null;
    }
}

