/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import org.apache.xerces.utils.QName;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.ContentLeafNameTypeVector;
import org.apache.xerces.validators.common.ElementWildcard;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;

public class SimpleContentModel
implements XMLContentModel {
    private QName fFirstChild = new QName();
    private QName fSecondChild = new QName();
    private int fOp;
    private boolean fDTD;
    private SubstitutionGroupComparator comparator = null;

    public SimpleContentModel(QName firstChild, QName secondChild, int cmOp) {
        this(firstChild, secondChild, cmOp, false);
    }

    public SimpleContentModel(QName firstChild, QName secondChild, int cmOp, boolean dtd) {
        this.fFirstChild.setValues(firstChild);
        if (secondChild != null) {
            this.fSecondChild.setValues(secondChild);
        } else {
            this.fSecondChild.clear();
        }
        this.fOp = cmOp;
        this.fDTD = dtd;
    }

    public void checkUniqueParticleAttribution(SchemaGrammar gram) throws Exception {
        this.fFirstChild.uri = gram.getContentSpecOrgUri(this.fFirstChild.uri);
        this.fSecondChild.uri = gram.getContentSpecOrgUri(this.fSecondChild.uri);
        if (this.fOp == 4) {
            ElementWildcard.conflict(0, this.fFirstChild.localpart, this.fFirstChild.uri, 0, this.fSecondChild.localpart, this.fSecondChild.uri, this.comparator);
        }
    }

    public int validateContent(QName[] children, int offset, int length) throws Exception {
        switch (this.fOp) {
            case 0: {
                if (length == 0) {
                    return 0;
                }
                if (this.fDTD ? children[offset].rawname != this.fFirstChild.rawname : children[offset].uri != this.fFirstChild.uri || children[offset].localpart != this.fFirstChild.localpart) {
                    return 0;
                }
                if (length <= 1) break;
                return 1;
            }
            case 1: {
                if (length == 1 && (this.fDTD ? children[offset].rawname != this.fFirstChild.rawname : children[offset].uri != this.fFirstChild.uri || children[offset].localpart != this.fFirstChild.localpart)) {
                    return 0;
                }
                if (length <= 1) break;
                return 1;
            }
            case 2: {
                if (length <= 0) break;
                if (this.fDTD) {
                    int index = 0;
                    while (index < length) {
                        if (children[offset + index].rawname != this.fFirstChild.rawname) {
                            return index;
                        }
                        ++index;
                    }
                } else {
                    int index = 0;
                    while (index < length) {
                        if (children[offset + index].uri != this.fFirstChild.uri || children[offset + index].localpart != this.fFirstChild.localpart) {
                            return index;
                        }
                        ++index;
                    }
                }
                break;
            }
            case 3: {
                if (length == 0) {
                    return 0;
                }
                if (this.fDTD) {
                    int index = 0;
                    while (index < length) {
                        if (children[offset + index].rawname != this.fFirstChild.rawname) {
                            return index;
                        }
                        ++index;
                    }
                } else {
                    int index = 0;
                    while (index < length) {
                        if (children[offset + index].uri != this.fFirstChild.uri || children[offset + index].localpart != this.fFirstChild.localpart) {
                            return index;
                        }
                        ++index;
                    }
                }
                break;
            }
            case 4: {
                if (length == 0) {
                    return 0;
                }
                if (this.fDTD ? children[offset].rawname != this.fFirstChild.rawname && children[offset].rawname != this.fSecondChild.rawname : !(children[offset].uri == this.fFirstChild.uri && children[offset].localpart == this.fFirstChild.localpart || children[offset].uri == this.fSecondChild.uri && children[offset].localpart == this.fSecondChild.localpart)) {
                    return 0;
                }
                if (length <= 1) break;
                return 1;
            }
            case 5: {
                if (length == 2) {
                    if (this.fDTD) {
                        if (children[offset].rawname != this.fFirstChild.rawname) {
                            return 0;
                        }
                        if (children[offset + 1].rawname == this.fSecondChild.rawname) break;
                        return 1;
                    }
                    if (children[offset].uri != this.fFirstChild.uri || children[offset].localpart != this.fFirstChild.localpart) {
                        return 0;
                    }
                    if (children[offset + 1].uri == this.fSecondChild.uri && children[offset + 1].localpart == this.fSecondChild.localpart) break;
                    return 1;
                }
                if (length > 2) {
                    return 2;
                }
                return length;
            }
            default: {
                throw new CMException(8);
            }
        }
        return -1;
    }

    public int validateContentSpecial(QName[] children, int offset, int length) throws Exception {
        if (this.comparator == null) {
            return this.validateContent(children, offset, length);
        }
        switch (this.fOp) {
            case 0: {
                if (length == 0) {
                    return 0;
                }
                if (!(children[offset].uri == this.fFirstChild.uri && children[offset].localpart == this.fFirstChild.localpart || this.comparator.isEquivalentTo(children[offset], this.fFirstChild))) {
                    return 0;
                }
                if (length <= 1) break;
                return 1;
            }
            case 1: {
                if (!(length != 1 || children[offset].uri == this.fFirstChild.uri && children[offset].localpart == this.fFirstChild.localpart || this.comparator.isEquivalentTo(children[offset], this.fFirstChild))) {
                    return 0;
                }
                if (length <= 1) break;
                return 1;
            }
            case 2: {
                if (length <= 0) break;
                int index = 0;
                while (index < length) {
                    if (!(children[offset + index].uri == this.fFirstChild.uri && children[offset + index].localpart == this.fFirstChild.localpart || this.comparator.isEquivalentTo(children[offset + index], this.fFirstChild))) {
                        return index;
                    }
                    ++index;
                }
                break;
            }
            case 3: {
                if (length == 0) {
                    return 0;
                }
                int index = 0;
                while (index < length) {
                    if (!(children[offset + index].uri == this.fFirstChild.uri && children[offset + index].localpart == this.fFirstChild.localpart || this.comparator.isEquivalentTo(children[offset + index], this.fFirstChild))) {
                        return index;
                    }
                    ++index;
                }
                break;
            }
            case 4: {
                if (length == 0) {
                    return 0;
                }
                if (!(children[offset].uri == this.fFirstChild.uri && children[offset].localpart == this.fFirstChild.localpart || children[offset].uri == this.fSecondChild.uri && children[offset].localpart == this.fSecondChild.localpart || this.comparator.isEquivalentTo(children[offset], this.fFirstChild) || this.comparator.isEquivalentTo(children[offset], this.fSecondChild))) {
                    return 0;
                }
                if (length <= 1) break;
                return 1;
            }
            case 5: {
                if (length == 2) {
                    if (!(children[offset].uri == this.fFirstChild.uri && children[offset].localpart == this.fFirstChild.localpart || this.comparator.isEquivalentTo(children[offset], this.fFirstChild))) {
                        return 0;
                    }
                    if (children[offset + 1].uri == this.fSecondChild.uri && children[offset + 1].localpart == this.fSecondChild.localpart || this.comparator.isEquivalentTo(children[offset + 1], this.fSecondChild)) break;
                    return 1;
                }
                if (length > 2) {
                    return 2;
                }
                return length;
            }
            default: {
                throw new CMException(8);
            }
        }
        return -1;
    }

    public void setSubstitutionGroupComparator(SubstitutionGroupComparator comparator) {
        this.comparator = comparator;
    }

    public int whatCanGoHere(boolean fullyValid, InsertableElementsInfo info) throws Exception {
        int index = info.insertAt;
        while (index < info.childCount - 1) {
            info.curChildren[index].setValues(info.curChildren[index + 1]);
            ++index;
        }
        --info.childCount;
        int failedIndex = this.validateContent(info.curChildren, 0, info.childCount);
        if (failedIndex != -1 && failedIndex < info.insertAt) {
            return failedIndex;
        }
        info.canHoldPCData = false;
        if (this.fOp == 0 || this.fOp == 1 || this.fOp == 2 || this.fOp == 3) {
            info.resultsCount = 1;
        } else if (this.fOp == 4 || this.fOp == 5) {
            info.resultsCount = 2;
        } else {
            throw new CMException(8);
        }
        if (info.results == null || info.results.length < info.resultsCount) {
            info.results = new boolean[info.resultsCount];
        }
        if (info.possibleChildren == null || info.possibleChildren.length < info.resultsCount) {
            info.possibleChildren = new QName[info.resultsCount];
            int i = 0;
            while (i < info.possibleChildren.length) {
                info.possibleChildren[i] = new QName();
                ++i;
            }
        }
        info.possibleChildren[0].setValues(this.fFirstChild);
        info.results[0] = false;
        if (info.resultsCount == 2) {
            info.possibleChildren[1].setValues(this.fSecondChild);
            info.results[1] = false;
        }
        info.isValidEOC = false;
        switch (this.fOp) {
            case 0: 
            case 1: {
                if (info.childCount == 0) {
                    info.results[0] = true;
                } else if (info.childCount > 0 && !fullyValid && info.insertAt == 0) {
                    info.results[0] = true;
                }
                if (this.fOp == 0) {
                    if (info.insertAt != 0) break;
                    info.isValidEOC = true;
                    break;
                }
                info.isValidEOC = true;
                break;
            }
            case 2: 
            case 3: {
                info.results[0] = true;
                if (this.fOp != 2 && info.insertAt <= 0) break;
                info.isValidEOC = true;
                break;
            }
            case 4: {
                if (info.insertAt == 0 && !fullyValid && info.childCount == 0) {
                    info.results[0] = true;
                    info.results[1] = true;
                }
                if (info.insertAt != 1) break;
                info.isValidEOC = true;
                break;
            }
            case 5: {
                if (info.insertAt == 0) {
                    if (fullyValid) {
                        if (info.childCount == 1) {
                            info.results[0] = info.curChildren[0].uri == this.fSecondChild.uri && info.curChildren[0].localpart == this.fSecondChild.localpart;
                        }
                    } else {
                        info.results[0] = true;
                    }
                } else if (!(info.insertAt != 1 || fullyValid && info.childCount != 1)) {
                    info.results[1] = true;
                }
                if (info.insertAt != 2) break;
                info.isValidEOC = true;
                break;
            }
            default: {
                throw new CMException(8);
            }
        }
        return -1;
    }

    public ContentLeafNameTypeVector getContentLeafNameTypeVector() {
        return null;
    }
}

