/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.common;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLDocumentHandler;
import org.apache.xerces.framework.XMLDocumentScanner;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.IntStack;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.CMException;
import org.apache.xerces.validators.common.ContentLeafNameTypeVector;
import org.apache.xerces.validators.common.DFAContentModel;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.InsertableElementsInfo;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.AnySimpleType;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.datatype.ENTITYDatatypeValidator;
import org.apache.xerces.validators.datatype.IDDatatypeValidator;
import org.apache.xerces.validators.datatype.IDREFDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.NOTATIONDatatypeValidator;
import org.apache.xerces.validators.datatype.StateMessageDatatype;
import org.apache.xerces.validators.datatype.UnionDatatypeValidator;
import org.apache.xerces.validators.dtd.DTDGrammar;
import org.apache.xerces.validators.schema.GeneralAttrCheck;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;
import org.apache.xerces.validators.schema.TraverseSchema;
import org.apache.xerces.validators.schema.identity.Field;
import org.apache.xerces.validators.schema.identity.FieldActivator;
import org.apache.xerces.validators.schema.identity.IDValue;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.Key;
import org.apache.xerces.validators.schema.identity.KeyRef;
import org.apache.xerces.validators.schema.identity.Selector;
import org.apache.xerces.validators.schema.identity.Unique;
import org.apache.xerces.validators.schema.identity.ValueStore;
import org.apache.xerces.validators.schema.identity.XPathMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public final class XMLValidator
implements DefaultEntityHandler.EventHandler,
XMLEntityHandler.CharDataHandler,
XMLDocumentScanner.EventHandler,
NamespacesScope.NamespacesHandler,
FieldActivator {
    private static final boolean PRINT_EXCEPTION_STACK_TRACE = false;
    private static final boolean DEBUG_PRINT_ATTRIBUTES = false;
    private static final boolean DEBUG_PRINT_CONTENT = false;
    private static final boolean DEBUG_SCHEMA_VALIDATION = false;
    private static final boolean DEBUG_ELEMENT_CHILDREN = false;
    protected static final boolean DEBUG_IDENTITY_CONSTRAINTS = false;
    protected static final boolean DEBUG_VALUE_STORES = false;
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private Hashtable fIdDefs = new Hashtable();
    private Hashtable fIdREFDefs = new Hashtable();
    private StateMessageDatatype fValidateIDRef = new StateMessageDatatype(){
        private Hashtable fIdDefs;

        public Object getDatatypeObject() {
            return this.fIdDefs;
        }

        public int getDatatypeState() {
            return 0;
        }

        public void setDatatypeObject(Object data) {
            this.fIdDefs = (Hashtable)data;
        }
    };
    private StateMessageDatatype fCheckIDRef = new StateMessageDatatype(){
        private Object[] fLists;

        public Object getDatatypeObject() {
            return this.fLists;
        }

        public int getDatatypeState() {
            return 1;
        }

        public void setDatatypeObject(Object data) {
            this.fLists = (Object[])data;
        }
    };
    private StateMessageDatatype fValidateEntity = new StateMessageDatatype(){
        private Object fData;

        public Object getDatatypeObject() {
            return this.fData;
        }

        public int getDatatypeState() {
            return 0;
        }

        public void setDatatypeObject(Object data) {
            this.fData = data;
        }
    };
    private AttributeValidator fAttValidatorNOTATION = new AttValidatorNOTATION();
    private AttributeValidator fAttValidatorENUMERATION = new AttValidatorENUMERATION();
    private AttributeValidator fAttValidatorDATATYPE = null;
    StringPool fStringPool = null;
    boolean fValidating = false;
    boolean fInElementContent = false;
    int fStandaloneReader = -1;
    private boolean fValidationEnabled = false;
    private boolean fDynamicValidation = false;
    private boolean fSchemaValidation = true;
    private boolean fSchemaValidationFullChecking = false;
    private boolean fValidationEnabledByDynamic = false;
    private boolean fDynamicDisabledByValidation = false;
    private boolean fWarningOnDuplicateAttDef = false;
    private boolean fWarningOnUndeclaredElements = false;
    private boolean fNormalizeAttributeValues = true;
    private boolean fLoadDTDGrammar = true;
    private boolean fNormalizeContents = false;
    private Hashtable fLocationUriPairs = new Hashtable(10);
    private String fExternalSchemas = null;
    private String fExternalNoNamespaceSchema = null;
    private DOMParser fSchemaGrammarParser = null;
    private int[] fDeclaration;
    private XMLErrorReporter fErrorReporter = null;
    private DefaultEntityHandler fEntityHandler = null;
    private QName fCurrentElement = new QName();
    private ContentLeafNameTypeVector[] fContentLeafStack = new ContentLeafNameTypeVector[8];
    private XMLContentModel[] fContentModelStack = new XMLContentModel[8];
    private int[] fContentModelStateStack = new int[8];
    private int[] fContentModelEleCount = new int[8];
    private int[] fValidationFlagStack = new int[8];
    private int[] fScopeStack = new int[8];
    private int[] fGrammarNameSpaceIndexStack = new int[8];
    private int[] fElementEntityStack = new int[8];
    private int[] fElementIndexStack = new int[8];
    private int[] fContentSpecTypeStack = new int[8];
    private static final int sizeQNameParts = 8;
    private QName[] fElementQNamePartsStack = new QName[8];
    private QName[] fElementChildren = new QName[32];
    private int fElementChildrenLength = 0;
    private int[] fElementChildrenOffsetStack = new int[32];
    private int fElementDepth = -1;
    private boolean fNamespacesEnabled = false;
    private NamespacesScope fNamespacesScope = null;
    private int fNamespacesPrefix = -1;
    private QName fRootElement = new QName();
    private int fAttrListHandle = -1;
    private int fCurrentElementEntity = -1;
    private int fCurrentElementIndex = -1;
    private int fCurrentContentSpecType = -1;
    private boolean fSeenDoctypeDecl = false;
    private final int TOP_LEVEL_SCOPE = -1;
    private int fCurrentScope = -1;
    private int fCurrentSchemaURI = 0;
    private int fEmptyURI = 0;
    private int fXsiPrefix = -1;
    private int fXsiURI = -2;
    private int fXsiTypeAttValue = -1;
    private DatatypeValidator fXsiTypeValidator = null;
    private boolean fNil = false;
    private Grammar fGrammar = null;
    private int fGrammarNameSpaceIndex = 0;
    private GrammarResolver fGrammarResolver = null;
    private boolean fScanningDTD = false;
    private XMLDocumentScanner fDocumentScanner = null;
    private boolean fCalledStartDocument = false;
    private XMLDocumentHandler fDocumentHandler = null;
    private XMLDocumentHandler.DTDHandler fDTDHandler = null;
    private boolean fSeenRootElement = false;
    private XMLAttrList fAttrList = null;
    private int fXMLLang = -1;
    private LocatorImpl fAttrNameLocator = null;
    private boolean fCheckedForSchema = false;
    private boolean fDeclsAreExternal = false;
    private StringPool.CharArrayRange fCurrentElementCharArrayRange = null;
    private char[] fCharRefData = null;
    private boolean fSendCharDataAsCharArray = false;
    private boolean fBufferDatatype = false;
    private StringBuffer fDatatypeBuffer = new StringBuffer();
    private QName fTempQName = new QName();
    private XMLAttributeDecl fTempAttDecl = new XMLAttributeDecl();
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private boolean fGrammarIsDTDGrammar = false;
    private boolean fGrammarIsSchemaGrammar = false;
    private boolean fNeedValidationOff = false;
    private static final boolean DEBUG_NORMALIZATION = false;
    private DatatypeValidator fCurrentDV = null;
    private boolean fFirstChunk = true;
    private boolean fTrailing = false;
    private short fWhiteSpace = (short)2;
    private StringBuffer fNormalizedStr = new StringBuffer(256);
    private StringBuffer fUnnormalizedStr = new StringBuffer(256);
    private int fEMPTYSymbol = -1;
    private int fANYSymbol = -1;
    private int fMIXEDSymbol = -1;
    private int fCHILDRENSymbol = -1;
    private int fCDATASymbol = -1;
    private int fIDSymbol = -1;
    private int fIDREFSymbol = -1;
    private int fIDREFSSymbol = -1;
    private int fENTITYSymbol = -1;
    private int fENTITIESSymbol = -1;
    private int fNMTOKENSymbol = -1;
    private int fNMTOKENSSymbol = -1;
    private int fNOTATIONSymbol = -1;
    private int fENUMERATIONSymbol = -1;
    private int fREQUIREDSymbol = -1;
    private int fFIXEDSymbol = -1;
    private int fDATATYPESymbol = -1;
    private int fEpsilonIndex = -1;
    private DatatypeValidatorFactoryImpl fDataTypeReg = null;
    private DatatypeValidator fValID = null;
    private DatatypeValidator fValIDRef = null;
    private DatatypeValidator fValIDRefs = null;
    private DatatypeValidator fValENTITY = null;
    private DatatypeValidator fValENTITIES = null;
    private DatatypeValidator fValNMTOKEN = null;
    private DatatypeValidator fValNMTOKENS = null;
    private DatatypeValidator fValNOTATION = null;
    protected XPathMatcherStack fMatcherStack = new XPathMatcherStack();
    protected ValueStoreCache fValueStoreCache = new ValueStoreCache();
    protected SubstitutionGroupComparator fSGComparator = null;
    protected Hashtable UPACheckedGrammarURIs = new Hashtable();
    protected static Object fgNullObject = new Object();

    public XMLValidator(StringPool stringPool, XMLErrorReporter errorReporter, DefaultEntityHandler entityHandler, XMLDocumentScanner documentScanner) {
        this.fStringPool = stringPool;
        this.fErrorReporter = errorReporter;
        this.fEntityHandler = entityHandler;
        this.fDocumentScanner = documentScanner;
        this.fValidateEntity.setDatatypeObject(new Object[]{entityHandler, stringPool});
        this.fValidateIDRef.setDatatypeObject(this.fIdREFDefs);
        this.fCheckIDRef.setDatatypeObject(new Object[]{this.fIdDefs, this.fIdREFDefs});
        this.fEmptyURI = this.fStringPool.addSymbol("");
        this.fXsiURI = this.fStringPool.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
        this.fAttrList = new XMLAttrList(this.fStringPool);
        entityHandler.setEventHandler(this);
        entityHandler.setCharDataHandler(this);
        this.fDocumentScanner.setEventHandler(this);
        int i = 0;
        while (i < 8) {
            this.fElementQNamePartsStack[i] = new QName();
            ++i;
        }
        this.init();
    }

    public void setGrammarResolver(GrammarResolver grammarResolver) {
        this.fGrammarResolver = grammarResolver;
    }

    public void initHandlers(boolean sendCharDataAsCharArray, XMLDocumentHandler docHandler, XMLDocumentHandler.DTDHandler dtdHandler) {
        this.fSendCharDataAsCharArray = sendCharDataAsCharArray;
        this.fEntityHandler.setSendCharDataAsCharArray(this.fSendCharDataAsCharArray);
        this.fDocumentHandler = docHandler;
        this.fDTDHandler = dtdHandler;
    }

    public void resetOrCopy(StringPool stringPool) throws Exception {
        this.fAttrList = new XMLAttrList(stringPool);
        this.resetCommon(stringPool);
    }

    public void reset(StringPool stringPool) throws Exception {
        this.fAttrList.reset(stringPool);
        this.resetCommon(stringPool);
    }

    public void setValidationEnabled(boolean flag) throws Exception {
        this.fValidationEnabled = flag;
        this.fValidationEnabledByDynamic = false;
        if (this.fValidationEnabled) {
            if (this.fDynamicDisabledByValidation) {
                this.fDynamicValidation = true;
                this.fDynamicDisabledByValidation = false;
            }
        } else if (this.fDynamicValidation) {
            this.fDynamicValidation = false;
            this.fDynamicDisabledByValidation = true;
        }
        this.fValidating = this.fValidationEnabled;
        if (this.fValidating) {
            this.initDataTypeValidators();
        }
    }

    public boolean getValidationEnabled() {
        return this.fValidationEnabled;
    }

    public void setSchemaValidationEnabled(boolean flag) {
        this.fSchemaValidation = flag;
    }

    public boolean getSchemaValidationEnabled() {
        return this.fSchemaValidation;
    }

    public void setSchemaFullCheckingEnabled(boolean flag) {
        this.fSchemaValidationFullChecking = flag;
    }

    public void setExternalSchemas(Object value) {
        this.fExternalSchemas = (String)value;
    }

    public void setExternalNoNamespaceSchema(Object value) {
        this.fExternalNoNamespaceSchema = (String)value;
    }

    public String getExternalSchemas() {
        return this.fExternalSchemas;
    }

    public String getExternalNoNamespaceSchema() {
        return this.fExternalNoNamespaceSchema;
    }

    public boolean getSchemaFullCheckingEnabled() {
        return this.fSchemaValidationFullChecking;
    }

    public void setDynamicValidationEnabled(boolean flag) throws Exception {
        this.fDynamicValidation = flag;
        this.fDynamicDisabledByValidation = false;
        if (!this.fDynamicValidation) {
            if (this.fValidationEnabledByDynamic) {
                this.fValidationEnabled = false;
                this.fValidationEnabledByDynamic = false;
            }
        } else if (!this.fValidationEnabled) {
            this.fValidationEnabled = true;
            this.fValidationEnabledByDynamic = true;
        }
        this.fValidating = this.fValidationEnabled;
        if (this.fValidating) {
            this.initDataTypeValidators();
        }
    }

    public boolean getDynamicValidationEnabled() {
        return this.fDynamicValidation;
    }

    public void setNormalizeAttributeValues(boolean normalize) {
        this.fNormalizeAttributeValues = normalize;
    }

    public void setLoadDTDGrammar(boolean loadDG) {
        this.fLoadDTDGrammar = this.fValidating ? true : loadDG;
    }

    public boolean getLoadDTDGrammar() {
        return this.fLoadDTDGrammar;
    }

    public void setNamespacesEnabled(boolean flag) {
        this.fNamespacesEnabled = flag;
    }

    public boolean getNamespacesEnabled() {
        return this.fNamespacesEnabled;
    }

    public void setWarningOnDuplicateAttDef(boolean flag) {
        this.fWarningOnDuplicateAttDef = flag;
    }

    public boolean getWarningOnDuplicateAttDef() {
        return this.fWarningOnDuplicateAttDef;
    }

    public void setWarningOnUndeclaredElements(boolean flag) {
        this.fWarningOnUndeclaredElements = flag;
    }

    public boolean getWarningOnUndeclaredElements() {
        return this.fWarningOnUndeclaredElements;
    }

    public void setNormalizeContents(boolean normalize) {
        this.fNormalizeContents = normalize;
    }

    public boolean getNormalizeConents() {
        return this.fNormalizeContents;
    }

    public void startValueScopeFor(IdentityConstraint identityConstraint) throws Exception {
        int i = 0;
        while (i < identityConstraint.getFieldCount()) {
            Field field = identityConstraint.getFieldAt(i);
            ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(field);
            valueStore.startValueScope();
            ++i;
        }
    }

    public XPathMatcher activateField(Field field) throws Exception {
        ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(field);
        field.setMayMatch(true);
        XPathMatcher matcher = field.createMatcher(valueStore);
        this.fMatcherStack.addMatcher(matcher);
        matcher.startDocumentFragment(this.fStringPool);
        return matcher;
    }

    public void endValueScopeFor(IdentityConstraint identityConstraint) throws Exception {
        ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(identityConstraint);
        valueStore.endValueScope();
    }

    public void startEntityReference(int entityName, int entityType, int entityContext) throws Exception {
        this.fDocumentHandler.startEntityReference(entityName, entityType, entityContext);
    }

    public void endEntityReference(int entityName, int entityType, int entityContext) throws Exception {
        this.fDocumentHandler.endEntityReference(entityName, entityType, entityContext);
    }

    public void sendEndOfInputNotifications(int entityName, boolean moreToFollow) throws Exception {
        this.fDocumentScanner.endOfInput(entityName, moreToFollow);
    }

    public void sendReaderChangeNotifications(XMLEntityHandler.EntityReader reader, int readerId) throws Exception {
        this.fDocumentScanner.readerChange(reader, readerId);
    }

    public boolean externalEntityStandaloneCheck() {
        return this.fStandaloneReader != -1 && this.fValidating;
    }

    public boolean getValidating() {
        return this.fValidating;
    }

    private String normalizeValue(String unNormalizedValue) {
        this.fUnnormalizedStr.setLength(0);
        this.fUnnormalizedStr.append(unNormalizedValue);
        this.normalizeWhitespace(this.fUnnormalizedStr, this.fWhiteSpace == 2);
        return this.fNormalizedStr.toString();
    }

    private int normalizeWhitespace(StringBuffer chars, boolean collapse) {
        int c;
        int length = this.fUnnormalizedStr.length();
        this.fNormalizedStr.setLength(0);
        boolean skipSpace = collapse;
        boolean sawNonWS = false;
        int leading = 0;
        int trailing = 0;
        int i = 0;
        while (i < length) {
            c = chars.charAt(i);
            if (c == 32 || c == 13 || c == 10 || c == 9) {
                if (!skipSpace) {
                    this.fNormalizedStr.append(' ');
                    skipSpace = collapse;
                }
                if (!sawNonWS) {
                    leading = 1;
                }
            } else {
                this.fNormalizedStr.append((char)c);
                skipSpace = false;
                sawNonWS = true;
            }
            ++i;
        }
        if (skipSpace) {
            c = this.fNormalizedStr.length();
            if (c != 0) {
                this.fNormalizedStr.setLength(--c);
                trailing = 2;
            } else if (leading != 0 && !sawNonWS) {
                trailing = 2;
            }
        }
        return collapse ? leading + trailing : 0;
    }

    public void processCharacters(char[] chars, int offset, int length) throws Exception {
        if (this.fValidating) {
            if (this.fInElementContent || this.fCurrentContentSpecType == 0) {
                this.charDataInContent();
            }
            if (this.fBufferDatatype) {
                if (this.fFirstChunk && this.fGrammar != null) {
                    this.fGrammar.getElementDecl(this.fCurrentElementIndex, this.fTempElementDecl);
                    this.fCurrentDV = this.fTempElementDecl.datatypeValidator;
                    if (this.fXsiTypeValidator != null) {
                        this.fCurrentDV = this.fXsiTypeValidator;
                        this.fXsiTypeValidator = null;
                    }
                    if (this.fCurrentDV != null) {
                        this.fWhiteSpace = this.fCurrentDV.getWSFacet();
                    }
                }
                if (!this.fNormalizeContents || this.fWhiteSpace == 0) {
                    this.fDatatypeBuffer.append(chars, offset, length);
                } else {
                    this.fUnnormalizedStr.setLength(0);
                    this.fUnnormalizedStr.append(chars, offset, length);
                    int spaces = this.normalizeWhitespace(this.fUnnormalizedStr, this.fWhiteSpace == 2);
                    int nLength = this.fNormalizedStr.length();
                    if (nLength > 0) {
                        if (!this.fFirstChunk && this.fWhiteSpace == 2 && this.fTrailing) {
                            this.fNormalizedStr.insert(0, ' ');
                            ++nLength;
                        }
                        if (length - offset != nLength) {
                            char[] newChars = new char[nLength];
                            this.fNormalizedStr.getChars(0, nLength, newChars, 0);
                            chars = newChars;
                            offset = 0;
                            length = nLength;
                        } else {
                            this.fNormalizedStr.getChars(0, nLength, chars, 0);
                        }
                        this.fDatatypeBuffer.append(chars, offset, length);
                        int count = this.fMatcherStack.getMatcherCount();
                        int i = 0;
                        while (i < count) {
                            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
                            matcher.characters(chars, offset, length);
                            ++i;
                        }
                        this.fDocumentHandler.characters(chars, offset, length);
                    }
                    this.fTrailing = spaces > 1;
                    this.fFirstChunk = false;
                    return;
                }
            }
        }
        this.fFirstChunk = false;
        int count = this.fMatcherStack.getMatcherCount();
        int i = 0;
        while (i < count) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
            matcher.characters(chars, offset, length);
            ++i;
        }
        this.fDocumentHandler.characters(chars, offset, length);
    }

    public void processCharacters(int data) throws Exception {
        int count;
        if (this.fValidating) {
            if (this.fInElementContent || this.fCurrentContentSpecType == 0) {
                this.charDataInContent();
            }
            if (this.fBufferDatatype) {
                this.fGrammar.getElementDecl(this.fCurrentElementIndex, this.fTempElementDecl);
                this.fCurrentDV = this.fTempElementDecl.datatypeValidator;
                if (this.fXsiTypeValidator != null) {
                    this.fCurrentDV = this.fXsiTypeValidator;
                    this.fXsiTypeValidator = null;
                }
                if (this.fCurrentDV != null) {
                    this.fWhiteSpace = this.fCurrentDV.getWSFacet();
                }
                if (!this.fNormalizeContents || this.fWhiteSpace == 0) {
                    this.fDatatypeBuffer.append(this.fStringPool.toString(data));
                } else {
                    String str = this.fStringPool.toString(data);
                    int length = str.length();
                    this.fUnnormalizedStr.setLength(0);
                    this.fUnnormalizedStr.append(str);
                    int spaces = this.normalizeWhitespace(this.fUnnormalizedStr, this.fWhiteSpace == 2);
                    if (this.fWhiteSpace != 0) {
                        this.fStringPool.releaseString(data);
                        data = this.fStringPool.addString(this.fNormalizedStr.toString());
                    }
                    this.fDatatypeBuffer.append(this.fNormalizedStr.toString());
                }
            }
        }
        if ((count = this.fMatcherStack.getMatcherCount()) > 0) {
            String text = this.fStringPool.toString(data);
            char[] chars = new char[text.length()];
            int offset = 0;
            int length = chars.length;
            text.getChars(offset, length, chars, offset);
            int i = 0;
            while (i < count) {
                XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
                matcher.characters(chars, offset, length);
                ++i;
            }
        }
        this.fDocumentHandler.characters(data);
    }

    public void processWhitespace(char[] chars, int offset, int length) throws Exception {
        if (this.fInElementContent) {
            if (this.fStandaloneReader != -1 && this.fValidating && this.getElementDeclIsExternal(this.fCurrentElementIndex)) {
                this.reportRecoverableXMLError(143, 80);
            }
            this.fDocumentHandler.ignorableWhitespace(chars, offset, length);
        } else {
            if (this.fCurrentContentSpecType == 0) {
                this.charDataInContent();
            }
            int count = this.fMatcherStack.getMatcherCount();
            int i = 0;
            while (i < count) {
                XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
                matcher.characters(chars, offset, length);
                ++i;
            }
            if (this.fGrammar != null && this.fValidating) {
                this.fGrammar.getElementDecl(this.fCurrentElementIndex, this.fTempElementDecl);
                this.fCurrentDV = this.fTempElementDecl.datatypeValidator;
                if (this.fXsiTypeValidator != null) {
                    this.fCurrentDV = this.fXsiTypeValidator;
                    this.fXsiTypeValidator = null;
                }
                if (this.fCurrentDV != null) {
                    this.fWhiteSpace = this.fCurrentDV.getWSFacet();
                }
                if (this.fWhiteSpace == 0) {
                    this.fDatatypeBuffer.append(chars, offset, length);
                }
            }
            this.fDocumentHandler.characters(chars, offset, length);
        }
    }

    public void processWhitespace(int data) throws Exception {
        if (this.fInElementContent) {
            if (this.fStandaloneReader != -1 && this.fValidating && this.getElementDeclIsExternal(this.fCurrentElementIndex)) {
                this.reportRecoverableXMLError(143, 80);
            }
            this.fDocumentHandler.ignorableWhitespace(data);
        } else {
            int count;
            if (this.fCurrentContentSpecType == 0) {
                this.charDataInContent();
            }
            if ((count = this.fMatcherStack.getMatcherCount()) > 0) {
                String text = this.fStringPool.toString(data);
                char[] chars = new char[text.length()];
                int offset = 0;
                int length = chars.length;
                text.getChars(length, length, chars, offset);
                int i = 0;
                while (i < count) {
                    XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
                    matcher.characters(chars, offset, length);
                    ++i;
                }
            }
            if (this.fGrammar != null && this.fValidating) {
                this.fGrammar.getElementDecl(this.fCurrentElementIndex, this.fTempElementDecl);
                this.fCurrentDV = this.fTempElementDecl.datatypeValidator;
                if (this.fXsiTypeValidator != null) {
                    this.fCurrentDV = this.fXsiTypeValidator;
                    this.fXsiTypeValidator = null;
                }
                if (this.fCurrentDV != null) {
                    this.fWhiteSpace = this.fCurrentDV.getWSFacet();
                }
                if (this.fWhiteSpace == 0) {
                    this.fDatatypeBuffer.append(this.fStringPool.toString(data));
                }
            }
            this.fDocumentHandler.characters(data);
        }
    }

    public void scanElementType(XMLEntityHandler.EntityReader entityReader, char fastchar, QName element) throws Exception {
        if (!this.fNamespacesEnabled) {
            element.clear();
            element.rawname = element.localpart = entityReader.scanName(fastchar);
        } else {
            entityReader.scanQName(fastchar, element);
            if (entityReader.lookingAtChar(':', false)) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
                entityReader.skipPastNmtoken(' ');
            }
        }
    }

    public boolean scanExpectedElementType(XMLEntityHandler.EntityReader entityReader, char fastchar, QName element) throws Exception {
        if (this.fCurrentElementCharArrayRange == null) {
            this.fCurrentElementCharArrayRange = this.fStringPool.createCharArrayRange();
        }
        this.fStringPool.getCharArrayRange(this.fCurrentElement.rawname, this.fCurrentElementCharArrayRange);
        return entityReader.scanExpectedName(fastchar, this.fCurrentElementCharArrayRange);
    }

    public void scanAttributeName(XMLEntityHandler.EntityReader entityReader, QName element, QName attribute) throws Exception {
        if (!this.fSeenRootElement) {
            this.fSeenRootElement = true;
            this.rootElementSpecified(element);
            this.fStringPool.resetShuffleCount();
        }
        if (!this.fNamespacesEnabled) {
            attribute.clear();
            attribute.rawname = attribute.localpart = entityReader.scanName('=');
        } else {
            entityReader.scanQName('=', attribute);
            if (entityReader.lookingAtChar(':', false)) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 126, 139, null, 2);
                entityReader.skipPastNmtoken(' ');
            }
        }
    }

    public void callStartDocument() throws Exception {
        if (!this.fCalledStartDocument) {
            this.fDocumentHandler.startDocument();
            this.fCalledStartDocument = true;
            if (this.fValidating) {
                this.fValueStoreCache.startDocument();
            }
        }
    }

    public void callEndDocument() throws Exception {
        if (this.fCalledStartDocument) {
            if (this.fValidating) {
                this.fValueStoreCache.endDocument();
            }
            this.fDocumentHandler.endDocument();
        }
    }

    public void callXMLDecl(int version, int encoding, int standalone) throws Exception {
        this.fDocumentHandler.xmlDecl(version, encoding, standalone);
    }

    public void callStandaloneIsYes() throws Exception {
        this.fStandaloneReader = this.fEntityHandler.getReaderId();
    }

    public void callTextDecl(int version, int encoding) throws Exception {
        this.fDocumentHandler.textDecl(version, encoding);
    }

    public void element(QName element) throws Exception {
        this.fAttrListHandle = -1;
    }

    public boolean attribute(QName element, QName attrName, int attrValue) throws Exception {
        if (this.fAttrListHandle == -1) {
            this.fAttrListHandle = this.fAttrList.startAttrList();
        }
        return this.fAttrList.addAttr(attrName, attrValue, this.fCDATASymbol, true, true) == -1;
    }

    public void callStartElement(QName element) throws Exception {
        int i;
        int[] dupAttrs;
        if (!this.fSeenRootElement) {
            this.rootElementSpecified(element);
            this.fStringPool.resetShuffleCount();
        }
        if (this.fGrammar != null && this.fGrammarIsDTDGrammar) {
            this.fAttrListHandle = this.addDTDDefaultAttributes(element, this.fAttrList, this.fAttrListHandle, this.fValidating, this.fStandaloneReader != -1);
        }
        this.fCheckedForSchema = true;
        if (this.fNamespacesEnabled) {
            this.bindNamespacesToElementAndAttributes(element, this.fAttrList);
        }
        if (this.fDynamicValidation && this.fGrammar == null) {
            this.fValidating = false;
        }
        if (!this.fSeenRootElement) {
            this.fSeenRootElement = true;
        }
        this.validateElementAndAttributes(element, this.fAttrList);
        if (this.fAttrListHandle != -1 && (dupAttrs = this.fAttrList.endAttrList()) != null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.fStringPool.toString(element.rawname);
            Object[] args = objectArray;
            i = 0;
            while (i < dupAttrs.length) {
                args[1] = this.fStringPool.toString(dupAttrs[i]);
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 28, 27, args, 1);
                ++i;
            }
        }
        if (this.fValidating && this.fGrammar != null && this.fGrammarIsSchemaGrammar) {
            this.fValueStoreCache.startElement();
            this.fMatcherStack.pushContext();
            int eindex = this.fGrammar.getElementDeclIndex(element, -1);
            if (eindex != -1) {
                this.fGrammar.getElementDecl(eindex, this.fTempElementDecl);
                this.fValueStoreCache.initValueStoresFor(this.fTempElementDecl);
                int uCount = this.fTempElementDecl.unique.size();
                i = 0;
                while (i < uCount) {
                    this.activateSelectorFor((IdentityConstraint)this.fTempElementDecl.unique.elementAt(i));
                    ++i;
                }
                int kCount = this.fTempElementDecl.key.size();
                int i2 = 0;
                while (i2 < kCount) {
                    this.activateSelectorFor((IdentityConstraint)this.fTempElementDecl.key.elementAt(i2));
                    ++i2;
                }
                int krCount = this.fTempElementDecl.keyRef.size();
                int i3 = 0;
                while (i3 < krCount) {
                    this.activateSelectorFor((IdentityConstraint)this.fTempElementDecl.keyRef.elementAt(i3));
                    ++i3;
                }
            }
            int count = this.fMatcherStack.getMatcherCount();
            i = 0;
            while (i < count) {
                XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
                matcher.startElement(element, this.fAttrList, this.fAttrListHandle, this.fCurrentElementIndex, (SchemaGrammar)this.fGrammar);
                ++i;
            }
        }
        this.fDocumentHandler.startElement(element, this.fAttrList, this.fAttrListHandle);
        ++this.fElementDepth;
        this.fAttrListHandle = -1;
        if (this.fValidating) {
            QName qname;
            Object[] newarray;
            if (this.fElementChildrenOffsetStack.length <= this.fElementDepth) {
                newarray = new int[this.fElementChildrenOffsetStack.length * 2];
                System.arraycopy(this.fElementChildrenOffsetStack, 0, newarray, 0, this.fElementChildrenOffsetStack.length);
                this.fElementChildrenOffsetStack = newarray;
            }
            this.fElementChildrenOffsetStack[this.fElementDepth] = this.fElementChildrenLength;
            if (this.fElementChildren.length <= this.fElementChildrenLength) {
                newarray = new QName[this.fElementChildrenLength * 2];
                System.arraycopy(this.fElementChildren, 0, newarray, 0, this.fElementChildren.length);
                this.fElementChildren = (QName[])newarray;
            }
            if ((qname = this.fElementChildren[this.fElementChildrenLength]) == null) {
                int i4 = this.fElementChildrenLength;
                while (i4 < this.fElementChildren.length) {
                    this.fElementChildren[i4] = new QName();
                    ++i4;
                }
                qname = this.fElementChildren[this.fElementChildrenLength];
            }
            qname.setValues(element);
            ++this.fElementChildrenLength;
        }
        this.ensureStackCapacity(this.fElementDepth);
        this.fCurrentElement.setValues(element);
        this.fCurrentElementEntity = this.fEntityHandler.getReaderId();
        this.fElementQNamePartsStack[this.fElementDepth].setValues(this.fCurrentElement);
        this.fElementEntityStack[this.fElementDepth] = this.fCurrentElementEntity;
        this.fElementIndexStack[this.fElementDepth] = this.fCurrentElementIndex;
        this.fContentSpecTypeStack[this.fElementDepth] = this.fCurrentContentSpecType;
        if (this.fNeedValidationOff) {
            this.fValidating = false;
            this.fNeedValidationOff = false;
        }
        if (this.fValidating && this.fGrammarIsSchemaGrammar) {
            this.pushContentLeafStack();
        } else {
            this.fContentModelStateStack[this.fElementDepth] = -2;
        }
        this.fValidationFlagStack[this.fElementDepth] = this.fValidating ? 0 : -1;
        this.fScopeStack[this.fElementDepth] = this.fCurrentScope;
        this.fGrammarNameSpaceIndexStack[this.fElementDepth] = this.fGrammarNameSpaceIndex;
    }

    private void activateSelectorFor(IdentityConstraint ic) throws Exception {
        Selector selector = ic.getSelector();
        XMLValidator activator = this;
        if (selector == null) {
            return;
        }
        XPathMatcher matcher = selector.createMatcher(activator);
        this.fMatcherStack.addMatcher(matcher);
        matcher.startDocumentFragment(this.fStringPool);
    }

    private void pushContentLeafStack() throws Exception {
        int contentType = this.getContentSpecType(this.fCurrentElementIndex);
        if (contentType == 4 || contentType == 3) {
            XMLContentModel cm = this.getElementContentModel(this.fCurrentElementIndex);
            ContentLeafNameTypeVector cv = cm.getContentLeafNameTypeVector();
            if (cm != null) {
                this.fContentLeafStack[this.fElementDepth] = cv;
                this.fContentModelStack[this.fElementDepth] = cm;
                this.fContentModelStateStack[this.fElementDepth] = cm instanceof DFAContentModel && cv != null ? 0 : -2;
                this.fContentModelEleCount[this.fElementDepth] = 0;
            }
        } else {
            this.fContentModelStateStack[this.fElementDepth] = -2;
        }
    }

    private void ensureStackCapacity(int newElementDepth) {
        if (newElementDepth == this.fElementQNamePartsStack.length) {
            int[] newStack = new int[newElementDepth * 2];
            System.arraycopy(this.fScopeStack, 0, newStack, 0, newElementDepth);
            this.fScopeStack = newStack;
            newStack = new int[newElementDepth * 2];
            System.arraycopy(this.fGrammarNameSpaceIndexStack, 0, newStack, 0, newElementDepth);
            this.fGrammarNameSpaceIndexStack = newStack;
            QName[] newStackOfQueue = new QName[newElementDepth * 2];
            System.arraycopy(this.fElementQNamePartsStack, 0, newStackOfQueue, 0, newElementDepth);
            this.fElementQNamePartsStack = newStackOfQueue;
            QName qname = this.fElementQNamePartsStack[newElementDepth];
            if (qname == null) {
                int i = newElementDepth;
                while (i < this.fElementQNamePartsStack.length) {
                    this.fElementQNamePartsStack[i] = new QName();
                    ++i;
                }
            }
            newStack = new int[newElementDepth * 2];
            System.arraycopy(this.fElementEntityStack, 0, newStack, 0, newElementDepth);
            this.fElementEntityStack = newStack;
            newStack = new int[newElementDepth * 2];
            System.arraycopy(this.fElementIndexStack, 0, newStack, 0, newElementDepth);
            this.fElementIndexStack = newStack;
            newStack = new int[newElementDepth * 2];
            System.arraycopy(this.fContentSpecTypeStack, 0, newStack, 0, newElementDepth);
            this.fContentSpecTypeStack = newStack;
            newStack = new int[newElementDepth * 2];
            System.arraycopy(this.fValidationFlagStack, 0, newStack, 0, newElementDepth);
            this.fValidationFlagStack = newStack;
            ContentLeafNameTypeVector[] newStackV = new ContentLeafNameTypeVector[newElementDepth * 2];
            System.arraycopy(this.fContentLeafStack, 0, newStackV, 0, newElementDepth);
            this.fContentLeafStack = newStackV;
            XMLContentModel[] newStackCM = new XMLContentModel[newElementDepth * 2];
            System.arraycopy(this.fContentModelStack, 0, newStackCM, 0, newElementDepth);
            this.fContentModelStack = newStackCM;
            newStack = new int[newElementDepth * 2];
            System.arraycopy(this.fContentModelStateStack, 0, newStack, 0, newElementDepth);
            this.fContentModelStateStack = newStack;
            newStack = new int[newElementDepth * 2];
            System.arraycopy(this.fContentModelEleCount, 0, newStack, 0, newElementDepth);
            this.fContentModelEleCount = newStack;
        }
    }

    public void callEndElement(int readerId) throws Exception {
        int prefixIndex = this.fCurrentElement.prefix;
        int elementType = this.fCurrentElement.rawname;
        if (this.fCurrentElementEntity != readerId) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 68, 68, new Object[]{this.fStringPool.toString(elementType)}, 2);
        }
        --this.fElementDepth;
        if (this.fValidating) {
            int elementIndex = this.fCurrentElementIndex;
            if (elementIndex != -1 && this.fCurrentContentSpecType != -1) {
                QName[] children = this.fElementChildren;
                int childrenOffset = this.fElementChildrenOffsetStack[this.fElementDepth + 1] + 1;
                int childrenLength = this.fElementChildrenLength - childrenOffset;
                int result = this.checkContent(elementIndex, children, childrenOffset, childrenLength);
                this.fCurrentDV = null;
                if (result != -1) {
                    int majorCode = result != childrenLength ? 87 : 88;
                    this.fGrammar.getElementDecl(elementIndex, this.fTempElementDecl);
                    if (this.fTempElementDecl.type == 0) {
                        this.reportRecoverableXMLError(majorCode, 0, this.fStringPool.toString(elementType), "EMPTY");
                    } else {
                        this.reportRecoverableXMLError(majorCode, 0, this.fStringPool.toString(elementType), XMLContentSpec.toString(this.fGrammar, this.fStringPool, this.fTempElementDecl.contentSpecIndex));
                    }
                }
            }
            this.fElementChildrenLength = this.fElementChildrenOffsetStack[this.fElementDepth + 1] + 1;
            if (this.fGrammarIsSchemaGrammar) {
                int oldCount = this.fMatcherStack.getMatcherCount();
                int i = oldCount - 1;
                while (i >= 0) {
                    XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
                    matcher.endElement(this.fCurrentElement, this.fCurrentElementIndex, (SchemaGrammar)this.fGrammar);
                    --i;
                }
                if (this.fMatcherStack.size() > 0) {
                    this.fMatcherStack.popContext();
                }
                int newCount = this.fMatcherStack.getMatcherCount();
                int i2 = oldCount - 1;
                while (i2 >= newCount) {
                    XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i2);
                    IdentityConstraint id = matcher.getIDConstraint();
                    if (id != null && id.getType() != 2) {
                        matcher.endDocumentFragment();
                        this.fValueStoreCache.transplant(id);
                    } else if (id == null) {
                        matcher.endDocumentFragment();
                    }
                    --i2;
                }
                i2 = oldCount - 1;
                while (i2 >= newCount) {
                    XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i2);
                    IdentityConstraint id = matcher.getIDConstraint();
                    if (id != null && id.getType() == 2) {
                        ValueStoreBase values = this.fValueStoreCache.getValueStoreFor(id);
                        if (values != null) {
                            values.endDocumentFragment();
                        }
                        matcher.endDocumentFragment();
                    }
                    --i2;
                }
                this.fValueStoreCache.endElement();
            }
        }
        this.fDocumentHandler.endElement(this.fCurrentElement);
        if (this.fNamespacesEnabled) {
            this.fNamespacesScope.decreaseDepth();
        }
        if (this.fElementDepth < -1) {
            throw new RuntimeException("FWK008 Element stack underflow");
        }
        if (this.fElementDepth < 0) {
            this.fCurrentElement.clear();
            this.fCurrentElementEntity = -1;
            this.fCurrentElementIndex = -1;
            this.fCurrentContentSpecType = -1;
            this.fInElementContent = false;
            if (this.fValidating) {
                try {
                    this.fValIDRef.validate(null, this.fCheckIDRef);
                    this.fIdDefs.clear();
                    this.fIdREFDefs.clear();
                }
                catch (InvalidDatatypeValueException ex) {
                    this.reportRecoverableXMLError(ex.getMajorCode(), ex.getMinorCode(), ex.getMessage());
                }
            }
            return;
        }
        this.fCurrentElement.prefix = -1;
        this.fCurrentElement.localpart = this.fNamespacesEnabled ? this.fElementQNamePartsStack[this.fElementDepth].localpart : this.fElementQNamePartsStack[this.fElementDepth].rawname;
        this.fCurrentElement.rawname = this.fElementQNamePartsStack[this.fElementDepth].rawname;
        this.fCurrentElement.uri = this.fElementQNamePartsStack[this.fElementDepth].uri;
        this.fCurrentElement.prefix = this.fElementQNamePartsStack[this.fElementDepth].prefix;
        this.fCurrentElementEntity = this.fElementEntityStack[this.fElementDepth];
        this.fCurrentElementIndex = this.fElementIndexStack[this.fElementDepth];
        this.fCurrentContentSpecType = this.fContentSpecTypeStack[this.fElementDepth];
        this.fValidating = this.fValidationFlagStack[this.fElementDepth] == 0;
        this.fCurrentScope = this.fScopeStack[this.fElementDepth];
        if (this.fGrammarNameSpaceIndex != this.fGrammarNameSpaceIndexStack[this.fElementDepth]) {
            this.fGrammarNameSpaceIndex = this.fGrammarNameSpaceIndexStack[this.fElementDepth];
            if (this.fValidating && this.fGrammarIsSchemaGrammar) {
                if (this.fGrammarNameSpaceIndex < 0) {
                    this.fGrammar = null;
                    this.fGrammarIsSchemaGrammar = false;
                    this.fGrammarIsDTDGrammar = false;
                } else if (!this.switchGrammar(this.fGrammarNameSpaceIndex)) {
                    this.reportRecoverableXMLError(169, 146, "Grammar with uri: " + this.fStringPool.toString(this.fGrammarNameSpaceIndex) + " , can not be found; possible mismatch between instance document's namespace and that of schema");
                }
            }
        }
        if (this.fValidating) {
            this.fBufferDatatype = false;
        }
        this.fInElementContent = this.fCurrentContentSpecType == 4;
    }

    public void callStartCDATA() throws Exception {
        if (this.fValidating && this.fInElementContent) {
            this.charDataInContent();
        }
        this.fDocumentHandler.startCDATA();
    }

    public void callEndCDATA() throws Exception {
        this.fDocumentHandler.endCDATA();
    }

    public void callCharacters(int ch) throws Exception {
        int count;
        if (this.fCharRefData == null) {
            this.fCharRefData = new char[2];
        }
        int n = count = ch < 65536 ? 1 : 2;
        if (count == 1) {
            this.fCharRefData[0] = (char)ch;
        } else {
            this.fCharRefData[0] = (char)((ch - 65536 >> 10) + 55296);
            this.fCharRefData[1] = (char)((ch - 65536 & 0x3FF) + 56320);
        }
        if (this.fValidating && (this.fInElementContent || this.fCurrentContentSpecType == 0)) {
            this.charDataInContent();
        }
        if (this.fValidating && this.fBufferDatatype) {
            this.fDatatypeBuffer.append(this.fCharRefData, 0, 1);
        }
        int matcherCount = this.fMatcherStack.getMatcherCount();
        int i = 0;
        while (i < matcherCount) {
            XPathMatcher matcher = this.fMatcherStack.getMatcherAt(i);
            matcher.characters(this.fCharRefData, 0, count);
            ++i;
        }
        if (this.fSendCharDataAsCharArray) {
            this.fDocumentHandler.characters(this.fCharRefData, 0, count);
        } else {
            int index = this.fStringPool.addString(new String(this.fCharRefData, 0, count));
            this.fDocumentHandler.characters(index);
        }
    }

    public void callProcessingInstruction(int target, int data) throws Exception {
        this.fDocumentHandler.processingInstruction(target, data);
    }

    public void callComment(int comment) throws Exception {
        this.fDocumentHandler.comment(comment);
    }

    public void startNamespaceDeclScope(int prefix, int uri) throws Exception {
        this.fDocumentHandler.startNamespaceDeclScope(prefix, uri);
    }

    public void endNamespaceDeclScope(int prefix) throws Exception {
        this.fDocumentHandler.endNamespaceDeclScope(prefix);
    }

    public void setRootElementType(QName rootElement) {
        this.fRootElement.setValues(rootElement);
    }

    private boolean getElementDeclIsExternal(int elementIndex) {
        if (this.fGrammarIsDTDGrammar) {
            return ((DTDGrammar)this.fGrammar).getElementDeclIsExternal(elementIndex);
        }
        return false;
    }

    public int getContentSpecType(int elementIndex) {
        int contentSpecType = -1;
        if (elementIndex > -1 && this.fGrammar.getElementDecl(elementIndex, this.fTempElementDecl)) {
            contentSpecType = this.fTempElementDecl.type;
        }
        return contentSpecType;
    }

    public int getContentSpecHandle(int elementIndex) {
        int contentSpecHandle = -1;
        if (elementIndex > -1 && this.fGrammar.getElementDecl(elementIndex, this.fTempElementDecl)) {
            contentSpecHandle = this.fTempElementDecl.contentSpecIndex;
        }
        return contentSpecHandle;
    }

    private void reportSchemaError(int code, Object[] args) throws Exception {
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", code, 0, args, 1);
    }

    protected void reportRecoverableXMLError(int majorCode, int minorCode) throws Exception {
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, null, 1);
    }

    protected void reportRecoverableXMLError(int majorCode, int minorCode, int stringIndex1) throws Exception {
        Object[] args = new Object[]{this.fStringPool.toString(stringIndex1)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 1);
    }

    protected void reportRecoverableXMLError(int majorCode, int minorCode, String string1) throws Exception {
        Object[] args = new Object[]{string1};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 1);
    }

    protected void reportRecoverableXMLError(int majorCode, int minorCode, int stringIndex1, int stringIndex2) throws Exception {
        Object[] args = new Object[]{this.fStringPool.toString(stringIndex1), this.fStringPool.toString(stringIndex2)};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 1);
    }

    protected void reportRecoverableXMLError(int majorCode, int minorCode, String string1, String string2) throws Exception {
        Object[] args = new Object[]{string1, string2};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 1);
    }

    protected void reportRecoverableXMLError(int majorCode, int minorCode, String string1, String string2, String string3) throws Exception {
        Object[] args = new Object[]{string1, string2, string3};
        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", majorCode, minorCode, args, 1);
    }

    protected int whatCanGoHere(int elementIndex, boolean fullyValid, InsertableElementsInfo info) throws Exception {
        if (info.insertAt > info.childCount || info.curChildren == null || info.childCount < 1 || info.childCount > info.curChildren.length) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 13, 0, null, 2);
        }
        int retVal = 0;
        try {
            XMLContentModel cmElem = this.getElementContentModel(elementIndex);
            retVal = cmElem.whatCanGoHere(fullyValid, info);
        }
        catch (CMException excToCatch) {
            int majorCode = excToCatch.getErrorCode();
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", majorCode, 0, null, 2);
            throw excToCatch;
        }
        return retVal;
    }

    protected boolean getAttDefIsExternal(QName element, QName attribute) {
        int attDefIndex = this.getAttDef(element, attribute);
        if (this.fGrammarIsDTDGrammar) {
            return ((DTDGrammar)this.fGrammar).getAttributeDeclIsExternal(attDefIndex);
        }
        return false;
    }

    private boolean usingStandaloneReader() {
        return this.fStandaloneReader == -1 || this.fEntityHandler.getReaderId() == this.fStandaloneReader;
    }

    private LocatorImpl getLocatorImpl(LocatorImpl fillin) {
        Locator here = this.fErrorReporter.getLocator();
        if (fillin == null) {
            return new LocatorImpl(here);
        }
        fillin.setPublicId(here.getPublicId());
        fillin.setSystemId(here.getSystemId());
        fillin.setLineNumber(here.getLineNumber());
        fillin.setColumnNumber(here.getColumnNumber());
        return fillin;
    }

    private void poolReset() {
        if (this.fValidating) {
            this.fIdDefs.clear();
            this.fIdREFDefs.clear();
        }
    }

    private void resetCommon(StringPool stringPool) throws Exception {
        this.fStringPool = stringPool;
        this.fValidateEntity.setDatatypeObject(new Object[]{this.fEntityHandler, stringPool});
        this.fValidating = this.fValidationEnabled;
        this.fValidationEnabledByDynamic = false;
        this.fDynamicDisabledByValidation = false;
        this.fNormalizeContents = false;
        this.poolReset();
        this.fCalledStartDocument = false;
        this.fStandaloneReader = -1;
        this.fElementChildrenLength = 0;
        this.fElementDepth = -1;
        this.fSeenRootElement = false;
        this.fSeenDoctypeDecl = false;
        this.fNamespacesScope = null;
        this.fNamespacesPrefix = -1;
        this.fRootElement.clear();
        this.fAttrListHandle = -1;
        this.fCheckedForSchema = false;
        this.fCurrentScope = -1;
        this.fCurrentSchemaURI = 0;
        this.fEmptyURI = 0;
        this.fXsiPrefix = -1;
        this.fXsiTypeValidator = null;
        this.fNil = false;
        this.fGrammar = null;
        this.fGrammarNameSpaceIndex = 0;
        this.fSGComparator = null;
        this.fGrammarIsDTDGrammar = false;
        this.fGrammarIsSchemaGrammar = false;
        this.fCurrentDV = null;
        this.fFirstChunk = true;
        this.fTrailing = false;
        this.fWhiteSpace = (short)2;
        this.fMatcherStack.clear();
        this.UPACheckedGrammarURIs.clear();
        this.init();
    }

    private void init() {
        this.fEmptyURI = this.fStringPool.addSymbol("");
        this.fXsiURI = this.fStringPool.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
        this.fEMPTYSymbol = this.fStringPool.addSymbol("EMPTY");
        this.fANYSymbol = this.fStringPool.addSymbol("ANY");
        this.fMIXEDSymbol = this.fStringPool.addSymbol("MIXED");
        this.fCHILDRENSymbol = this.fStringPool.addSymbol("CHILDREN");
        this.fCDATASymbol = this.fStringPool.addSymbol("CDATA");
        this.fIDSymbol = this.fStringPool.addSymbol("ID");
        this.fIDREFSymbol = this.fStringPool.addSymbol("IDREF");
        this.fIDREFSSymbol = this.fStringPool.addSymbol("IDREFS");
        this.fENTITYSymbol = this.fStringPool.addSymbol("ENTITY");
        this.fENTITIESSymbol = this.fStringPool.addSymbol("ENTITIES");
        this.fNMTOKENSymbol = this.fStringPool.addSymbol("NMTOKEN");
        this.fNMTOKENSSymbol = this.fStringPool.addSymbol("NMTOKENS");
        this.fNOTATIONSymbol = this.fStringPool.addSymbol("NOTATION");
        this.fENUMERATIONSymbol = this.fStringPool.addSymbol("ENUMERATION");
        this.fREQUIREDSymbol = this.fStringPool.addSymbol("#REQUIRED");
        this.fFIXEDSymbol = this.fStringPool.addSymbol("#FIXED");
        this.fDATATYPESymbol = this.fStringPool.addSymbol("<<datatype>>");
        this.fEpsilonIndex = this.fStringPool.addSymbol("<<CMNODE_EPSILON>>");
        this.fXMLLang = this.fStringPool.addSymbol("xml:lang");
    }

    private void initDataTypeValidators() {
        if (this.fGrammarResolver != null) {
            this.fDataTypeReg = (DatatypeValidatorFactoryImpl)this.fGrammarResolver.getDatatypeRegistry();
            this.fDataTypeReg.initializeDTDRegistry();
        }
        if (this.fDataTypeReg != null) {
            this.fValID = this.fDataTypeReg.getDatatypeValidator("ID");
            this.fValIDRef = this.fDataTypeReg.getDatatypeValidator("IDREF");
            this.fValIDRefs = this.fDataTypeReg.getDatatypeValidator("IDREFS");
            this.fValENTITY = this.fDataTypeReg.getDatatypeValidator("ENTITY");
            this.fValENTITIES = this.fDataTypeReg.getDatatypeValidator("ENTITIES");
            this.fValNMTOKEN = this.fDataTypeReg.getDatatypeValidator("NMTOKEN");
            this.fValNMTOKENS = this.fDataTypeReg.getDatatypeValidator("NMTOKENS");
            this.fValNOTATION = this.fDataTypeReg.getDatatypeValidator("NOTATION");
        }
    }

    private int addDefaultAttributes(int elementIndex, XMLAttrList attrList, int attrIndex, boolean validationEnabled, boolean standalone) throws Exception {
        this.fGrammar.getElementDecl(elementIndex, this.fTempElementDecl);
        int elementNameIndex = this.fTempElementDecl.name.localpart;
        int attlistIndex = this.fGrammar.getFirstAttributeDeclIndex(elementIndex);
        int firstCheck = attrIndex;
        int lastCheck = -1;
        while (attlistIndex != -1) {
            boolean fixed;
            this.fGrammar.getAttributeDecl(attlistIndex, this.fTempAttDecl);
            int attPrefix = this.fTempAttDecl.name.prefix;
            int attName = this.fTempAttDecl.name.localpart;
            int attType = this.attributeTypeName(this.fTempAttDecl);
            int attDefType = this.fTempAttDecl.defaultType;
            int attValue = -1;
            if (this.fTempAttDecl.defaultValue != null) {
                attValue = this.fStringPool.addSymbol(this.fTempAttDecl.defaultValue);
            }
            boolean specified = false;
            boolean required = (attDefType & 2) > 0;
            boolean prohibited = (attDefType & 4) > 0;
            boolean bl = fixed = (attDefType & 0x10) > 0;
            if (firstCheck != -1) {
                boolean cdata;
                boolean bl2 = cdata = attType == this.fCDATASymbol;
                if (!cdata || required || prohibited || attValue != -1) {
                    int i = attrList.getFirstAttr(firstCheck);
                    while (i != -1 && (lastCheck == -1 || i <= lastCheck)) {
                        if (this.fGrammarIsDTDGrammar && attrList.getAttrName(i) == this.fTempAttDecl.name.rawname || this.fStringPool.equalNames(attrList.getAttrLocalpart(i), attName) && this.fStringPool.equalNames(attrList.getAttrURI(i), this.fTempAttDecl.name.uri)) {
                            if (prohibited && validationEnabled) {
                                Object[] args = new Object[]{this.fStringPool.toString(elementNameIndex), this.fStringPool.toString(attName)};
                                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 28, 0, args, 1);
                            }
                            specified = true;
                            break;
                        }
                        i = attrList.getNextAttr(i);
                    }
                }
            }
            if (!specified) {
                if (required) {
                    if (validationEnabled) {
                        Object[] args = new Object[]{this.fStringPool.toString(elementNameIndex), this.fStringPool.toString(attName)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 94, 88, args, 1);
                    }
                } else if (attValue != -1) {
                    if (validationEnabled && standalone && this.fGrammarIsDTDGrammar && ((DTDGrammar)this.fGrammar).getAttributeDeclIsExternal(attlistIndex)) {
                        Object[] args = new Object[]{this.fStringPool.toString(elementNameIndex), this.fStringPool.toString(attName)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 95, 80, args, 1);
                    }
                    if (validationEnabled) {
                        this.validateUsingDV(this.fTempAttDecl.datatypeValidator, this.fStringPool.toString(attValue), true);
                    }
                    if (attrIndex == -1) {
                        attrIndex = attrList.startAttrList();
                    }
                    this.fTempQName.setValues(attPrefix, attName, attName, this.fTempAttDecl.name.uri);
                    int newAttr = attrList.addAttr(this.fTempQName, attValue, attType, false, false);
                    if (lastCheck == -1) {
                        lastCheck = newAttr;
                    }
                }
            }
            attlistIndex = this.fGrammar.getNextAttributeDeclIndex(attlistIndex);
        }
        return attrIndex;
    }

    private int addDTDDefaultAttributes(QName element, XMLAttrList attrList, int attrIndex, boolean validationEnabled, boolean standalone) throws Exception {
        int elementIndex = this.fGrammar.getElementDeclIndex(element, -1);
        if (elementIndex == -1) {
            return attrIndex;
        }
        this.fGrammar.getElementDecl(elementIndex, this.fTempElementDecl);
        int elementNameIndex = this.fTempElementDecl.name.rawname;
        int attlistIndex = this.fGrammar.getFirstAttributeDeclIndex(elementIndex);
        int firstCheck = attrIndex;
        int lastCheck = -1;
        while (attlistIndex != -1) {
            boolean required;
            this.fGrammar.getAttributeDecl(attlistIndex, this.fTempAttDecl);
            int attPrefix = this.fTempAttDecl.name.prefix;
            int attName = this.fTempAttDecl.name.rawname;
            int attLocalpart = this.fTempAttDecl.name.localpart;
            int attType = this.attributeTypeName(this.fTempAttDecl);
            int attDefType = this.fTempAttDecl.defaultType;
            int attValue = -1;
            if (this.fTempAttDecl.defaultValue != null) {
                attValue = this.fStringPool.addSymbol(this.fTempAttDecl.defaultValue);
            }
            boolean specified = false;
            boolean bl = required = (attDefType & 2) > 0;
            if (firstCheck != -1) {
                boolean cdata;
                boolean bl2 = cdata = attType == this.fCDATASymbol;
                if (!cdata || required || attValue != -1) {
                    int i = attrList.getFirstAttr(firstCheck);
                    while (i != -1 && (lastCheck == -1 || i <= lastCheck)) {
                        if (attrList.getAttrName(i) == this.fTempAttDecl.name.rawname) {
                            int alistValue;
                            if (validationEnabled && (attDefType & 0x10) > 0 && (alistValue = attrList.getAttValue(i)) != attValue && !this.fStringPool.toString(alistValue).equals(this.fStringPool.toString(attValue))) {
                                Object[] args = new Object[]{this.fStringPool.toString(elementNameIndex), this.fStringPool.toString(attName), this.fStringPool.toString(alistValue), this.fStringPool.toString(attValue)};
                                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 93, 87, args, 1);
                            }
                            specified = true;
                            break;
                        }
                        i = attrList.getNextAttr(i);
                    }
                }
            }
            if (!specified) {
                if (required) {
                    if (validationEnabled) {
                        Object[] args = new Object[]{this.fStringPool.toString(elementNameIndex), this.fStringPool.toString(attName)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 94, 88, args, 1);
                    }
                } else if (attValue != -1) {
                    if (validationEnabled && standalone && this.fGrammarIsDTDGrammar && ((DTDGrammar)this.fGrammar).getAttributeDeclIsExternal(attlistIndex)) {
                        Object[] args = new Object[]{this.fStringPool.toString(elementNameIndex), this.fStringPool.toString(attName)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 95, 80, args, 1);
                    }
                    if (validationEnabled) {
                        this.validateUsingDV(this.fTempAttDecl.datatypeValidator, this.fStringPool.toString(attValue), true);
                    }
                    if (attrIndex == -1) {
                        attrIndex = attrList.startAttrList();
                    }
                    this.fTempQName.setValues(attPrefix, attLocalpart, attName, this.fTempAttDecl.name.uri);
                    int newAttr = attrList.addAttr(this.fTempQName, attValue, attType, false, false);
                    if (lastCheck == -1) {
                        lastCheck = newAttr;
                    }
                }
            }
            attlistIndex = this.fGrammar.getNextAttributeDeclIndex(attlistIndex);
        }
        return attrIndex;
    }

    private XMLContentModel getElementContentModel(int elementIndex) throws Exception {
        XMLContentModel contentModel = null;
        if (elementIndex > -1 && this.fGrammar.getElementDecl(elementIndex, this.fTempElementDecl)) {
            if (this.fSGComparator == null) {
                this.fSGComparator = new SubstitutionGroupComparator(this.fGrammarResolver, this.fStringPool, this.fErrorReporter);
            }
            contentModel = this.fGrammar.getElementContentModel(elementIndex, this.fSGComparator);
        }
        return contentModel;
    }

    private int getAttDef(QName element, QName attribute) {
        if (this.fGrammar != null) {
            int elementIndex;
            int scope = this.fCurrentScope;
            if (element.uri > -1) {
                scope = -1;
            }
            if ((elementIndex = this.fGrammar.getElementDeclIndex(element, scope)) == -1) {
                return -1;
            }
            int attDefIndex = this.fGrammar.getFirstAttributeDeclIndex(elementIndex);
            while (attDefIndex != -1) {
                this.fGrammar.getAttributeDecl(attDefIndex, this.fTempAttributeDecl);
                if (this.fTempAttributeDecl.name.localpart == attribute.localpart && this.fTempAttributeDecl.name.uri == attribute.uri) {
                    return attDefIndex;
                }
                attDefIndex = this.fGrammar.getNextAttributeDeclIndex(attDefIndex);
            }
        }
        return -1;
    }

    private int getAttDefByElementIndex(int elementIndex, QName attribute) {
        if (this.fGrammar != null && elementIndex > -1) {
            if (elementIndex == -1) {
                return -1;
            }
            int attDefIndex = this.fGrammar.getFirstAttributeDeclIndex(elementIndex);
            while (attDefIndex != -1) {
                this.fGrammar.getAttributeDecl(attDefIndex, this.fTempAttDecl);
                if (this.fGrammarIsDTDGrammar ? this.fTempAttDecl.name.rawname == attribute.rawname : this.fTempAttDecl.name.localpart == attribute.localpart && this.fTempAttDecl.name.uri == attribute.uri) {
                    return attDefIndex;
                }
                if (this.fGrammarIsSchemaGrammar) {
                    if (this.fTempAttDecl.type == 8) {
                        return attDefIndex;
                    }
                    if (this.fTempAttDecl.type == 9 ? attribute.uri != this.fTempAttDecl.name.uri : this.fTempAttDecl.type == 11 && this.fStringPool.stringInList(this.fTempAttDecl.enumeration, attribute.uri)) {
                        return attDefIndex;
                    }
                }
                attDefIndex = this.fGrammar.getNextAttributeDeclIndex(attDefIndex);
            }
        }
        return -1;
    }

    private void rootElementSpecified(QName rootElement) throws Exception {
        String root2;
        String root1;
        if (this.fLoadDTDGrammar && this.fGrammar == null) {
            this.fGrammar = this.fGrammarResolver.getGrammar("");
            if (this.fGrammar != null) {
                if (this.fGrammar instanceof DTDGrammar) {
                    this.fGrammarIsDTDGrammar = true;
                    this.fGrammarIsSchemaGrammar = false;
                } else if (this.fGrammar instanceof SchemaGrammar) {
                    this.fGrammarIsSchemaGrammar = true;
                    this.fGrammarIsDTDGrammar = false;
                }
                this.fGrammarNameSpaceIndex = this.fEmptyURI;
            }
        }
        if (this.fValidating && this.fGrammarIsDTDGrammar && ((DTDGrammar)this.fGrammar).getRootElementQName(this.fRootElement) && !(root1 = this.fStringPool.toString(this.fRootElement.rawname)).equals(root2 = this.fStringPool.toString(rootElement.rawname))) {
            this.reportRecoverableXMLError(3, 1, this.fRootElement.rawname, rootElement.rawname);
        }
        if (this.fNamespacesEnabled && this.fNamespacesScope == null) {
            this.fNamespacesScope = new NamespacesScope(this);
            this.fNamespacesPrefix = this.fStringPool.addSymbol("xmlns");
            this.fNamespacesScope.setNamespaceForPrefix(this.fNamespacesPrefix, -1);
            int xmlSymbol = this.fStringPool.addSymbol("xml");
            int xmlNamespace = this.fStringPool.addSymbol("http://www.w3.org/XML/1998/namespace");
            this.fNamespacesScope.setNamespaceForPrefix(xmlSymbol, xmlNamespace);
        }
    }

    private boolean switchGrammar(int newGrammarNameSpaceIndex) throws Exception {
        Grammar tempGrammar = this.fGrammarResolver.getGrammar(this.fStringPool.toString(newGrammarNameSpaceIndex));
        if (tempGrammar == null) {
            tempGrammar = this.fGrammarResolver.getGrammar("");
        }
        if (tempGrammar == null) {
            return false;
        }
        this.fGrammar = tempGrammar;
        if (this.fGrammar instanceof DTDGrammar) {
            this.fGrammarIsDTDGrammar = true;
            this.fGrammarIsSchemaGrammar = false;
        } else if (this.fGrammar instanceof SchemaGrammar) {
            this.fGrammarIsSchemaGrammar = true;
            this.fGrammarIsDTDGrammar = false;
        }
        return true;
    }

    private void bindNamespacesToElementAndAttributes(QName element, XMLAttrList attrList) throws Exception {
        int attPrefix;
        int attName;
        this.fNamespacesScope.increaseDepth();
        if (this.fAttrListHandle != -1 || !this.fSeenRootElement) {
            int index = attrList.getFirstAttr(this.fAttrListHandle);
            while (index != -1) {
                int attName2 = attrList.getAttrName(index);
                int attPrefix2 = attrList.getAttrPrefix(index);
                if (!this.fStringPool.equalNames(attName2, this.fXMLLang)) {
                    if (this.fStringPool.equalNames(attName2, this.fNamespacesPrefix)) {
                        int uri = this.fStringPool.addSymbol(attrList.getAttValue(index));
                        this.fNamespacesScope.setNamespaceForPrefix(0, uri);
                    } else if (attPrefix2 == this.fNamespacesPrefix) {
                        int nsPrefix = attrList.getAttrLocalpart(index);
                        int uri = this.fStringPool.addSymbol(attrList.getAttValue(index));
                        if (uri == 0) {
                            Object[] args = new Object[]{this.fStringPool.toString(nsPrefix)};
                            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 171, 147, args, 1);
                        }
                        this.fNamespacesScope.setNamespaceForPrefix(nsPrefix, uri);
                        if (this.fValidating && this.fSchemaValidation) {
                            boolean seeXsi = false;
                            String attrValue = this.fStringPool.toString(attrList.getAttValue(index));
                            if (attrValue.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                                this.fXsiPrefix = nsPrefix;
                                seeXsi = true;
                            }
                        }
                    }
                }
                index = attrList.getNextAttr(index);
            }
            Object location = null;
            Object uri = null;
            if (this.fValidating && this.fSchemaValidation) {
                this.fLocationUriPairs.clear();
                if (!this.fSeenRootElement) {
                    if (this.fExternalSchemas != null && this.fExternalSchemas.length() != 0) {
                        this.parseSchemaLocation(this.fExternalSchemas);
                    }
                    if (this.fExternalNoNamespaceSchema != null && this.fExternalNoNamespaceSchema.length() != 0) {
                        this.fLocationUriPairs.put(this.fExternalNoNamespaceSchema, "");
                        if (this.fNamespacesScope != null) {
                            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
                        }
                    }
                    this.parseSchemas();
                    this.fLocationUriPairs.clear();
                }
                this.fXsiTypeAttValue = -1;
                this.fNil = false;
                index = attrList.getFirstAttr(this.fAttrListHandle);
                while (index != -1) {
                    attName = attrList.getAttrName(index);
                    attPrefix = attrList.getAttrPrefix(index);
                    if (!this.fStringPool.equalNames(attName, this.fNamespacesPrefix) && this.fXsiPrefix != -1 && attPrefix == this.fXsiPrefix) {
                        int localpart = attrList.getAttrLocalpart(index);
                        if (localpart == this.fStringPool.addSymbol("schemaLocation")) {
                            this.parseSchemaLocation(this.fStringPool.toString(attrList.getAttValue(index)));
                        } else if (localpart == this.fStringPool.addSymbol("noNamespaceSchemaLocation")) {
                            this.fLocationUriPairs.put(this.fStringPool.toString(attrList.getAttValue(index)), "");
                            if (this.fNamespacesScope != null) {
                                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
                            }
                        } else if (localpart == this.fStringPool.addSymbol("type")) {
                            this.fXsiTypeAttValue = attrList.getAttValue(index);
                        } else if (localpart == this.fStringPool.addSymbol("nil")) {
                            this.fNil = this.fStringPool.toString(attrList.getAttValue(index)).equals("true");
                        }
                    }
                    index = attrList.getNextAttr(index);
                }
                this.parseSchemas();
            }
        }
        int prefix = element.prefix != -1 ? element.prefix : 0;
        int uri = this.fNamespacesScope.getNamespaceForPrefix(prefix);
        if (element.prefix != -1 || uri != 0) {
            element.uri = uri;
            if (element.uri == 0) {
                Object[] args = new Object[]{this.fStringPool.toString(element.prefix)};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 167, 144, args, 1);
            }
        }
        if (this.fAttrListHandle != -1) {
            int index = attrList.getFirstAttr(this.fAttrListHandle);
            while (index != -1) {
                attName = attrList.getAttrName(index);
                if (!this.fStringPool.equalNames(attName, this.fNamespacesPrefix) && (attPrefix = attrList.getAttrPrefix(index)) != this.fNamespacesPrefix && attPrefix != -1) {
                    int attrUri = this.fNamespacesScope.getNamespaceForPrefix(attPrefix);
                    if (attrUri == -1) {
                        Object[] args = new Object[]{this.fStringPool.toString(attPrefix)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 167, 144, args, 1);
                    }
                    attrList.setAttrURI(index, attrUri);
                }
                index = attrList.getNextAttr(index);
            }
        }
    }

    private void parseSchemas() throws Exception {
        Enumeration locations = this.fLocationUriPairs.keys();
        String location = null;
        String uri = null;
        while (locations.hasMoreElements()) {
            location = (String)locations.nextElement();
            uri = (String)this.fLocationUriPairs.get(location);
            this.resolveSchemaGrammar(location, uri);
        }
    }

    private void parseSchemaLocation(String schemaLocationStr) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(schemaLocationStr, " \n\t\r", false);
        int tokenTotal = tokenizer.countTokens();
        if (tokenTotal % 2 != 0) {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 51, 0, new Object[]{schemaLocationStr}, 1);
        } else {
            String uri = null;
            String location = null;
            while (tokenizer.hasMoreTokens()) {
                uri = tokenizer.nextToken();
                location = tokenizer.nextToken();
                this.fLocationUriPairs.put(location, uri);
            }
        }
    }

    private void resolveSchemaGrammar(String loc, String uri) throws Exception {
        Grammar grammar = null;
        if (uri != null) {
            if (this.fGrammarIsDTDGrammar && uri.length() == 0) {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 170, 170, null, 0);
            } else {
                grammar = this.fGrammarResolver.getGrammar(uri);
            }
        }
        if (grammar == null) {
            if (this.fSchemaGrammarParser == null) {
                this.fSchemaGrammarParser = new DOMParser();
                this.fSchemaGrammarParser.setEntityResolver(new Resolver(this.fEntityHandler));
                this.fSchemaGrammarParser.setErrorHandler(new ErrorHandler());
                try {
                    this.fSchemaGrammarParser.setFeature("http://xml.org/sax/features/validation", false);
                    this.fSchemaGrammarParser.setFeature("http://xml.org/sax/features/namespaces", true);
                    this.fSchemaGrammarParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
                }
                catch (SAXNotRecognizedException e) {
                    e.printStackTrace();
                }
                catch (SAXNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            InputSource source = null;
            EntityResolver currentER = this.fSchemaGrammarParser.getEntityResolver();
            if (currentER != null) {
                source = currentER.resolveEntity("", loc);
            }
            if (source == null) {
                loc = this.fEntityHandler.expandSystemId(loc);
                source = new InputSource(loc);
            }
            try {
                this.fSchemaGrammarParser.parse(source);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                this.reportRecoverableXMLError(169, 146, e.getMessage());
            }
            Document document = this.fSchemaGrammarParser.getDocument();
            TraverseSchema tst = null;
            Element root = null;
            if (document != null) {
                root = document.getDocumentElement();
            }
            if (root == null) {
                this.reportRecoverableXMLError(169, 146, "Can't get back Schema document's root element :" + loc);
            } else {
                if (uri != null && !uri.equals(root.getAttribute("targetNamespace"))) {
                    this.reportRecoverableXMLError(169, 146, "Schema in " + loc + " has a different target namespace " + "from the one specified in the instance document :" + uri);
                }
                grammar = new SchemaGrammar();
                grammar.setGrammarDocument(document);
                this.fGrammarIsSchemaGrammar = true;
                this.fGrammarIsDTDGrammar = false;
                GeneralAttrCheck generalAttrCheck = new GeneralAttrCheck(this.fErrorReporter, this.fDataTypeReg);
                tst = new TraverseSchema(root, this.fStringPool, (SchemaGrammar)grammar, this.fGrammarResolver, this.fErrorReporter, source.getSystemId(), currentER, this.getSchemaFullCheckingEnabled(), generalAttrCheck, this.fExternalSchemas, this.fExternalNoNamespaceSchema);
                generalAttrCheck.checkNonSchemaAttributes(this.fGrammarResolver);
                String targetNS = root.getAttribute("targetNamespace");
                this.fGrammarNameSpaceIndex = this.fStringPool.addSymbol(targetNS);
                this.fGrammarResolver.putGrammar(targetNS, grammar);
                this.fGrammar = (SchemaGrammar)grammar;
                if (this.fSchemaValidationFullChecking) {
                    try {
                        Enumeration grammarURIs = this.fGrammarResolver.nameSpaceKeys();
                        while (grammarURIs.hasMoreElements()) {
                            String grammarURI = (String)grammarURIs.nextElement();
                            if (this.UPACheckedGrammarURIs.get(grammarURI) != null) continue;
                            this.UPACheckedGrammarURIs.put(grammarURI, fgNullObject);
                            Grammar gGrammar = this.fGrammarResolver.getGrammar(grammarURI);
                            if (!(gGrammar instanceof SchemaGrammar)) continue;
                            SchemaGrammar sGrammar = (SchemaGrammar)gGrammar;
                            Hashtable complexTypeRegistry = sGrammar.getComplexTypeRegistry();
                            int count = complexTypeRegistry.size();
                            Enumeration enumeration = complexTypeRegistry.elements();
                            if (this.fSGComparator == null) {
                                this.fSGComparator = new SubstitutionGroupComparator(this.fGrammarResolver, this.fStringPool, this.fErrorReporter);
                            }
                            while (enumeration.hasMoreElements()) {
                                TraverseSchema.ComplexTypeInfo typeInfo = (TraverseSchema.ComplexTypeInfo)enumeration.nextElement();
                                sGrammar.getContentModel(typeInfo.contentSpecHandle, typeInfo.contentType, this.fSGComparator);
                            }
                        }
                    }
                    catch (CMException excToCatch) {
                        int majorCode = excToCatch.getErrorCode();
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", majorCode, 0, null, 2);
                    }
                }
            }
        }
    }

    private String bindNotationURI(String value) throws Exception {
        int colonP = value.indexOf(":");
        String prefix = "";
        String localpart = value;
        if (colonP > -1) {
            prefix = value.substring(0, colonP);
            localpart = value.substring(colonP + 1);
        }
        String uri = "";
        int uriIndex = 0;
        if (this.fNamespacesScope != null) {
            uriIndex = this.fNamespacesScope.getNamespaceForPrefix(this.fStringPool.addSymbol(prefix));
            if (uriIndex > 0) {
                return String.valueOf(this.fStringPool.toString(uriIndex)) + ":" + localpart;
            }
            if (this.fGrammarNameSpaceIndex != -1) {
                return String.valueOf(this.fStringPool.toString(this.fGrammarNameSpaceIndex)) + ":" + localpart;
            }
        }
        return value;
    }

    private int attributeTypeName(XMLAttributeDecl attrDecl) {
        switch (attrDecl.type) {
            case 1: {
                return attrDecl.list ? this.fENTITIESSymbol : this.fENTITYSymbol;
            }
            case 2: {
                String enumeration = this.fStringPool.stringListAsString(attrDecl.enumeration);
                return this.fStringPool.addSymbol(enumeration);
            }
            case 3: {
                return this.fIDSymbol;
            }
            case 4: {
                return attrDecl.list ? this.fIDREFSSymbol : this.fIDREFSymbol;
            }
            case 5: {
                return attrDecl.list ? this.fNMTOKENSSymbol : this.fNMTOKENSymbol;
            }
            case 6: {
                return this.fNOTATIONSymbol;
            }
        }
        return this.fCDATASymbol;
    }

    private void validateElementAndAttributes(QName element, XMLAttrList attrList) throws Exception {
        if (this.fGrammarIsSchemaGrammar && this.fElementDepth >= 0 && this.fValidationFlagStack[this.fElementDepth] != 0 || this.fGrammar == null && !this.fValidating && !this.fNamespacesEnabled) {
            int[] dupAttrs;
            this.fCurrentElementIndex = -1;
            this.fCurrentContentSpecType = -1;
            this.fInElementContent = false;
            if (this.fAttrListHandle != -1 && (dupAttrs = this.fAttrList.endAttrList()) != null) {
                Object[] objectArray = new Object[2];
                objectArray[0] = this.fStringPool.toString(element.rawname);
                Object[] args = objectArray;
                int i = 0;
                while (i < dupAttrs.length) {
                    args[1] = this.fStringPool.toString(dupAttrs[i]);
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 28, 27, args, 1);
                    ++i;
                }
            }
            return;
        }
        int elementIndex = -1;
        int contentSpecType = -1;
        boolean skipThisOne = false;
        boolean laxThisOne = false;
        if (this.fGrammarIsSchemaGrammar && this.fElementDepth > -1 && this.fContentLeafStack[this.fElementDepth] != null) {
            int pos;
            ContentLeafNameTypeVector cv = this.fContentLeafStack[this.fElementDepth];
            if (this.fContentModelStateStack[this.fElementDepth] >= 0 && (pos = ((DFAContentModel)this.fContentModelStack[this.fElementDepth]).oneTransition(element, this.fContentModelStateStack, this.fElementDepth)) >= 0) {
                int n = this.fElementDepth;
                this.fContentModelEleCount[n] = this.fContentModelEleCount[n] + 1;
                switch (cv.leafTypes[pos]) {
                    case 38: 
                    case 39: 
                    case 40: {
                        skipThisOne = true;
                        break;
                    }
                    case 22: 
                    case 23: 
                    case 24: {
                        laxThisOne = true;
                    }
                }
            }
        }
        if (skipThisOne) {
            this.fNeedValidationOff = true;
        } else {
            int[] dupAttrs;
            TraverseSchema.ComplexTypeInfo baseTypeInfo = null;
            if (this.fGrammarIsSchemaGrammar && this.fCurrentElementIndex != -1) {
                baseTypeInfo = ((SchemaGrammar)this.fGrammar).getElementComplexTypeInfo(this.fCurrentElementIndex);
            }
            if (this.fNamespacesEnabled && this.fValidating && element.uri != this.fGrammarNameSpaceIndex && element.uri != 0) {
                this.fGrammarNameSpaceIndex = element.uri;
                boolean success = this.switchGrammar(this.fGrammarNameSpaceIndex);
                if (!success && !laxThisOne) {
                    this.reportRecoverableXMLError(169, 146, "Grammar with uri: " + this.fStringPool.toString(this.fGrammarNameSpaceIndex) + " , can not be found; schema namespace may be wrong:  Xerces supports schemas from the \"http://www.w3.org/2001/XMLSchema\" namespace" + " or the instance document's namespace may not match the targetNamespace of the schema");
                }
            }
            if (this.fGrammar != null) {
                elementIndex = this.fGrammar.getElementDeclIndex(element, this.fCurrentScope);
                if (elementIndex == -1) {
                    elementIndex = this.fGrammar.getElementDeclIndex(element, -1);
                }
                if (elementIndex == -1) {
                    if (this.fGrammarIsSchemaGrammar && this.fCurrentElementIndex != -1) {
                        boolean success;
                        int aGrammarNSIndex = this.fGrammarNameSpaceIndex;
                        while (baseTypeInfo != null) {
                            int comma;
                            String baseTName = baseTypeInfo.typeName;
                            if (!baseTName.startsWith("#") && (aGrammarNSIndex = this.fStringPool.addSymbol(baseTName.substring(0, comma = baseTName.indexOf(44)).trim())) != this.fGrammarNameSpaceIndex) {
                                if (!this.switchGrammar(aGrammarNSIndex)) break;
                                this.fGrammarNameSpaceIndex = aGrammarNSIndex;
                            }
                            if ((elementIndex = this.fGrammar.getElementDeclIndex(element, baseTypeInfo.scopeDefined)) > -1) break;
                            baseTypeInfo = baseTypeInfo.baseComplexTypeInfo;
                        }
                        if (elementIndex == -1 && element.uri == 0 && (success = this.switchGrammar(element.uri))) {
                            this.fGrammarNameSpaceIndex = element.uri;
                            elementIndex = this.fGrammar.getElementDeclIndex(element.localpart, -1);
                        }
                    }
                    if (element.uri == 0 && elementIndex == -1 && this.fNamespacesScope != null) {
                        elementIndex = this.fGrammar.getElementDeclIndex(element.localpart, -1);
                        element.uri = 0;
                    }
                    if (elementIndex == -1 && laxThisOne) {
                        this.fNeedValidationOff = true;
                    }
                }
            }
            int oldElementIndex = elementIndex;
            contentSpecType = this.getContentSpecType(elementIndex);
            int elementNameLocalPart = -1;
            DatatypeValidator elementDatatypeValidator = null;
            if (elementIndex != -1) {
                this.fGrammar.getElementDecl(elementIndex, this.fTempElementDecl);
                elementNameLocalPart = this.fTempElementDecl.name.localpart;
                elementDatatypeValidator = this.fTempElementDecl.datatypeValidator;
            }
            if (this.fGrammarIsSchemaGrammar) {
                TraverseSchema.ComplexTypeInfo typeInfo;
                if (this.fXsiTypeAttValue > -1) {
                    String xsiType = this.fStringPool.toString(this.fXsiTypeAttValue);
                    int colonP = xsiType.indexOf(":");
                    String prefix = "";
                    String localpart = xsiType;
                    if (colonP > -1) {
                        prefix = xsiType.substring(0, colonP);
                        localpart = xsiType.substring(colonP + 1);
                    }
                    String uri = "";
                    int uriIndex = 0;
                    if (this.fNamespacesScope != null && (uriIndex = this.fNamespacesScope.getNamespaceForPrefix(this.fStringPool.addSymbol(prefix))) > 0) {
                        uri = this.fStringPool.toString(uriIndex);
                        if (uriIndex != this.fGrammarNameSpaceIndex) {
                            this.fGrammarNameSpaceIndex = this.fCurrentSchemaURI = uriIndex;
                            boolean success = this.switchGrammar(this.fCurrentSchemaURI);
                            if (!(success || this.fNeedValidationOff || uri.equals("http://www.w3.org/2001/XMLSchema"))) {
                                this.reportRecoverableXMLError(169, 146, "Grammar with uri: " + this.fStringPool.toString(this.fCurrentSchemaURI) + " , can not be found");
                            }
                        }
                    }
                    Hashtable complexRegistry = ((SchemaGrammar)this.fGrammar).getComplexTypeRegistry();
                    DatatypeValidatorFactoryImpl dataTypeReg = ((SchemaGrammar)this.fGrammar).getDatatypeRegistry();
                    if (complexRegistry == null || dataTypeReg == null) {
                        this.reportRecoverableXMLError(169, 146, String.valueOf(this.fErrorReporter.getLocator().getSystemId()) + " line" + this.fErrorReporter.getLocator().getLineNumber() + ", canot resolve xsi:type = " + xsiType + "  ---2");
                    } else {
                        TraverseSchema.ComplexTypeInfo typeInfo2 = (TraverseSchema.ComplexTypeInfo)complexRegistry.get(String.valueOf(uri) + "," + localpart);
                        if (typeInfo2 == null) {
                            this.fXsiTypeValidator = uri.equals("http://www.w3.org/2001/XMLSchema") ? dataTypeReg.getDatatypeValidator(localpart) : dataTypeReg.getDatatypeValidator(String.valueOf(uri) + "," + localpart);
                            if (this.fXsiTypeValidator == null) {
                                this.reportRecoverableXMLError(169, 146, "unresolved type : " + uri + "," + localpart + " found  in xsi:type handling");
                            } else if (elementIndex != -1) {
                                DatatypeValidator ancestorValidator = elementDatatypeValidator;
                                DatatypeValidator tempVal = this.fXsiTypeValidator;
                                while (tempVal != null) {
                                    if (tempVal == ancestorValidator) break;
                                    tempVal = tempVal.getBaseValidator();
                                }
                                if (tempVal == null) {
                                    if (ancestorValidator instanceof UnionDatatypeValidator) {
                                        Vector subUnionMemberDV = ((UnionDatatypeValidator)ancestorValidator).getBaseValidators();
                                        int subUnionSize = subUnionMemberDV.size();
                                        boolean found = false;
                                        int i = 0;
                                        while (i < subUnionSize && !found) {
                                            DatatypeValidator dTempSub = (DatatypeValidator)subUnionMemberDV.elementAt(i);
                                            DatatypeValidator dTemp = this.fXsiTypeValidator;
                                            while (dTemp != null) {
                                                if (dTempSub == dTemp) {
                                                    found = true;
                                                    break;
                                                }
                                                dTemp = dTemp.getBaseValidator();
                                            }
                                            if (!found && dTempSub instanceof AnySimpleType) {
                                                found = true;
                                            }
                                            ++i;
                                        }
                                        if (!found) {
                                            this.reportRecoverableXMLError(169, 146, "Type : " + uri + "," + localpart + " does not derive from the type of element " + this.fStringPool.toString(elementNameLocalPart));
                                        }
                                    } else if (!(ancestorValidator == null && ((SchemaGrammar)this.fGrammar).getElementComplexTypeInfo(elementIndex) == null || ancestorValidator instanceof AnySimpleType)) {
                                        this.reportRecoverableXMLError(169, 146, "Type : " + uri + "," + localpart + " does not derive from the type of element " + this.fStringPool.toString(elementNameLocalPart));
                                    }
                                } else {
                                    if (tempVal != null && this.fXsiTypeValidator != null && this.fGrammar.getFirstAttributeDeclIndex(elementIndex) != -1) {
                                        this.reportRecoverableXMLError(169, 146, "Type : " + uri + "," + localpart + " does not derive from the type of element " + this.fStringPool.toString(elementNameLocalPart));
                                    }
                                    if ((((SchemaGrammar)this.fGrammar).getElementDeclBlockSet(elementIndex) & 2) != 0) {
                                        this.reportRecoverableXMLError(169, 146, "Element " + this.fStringPool.toString(elementNameLocalPart) + "does not permit substitution by a type such as " + uri + "," + localpart);
                                    }
                                }
                            }
                        } else {
                            if (typeInfo2.isAbstractType()) {
                                this.reportRecoverableXMLError(169, 146, "Abstract type " + xsiType + " should not be used in xsi:type");
                            }
                            if (elementIndex != -1) {
                                TraverseSchema.ComplexTypeInfo tempType = typeInfo2;
                                TraverseSchema.ComplexTypeInfo destType = ((SchemaGrammar)this.fGrammar).getElementComplexTypeInfo(elementIndex);
                                while (tempType != null && destType != null) {
                                    if (tempType.typeName.equals(destType.typeName)) break;
                                    tempType = tempType.baseComplexTypeInfo;
                                }
                                if (tempType == null) {
                                    this.reportRecoverableXMLError(169, 146, "Type : " + uri + "," + localpart + " does not derive from the type " + destType.typeName);
                                } else if (destType == null && elementDatatypeValidator != null) {
                                    DatatypeValidator ancestorValidator = elementDatatypeValidator;
                                    DatatypeValidator tempVal = this.fXsiTypeValidator;
                                    while (tempVal != null) {
                                        if (tempVal == ancestorValidator) break;
                                        tempVal = tempVal.getBaseValidator();
                                    }
                                    if (tempVal == null && ancestorValidator instanceof AnySimpleType) {
                                        tempVal = this.fXsiTypeValidator;
                                    }
                                    if (tempVal == null) {
                                        if (ancestorValidator instanceof UnionDatatypeValidator) {
                                            Vector subUnionMemberDV = ((UnionDatatypeValidator)ancestorValidator).getBaseValidators();
                                            int subUnionSize = subUnionMemberDV.size();
                                            boolean found = false;
                                            int i = 0;
                                            while (i < subUnionSize && !found) {
                                                DatatypeValidator dTempSub = (DatatypeValidator)subUnionMemberDV.elementAt(i);
                                                DatatypeValidator dTemp = this.fXsiTypeValidator;
                                                while (dTemp != null) {
                                                    if (dTempSub == dTemp) {
                                                        found = true;
                                                        break;
                                                    }
                                                    dTemp = dTemp.getBaseValidator();
                                                }
                                                if (!found && dTempSub instanceof AnySimpleType) {
                                                    found = true;
                                                }
                                                ++i;
                                            }
                                            if (!found) {
                                                this.reportRecoverableXMLError(169, 146, "Type : " + uri + "," + localpart + " does not derive from the type of element " + this.fStringPool.toString(elementNameLocalPart));
                                            }
                                        } else {
                                            this.reportRecoverableXMLError(169, 146, "Type : " + uri + "," + localpart + " does not derive from the type of element " + this.fStringPool.toString(elementNameLocalPart));
                                        }
                                    }
                                } else if (typeInfo2 != destType) {
                                    int derivationMethod = typeInfo2.derivedBy;
                                    if ((((SchemaGrammar)this.fGrammar).getElementDeclBlockSet(elementIndex) & derivationMethod) != 0) {
                                        this.reportRecoverableXMLError(169, 146, "Element " + this.fStringPool.toString(elementNameLocalPart) + " does not permit xsi:type substitution in the manner required by type " + uri + "," + localpart);
                                    } else if (typeInfo2.baseComplexTypeInfo != null && (typeInfo2.baseComplexTypeInfo.blockSet & derivationMethod) != 0) {
                                        this.reportRecoverableXMLError(169, 146, "Type " + typeInfo2.baseComplexTypeInfo.typeName + " does not permit other types, such as " + uri + "," + localpart + " to be substituted for itself using xsi:type");
                                    }
                                }
                            }
                            elementIndex = typeInfo2.templateElementIndex;
                        }
                    }
                    this.fXsiTypeAttValue = -1;
                } else if (elementIndex != -1 && (typeInfo = ((SchemaGrammar)this.fGrammar).getElementComplexTypeInfo(elementIndex)) != null && typeInfo.isAbstractType()) {
                    this.reportRecoverableXMLError(169, 146, "Element " + this.fStringPool.toString(element.rawname) + " is declared with a type that is abstract.  Use xsi:type to specify a non-abstract type");
                }
                if (elementIndex != -1) {
                    int miscFlags = ((SchemaGrammar)this.fGrammar).getElementDeclMiscFlags(elementIndex);
                    if ((miscFlags & 2) != 0) {
                        this.reportRecoverableXMLError(169, 146, "A member of abstract element " + this.fStringPool.toString(element.rawname) + "'s substitution group must be specified");
                    }
                    if (this.fNil && (miscFlags & 1) == 0) {
                        this.fNil = false;
                        this.reportRecoverableXMLError(169, 146, "xsi:nil must not be specified for the element " + this.fStringPool.toString(element.rawname) + " with {nillable} equals 'false'");
                    }
                    this.fCurrentScope = ((SchemaGrammar)this.fGrammar).getElementDefinedScope(elementIndex);
                    String anotherSchemaURI = ((SchemaGrammar)this.fGrammar).getElementFromAnotherSchemaURI(elementIndex);
                    if (anotherSchemaURI != null && contentSpecType != -1) {
                        TraverseSchema.ComplexTypeInfo typeInfo3 = ((SchemaGrammar)this.fGrammar).getElementComplexTypeInfo(elementIndex);
                        if (typeInfo3 != null) {
                            elementIndex = typeInfo3.templateElementIndex;
                        }
                        this.fGrammarNameSpaceIndex = this.fCurrentSchemaURI = this.fStringPool.addSymbol(anotherSchemaURI);
                        boolean success = this.switchGrammar(this.fCurrentSchemaURI);
                        if (!success && !this.fNeedValidationOff) {
                            this.reportRecoverableXMLError(169, 146, "Grammar with uri: " + this.fStringPool.toString(this.fCurrentSchemaURI) + " , can not be found");
                        }
                    }
                }
            }
            if (elementIndex != oldElementIndex) {
                contentSpecType = this.getContentSpecType(elementIndex);
            }
            if (contentSpecType == -1 && this.fValidating && !this.fNeedValidationOff) {
                this.reportRecoverableXMLError(83, 79, element.rawname);
            }
            if (this.fGrammar != null && this.fGrammarIsSchemaGrammar && elementIndex != -1) {
                this.fAttrListHandle = this.addDefaultAttributes(elementIndex, attrList, this.fAttrListHandle, this.fValidating, this.fStandaloneReader != -1);
            }
            if (this.fAttrListHandle != -1 && (dupAttrs = this.fAttrList.endAttrList()) != null) {
                Object[] objectArray = new Object[2];
                objectArray[0] = this.fStringPool.toString(element.rawname);
                Object[] args = objectArray;
                int i = 0;
                while (i < dupAttrs.length) {
                    args[1] = this.fStringPool.toString(dupAttrs[i]);
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 28, 27, args, 1);
                    ++i;
                }
            }
            if (this.fAttrListHandle != -1 && !this.fNeedValidationOff) {
                int index = this.fAttrList.getFirstAttr(this.fAttrListHandle);
                while (index != -1) {
                    int _xmlns;
                    int attrNameIndex = attrList.getAttrName(index);
                    if (attrNameIndex != (_xmlns = this.fStringPool.addSymbol("xmlns")) && attrList.getAttrPrefix(index) != _xmlns && this.fGrammar != null) {
                        this.fTempQName.setValues(attrList.getAttrPrefix(index), attrList.getAttrLocalpart(index), attrList.getAttrName(index), attrList.getAttrURI(index));
                        int attDefIndex = this.getAttDefByElementIndex(elementIndex, this.fTempQName);
                        if (this.fTempQName.uri != this.fXsiURI) {
                            if (attDefIndex == -1) {
                                if (this.fValidating) {
                                    Object[] args = new Object[]{this.fStringPool.toString(element.rawname), this.fStringPool.toString(attrList.getAttrName(index))};
                                    this.fAttrNameLocator = this.getLocatorImpl(this.fAttrNameLocator);
                                    this.fErrorReporter.reportError(this.fAttrNameLocator, "http://www.w3.org/TR/1998/REC-xml-19980210", 82, 78, args, 1);
                                }
                            } else {
                                this.fGrammar.getAttributeDecl(attDefIndex, this.fTempAttDecl);
                                int attributeType = this.attributeTypeName(this.fTempAttDecl);
                                attrList.setAttType(index, attributeType);
                                if (this.fGrammarIsDTDGrammar) {
                                    int normalizedValue = this.validateDTDattribute(element, attrList.getAttValue(index), this.fTempAttDecl);
                                    attrList.setAttValue(index, normalizedValue);
                                }
                                if (this.fValidating && !this.fGrammarIsDTDGrammar) {
                                    Object[] args;
                                    if (this.fGrammarIsSchemaGrammar && (this.fTempAttDecl.type == 8 || this.fTempAttDecl.type == 11 || this.fTempAttDecl.type == 9)) {
                                        if ((this.fTempAttDecl.defaultType & 0x1000) <= 0 && ((this.fTempAttDecl.defaultType & 0x400) > 0 || (this.fTempAttDecl.defaultType & 0x800) > 0)) {
                                            boolean reportError = false;
                                            boolean processContentStrict = (this.fTempAttDecl.defaultType & 0x400) > 0;
                                            Grammar aGrammar = this.fGrammarResolver.getGrammar(this.fStringPool.toString(this.fTempQName.uri));
                                            if (aGrammar == null || !(aGrammar instanceof SchemaGrammar)) {
                                                if (processContentStrict) {
                                                    reportError = true;
                                                }
                                            } else {
                                                SchemaGrammar sGrammar = (SchemaGrammar)aGrammar;
                                                Hashtable attRegistry = sGrammar.getAttributeDeclRegistry();
                                                if (attRegistry == null) {
                                                    if (processContentStrict) {
                                                        reportError = true;
                                                    }
                                                } else {
                                                    XMLAttributeDecl attDecl = (XMLAttributeDecl)attRegistry.get(this.fStringPool.toString(this.fTempQName.localpart));
                                                    if (attDecl == null) {
                                                        if (processContentStrict) {
                                                            reportError = true;
                                                        }
                                                    } else {
                                                        DatatypeValidator attDV = attDecl.datatypeValidator;
                                                        if (attDV == null) {
                                                            if (processContentStrict) {
                                                                reportError = true;
                                                            }
                                                        } else {
                                                            try {
                                                                String value = this.fStringPool.toString(attrList.getAttValue(index));
                                                                this.fWhiteSpace = attDV.getWSFacet();
                                                                if (this.fWhiteSpace != 0) {
                                                                    value = this.normalizeValue(value);
                                                                }
                                                                this.validateUsingDV(attDV, value, false);
                                                                if (this.fNormalizeContents) {
                                                                    int normalizedValue = this.fStringPool.addString(value);
                                                                    attrList.setAttValue(index, normalizedValue);
                                                                }
                                                            }
                                                            catch (InvalidDatatypeValueException idve) {
                                                                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 21, 0, new Object[]{idve.getMessage()}, 1);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            if (reportError) {
                                                args = new Object[]{this.fStringPool.toString(element.rawname), "ANY---" + this.fStringPool.toString(attrList.getAttrName(index))};
                                                this.fAttrNameLocator = this.getLocatorImpl(this.fAttrNameLocator);
                                                this.fErrorReporter.reportError(this.fAttrNameLocator, "http://www.w3.org/TR/1998/REC-xml-19980210", 82, 78, args, 1);
                                            }
                                        }
                                    } else if (this.fTempAttDecl.datatypeValidator == null) {
                                        Object[] args2 = new Object[]{this.fStringPool.toString(element.rawname), this.fStringPool.toString(attrList.getAttrName(index))};
                                        System.out.println("[Error] Datatypevalidator for attribute " + this.fStringPool.toString(attrList.getAttrName(index)) + " not found in element type " + this.fStringPool.toString(element.rawname));
                                        this.fAttrNameLocator = this.getLocatorImpl(this.fAttrNameLocator);
                                        this.fErrorReporter.reportError(this.fAttrNameLocator, "http://www.w3.org/TR/1998/REC-xml-19980210", 82, 78, args2, 1);
                                    } else {
                                        try {
                                            String value = this.fStringPool.toString(attrList.getAttValue(index));
                                            DatatypeValidator tempDV = this.fTempAttDecl.datatypeValidator;
                                            this.fWhiteSpace = tempDV.getWSFacet();
                                            if (this.fWhiteSpace != 0) {
                                                value = this.normalizeValue(value);
                                            }
                                            if ((this.fTempAttDecl.defaultType & 0x10) > 0 && tempDV.compare(value, this.fTempAttDecl.defaultValue) != 0) {
                                                args = new Object[]{this.fStringPool.toString(element.rawname), this.fStringPool.toString(attrList.getAttrName(index)), value, this.fTempAttDecl.defaultValue};
                                                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 93, 87, args, 1);
                                            }
                                            this.validateUsingDV(tempDV, value, false);
                                            if (this.fNormalizeContents) {
                                                int normalizedValue = this.fStringPool.addString(value);
                                                attrList.setAttValue(index, normalizedValue);
                                            }
                                        }
                                        catch (InvalidDatatypeValueException idve) {
                                            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 21, 0, new Object[]{idve.getMessage()}, 1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    index = this.fAttrList.getNextAttr(index);
                }
            }
        }
        if (this.fAttrListHandle != -1) {
            int index = attrList.getFirstAttr(this.fAttrListHandle);
            while (index != -1) {
                int attPrefix;
                int attName = attrList.getAttrName(index);
                if (!this.fStringPool.equalNames(attName, this.fNamespacesPrefix) && (attPrefix = attrList.getAttrPrefix(index)) != this.fNamespacesPrefix && attPrefix != -1) {
                    int uri = this.fNamespacesScope.getNamespaceForPrefix(attPrefix);
                    if (uri == 0) {
                        Object[] args = new Object[]{this.fStringPool.toString(attPrefix)};
                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1999/REC-xml-names-19990114", 167, 144, args, 1);
                    }
                    attrList.setAttrURI(index, uri);
                }
                index = attrList.getNextAttr(index);
            }
        }
        this.fCurrentElementIndex = elementIndex;
        this.fCurrentContentSpecType = contentSpecType;
        if (this.fValidating && contentSpecType == 5) {
            this.fBufferDatatype = true;
            this.fDatatypeBuffer.setLength(0);
        }
        this.fInElementContent = contentSpecType == 4;
    }

    private int validateDTDattribute(QName element, int attValue, XMLAttributeDecl attributeDecl) throws Exception {
        AttributeValidator av = null;
        switch (attributeDecl.type) {
            case 1: {
                boolean isAlistAttribute = attributeDecl.list;
                String unTrimValue = this.fStringPool.toString(attValue);
                String value = unTrimValue.trim();
                if (this.fValidationEnabled) {
                    if (value != unTrimValue && this.invalidStandaloneAttDef(element, attributeDecl.name)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(attributeDecl.name.rawname), unTrimValue, value);
                    }
                    try {
                        if (isAlistAttribute) {
                            this.fValENTITIES.validate(value, this.fValidateEntity);
                        } else {
                            this.fValENTITY.validate(value, this.fValidateEntity);
                        }
                    }
                    catch (InvalidDatatypeValueException ex) {
                        if (ex.getMajorCode() != 1 && ex.getMinorCode() != -1) {
                            this.reportRecoverableXMLError(ex.getMajorCode(), ex.getMinorCode(), this.fStringPool.toString(attributeDecl.name.rawname), value);
                        }
                        this.reportRecoverableXMLError(79, 77, this.fStringPool.toString(attributeDecl.name.rawname), value);
                    }
                }
                if (!this.fNormalizeAttributeValues) break;
                if (attributeDecl.list) {
                    attValue = this.normalizeListAttribute(value, attValue, unTrimValue);
                    break;
                }
                if (value == unTrimValue) break;
                attValue = this.fStringPool.addSymbol(value);
                break;
            }
            case 2: {
                av = this.fAttValidatorENUMERATION;
                break;
            }
            case 3: {
                String unTrimValue = this.fStringPool.toString(attValue);
                String value = unTrimValue.trim();
                if (this.fValidationEnabled) {
                    if (value != unTrimValue && this.invalidStandaloneAttDef(element, attributeDecl.name)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(attributeDecl.name.rawname), unTrimValue, value);
                    }
                    try {
                        this.fValID.validate(value, this.fIdDefs);
                        this.fValIDRef.validate(value, this.fValidateIDRef);
                    }
                    catch (InvalidDatatypeValueException ex) {
                        int major = ex.getMajorCode();
                        int minor = ex.getMinorCode();
                        if (major == -1) {
                            major = 75;
                            minor = 76;
                        }
                        this.reportRecoverableXMLError(major, minor, this.fStringPool.toString(attributeDecl.name.rawname), value);
                    }
                }
                if (!this.fNormalizeAttributeValues || value == unTrimValue) break;
                attValue = this.fStringPool.addSymbol(value);
                break;
            }
            case 4: {
                String unTrimValue = this.fStringPool.toString(attValue);
                String value = unTrimValue.trim();
                boolean isAlistAttribute = attributeDecl.list;
                if (this.fValidationEnabled) {
                    if (value != unTrimValue && this.invalidStandaloneAttDef(element, attributeDecl.name)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(attributeDecl.name.rawname), unTrimValue, value);
                    }
                    if (attributeDecl.list && value.length() == 0) {
                        this.reportRecoverableXMLError(4, 2, this.fStringPool.toString(attributeDecl.name.rawname));
                    }
                    try {
                        if (isAlistAttribute) {
                            this.fValIDRefs.validate(value, this.fValidateIDRef);
                        } else {
                            this.fValIDRef.validate(value, this.fValidateIDRef);
                        }
                    }
                    catch (InvalidDatatypeValueException ex) {
                        if (ex.getMajorCode() != 1 && ex.getMinorCode() != -1) {
                            this.reportRecoverableXMLError(ex.getMajorCode(), ex.getMinorCode(), this.fStringPool.toString(attributeDecl.name.rawname), value);
                        }
                        this.reportRecoverableXMLError(4, 2, this.fStringPool.toString(attributeDecl.name.rawname), value);
                    }
                }
                if (!this.fNormalizeAttributeValues) break;
                if (attributeDecl.list) {
                    attValue = this.normalizeListAttribute(value, attValue, unTrimValue);
                    break;
                }
                if (value == unTrimValue) break;
                attValue = this.fStringPool.addSymbol(value);
                break;
            }
            case 6: {
                av = this.fAttValidatorNOTATION;
                break;
            }
            case 5: {
                String unTrimValue = this.fStringPool.toString(attValue);
                String value = unTrimValue.trim();
                boolean isAlistAttribute = attributeDecl.list;
                if (this.fValidationEnabled) {
                    if (value != unTrimValue && this.invalidStandaloneAttDef(element, attributeDecl.name)) {
                        this.reportRecoverableXMLError(123, 80, this.fStringPool.toString(attributeDecl.name.rawname), unTrimValue, value);
                    }
                    if (attributeDecl.list && value.length() == 0) {
                        this.reportRecoverableXMLError(5, 3, this.fStringPool.toString(attributeDecl.name.rawname));
                    }
                    try {
                        if (isAlistAttribute) {
                            this.fValNMTOKENS.validate(value, null);
                        } else {
                            this.fValNMTOKEN.validate(value, null);
                        }
                    }
                    catch (InvalidDatatypeValueException ex) {
                        this.reportRecoverableXMLError(78, 3, this.fStringPool.toString(attributeDecl.name.rawname), value);
                    }
                }
                if (!this.fNormalizeAttributeValues) break;
                if (attributeDecl.list) {
                    attValue = this.normalizeListAttribute(value, attValue, unTrimValue);
                    break;
                }
                if (value == unTrimValue) break;
                attValue = this.fStringPool.addSymbol(value);
            }
        }
        if (av != null) {
            int newValue = av.normalize(element, attributeDecl.name, attValue, attributeDecl.type, attributeDecl.enumeration);
            if (this.fNormalizeAttributeValues) {
                attValue = newValue;
            }
        }
        return attValue;
    }

    private int normalizeListAttribute(String value, int origIndex, String unTrimValue) {
        this.fNormalizedStr.setLength(0);
        int length = value.length();
        boolean skipSpace = true;
        char c = '\u0000';
        int i = 0;
        while (i < length) {
            c = value.charAt(i);
            if (c == ' ') {
                if (!skipSpace) {
                    this.fNormalizedStr.append(' ');
                    skipSpace = true;
                }
            } else {
                this.fNormalizedStr.append(c);
                skipSpace = false;
            }
            ++i;
        }
        if (this.fNormalizedStr.length() == unTrimValue.length()) {
            return origIndex;
        }
        return this.fStringPool.addSymbol(this.fNormalizedStr.toString());
    }

    private void charDataInContent() {
        QName qname;
        if (this.fElementChildren.length <= this.fElementChildrenLength) {
            QName[] newarray = new QName[this.fElementChildren.length * 2];
            System.arraycopy(this.fElementChildren, 0, newarray, 0, this.fElementChildren.length);
            this.fElementChildren = newarray;
        }
        if ((qname = this.fElementChildren[this.fElementChildrenLength]) == null) {
            int i = this.fElementChildrenLength;
            while (i < this.fElementChildren.length) {
                this.fElementChildren[i] = new QName();
                ++i;
            }
            qname = this.fElementChildren[this.fElementChildrenLength];
        }
        qname.clear();
        ++this.fElementChildrenLength;
    }

    private int checkContent(int elementIndex, QName[] children, int childOffset, int childCount) throws Exception {
        int elementType = this.fCurrentElement.rawname;
        int contentType = this.fCurrentContentSpecType;
        if (contentType == 0) {
            if (childCount != 0) {
                return 0;
            }
        } else if (contentType != 1) {
            if (contentType == 2 || contentType == 3 || contentType == 4) {
                XMLContentModel cmElem;
                block36: {
                    if (childCount == 0 && this.fNil) {
                        this.fNil = false;
                        return -1;
                    }
                    cmElem = null;
                    cmElem = this.getElementContentModel(elementIndex);
                    int curState = this.fContentModelStateStack[this.fElementDepth + 1];
                    if (curState == -2) break block36;
                    if (curState == -1 || !((DFAContentModel)cmElem).isFinalState(curState)) {
                        return this.fContentModelEleCount[this.fElementDepth + 1];
                    }
                    return -1;
                }
                try {
                    int result = cmElem.validateContent(children, childOffset, childCount);
                    if (result != -1 && this.fGrammarIsSchemaGrammar) {
                        result = cmElem.validateContentSpecial(children, childOffset, childCount);
                    }
                    return result;
                }
                catch (CMException excToCatch) {
                    int majorCode = excToCatch.getErrorCode();
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", majorCode, 0, null, 2);
                }
            } else if (contentType == -1) {
                this.reportRecoverableXMLError(83, 79, elementType);
            } else if (contentType == 5) {
                Object cmElem = null;
                if (childCount > 0) {
                    this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 21, 0, new Object[]{"In element '" + this.fStringPool.toString(elementType) + "' : " + "Can not have element children within a simple type content"}, 1);
                } else {
                    block37: {
                        int hasFixed;
                        String currentElementDefault;
                        String value;
                        block38: {
                            if (this.fCurrentDV == null) {
                                this.fGrammar.getElementDecl(elementIndex, this.fTempElementDecl);
                                this.fCurrentDV = this.fTempElementDecl.datatypeValidator;
                            }
                            if (this.fXsiTypeValidator != null) {
                                this.fCurrentDV = this.fXsiTypeValidator;
                                this.fXsiTypeValidator = null;
                            }
                            if (this.fCurrentDV == null) {
                                System.out.println("Internal Error: this element have a simpletype but no datatypevalidator was found, element " + this.fTempElementDecl.name + ",locapart: " + this.fStringPool.toString(this.fTempElementDecl.name.localpart));
                                break block37;
                            }
                            value = this.fDatatypeBuffer.toString();
                            if (!this.fNormalizeContents && this.fWhiteSpace != 0) {
                                this.fUnnormalizedStr.setLength(0);
                                this.fUnnormalizedStr.append(value);
                                this.normalizeWhitespace(this.fUnnormalizedStr, this.fWhiteSpace == 2);
                                value = this.fNormalizedStr.toString();
                            }
                            currentElementDefault = ((SchemaGrammar)this.fGrammar).getElementDefaultValue(this.fCurrentElementIndex);
                            hasFixed = ((SchemaGrammar)this.fGrammar).getElementDeclMiscFlags(this.fCurrentElementIndex) & 4;
                            if (!this.fNil) break block38;
                            if (value.length() != 0) {
                                this.reportRecoverableXMLError(169, 146, "An element <" + this.fStringPool.toString(elementType) + "> with attribute xsi:nil=\"true\" must be empty");
                            }
                            if (hasFixed != 0) {
                                this.reportRecoverableXMLError(169, 146, "An element <" + this.fStringPool.toString(elementType) + "> with attribute xsi:nil=\"true\" must not have fixed value constraint");
                            }
                            this.fNil = false;
                            return -1;
                        }
                        try {
                            if (currentElementDefault == null || currentElementDefault.length() == 0) {
                                this.validateUsingDV(this.fCurrentDV, value, false);
                            } else if (hasFixed != 0) {
                                if (value.length() == 0) {
                                    this.fDocumentHandler.characters(currentElementDefault.toCharArray(), 0, currentElementDefault.length());
                                    this.validateUsingDV(this.fCurrentDV, currentElementDefault, true);
                                } else {
                                    if (this.fCurrentDV.compare(value, currentElementDefault) != 0) {
                                        this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 38, 0, null, 1);
                                    }
                                    this.validateUsingDV(this.fCurrentDV, value, true);
                                }
                            } else if (value.length() == 0) {
                                this.fDocumentHandler.characters(currentElementDefault.toCharArray(), 0, currentElementDefault.length());
                                this.validateUsingDV(this.fCurrentDV, currentElementDefault, true);
                            } else {
                                this.validateUsingDV(this.fCurrentDV, value, false);
                            }
                        }
                        catch (InvalidDatatypeValueException idve) {
                            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", 21, 0, new Object[]{"In element '" + this.fStringPool.toString(elementType) + "' : " + idve.getMessage()}, 1);
                        }
                    }
                    this.fCurrentDV = null;
                    this.fFirstChunk = true;
                    this.fTrailing = false;
                }
            } else {
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.apache.org/xml/xerces.html", 8, 0, null, 2);
            }
        }
        return -1;
    }

    private void printChildren() {
    }

    private void printStack() {
    }

    boolean invalidStandaloneAttDef(QName element, QName attribute) {
        if (this.fStandaloneReader == -1) {
            return false;
        }
        if (element.rawname == -1) {
            return false;
        }
        return this.getAttDefIsExternal(element, attribute);
    }

    void validateUsingDV(DatatypeValidator dv, String content, boolean onlyVal3Types) throws Exception, InvalidDatatypeValueException {
        if (dv instanceof IDDatatypeValidator) {
            dv.validate(content, this.fIdDefs);
        } else if (dv instanceof IDREFDatatypeValidator) {
            dv.validate(content, this.fValidateIDRef);
        } else if (dv instanceof ENTITYDatatypeValidator) {
            dv.validate(content, this.fValidateEntity);
        } else if (!onlyVal3Types) {
            if (dv instanceof NOTATIONDatatypeValidator && content != null) {
                content = this.bindNotationURI(content);
            }
            dv.validate(content, null);
        }
    }

    final class AttValidatorENUMERATION
    implements AttributeValidator {
        AttValidatorENUMERATION() {
        }

        public int normalize(QName element, QName attribute, int attValueHandle, int attType, int enumHandle) throws Exception {
            String attValue = XMLValidator.this.fStringPool.toString(attValueHandle);
            String newAttValue = attValue.trim();
            if (XMLValidator.this.fValidating) {
                if (newAttValue != attValue) {
                    if (this.invalidStandaloneAttDef(element, attribute)) {
                        XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(attribute.rawname), attValue, newAttValue);
                    }
                    attValueHandle = XMLValidator.this.fStringPool.addSymbol(newAttValue);
                } else {
                    attValueHandle = XMLValidator.this.fStringPool.addSymbol(attValueHandle);
                }
                if (!XMLValidator.this.fStringPool.stringInList(enumHandle, attValueHandle)) {
                    XMLValidator.this.reportRecoverableXMLError(90, 86, XMLValidator.this.fStringPool.toString(attribute.rawname), newAttValue, XMLValidator.this.fStringPool.stringListAsString(enumHandle));
                }
            } else if (newAttValue != attValue) {
                attValueHandle = XMLValidator.this.fStringPool.addSymbol(newAttValue);
            }
            return attValueHandle;
        }

        boolean invalidStandaloneAttDef(QName element, QName attribute) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (element.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(element, attribute);
        }
    }

    final class AttValidatorNOTATION
    implements AttributeValidator {
        AttValidatorNOTATION() {
        }

        public int normalize(QName element, QName attribute, int attValueHandle, int attType, int enumHandle) throws Exception {
            String attValue = XMLValidator.this.fStringPool.toString(attValueHandle);
            String newAttValue = attValue.trim();
            if (XMLValidator.this.fValidating) {
                if (newAttValue != attValue) {
                    if (this.invalidStandaloneAttDef(element, attribute)) {
                        XMLValidator.this.reportRecoverableXMLError(123, 80, XMLValidator.this.fStringPool.toString(attribute.rawname), attValue, newAttValue);
                    }
                    attValueHandle = XMLValidator.this.fStringPool.addSymbol(newAttValue);
                } else {
                    attValueHandle = XMLValidator.this.fStringPool.addSymbol(attValueHandle);
                }
                if (!XMLValidator.this.fStringPool.stringInList(enumHandle, attValueHandle)) {
                    XMLValidator.this.reportRecoverableXMLError(90, 84, XMLValidator.this.fStringPool.toString(attribute.rawname), newAttValue, XMLValidator.this.fStringPool.stringListAsString(enumHandle));
                }
            } else if (newAttValue != attValue) {
                attValueHandle = XMLValidator.this.fStringPool.addSymbol(newAttValue);
            }
            return attValueHandle;
        }

        boolean invalidStandaloneAttDef(QName element, QName attribute) {
            if (XMLValidator.this.fStandaloneReader == -1) {
                return false;
            }
            if (element.rawname == -1) {
                return false;
            }
            return XMLValidator.this.getAttDefIsExternal(element, attribute);
        }
    }

    public static interface AttributeValidator {
        public int normalize(QName var1, QName var2, int var3, int var4, int var5) throws Exception;
    }

    static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        ErrorHandler() {
        }

        public void warning(SAXParseException ex) {
            System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        public void error(SAXParseException ex) {
            System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        public void fatalError(SAXParseException ex) {
            System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        private String getLocationString(SAXParseException ex) {
            StringBuffer str = new StringBuffer();
            String systemId_ = ex.getSystemId();
            if (systemId_ != null) {
                int index = systemId_.lastIndexOf(47);
                if (index != -1) {
                    systemId_ = systemId_.substring(index + 1);
                }
                str.append(systemId_);
            }
            str.append(':');
            str.append(ex.getLineNumber());
            str.append(':');
            str.append(ex.getColumnNumber());
            return str.toString();
        }
    }

    protected class KeyRefValueStore
    extends ValueStoreBase {
        protected ValueStoreBase fKeyValueStore;

        public KeyRefValueStore(KeyRef keyRef, KeyValueStore keyValueStore) {
            super(keyRef);
            this.fKeyValueStore = keyValueStore;
        }

        public void endDocumentFragment() throws Exception {
            super.endDocumentFragment();
            this.fKeyValueStore = (ValueStoreBase)XMLValidator.this.fValueStoreCache.fGlobalIDConstraintMap.get(((KeyRef)this.fIdentityConstraint).getKey());
            if (this.fKeyValueStore == null) {
                int code = 41;
                String value = this.fIdentityConstraint.toString();
                XMLValidator.this.reportSchemaError(code, new Object[]{value});
                return;
            }
            int count = this.fValueTuples.size();
            int i = 0;
            while (i < count) {
                OrderedHashtable values = (OrderedHashtable)this.fValueTuples.elementAt(i);
                if (!this.fKeyValueStore.contains(values)) {
                    int code = 35;
                    String value = this.toString(values);
                    String element = this.fIdentityConstraint.getElementName();
                    XMLValidator.this.reportSchemaError(code, new Object[]{value, element});
                }
                ++i;
            }
        }

        public void endDocument() throws Exception {
            super.endDocument();
        }
    }

    protected class KeyValueStore
    extends ValueStoreBase {
        public KeyValueStore(Key key) {
            super(key);
        }

        protected void duplicateValue(OrderedHashtable tuple) throws Exception {
            int code = 34;
            String value = this.toString(tuple);
            String ename = this.fIdentityConstraint.getElementName();
            XMLValidator.this.reportSchemaError(code, new Object[]{value, ename});
        }
    }

    static final class OrderedHashtable
    implements Cloneable {
        private int fSize;
        private Entry[] fEntries = null;

        OrderedHashtable() {
        }

        public int size() {
            return this.fSize;
        }

        public void put(Field key, IDValue value) {
            int index = this.indexOf(key);
            if (index == -1) {
                this.ensureCapacity(this.fSize);
                index = this.fSize++;
                this.fEntries[index].key = key;
            }
            this.fEntries[index].value = value;
        }

        public IDValue get(Field key) {
            return this.fEntries[this.indexOf((Field)key)].value;
        }

        public int indexOf(Field key) {
            int i = 0;
            while (i < this.fSize) {
                if (this.fEntries[i].key == key) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Field keyAt(int index) {
            return this.fEntries[index].key;
        }

        public IDValue valueAt(int index) {
            return this.fEntries[index].value;
        }

        public void clear() {
            this.fSize = 0;
        }

        private void ensureCapacity(int size) {
            int osize = -1;
            int nsize = -1;
            if (this.fEntries == null) {
                osize = 0;
                nsize = 2;
                this.fEntries = new Entry[nsize];
            } else if (this.fEntries.length <= size) {
                osize = this.fEntries.length;
                nsize = 2 * osize;
                Entry[] array = new Entry[nsize];
                System.arraycopy(this.fEntries, 0, array, 0, osize);
                this.fEntries = array;
            }
            int i = osize;
            while (i < nsize) {
                this.fEntries[i] = new Entry();
                ++i;
            }
        }

        public Object clone() {
            OrderedHashtable hashtable = new OrderedHashtable();
            int i = 0;
            while (i < this.fSize) {
                hashtable.put(this.fEntries[i].key, this.fEntries[i].value);
                ++i;
            }
            return hashtable;
        }

        public String toString() {
            if (this.fSize == 0) {
                return "[]";
            }
            StringBuffer str = new StringBuffer();
            str.append('[');
            int i = 0;
            while (i < this.fSize) {
                if (i > 0) {
                    str.append(',');
                }
                str.append('{');
                str.append(this.fEntries[i].key);
                str.append(',');
                str.append(this.fEntries[i].value);
                str.append('}');
                ++i;
            }
            str.append(']');
            return str.toString();
        }

        public static final class Entry {
            public Field key;
            public IDValue value;
        }
    }

    static class Resolver
    implements EntityResolver {
        private static final String[] SYSTEM = new String[]{"http://www.w3.org/2001/XMLSchema.dtd", "http://www.w3.org/XMLSchema/datatypes.dtd", "http://www.w3.org/XMLSchema/versionInfo.ent"};
        private static final String[] PATH = new String[]{"structures.dtd", "datatypes.dtd", "versionInfo.ent"};
        private DefaultEntityHandler fEntityHandler;

        public Resolver(DefaultEntityHandler handler) {
            this.fEntityHandler = handler;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            InputSource source;
            int i = 0;
            while (i < SYSTEM.length) {
                if (systemId.equals(SYSTEM[i])) {
                    InputSource source2 = new InputSource(this.getClass().getResourceAsStream(PATH[i]));
                    source2.setPublicId(publicId);
                    source2.setSystemId(systemId);
                    return source2;
                }
                ++i;
            }
            EntityResolver resolver = this.fEntityHandler.getEntityResolver();
            if (resolver != null && (source = resolver.resolveEntity(publicId, systemId)) != null) {
                return source;
            }
            return new InputSource(this.fEntityHandler.expandSystemId(systemId));
        }
    }

    protected class UniqueValueStore
    extends ValueStoreBase {
        public UniqueValueStore(Unique unique) {
            super(unique);
        }

        protected void duplicateValue(OrderedHashtable tuple) throws Exception {
            int code = 33;
            String value = this.toString(tuple);
            String ename = this.fIdentityConstraint.getElementName();
            XMLValidator.this.reportSchemaError(code, new Object[]{value, ename});
        }
    }

    protected abstract class ValueStoreBase
    implements ValueStore {
        protected IDValue NOT_AN_IDVALUE = new IDValue("\uffff", null);
        protected IdentityConstraint fIdentityConstraint;
        protected final OrderedHashtable fValues = new OrderedHashtable();
        protected int fValuesCount;
        protected final Vector fValueTuples = new Vector();

        protected ValueStoreBase(IdentityConstraint identityConstraint) {
            this.fIdentityConstraint = identityConstraint;
        }

        public void destroy() {
            this.fValuesCount = 0;
            this.fValues.clear();
            this.fValueTuples.removeAllElements();
        }

        public void append(ValueStoreBase newVal) {
            int i = 0;
            while (i < newVal.fValueTuples.size()) {
                OrderedHashtable o = (OrderedHashtable)newVal.fValueTuples.elementAt(i);
                if (!this.contains(o)) {
                    this.fValueTuples.addElement(o);
                }
                ++i;
            }
        }

        public void startValueScope() throws Exception {
            this.fValuesCount = 0;
            int count = this.fIdentityConstraint.getFieldCount();
            int i = 0;
            while (i < count) {
                this.fValues.put(this.fIdentityConstraint.getFieldAt(i), this.NOT_AN_IDVALUE);
                ++i;
            }
        }

        public void endValueScope() throws Exception {
            if (this.fValuesCount == 0) {
                if (this.fIdentityConstraint.getType() == 1) {
                    int code = 42;
                    String eName = this.fIdentityConstraint.getElementName();
                    XMLValidator.this.reportSchemaError(code, new Object[]{eName});
                }
                return;
            }
            if (this.fValuesCount != this.fIdentityConstraint.getFieldCount()) {
                switch (this.fIdentityConstraint.getType()) {
                    case 0: {
                        int code = 29;
                        String ename = this.fIdentityConstraint.getElementName();
                        XMLValidator.this.reportSchemaError(code, new Object[]{ename});
                        break;
                    }
                    case 1: {
                        int code = 30;
                        Key key = (Key)this.fIdentityConstraint;
                        String ename = this.fIdentityConstraint.getElementName();
                        String kname = key.getIdentityConstraintName();
                        XMLValidator.this.reportSchemaError(code, new Object[]{ename, kname});
                        break;
                    }
                    case 2: {
                        int code = 31;
                        KeyRef keyref = (KeyRef)this.fIdentityConstraint;
                        String ename = this.fIdentityConstraint.getElementName();
                        String kname = keyref.getKey().getIdentityConstraintName();
                        XMLValidator.this.reportSchemaError(code, new Object[]{ename, kname});
                    }
                }
                return;
            }
        }

        public void endDocumentFragment() throws Exception {
        }

        public void endDocument() throws Exception {
        }

        public void reportNilError(IdentityConstraint id) throws Exception {
            if (id.getType() == 1) {
                int code = 43;
                XMLValidator.this.reportSchemaError(code, new Object[]{id.getElementName()});
            }
        }

        public void addValue(Field field, IDValue value) throws Exception {
            int index;
            if (!field.mayMatch()) {
                int code = 40;
                XMLValidator.this.reportSchemaError(code, new Object[]{field.toString()});
            }
            if ((index = this.fValues.indexOf(field)) == -1) {
                int code = 36;
                XMLValidator.this.reportSchemaError(code, new Object[]{field.toString()});
                return;
            }
            IDValue storedValue = this.fValues.valueAt(index);
            if (storedValue.isDuplicateOf(this.NOT_AN_IDVALUE)) {
                ++this.fValuesCount;
            }
            this.fValues.put(field, value);
            if (this.fValuesCount == this.fValues.size()) {
                if (this.contains(this.fValues)) {
                    this.duplicateValue(this.fValues);
                }
                OrderedHashtable values = (OrderedHashtable)this.fValues.clone();
                this.fValueTuples.addElement(values);
            }
        }

        public boolean contains(OrderedHashtable tuple) {
            int tcount = tuple.size();
            int count = this.fValueTuples.size();
            int i = 0;
            while (i < count) {
                block3: {
                    OrderedHashtable vtuple = (OrderedHashtable)this.fValueTuples.elementAt(i);
                    int j = 0;
                    while (j < tcount) {
                        IDValue value2;
                        IDValue value1 = vtuple.valueAt(j);
                        if (value1.isDuplicateOf(value2 = tuple.valueAt(j))) {
                            ++j;
                            continue;
                        }
                        break block3;
                    }
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected void duplicateValue(OrderedHashtable tuple) throws Exception {
        }

        protected String toString(OrderedHashtable tuple) {
            int size = tuple.size();
            if (size == 0) {
                return "";
            }
            StringBuffer str = new StringBuffer();
            int i = 0;
            while (i < size) {
                if (i > 0) {
                    str.append(',');
                }
                str.append(tuple.valueAt(i));
                ++i;
            }
            return str.toString();
        }

        public String toString() {
            int index2;
            String s = super.toString();
            int index1 = s.lastIndexOf(36);
            if (index1 != -1) {
                s = s.substring(index1 + 1);
            }
            if ((index2 = s.lastIndexOf(46)) != -1) {
                s = s.substring(index2 + 1);
            }
            return String.valueOf(s) + '[' + this.fIdentityConstraint + ']';
        }
    }

    protected class ValueStoreCache {
        protected final Vector fValueStores = new Vector();
        protected final Hashtable fIdentityConstraint2ValueStoreMap = new Hashtable();
        protected final Stack fGlobalMapStack = new Stack();
        protected final Hashtable fGlobalIDConstraintMap = new Hashtable();

        public void startDocument() throws Exception {
            this.fValueStores.removeAllElements();
            this.fIdentityConstraint2ValueStoreMap.clear();
            this.fGlobalIDConstraintMap.clear();
            this.fGlobalMapStack.removeAllElements();
        }

        public void startElement() {
            this.fGlobalMapStack.push(this.fGlobalIDConstraintMap.clone());
            this.fGlobalIDConstraintMap.clear();
        }

        public void endElement() {
            if (this.fGlobalMapStack.isEmpty()) {
                return;
            }
            Hashtable oldMap = (Hashtable)this.fGlobalMapStack.pop();
            Enumeration keys = oldMap.keys();
            while (keys.hasMoreElements()) {
                IdentityConstraint id = (IdentityConstraint)keys.nextElement();
                ValueStoreBase oldVal = (ValueStoreBase)oldMap.get(id);
                if (oldVal == null) continue;
                ValueStoreBase currVal = (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
                if (currVal == null) {
                    this.fGlobalIDConstraintMap.put(id, oldVal);
                    continue;
                }
                currVal.append(oldVal);
                this.fGlobalIDConstraintMap.put(id, currVal);
            }
        }

        public void initValueStoresFor(XMLElementDecl eDecl) throws Exception {
            Vector uVector = eDecl.unique;
            int uCount = uVector.size();
            int i = 0;
            while (i < uCount) {
                Unique unique = (Unique)uVector.elementAt(i);
                UniqueValueStore valueStore = (UniqueValueStore)this.fIdentityConstraint2ValueStoreMap.get(unique);
                if (valueStore == null) {
                    valueStore = new UniqueValueStore(unique);
                    this.fValueStores.addElement(valueStore);
                    this.fIdentityConstraint2ValueStoreMap.put(unique, valueStore);
                }
                ++i;
            }
            Vector kVector = eDecl.key;
            int kCount = kVector.size();
            int i2 = 0;
            while (i2 < kCount) {
                Key key = (Key)kVector.elementAt(i2);
                KeyValueStore valueStore = (KeyValueStore)this.fIdentityConstraint2ValueStoreMap.get(key);
                if (valueStore == null) {
                    valueStore = new KeyValueStore(key);
                    this.fValueStores.addElement(valueStore);
                    this.fIdentityConstraint2ValueStoreMap.put(key, valueStore);
                }
                ++i2;
            }
            Vector krVector = eDecl.keyRef;
            int krCount = krVector.size();
            int i3 = 0;
            while (i3 < krCount) {
                KeyRef keyRef = (KeyRef)krVector.elementAt(i3);
                KeyRefValueStore keyRefValueStore = new KeyRefValueStore(keyRef, null);
                this.fValueStores.addElement(keyRefValueStore);
                this.fIdentityConstraint2ValueStoreMap.put(keyRef, keyRefValueStore);
                ++i3;
            }
        }

        public ValueStoreBase getValueStoreFor(Field field) {
            IdentityConstraint identityConstraint = field.getIdentityConstraint();
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(identityConstraint);
        }

        public ValueStoreBase getValueStoreFor(IdentityConstraint id) {
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(id);
        }

        public ValueStoreBase getGlobalValueStoreFor(IdentityConstraint id) {
            return (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
        }

        public void transplant(IdentityConstraint id) throws Exception {
            if (id.getType() == 2) {
                return;
            }
            ValueStoreBase newVals = (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(id);
            this.fIdentityConstraint2ValueStoreMap.remove(id);
            ValueStoreBase currVals = (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
            if (currVals != null) {
                currVals.append(newVals);
                this.fGlobalIDConstraintMap.put(id, currVals);
            } else {
                this.fGlobalIDConstraintMap.put(id, newVals);
            }
        }

        public void endDocument() throws Exception {
            int count = this.fValueStores.size();
            int i = 0;
            while (i < count) {
                ValueStoreBase valueStore = (ValueStoreBase)this.fValueStores.elementAt(i);
                valueStore.endDocument();
                ++i;
            }
        }

        public String toString() {
            String s = super.toString();
            int index1 = s.lastIndexOf(36);
            if (index1 != -1) {
                return s.substring(index1 + 1);
            }
            int index2 = s.lastIndexOf(46);
            if (index2 != -1) {
                return s.substring(index2 + 1);
            }
            return s;
        }
    }

    protected static class XPathMatcherStack {
        protected XPathMatcher[] fMatchers = new XPathMatcher[4];
        protected int fMatchersCount;
        protected IntStack fContextStack = new IntStack();

        public void clear() {
            int i = 0;
            while (i < this.fMatchersCount) {
                this.fMatchers[i] = null;
                ++i;
            }
            this.fMatchersCount = 0;
            this.fContextStack.clear();
        }

        public int size() {
            return this.fContextStack.size();
        }

        public int getMatcherCount() {
            return this.fMatchersCount;
        }

        public void addMatcher(XPathMatcher matcher) {
            this.ensureMatcherCapacity();
            this.fMatchers[this.fMatchersCount++] = matcher;
        }

        public XPathMatcher getMatcherAt(int index) {
            return this.fMatchers[index];
        }

        public void pushContext() {
            this.fContextStack.push(this.fMatchersCount);
        }

        public void popContext() {
            this.fMatchersCount = this.fContextStack.pop();
        }

        private void ensureMatcherCapacity() {
            if (this.fMatchersCount == this.fMatchers.length) {
                XPathMatcher[] array = new XPathMatcher[this.fMatchers.length * 2];
                System.arraycopy(this.fMatchers, 0, array, 0, this.fMatchers.length);
                this.fMatchers = array;
            }
        }
    }
}

