/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public abstract class AbstractNumericFacetValidator
extends AbstractDatatypeValidator {
    protected Object[] fEnumeration = null;
    protected Object fMaxInclusive = null;
    protected Object fMaxExclusive = null;
    protected Object fMinInclusive = null;
    protected Object fMinExclusive = null;
    protected static final short INDETERMINATE = 2;

    public AbstractNumericFacetValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public AbstractNumericFacetValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        this.fBaseValidator = base;
        if (derivedByList) {
            return;
        }
        this.initializeValues();
        if (facets != null) {
            int result;
            Vector enumeration = null;
            Enumeration e = facets.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = null;
                try {
                    if (key.equals("pattern")) {
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                        this.fPattern = (String)facets.get(key);
                        if (this.fPattern == null) continue;
                        this.fRegex = new RegularExpression(this.fPattern, "X");
                        continue;
                    }
                    if (key.equals("enumeration")) {
                        enumeration = (Vector)facets.get(key);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                        continue;
                    }
                    if (key.equals("maxInclusive")) {
                        value = (String)facets.get(key);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                        this.setMaxInclusive(value);
                        continue;
                    }
                    if (key.equals("maxExclusive")) {
                        value = (String)facets.get(key);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                        this.setMaxExclusive(value);
                        continue;
                    }
                    if (key.equals("minInclusive")) {
                        value = (String)facets.get(key);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                        this.setMinInclusive(value);
                        continue;
                    }
                    if (key.equals("minExclusive")) {
                        value = (String)facets.get(key);
                        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                        this.setMinExclusive(value);
                        continue;
                    }
                    if (key.equals("fixed")) {
                        this.fFlags = (Short)facets.get(key);
                        continue;
                    }
                    this.assignAdditionalFacets(key, facets);
                }
                catch (Exception ex) {
                    if (value == null) {
                        throw new InvalidDatatypeFacetException(ex.getMessage());
                    }
                    throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_FACET_VALUE, 0, new Object[]{value, key}));
                }
            }
            if (this.fFacetsDefined != 0) {
                if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x20) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
                }
                if ((this.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x80) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
                }
                if ((this.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x80) != 0 && ((result = this.compareValues(this.fMinInclusive, this.fMaxInclusive)) == 1 || result == 2)) {
                    throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "'must be <= maxInclusive value ='" + this.getMaxInclusive(false) + "'. ");
                }
                if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x100) != 0 && ((result = this.compareValues(this.fMinExclusive, this.fMaxExclusive)) == 1 || result == 2)) {
                    throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "'must be <= maxExclusive value ='" + this.getMaxExclusive(false) + "'. ");
                }
                if ((this.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMinExclusive, this.fMaxInclusive) != -1) {
                    throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "'must be > maxInclusive value ='" + this.getMaxInclusive(false) + "'. ");
                }
                if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x80) != 0 && this.compareValues(this.fMinInclusive, this.fMaxExclusive) != -1) {
                    throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "'must be < maxExclusive value ='" + this.getMaxExclusive(false) + "'. ");
                }
                this.checkFacetConstraints();
            }
            if (base != null) {
                AbstractNumericFacetValidator numBase = (AbstractNumericFacetValidator)base;
                if (this.fFacetsDefined != 0) {
                    if ((this.fFacetsDefined & 0x20) != 0) {
                        if ((numBase.fFacetsDefined & 0x20) != 0) {
                            result = this.compareValues(this.fMaxInclusive, numBase.fMaxInclusive);
                            if ((numBase.fFlags & 0x20) != 0 && result != 0) {
                                throw new InvalidDatatypeFacetException("maxInclusive value = '" + this.getMaxInclusive(false) + "' must be equal to base.maxInclusive value = '" + this.getMaxInclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (result == 1 || result == 2) {
                                throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                            }
                        }
                        if ((numBase.fFacetsDefined & 0x40) != 0 && this.compareValues(this.fMaxInclusive, numBase.fMaxExclusive) != -1) {
                            throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x80) != 0 && ((result = this.compareValues(this.fMaxInclusive, numBase.fMinInclusive)) == -1 || result == 2)) {
                            throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be >= base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMaxInclusive, numBase.fMinExclusive) != 1) {
                            throw new InvalidDatatypeFacetException("maxInclusive value ='" + this.getMaxInclusive(false) + "' must be > base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                        }
                    }
                    if ((this.fFacetsDefined & 0x40) != 0) {
                        if ((numBase.fFacetsDefined & 0x40) != 0) {
                            result = this.compareValues(this.fMaxExclusive, numBase.fMaxExclusive);
                            if ((numBase.fFlags & 0x40) != 0 && result != 0) {
                                throw new InvalidDatatypeFacetException("maxExclusive value = '" + this.getMaxExclusive(false) + "' must be equal to base.maxExclusive value = '" + this.getMaxExclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (result == 1 || result == 2) {
                                throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                            }
                        }
                        if ((numBase.fFacetsDefined & 0x20) != 0 && ((result = this.compareValues(this.fMaxExclusive, numBase.fMaxInclusive)) == 1 || result == 2)) {
                            throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMaxExclusive, numBase.fMinExclusive) != 1) {
                            throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be > base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x80) != 0 && this.compareValues(this.fMaxExclusive, numBase.fMinInclusive) != 1) {
                            throw new InvalidDatatypeFacetException("maxExclusive value ='" + this.getMaxExclusive(false) + "' must be > base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                        }
                    }
                    if ((this.fFacetsDefined & 0x100) != 0) {
                        if ((numBase.fFacetsDefined & 0x100) != 0) {
                            result = this.compareValues(this.fMinExclusive, numBase.fMinExclusive);
                            if ((numBase.fFlags & 0x100) != 0 && result != 0) {
                                throw new InvalidDatatypeFacetException("minExclusive value = '" + this.getMinExclusive(false) + "' must be equal to base.minExclusive value = '" + this.getMinExclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (result == -1 || result == 2) {
                                throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be >= base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                            }
                        }
                        if ((numBase.fFacetsDefined & 0x20) != 0 && ((result = this.compareValues(this.fMinExclusive, numBase.fMaxInclusive)) == 1 || result == 2)) {
                            throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x80) != 0 && ((result = this.compareValues(this.fMinExclusive, numBase.fMinInclusive)) == -1 || result == 2)) {
                            throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be >= base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x40) != 0 && this.compareValues(this.fMinExclusive, numBase.fMaxExclusive) != -1) {
                            throw new InvalidDatatypeFacetException("minExclusive value ='" + this.getMinExclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                        }
                    }
                    if ((this.fFacetsDefined & 0x80) != 0) {
                        if ((numBase.fFacetsDefined & 0x80) != 0) {
                            result = this.compareValues(this.fMinInclusive, numBase.fMinInclusive);
                            if ((numBase.fFlags & 0x80) != 0 && result != 0) {
                                throw new InvalidDatatypeFacetException("minInclusive value = '" + this.getMinInclusive(false) + "' must be equal to base.minInclusive value = '" + this.getMinInclusive(true) + "' with attribute {fixed} = true");
                            }
                            if (result == -1 || result == 2) {
                                throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be >= base.minInclusive value ='" + this.getMinInclusive(true) + "'.");
                            }
                        }
                        if ((numBase.fFacetsDefined & 0x20) != 0 && ((result = this.compareValues(this.fMinInclusive, numBase.fMaxInclusive)) == 1 || result == 2)) {
                            throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be <= base.maxInclusive value ='" + this.getMaxInclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x100) != 0 && this.compareValues(this.fMinInclusive, numBase.fMinExclusive) != 1) {
                            throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be > base.minExclusive value ='" + this.getMinExclusive(true) + "'.");
                        }
                        if ((numBase.fFacetsDefined & 0x40) != 0 && this.compareValues(this.fMinInclusive, numBase.fMaxExclusive) != -1) {
                            throw new InvalidDatatypeFacetException("minInclusive value ='" + this.getMinInclusive(false) + "' must be < base.maxExclusive value ='" + this.getMaxExclusive(true) + "'.");
                        }
                    }
                    this.checkBaseFacetConstraints();
                }
                if ((this.fFacetsDefined & 0x10) == 0 && (numBase.fFacetsDefined & 0x10) != 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    this.fEnumeration = numBase.fEnumeration;
                }
                if ((numBase.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x20) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                    this.fMaxExclusive = numBase.fMaxExclusive;
                }
                if ((numBase.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x20) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                    this.fMaxInclusive = numBase.fMaxInclusive;
                }
                if ((numBase.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                    this.fMinExclusive = numBase.fMinExclusive;
                }
                if ((numBase.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                    this.fMinInclusive = numBase.fMinInclusive;
                }
                this.inheritAdditionalFacets();
                this.fFlags = (short)(this.fFlags | numBase.fFlags);
                if ((this.fFacetsDefined & 0x10) != 0 && enumeration != null) {
                    try {
                        this.setEnumeration(enumeration);
                    }
                    catch (Exception idve) {
                        throw new InvalidDatatypeFacetException(idve.getMessage());
                    }
                }
            }
        }
    }

    protected abstract int compareValues(Object var1, Object var2);

    protected abstract void setMaxInclusive(String var1);

    protected abstract void setMinInclusive(String var1);

    protected abstract void setMaxExclusive(String var1);

    protected abstract void setMinExclusive(String var1);

    protected abstract void setEnumeration(Vector var1) throws InvalidDatatypeValueException;

    protected abstract String getMaxInclusive(boolean var1);

    protected abstract String getMinInclusive(boolean var1);

    protected abstract String getMaxExclusive(boolean var1);

    protected abstract String getMinExclusive(boolean var1);

    protected void initializeValues() {
    }

    protected abstract void assignAdditionalFacets(String var1, Hashtable var2) throws InvalidDatatypeFacetException;

    protected void inheritAdditionalFacets() {
    }

    protected void checkBaseFacetConstraints() throws InvalidDatatypeFacetException {
    }

    protected void checkFacetConstraints() throws InvalidDatatypeFacetException {
    }
}

