/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public abstract class AbstractStringValidator
extends AbstractDatatypeValidator {
    protected int fLength = 0;
    protected int fMaxLength = Integer.MAX_VALUE;
    protected int fMinLength = 0;
    protected Vector fEnumeration = null;
    public static final String FACET_SPECIAL_TOKEN = "specialToken";
    public static final String SPECIAL_TOKEN_NONE = "NONE";
    public static final String SPECIAL_TOKEN_NMTOKEN = "NMTOKEN";
    public static final String SPECIAL_TOKEN_NAME = "Name";
    public static final String SPECIAL_TOKEN_IDNAME = "ID(Name)";
    public static final String SPECIAL_TOKEN_IDREFNAME = "IDREF(Name)";
    public static final String SPECIAL_TOKEN_NCNAME = "NCName";
    public static final String SPECIAL_TOKEN_IDNCNAME = "ID(NCName)";
    public static final String SPECIAL_TOKEN_IDREFNCNAME = "IDREF(NCName)";
    public static final String SPECIAL_TOKEN_ENTITY = "ENTITY(NCName)";
    protected String fTokenType = "NONE";

    public AbstractStringValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public AbstractStringValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        this.fBaseValidator = base;
        if (this.derivationList(derivedByList)) {
            return;
        }
        if (facets != null) {
            Enumeration e = facets.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.equals("length")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
                    String lengthValue = (String)facets.get(key);
                    try {
                        this.fLength = Integer.parseInt(lengthValue);
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidDatatypeFacetException("Length value '" + lengthValue + "' is invalid.");
                    }
                    if (this.fLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("Length value '" + lengthValue + "'  must be a nonNegativeInteger.");
                }
                if (key.equals("minLength")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
                    String minLengthValue = (String)facets.get(key);
                    try {
                        this.fMinLength = Integer.parseInt(minLengthValue);
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidDatatypeFacetException("minLength value '" + minLengthValue + "' is invalid.");
                    }
                    if (this.fMinLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("minLength value '" + minLengthValue + "'  must be a nonNegativeInteger.");
                }
                if (key.equals("maxLength")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
                    String maxLengthValue = (String)facets.get(key);
                    try {
                        this.fMaxLength = Integer.parseInt(maxLengthValue);
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + maxLengthValue + "' is invalid.");
                    }
                    if (this.fMaxLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("maxLength value '" + maxLengthValue + "'  must be a nonNegativeInteger.");
                }
                if (key.equals("pattern")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    this.fPattern = (String)facets.get(key);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                if (key.equals("enumeration")) {
                    this.fEnumeration = (Vector)facets.get(key);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    continue;
                }
                if (key.equals("fixed")) {
                    this.fFlags = (Short)facets.get(key);
                    continue;
                }
                if (key == FACET_SPECIAL_TOKEN) {
                    this.setTokenType((String)facets.get(key));
                    continue;
                }
                this.assignAdditionalFacets(key, facets);
            }
            if (base != null && (this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null) {
                int i = 0;
                try {
                    while (i < this.fEnumeration.size()) {
                        ((AbstractStringValidator)base).checkContent((String)this.fEnumeration.elementAt(i), null, false);
                        ++i;
                    }
                }
                catch (Exception idve) {
                    throw new InvalidDatatypeFacetException("Value of enumeration = '" + this.fEnumeration.elementAt(i) + "' must be from the value space of base.");
                }
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 4) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                }
            }
            if ((this.fFacetsDefined & 6) != 0 && this.fMinLength > this.fMaxLength) {
                throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "'must be <= the value of maxLength = '" + this.fMaxLength + "'.");
            }
            if (base != null) {
                AbstractStringValidator strBase = (AbstractStringValidator)base;
                if ((this.fFacetsDefined & 1) != 0) {
                    if ((strBase.fFacetsDefined & 4) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                    }
                    if ((strBase.fFacetsDefined & 2) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                    }
                    if ((strBase.fFacetsDefined & 1) != 0 && this.fLength != strBase.fLength) {
                        throw new InvalidDatatypeFacetException("Value of length = '" + this.fLength + "' must be = the value of base.length = '" + strBase.fLength + "'.");
                    }
                }
                if ((strBase.fFacetsDefined & 1) != 0) {
                    if ((this.fFacetsDefined & 4) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                    }
                    if ((this.fFacetsDefined & 2) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                    }
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    if ((strBase.fFacetsDefined & 4) != 0) {
                        if (this.fMinLength > strBase.fMaxLength) {
                            throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "'must be <= the value of maxLength = '" + this.fMaxLength + "'.");
                        }
                    } else if ((strBase.fFacetsDefined & 2) != 0) {
                        if ((strBase.fFlags & 2) != 0 && this.fMinLength != strBase.fMinLength) {
                            throw new InvalidDatatypeFacetException("minLength value = '" + this.fMinLength + "' must be equal to base.minLength value = '" + strBase.fMinLength + "' with attribute {fixed} = true");
                        }
                        if (this.fMinLength < strBase.fMinLength) {
                            throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "' must be >= the value of base.minLength = '" + strBase.fMinLength + "'.");
                        }
                    }
                }
                if ((strBase.fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 4) != 0 && strBase.fMinLength > this.fMaxLength) {
                    throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "'must be <= the value of maxLength = '" + this.fMaxLength + "'.");
                }
                if ((this.fFacetsDefined & 4) != 0) {
                    if ((strBase.fFlags & 4) != 0 && this.fMaxLength != strBase.fMaxLength) {
                        throw new InvalidDatatypeFacetException("maxLength value = '" + this.fMaxLength + "' must be equal to base.maxLength value = '" + strBase.fMaxLength + "' with attribute {fixed} = true");
                    }
                    if ((strBase.fFacetsDefined & 4) != 0 && this.fMaxLength > strBase.fMaxLength) {
                        throw new InvalidDatatypeFacetException("Value of maxLength = '" + this.fMaxLength + "' must be <= the value of base.maxLength = '" + strBase.fMaxLength + "'.");
                    }
                }
                this.checkBaseFacetConstraints();
                if ((strBase.fFacetsDefined & 1) != 0 && (this.fFacetsDefined & 1) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
                    this.fLength = strBase.fLength;
                }
                if ((strBase.fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 2) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
                    this.fMinLength = strBase.fMinLength;
                }
                if ((strBase.fFacetsDefined & 4) != 0 && (this.fFacetsDefined & 4) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
                    this.fMaxLength = strBase.fMaxLength;
                }
                if ((this.fFacetsDefined & 0x10) == 0 && (strBase.fFacetsDefined & 0x10) != 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    this.fEnumeration = strBase.fEnumeration;
                }
                this.inheritAdditionalFacets();
                this.fFlags = (short)(this.fFlags | strBase.fFlags);
            }
        }
    }

    protected abstract void assignAdditionalFacets(String var1, Hashtable var2) throws InvalidDatatypeFacetException;

    protected void inheritAdditionalFacets() {
    }

    protected void checkBaseFacetConstraints() throws InvalidDatatypeFacetException {
    }

    protected boolean derivationList(boolean derivedByList) {
        return derivedByList;
    }

    public Object validate(String content, Object state) throws InvalidDatatypeValueException {
        this.checkContent(content, state, false);
        return null;
    }

    private void checkContent(String content, Object state, boolean asBase) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            ((AbstractStringValidator)this.fBaseValidator).checkContent(content, state, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(content))) {
            throw new InvalidDatatypeValueException("Value '" + content + "' does not match regular expression facet '" + this.fPattern + "'.");
        }
        if (this.fTokenType != SPECIAL_TOKEN_NONE) {
            AbstractStringValidator.validateToken(this.fTokenType, content);
        }
        if (asBase) {
            return;
        }
        this.checkValueSpace(content);
        int length = this.getLength(content);
        if ((this.fFacetsDefined & 4) != 0 && length > this.fMaxLength) {
            throw new InvalidDatatypeValueException("Value '" + content + "' with length '" + length + "' exceeds maximum length facet of '" + this.fMaxLength + "'.");
        }
        if ((this.fFacetsDefined & 2) != 0 && length < this.fMinLength) {
            throw new InvalidDatatypeValueException("Value '" + content + "' with length '" + length + "' is less than minimum length facet of '" + this.fMinLength + "'.");
        }
        if ((this.fFacetsDefined & 1) != 0 && length != this.fLength) {
            throw new InvalidDatatypeValueException("Value '" + content + "' with length '" + length + "' is not equal to length facet '" + this.fLength + "'.");
        }
        if ((this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null && !this.fEnumeration.contains(content)) {
            throw new InvalidDatatypeValueException("Value '" + content + "' must be one of " + this.fEnumeration);
        }
    }

    protected int getLength(String content) {
        return content.length();
    }

    protected void checkValueSpace(String content) throws InvalidDatatypeValueException {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public void setTokenType(String tokenType) {
        this.fTokenType = tokenType;
    }

    protected static void validateToken(String tokenType, String content) throws InvalidDatatypeValueException {
        int len;
        if (content == null || (len = content.length()) == 0) {
            throw new InvalidDatatypeValueException("The length of the content must be greater than 0");
        }
        boolean seenErr = false;
        if (tokenType == SPECIAL_TOKEN_NMTOKEN) {
            seenErr = !XMLCharacterProperties.validNmtoken(content);
        } else if (tokenType == SPECIAL_TOKEN_NAME || tokenType == SPECIAL_TOKEN_IDNAME || tokenType == SPECIAL_TOKEN_IDREFNAME) {
            seenErr = !XMLCharacterProperties.validName(content);
        } else if (tokenType == SPECIAL_TOKEN_NCNAME || tokenType == SPECIAL_TOKEN_IDNCNAME || tokenType == SPECIAL_TOKEN_IDREFNCNAME || tokenType == SPECIAL_TOKEN_ENTITY) {
            boolean bl = seenErr = !XMLCharacterProperties.validNCName(content);
        }
        if (seenErr) {
            throw new InvalidDatatypeValueException("Value '" + content + "' is not a valid " + tokenType);
        }
    }
}

