/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import org.apache.xerces.utils.URI;
import org.apache.xerces.validators.datatype.AbstractStringValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class AnyURIDatatypeValidator
extends AbstractStringValidator {
    private URI fTempURI = null;

    public AnyURIDatatypeValidator() throws InvalidDatatypeFacetException {
        super(null, null, false);
    }

    public AnyURIDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        super(base, facets, derivedByList);
    }

    protected void assignAdditionalFacets(String key, Hashtable facets) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_STRING_FACET, 0, new Object[]{key}));
    }

    protected void checkValueSpace(String content) throws InvalidDatatypeValueException {
        try {
            if (this.fTempURI == null) {
                this.fTempURI = new URI("http://www.template.com");
            }
            if (content.length() != 0) {
                new URI(this.fTempURI, content);
            }
        }
        catch (URI.MalformedURIException ex) {
            throw new InvalidDatatypeValueException("Value '" + content + "' is a Malformed URI ");
        }
    }

    public int compare(String content1, String content2) {
        return content1.equals(content2) ? 0 : -1;
    }
}

