/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class BooleanDatatypeValidator
extends AbstractDatatypeValidator {
    private static final String[] fValueSpace = new String[]{"false", "true", "0", "1"};

    public BooleanDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public BooleanDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        this.fBaseValidator = base;
        if (derivedByList) {
            return;
        }
        if (facets != null) {
            Enumeration e = facets.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.equals("pattern")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    this.fPattern = (String)facets.get(key);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_BOOLEAN_FACET, 0, new Object[]{key}));
            }
        }
    }

    public Object validate(String content, Object state) throws InvalidDatatypeValueException {
        this.checkContent(content, false);
        return null;
    }

    public int compare(String content1, String content2) {
        Boolean b2;
        if (content1.equals(content2)) {
            return 0;
        }
        Boolean b1 = Boolean.valueOf(content1);
        return b1.equals(b2 = Boolean.valueOf(content2)) ? 0 : 1;
    }

    public Hashtable getFacets() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    private void checkContent(String content, boolean asBase) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            ((BooleanDatatypeValidator)this.fBaseValidator).checkContent(content, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(content))) {
            throw new InvalidDatatypeValueException("Value'" + content + "does not match regular expression facet" + this.fPattern);
        }
        if (asBase) {
            return;
        }
        boolean isContentInDomain = false;
        int i = 0;
        while (i < fValueSpace.length) {
            if (content.equals(fValueSpace[i])) {
                isContentInDomain = true;
            }
            ++i;
        }
        if (!isContentInDomain) {
            throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_BOOLEAN, 0, new Object[]{content}));
        }
    }
}

