/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.AnySimpleType;
import org.apache.xerces.validators.datatype.AnyURIDatatypeValidator;
import org.apache.xerces.validators.datatype.Base64BinaryDatatypeValidator;
import org.apache.xerces.validators.datatype.BooleanDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactory;
import org.apache.xerces.validators.datatype.DateDatatypeValidator;
import org.apache.xerces.validators.datatype.DateTimeDatatypeValidator;
import org.apache.xerces.validators.datatype.DayDatatypeValidator;
import org.apache.xerces.validators.datatype.DecimalDatatypeValidator;
import org.apache.xerces.validators.datatype.DoubleDatatypeValidator;
import org.apache.xerces.validators.datatype.DurationDatatypeValidator;
import org.apache.xerces.validators.datatype.ENTITYDatatypeValidator;
import org.apache.xerces.validators.datatype.FloatDatatypeValidator;
import org.apache.xerces.validators.datatype.HexBinaryDatatypeValidator;
import org.apache.xerces.validators.datatype.IDDatatypeValidator;
import org.apache.xerces.validators.datatype.IDREFDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.ListDatatypeValidator;
import org.apache.xerces.validators.datatype.MonthDatatypeValidator;
import org.apache.xerces.validators.datatype.MonthDayDatatypeValidator;
import org.apache.xerces.validators.datatype.NOTATIONDatatypeValidator;
import org.apache.xerces.validators.datatype.QNameDatatypeValidator;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;
import org.apache.xerces.validators.datatype.TimeDatatypeValidator;
import org.apache.xerces.validators.datatype.UnionDatatypeValidator;
import org.apache.xerces.validators.datatype.YearDatatypeValidator;
import org.apache.xerces.validators.datatype.YearMonthDatatypeValidator;

public class DatatypeValidatorFactoryImpl
implements DatatypeValidatorFactory {
    private static final boolean fDebug = false;
    private Hashtable fRegistry = new Hashtable(30);
    private Hashtable fDTDDatatypeRegistry;
    private Hashtable fSchemaDatatypeRegistry = new Hashtable(40);
    private byte fRegistryExpanded = 0;
    private byte fSchemaValidation = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public DatatypeValidatorFactoryImpl() {
        this.fDTDDatatypeRegistry = new Hashtable(10);
    }

    public void initializeDTDRegistry() {
        if (this.fRegistryExpanded == 0) {
            try {
                this.fDTDDatatypeRegistry.put("string", new StringDatatypeValidator());
                this.fDTDDatatypeRegistry.put("ID", new IDDatatypeValidator());
                this.fDTDDatatypeRegistry.put("IDREF", new IDREFDatatypeValidator());
                this.fDTDDatatypeRegistry.put("ENTITY", new ENTITYDatatypeValidator());
                this.fDTDDatatypeRegistry.put("NOTATION", new NOTATIONDatatypeValidator());
                this.createDTDDatatypeValidator("IDREFS", new IDREFDatatypeValidator(), null, true);
                this.createDTDDatatypeValidator("ENTITIES", new ENTITYDatatypeValidator(), null, true);
                Hashtable<String, String> facets = new Hashtable<String, String>(2);
                facets.put("specialToken", "NMTOKEN");
                facets.put("whiteSpace", "collapse");
                this.createDTDDatatypeValidator("NMTOKEN", new StringDatatypeValidator(), facets, false);
                this.createDTDDatatypeValidator("NMTOKENS", this.getDatatypeValidator("NMTOKEN"), null, true);
                this.fRegistryExpanded = 1;
            }
            catch (InvalidDatatypeFacetException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void expandRegistryToFullSchemaSet() {
        this.fSchemaValidation = 1;
        if (this.fRegistryExpanded != 2) {
            try {
                this.fSchemaDatatypeRegistry.put("anySimpleType", new AnySimpleType());
                this.fSchemaDatatypeRegistry.put("boolean", new BooleanDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("float", new FloatDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("double", new DoubleDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("decimal", new DecimalDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("hexBinary", new HexBinaryDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("base64Binary", new Base64BinaryDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("anyURI", new AnyURIDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("QName", new QNameDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("duration", new DurationDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("gDay", new DayDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("time", new TimeDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("dateTime", new DateTimeDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("date", new DateDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("gMonthDay", new MonthDayDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("gYearMonth", new YearMonthDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("gYear", new YearDatatypeValidator());
                this.fSchemaDatatypeRegistry.put("gMonth", new MonthDatatypeValidator());
                if (this.fRegistryExpanded == 0) {
                    this.initializeDTDRegistry();
                }
                Hashtable<String, String> facets = new Hashtable<String, String>(2);
                facets.put("whiteSpace", "replace");
                this.createSchemaDatatypeValidator("normalizedString", this.getDatatypeValidator("string"), facets, false);
                facets.clear();
                facets.put("whiteSpace", "collapse");
                this.createSchemaDatatypeValidator("token", this.getDatatypeValidator("string"), facets, false);
                facets.clear();
                facets.put("whiteSpace", "collapse");
                facets.put("pattern", "([a-zA-Z]{2}|[iI]-[a-zA-Z]+|[xX]-[a-zA-Z]+)(-[a-zA-Z]+)*");
                this.createSchemaDatatypeValidator("language", this.getDatatypeValidator("string"), facets, false);
                facets.clear();
                facets.put("whiteSpace", "collapse");
                facets.put("specialToken", "Name");
                this.createSchemaDatatypeValidator("Name", this.getDatatypeValidator("string"), facets, false);
                facets.clear();
                facets.put("whiteSpace", "collapse");
                facets.put("specialToken", "NCName");
                this.createSchemaDatatypeValidator("NCName", this.getDatatypeValidator("string"), facets, false);
                facets.clear();
                facets.put("fractionDigits", "0");
                this.createSchemaDatatypeValidator("integer", this.getDatatypeValidator("decimal"), facets, false);
                facets.clear();
                facets.put("maxInclusive", "0");
                this.createSchemaDatatypeValidator("nonPositiveInteger", this.getDatatypeValidator("integer"), facets, false);
                facets.clear();
                facets.put("maxInclusive", "-1");
                this.createSchemaDatatypeValidator("negativeInteger", this.getDatatypeValidator("nonPositiveInteger"), facets, false);
                facets.clear();
                facets.put("maxInclusive", "9223372036854775807");
                facets.put("minInclusive", "-9223372036854775808");
                this.createSchemaDatatypeValidator("long", this.getDatatypeValidator("integer"), facets, false);
                facets.clear();
                facets.put("maxInclusive", "2147483647");
                facets.put("minInclusive", "-2147483648");
                this.createSchemaDatatypeValidator("int", this.getDatatypeValidator("long"), facets, false);
                facets.clear();
                facets.put("maxInclusive", "32767");
                facets.put("minInclusive", "-32768");
                this.createSchemaDatatypeValidator("short", this.getDatatypeValidator("int"), facets, false);
                facets.clear();
                facets.put("maxInclusive", "127");
                facets.put("minInclusive", "-128");
                this.createSchemaDatatypeValidator("byte", this.getDatatypeValidator("short"), facets, false);
                facets.clear();
                facets.put("minInclusive", "0");
                this.createSchemaDatatypeValidator("nonNegativeInteger", this.getDatatypeValidator("integer"), facets, false);
                facets.clear();
                facets.put("maxInclusive", "18446744073709551615");
                this.createSchemaDatatypeValidator("unsignedLong", this.getDatatypeValidator("nonNegativeInteger"), facets, false);
                facets.clear();
                facets.put("maxInclusive", "4294967295");
                this.createSchemaDatatypeValidator("unsignedInt", this.getDatatypeValidator("unsignedLong"), facets, false);
                facets.clear();
                facets.put("maxInclusive", "65535");
                this.createSchemaDatatypeValidator("unsignedShort", this.getDatatypeValidator("unsignedInt"), facets, false);
                facets.clear();
                facets.put("maxInclusive", "255");
                this.createSchemaDatatypeValidator("unsignedByte", this.getDatatypeValidator("unsignedShort"), facets, false);
                facets.clear();
                facets.put("minInclusive", "1");
                this.createSchemaDatatypeValidator("positiveInteger", this.getDatatypeValidator("nonNegativeInteger"), facets, false);
                ((IDDatatypeValidator)this.getDatatypeValidator("ID")).setTokenType("ID(NCName)");
                ((IDREFDatatypeValidator)this.getDatatypeValidator("IDREF")).setTokenType("IDREF(NCName)");
                QNameDatatypeValidator.setNCNameValidator(this.getDatatypeValidator("NCName"));
                this.fRegistryExpanded = (byte)2;
            }
            catch (InvalidDatatypeFacetException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void resetRegistry() {
        this.fRegistry.clear();
        this.fSchemaValidation = 0;
    }

    public DatatypeValidator createDatatypeValidator(String typeName, DatatypeValidator base, Hashtable facets, boolean list) throws InvalidDatatypeFacetException {
        if (base == null) {
            return null;
        }
        DatatypeValidator simpleType = this.createSchemaValidator(typeName, base, facets, list);
        this.registerUserDefinedValidator(typeName, simpleType);
        return simpleType;
    }

    public DatatypeValidator createDatatypeValidator(String typeName, Vector validators) {
        UnionDatatypeValidator simpleType = null;
        if (validators != null) {
            simpleType = new UnionDatatypeValidator(validators);
        }
        if (simpleType != null) {
            this.registerUserDefinedValidator(typeName, simpleType);
        }
        return simpleType;
    }

    public DatatypeValidator getDatatypeValidator(String type) {
        AbstractDatatypeValidator simpleType = null;
        if (type == null) {
            return null;
        }
        simpleType = (AbstractDatatypeValidator)this.fDTDDatatypeRegistry.get(type);
        if (simpleType == null && this.fSchemaValidation == 1 && (simpleType = (AbstractDatatypeValidator)this.fSchemaDatatypeRegistry.get(type)) == null) {
            return (DatatypeValidator)this.fRegistry.get(type);
        }
        return simpleType;
    }

    private DatatypeValidator createSchemaDatatypeValidator(String typeName, DatatypeValidator base, Hashtable facets, boolean list) throws InvalidDatatypeFacetException {
        DatatypeValidator primitive = this.createSchemaValidator(typeName, base, facets, list);
        this.registerSchemaValidator(typeName, primitive);
        return primitive;
    }

    private DatatypeValidator createDTDDatatypeValidator(String typeName, DatatypeValidator base, Hashtable facets, boolean list) throws InvalidDatatypeFacetException {
        DatatypeValidator primitive = this.createSchemaValidator(typeName, base, facets, list);
        this.registerDTDValidator(typeName, primitive);
        return primitive;
    }

    private DatatypeValidator createSchemaValidator(String typeName, DatatypeValidator base, Hashtable facets, boolean list) throws InvalidDatatypeFacetException {
        DatatypeValidator simpleType = null;
        if (list) {
            simpleType = new ListDatatypeValidator(base, facets, list);
        } else {
            try {
                String value = (String)facets.get("whiteSpace");
                if (value != null && !(base instanceof StringDatatypeValidator)) {
                    if (!value.equals("collapse")) {
                        throw new InvalidDatatypeFacetException("whiteSpace value '" + value + "' for this type must be 'collapse'.");
                    }
                    facets.remove("whiteSpace");
                }
                Class<?> validatorDef = base.getClass();
                Class[] classArray = new Class[3];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.apache.xerces.validators.datatype.DatatypeValidator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("java.util.Hashtable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                classArray[2] = Boolean.TYPE;
                Class[] validatorArgsClass = classArray;
                Object[] validatorArgs = new Object[]{base, facets, Boolean.FALSE};
                Constructor<?> validatorConstructor = validatorDef.getConstructor(validatorArgsClass);
                simpleType = (DatatypeValidator)DatatypeValidatorFactoryImpl.createDatatypeValidator(validatorConstructor, validatorArgs);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return simpleType;
    }

    private void registerUserDefinedValidator(String typeName, DatatypeValidator simpleType) {
        if (simpleType != null) {
            this.fRegistry.put(typeName, simpleType);
        }
    }

    private void registerSchemaValidator(String typeName, DatatypeValidator simpleType) {
        if (simpleType != null) {
            this.fSchemaDatatypeRegistry.put(typeName, simpleType);
        }
    }

    private void registerDTDValidator(String typeName, DatatypeValidator simpleType) {
        if (simpleType != null) {
            this.fDTDDatatypeRegistry.put(typeName, simpleType);
        }
    }

    private static Object createDatatypeValidator(Constructor validatorConstructor, Object[] arguments) throws InvalidDatatypeFacetException {
        Object validator = null;
        try {
            validator = validatorConstructor.newInstance(arguments);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException e) {
            throw new InvalidDatatypeFacetException(e.getTargetException().getMessage());
        }
        return validator;
    }
}

