/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.validators.datatype.AbstractNumericValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class DecimalDatatypeValidator
extends AbstractNumericValidator {
    protected int fTotalDigits;
    protected int fFractionDigits;

    public DecimalDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public DecimalDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        super(base, facets, derivedByList);
    }

    public int compare(String value1, String value2) {
        try {
            BigDecimal d1 = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(value1));
            BigDecimal d2 = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(value2));
            return d1.compareTo(d2);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    protected void inheritAdditionalFacets() {
        if ((((DecimalDatatypeValidator)this.fBaseValidator).fFacetsDefined & 0x200) != 0 && (this.fFacetsDefined & 0x200) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x200);
            this.fTotalDigits = ((DecimalDatatypeValidator)this.fBaseValidator).fTotalDigits;
        }
        if ((((DecimalDatatypeValidator)this.fBaseValidator).fFacetsDefined & 0x400) != 0 && (this.fFacetsDefined & 0x400) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x400);
            this.fFractionDigits = ((DecimalDatatypeValidator)this.fBaseValidator).fFractionDigits;
        }
    }

    protected void checkFacetConstraints() throws InvalidDatatypeFacetException {
        if ((this.fFacetsDefined & 0x400) != 0 && (this.fFacetsDefined & 0x200) != 0 && this.fFractionDigits > this.fTotalDigits) {
            throw new InvalidDatatypeFacetException("fractionDigits value ='" + this.fFractionDigits + "'must be <= totalDigits value ='" + this.fTotalDigits + "'. ");
        }
    }

    protected void checkBaseFacetConstraints() throws InvalidDatatypeFacetException {
        if ((this.fFacetsDefined & 0x200) != 0 && (((DecimalDatatypeValidator)this.fBaseValidator).fFacetsDefined & 0x200) != 0) {
            if ((((DecimalDatatypeValidator)this.fBaseValidator).fFlags & 0x200) != 0 && this.fTotalDigits != ((DecimalDatatypeValidator)this.fBaseValidator).fTotalDigits) {
                throw new InvalidDatatypeFacetException("totalDigits value = '" + this.fTotalDigits + "' must be equal to base.totalDigits value = '" + ((DecimalDatatypeValidator)this.fBaseValidator).fTotalDigits + "' with attribute {fixed} = true");
            }
            if (this.fTotalDigits > ((DecimalDatatypeValidator)this.fBaseValidator).fTotalDigits) {
                throw new InvalidDatatypeFacetException("totalDigits value ='" + this.fTotalDigits + "' must be <= base.totalDigits value ='" + ((DecimalDatatypeValidator)this.fBaseValidator).fTotalDigits + "'.");
            }
        }
        if ((this.fFacetsDefined & 0x400) != 0 && (((DecimalDatatypeValidator)this.fBaseValidator).fFacetsDefined & 0x400) != 0 && (((DecimalDatatypeValidator)this.fBaseValidator).fFlags & 0x400) != 0 && this.fFractionDigits != ((DecimalDatatypeValidator)this.fBaseValidator).fFractionDigits) {
            throw new InvalidDatatypeFacetException("fractionDigits value = '" + this.fFractionDigits + "' must be equal to base.fractionDigits value = '" + ((DecimalDatatypeValidator)this.fBaseValidator).fFractionDigits + "' with attribute {fixed} = true");
        }
    }

    protected void assignAdditionalFacets(String key, Hashtable facets) throws InvalidDatatypeFacetException {
        block6: {
            String value = null;
            try {
                if (key.equals("totalDigits")) {
                    value = (String)facets.get(key);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x200);
                    this.fTotalDigits = Integer.parseInt(value);
                    if (this.fTotalDigits <= 0) {
                        throw new InvalidDatatypeFacetException("totalDigits value '" + this.fTotalDigits + "' must be a positiveInteger.");
                    }
                    break block6;
                }
                if (key.equals("fractionDigits")) {
                    value = (String)facets.get(key);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x400);
                    this.fFractionDigits = Integer.parseInt(value);
                    if (this.fFractionDigits < 0) {
                        throw new InvalidDatatypeFacetException("fractionDigits value '" + this.fFractionDigits + "' must be a positiveInteger.");
                    }
                    break block6;
                }
                throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_DECIMAL_FACET, 0, new Object[]{value, key}));
            }
            catch (Exception ex) {
                throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_FACET_VALUE, 0, new Object[]{value, key}));
            }
        }
    }

    protected int compareValues(Object value1, Object value2) {
        return ((BigDecimal)value1).compareTo((BigDecimal)value2);
    }

    protected void setMaxInclusive(String value) {
        this.fMaxInclusive = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(value));
    }

    protected void setMinInclusive(String value) {
        this.fMinInclusive = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(value));
    }

    protected void setMaxExclusive(String value) {
        this.fMaxExclusive = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(value));
    }

    protected void setMinExclusive(String value) {
        this.fMinExclusive = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(value));
    }

    protected void setEnumeration(Vector enumeration) throws InvalidDatatypeValueException {
        if (enumeration != null) {
            this.fEnumeration = new BigDecimal[enumeration.size()];
            Object baseEnum = null;
            try {
                int i = 0;
                while (i < enumeration.size()) {
                    this.fEnumeration[i] = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent((String)enumeration.elementAt(i)));
                    ((DecimalDatatypeValidator)this.fBaseValidator).validate((String)enumeration.elementAt(i), null);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new InvalidDatatypeValueException(e.getMessage());
            }
        }
    }

    protected String getMaxInclusive(boolean isBase) {
        return isBase ? ((DecimalDatatypeValidator)this.fBaseValidator).fMaxInclusive.toString() : ((BigDecimal)this.fMaxInclusive).toString();
    }

    protected String getMinInclusive(boolean isBase) {
        return isBase ? ((DecimalDatatypeValidator)this.fBaseValidator).fMinInclusive.toString() : ((BigDecimal)this.fMinInclusive).toString();
    }

    protected String getMaxExclusive(boolean isBase) {
        return isBase ? ((DecimalDatatypeValidator)this.fBaseValidator).fMaxExclusive.toString() : ((BigDecimal)this.fMaxExclusive).toString();
    }

    protected String getMinExclusive(boolean isBase) {
        return isBase ? ((DecimalDatatypeValidator)this.fBaseValidator).fMinExclusive.toString() : ((BigDecimal)this.fMinExclusive).toString();
    }

    protected void checkContent(String content, Object state, Vector enumeration, boolean asBase) throws InvalidDatatypeValueException {
        int totalDigits;
        if (this.fBaseValidator != null) {
            ((DecimalDatatypeValidator)this.fBaseValidator).checkContent(content, state, enumeration, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(content))) {
            throw new InvalidDatatypeValueException("Value'" + content + "' does not match regular expression facet " + this.fRegex.getPattern());
        }
        if (asBase) {
            return;
        }
        BigDecimal d = null;
        try {
            d = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent(content));
        }
        catch (Exception nfe) {
            throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_DECIMAL, 0, new Object[]{"'" + content + "'"}));
        }
        if (enumeration != null) {
            int size = enumeration.size();
            BigDecimal[] enumDecimal = new BigDecimal[size];
            int i = 0;
            try {
                while (i < size) {
                    enumDecimal[i] = new BigDecimal(DecimalDatatypeValidator.stripPlusIfPresent((String)enumeration.elementAt(i)));
                    ++i;
                }
            }
            catch (NumberFormatException nfe) {
                throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.INVALID_ENUM_VALUE, 0, new Object[]{enumeration.elementAt(i)}));
            }
            this.enumCheck(d, enumDecimal);
        }
        if ((this.fFacetsDefined & 0x400) != 0 && d.scale() > this.fFractionDigits) {
            throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.FRACTION_EXCEEDED, 0, new Object[]{"'" + content + "'" + " with fractionDigits = '" + d.scale() + "'", "'" + this.fFractionDigits + "'"}));
        }
        if ((this.fFacetsDefined & 0x200) != 0 && (totalDigits = d.movePointRight(d.scale()).toString().length() - (d.signum() < 0 ? 1 : 0)) > this.fTotalDigits) {
            throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.TOTALDIGITS_EXCEEDED, 0, new Object[]{"'" + content + "'" + " with totalDigits = '" + totalDigits + "'", "'" + this.fTotalDigits + "'"}));
        }
        this.boundsCheck(d);
        if (this.fEnumeration != null) {
            this.enumCheck(d, (BigDecimal[])this.fEnumeration);
        }
    }

    private static String stripPlusIfPresent(String value) {
        String strippedPlus = value;
        if (value.length() >= 2 && value.charAt(0) == '+' && value.charAt(1) != '-') {
            strippedPlus = value.substring(1);
        }
        return strippedPlus;
    }

    private void enumCheck(BigDecimal v, BigDecimal[] bigDecimalArray) throws InvalidDatatypeValueException {
        int i = 0;
        while (i < bigDecimalArray.length) {
            if (v.equals(bigDecimalArray[i])) {
                return;
            }
            ++i;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_ENUM_VALUE, 0, new Object[]{v}));
    }
}

