/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.validators.datatype.AbstractNumericValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class DoubleDatatypeValidator
extends AbstractNumericValidator {
    public DoubleDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public DoubleDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        super(base, facets, derivedByList);
    }

    public int compare(String value1, String value2) {
        try {
            double d1 = DoubleDatatypeValidator.dValueOf(value1);
            double d2 = DoubleDatatypeValidator.dValueOf(value2);
            return this.compareDoubles(d1, d2);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected void assignAdditionalFacets(String key, Hashtable facets) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_DOUBLE_FACET, 0, new Object[]{key}));
    }

    protected int compareValues(Object value1, Object value2) {
        double d1 = (Double)value1;
        double d2 = (Double)value2;
        return this.compareDoubles(d1, d2);
    }

    protected void setMaxInclusive(String value) {
        this.fMaxInclusive = DoubleDatatypeValidator.dValueOf(value);
    }

    protected void setMinInclusive(String value) {
        this.fMinInclusive = DoubleDatatypeValidator.dValueOf(value);
    }

    protected void setMaxExclusive(String value) {
        this.fMaxExclusive = DoubleDatatypeValidator.dValueOf(value);
    }

    protected void setMinExclusive(String value) {
        this.fMinExclusive = DoubleDatatypeValidator.dValueOf(value);
    }

    protected void setEnumeration(Vector enumeration) throws InvalidDatatypeValueException {
        if (enumeration != null) {
            this.fEnumeration = new Double[enumeration.size()];
            Object baseEnum = null;
            try {
                int i = 0;
                while (i < enumeration.size()) {
                    this.fEnumeration[i] = DoubleDatatypeValidator.dValueOf((String)enumeration.elementAt(i));
                    ((DoubleDatatypeValidator)this.fBaseValidator).validate((String)enumeration.elementAt(i), null);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new InvalidDatatypeValueException(e.getMessage());
            }
        }
    }

    protected String getMaxInclusive(boolean isBase) {
        return isBase ? ((DoubleDatatypeValidator)this.fBaseValidator).fMaxInclusive.toString() : ((Double)this.fMaxInclusive).toString();
    }

    protected String getMinInclusive(boolean isBase) {
        return isBase ? ((DoubleDatatypeValidator)this.fBaseValidator).fMinInclusive.toString() : ((Double)this.fMinInclusive).toString();
    }

    protected String getMaxExclusive(boolean isBase) {
        return isBase ? ((DoubleDatatypeValidator)this.fBaseValidator).fMaxExclusive.toString() : ((Double)this.fMaxExclusive).toString();
    }

    protected String getMinExclusive(boolean isBase) {
        return isBase ? ((DoubleDatatypeValidator)this.fBaseValidator).fMinExclusive.toString() : ((Double)this.fMinExclusive).toString();
    }

    protected void checkContentEnum(String content, Object state, Vector enumeration) throws InvalidDatatypeValueException {
        this.checkContent(content, state, enumeration, false);
    }

    protected void checkContent(String content, Object state, Vector enumeration, boolean asBase) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            ((DoubleDatatypeValidator)this.fBaseValidator).checkContent(content, state, enumeration, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(content))) {
            throw new InvalidDatatypeValueException("Value'" + content + "does not match regular expression facet" + this.fPattern);
        }
        if (asBase) {
            return;
        }
        Double d = null;
        try {
            d = DoubleDatatypeValidator.dValueOf(content);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_DOUBLE, 0, new Object[]{content}));
        }
        if (enumeration != null) {
            int size = enumeration.size();
            Double[] enumDoubles = new Double[size];
            int i = 0;
            try {
                while (i < size) {
                    enumDoubles[i] = DoubleDatatypeValidator.dValueOf((String)enumeration.elementAt(i));
                    ++i;
                }
            }
            catch (NumberFormatException nfe) {
                throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.INVALID_ENUM_VALUE, 0, new Object[]{enumeration.elementAt(i)}));
            }
            this.enumCheck(d, enumDoubles);
        }
        this.boundsCheck(d);
        if ((this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null) {
            this.enumCheck(d, (Double[])this.fEnumeration);
        }
    }

    protected int getInvalidFacetMsg() {
        return DatatypeMessageProvider.ILLEGAL_DOUBLE_FACET;
    }

    private static Double dValueOf(String s) throws NumberFormatException {
        Double d;
        try {
            d = Double.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            if (s.equals("INF")) {
                d = new Double(Double.POSITIVE_INFINITY);
            }
            if (s.equals("-INF")) {
                d = new Double(Double.NEGATIVE_INFINITY);
            }
            if (s.equals("NaN")) {
                d = new Double(Double.NaN);
            }
            throw nfe;
        }
        return d;
    }

    private void enumCheck(double v, Double[] enumDoubles) throws InvalidDatatypeValueException {
        int i = 0;
        while (i < enumDoubles.length) {
            if (v == enumDoubles[i]) {
                return;
            }
            ++i;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_ENUM_VALUE, 0, new Object[]{new Double(v)}));
    }

    private int compareDoubles(double d1, double d2) {
        long d1V = Double.doubleToLongBits(d1);
        long d2V = Double.doubleToLongBits(d2);
        if (d1 > d2) {
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        if (d1V == d2V) {
            return 0;
        }
        return d1V < d2V ? -1 : 1;
    }
}

