/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DateTimeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.SchemaDateTimeException;

public class DurationDatatypeValidator
extends DateTimeValidator {
    private static final int[][] DATETIMES;
    private int[][] fDuration = null;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[8];
        nArray[0] = 1696;
        nArray[1] = 9;
        nArray[2] = 1;
        nArray[7] = 90;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1697;
        nArray2[1] = 2;
        nArray2[2] = 1;
        nArray2[7] = 90;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[8];
        nArray3[0] = 1903;
        nArray3[1] = 3;
        nArray3[2] = 1;
        nArray3[7] = 90;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[8];
        nArray4[0] = 1903;
        nArray4[1] = 7;
        nArray4[2] = 1;
        nArray4[7] = 90;
        nArrayArray[3] = nArray4;
        DATETIMES = nArrayArray;
    }

    public DurationDatatypeValidator() throws InvalidDatatypeFacetException {
    }

    public DurationDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        super(base, facets, derivedByList);
    }

    protected int[] parse(String str, int[] date) throws SchemaDateTimeException {
        int end;
        this.resetBuffer(str);
        if (date == null) {
            date = new int[8];
        }
        this.resetDateObj(date);
        char c = this.fBuffer.charAt(this.fStart++);
        if (c != 'P' && c != '-') {
            throw new SchemaDateTimeException();
        }
        int n = date[7] = c == '-' ? 45 : 0;
        if (c == '-' && this.fBuffer.charAt(this.fStart++) != 'P') {
            throw new SchemaDateTimeException();
        }
        int negate = 1;
        if (date[7] == 45) {
            negate = -1;
        }
        boolean designator = false;
        int endDate = this.indexOf(this.fStart, this.fEnd, 'T');
        if (endDate == -1) {
            endDate = this.fEnd;
        }
        if ((end = this.indexOf(this.fStart, endDate, 'Y')) != -1) {
            date[0] = negate * this.parseInt(this.fStart, end);
            this.fStart = end + 1;
            designator = true;
        }
        if ((end = this.indexOf(this.fStart, endDate, 'M')) != -1) {
            date[1] = negate * this.parseInt(this.fStart, end);
            this.fStart = end + 1;
            designator = true;
        }
        if ((end = this.indexOf(this.fStart, endDate, 'D')) != -1) {
            date[2] = negate * this.parseInt(this.fStart, end);
            this.fStart = end + 1;
            designator = true;
        }
        if (this.fEnd == endDate && this.fStart != this.fEnd) {
            throw new SchemaDateTimeException();
        }
        if (this.fEnd != endDate) {
            if ((end = this.indexOf(++this.fStart, this.fEnd, 'H')) != -1) {
                date[3] = negate * this.parseInt(this.fStart, end);
                this.fStart = end + 1;
                designator = true;
            }
            if ((end = this.indexOf(this.fStart, this.fEnd, 'M')) != -1) {
                date[4] = negate * this.parseInt(this.fStart, end);
                this.fStart = end + 1;
                designator = true;
            }
            if ((end = this.indexOf(this.fStart, this.fEnd, 'S')) != -1) {
                int mlsec = this.indexOf(this.fStart, end, '.');
                if (mlsec > 0) {
                    date[5] = negate * this.parseInt(this.fStart, mlsec);
                    date[6] = negate * this.parseInt(mlsec + 1, end);
                } else {
                    date[5] = negate * this.parseInt(this.fStart, end);
                }
                this.fStart = end + 1;
                designator = true;
            }
            if (this.fStart != this.fEnd || this.fBuffer.charAt(--this.fStart) == 'T') {
                throw new SchemaDateTimeException();
            }
        }
        if (!designator) {
            throw new SchemaDateTimeException();
        }
        return date;
    }

    protected short compareDates(int[] date1, int[] date2, boolean strict) {
        int[] tempB;
        int[] tempA;
        short resultB = 2;
        short resultA = this.compareOrder(date1, date2);
        if (resultA == 0) {
            return 0;
        }
        if (this.fDuration == null) {
            this.fDuration = new int[2][8];
        }
        if ((resultA = this.compareOrder(tempA = this.addDuration(date1, 0, this.fDuration[0]), tempB = this.addDuration(date2, 0, this.fDuration[1]))) == 2) {
            return 2;
        }
        tempA = this.addDuration(date1, 1, this.fDuration[0]);
        resultB = this.compareOrder(tempA, tempB = this.addDuration(date2, 1, this.fDuration[1]));
        if ((resultA = this.compareResults(resultA, resultB, strict)) == 2) {
            return 2;
        }
        tempA = this.addDuration(date1, 2, this.fDuration[0]);
        resultB = this.compareOrder(tempA, tempB = this.addDuration(date2, 2, this.fDuration[1]));
        if ((resultA = this.compareResults(resultA, resultB, strict)) == 2) {
            return 2;
        }
        tempA = this.addDuration(date1, 3, this.fDuration[0]);
        tempB = this.addDuration(date2, 3, this.fDuration[1]);
        resultB = this.compareOrder(tempA, tempB);
        resultA = this.compareResults(resultA, resultB, strict);
        return resultA;
    }

    private short compareResults(short resultA, short resultB, boolean strict) {
        if (resultB == 2) {
            return 2;
        }
        if (resultA != resultB && strict) {
            return 2;
        }
        if (resultA != resultB && !strict) {
            if (resultA != 0 && resultB != 0) {
                return 2;
            }
            return resultA != 0 ? resultA : resultB;
        }
        return resultA;
    }

    private int[] addDuration(int[] date, int index, int[] duration) {
        this.resetDateObj(duration);
        int temp = DATETIMES[index][1] + date[1];
        duration[1] = this.modulo(temp, 1, 13);
        int carry = this.fQuotient(temp, 1, 13);
        duration[0] = DATETIMES[index][0] + date[0] + carry;
        temp = DATETIMES[index][5] + date[5];
        carry = this.fQuotient(temp, 60);
        duration[5] = this.mod(temp, 60, carry);
        temp = DATETIMES[index][4] + date[4] + carry;
        carry = this.fQuotient(temp, 60);
        duration[4] = this.mod(temp, 60, carry);
        temp = DATETIMES[index][3] + date[3] + carry;
        carry = this.fQuotient(temp, 24);
        duration[3] = this.mod(temp, 24, carry);
        duration[2] = DATETIMES[index][2] + date[2] + carry;
        while (true) {
            temp = this.maxDayInMonthFor(duration[0], duration[1]);
            if (duration[2] < 1) {
                duration[2] = duration[2] + this.maxDayInMonthFor(duration[0], duration[1] - 1);
                carry = -1;
            } else {
                if (duration[2] <= temp) break;
                duration[2] = duration[2] - temp;
                carry = 1;
            }
            temp = duration[1] + carry;
            duration[1] = this.modulo(temp, 1, 13);
            duration[0] = duration[0] + this.fQuotient(temp, 1, 13);
        }
        duration[7] = 90;
        return duration;
    }

    protected String dateToString(int[] date) {
        this.message.setLength(0);
        int negate = 1;
        if (date[0] < 0) {
            this.message.append('-');
            negate = -1;
        }
        this.message.append('P');
        this.message.append(negate * date[0]);
        this.message.append('Y');
        this.message.append(negate * date[1]);
        this.message.append('M');
        this.message.append(negate * date[2]);
        this.message.append('D');
        this.message.append('T');
        this.message.append(negate * date[3]);
        this.message.append('H');
        this.message.append(negate * date[4]);
        this.message.append('M');
        this.message.append(negate * date[5]);
        this.message.append('.');
        this.message.append(negate * date[6]);
        this.message.append('S');
        return this.message.toString();
    }
}

