/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import org.apache.xerces.readers.DefaultEntityHandler;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StateMessageDatatype;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;

public class ENTITYDatatypeValidator
extends StringDatatypeValidator {
    public static final int ENTITY_VALIDATE = 0;

    public ENTITYDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public ENTITYDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        super(base, facets, derivedByList);
        if (derivedByList) {
            return;
        }
        this.setTokenType("ENTITY(NCName)");
    }

    public short getWSFacet() {
        return 2;
    }

    public Object validate(String content, Object state) throws InvalidDatatypeValueException {
        StringPool stringPool;
        int attValueHandle;
        Object[] params;
        DefaultEntityHandler entityHandler;
        super.validate(content, state);
        StateMessageDatatype message = (StateMessageDatatype)state;
        if (message != null && message.getDatatypeState() == 0 && !(entityHandler = (DefaultEntityHandler)(params = (Object[])message.getDatatypeObject())[0]).isUnparsedEntity(attValueHandle = (stringPool = (StringPool)params[1]).addSymbol(content))) {
            InvalidDatatypeValueException error = new InvalidDatatypeValueException("ENTITY '" + content + "' is not valid");
            error.setMinorCode(79);
            error.setMajorCode(62);
            throw error;
        }
        return null;
    }

    public int compare(String content1, String content2) {
        return content1.equals(content2) ? 0 : -1;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }
}

