/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.validators.datatype.AbstractNumericValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class FloatDatatypeValidator
extends AbstractNumericValidator {
    public FloatDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public FloatDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        super(base, facets, derivedByList);
    }

    public int compare(String value1, String value2) {
        try {
            float f1 = FloatDatatypeValidator.fValueOf(value1).floatValue();
            float f2 = FloatDatatypeValidator.fValueOf(value2).floatValue();
            return this.compareFloats(f1, f2);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected void assignAdditionalFacets(String key, Hashtable facets) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_FLOAT_FACET, 0, new Object[]{key}));
    }

    protected int compareValues(Object value1, Object value2) {
        float f1 = ((Float)value1).floatValue();
        float f2 = ((Float)value2).floatValue();
        return this.compareFloats(f1, f2);
    }

    protected void setMaxInclusive(String value) {
        this.fMaxInclusive = FloatDatatypeValidator.fValueOf(value);
    }

    protected void setMinInclusive(String value) {
        this.fMinInclusive = FloatDatatypeValidator.fValueOf(value);
    }

    protected void setMaxExclusive(String value) {
        this.fMaxExclusive = FloatDatatypeValidator.fValueOf(value);
    }

    protected void setMinExclusive(String value) {
        this.fMinExclusive = FloatDatatypeValidator.fValueOf(value);
    }

    protected void setEnumeration(Vector enumeration) throws InvalidDatatypeValueException {
        if (enumeration != null) {
            this.fEnumeration = new Float[enumeration.size()];
            Object[] baseEnum = null;
            int i = 0;
            while (i < enumeration.size()) {
                this.fEnumeration[i] = FloatDatatypeValidator.fValueOf((String)enumeration.elementAt(i));
                ((FloatDatatypeValidator)this.fBaseValidator).validate((String)enumeration.elementAt(i), null);
                ++i;
            }
        }
    }

    protected String getMaxInclusive(boolean isBase) {
        return isBase ? ((FloatDatatypeValidator)this.fBaseValidator).fMaxInclusive.toString() : ((Float)this.fMaxInclusive).toString();
    }

    protected String getMinInclusive(boolean isBase) {
        return isBase ? ((FloatDatatypeValidator)this.fBaseValidator).fMinInclusive.toString() : ((Float)this.fMinInclusive).toString();
    }

    protected String getMaxExclusive(boolean isBase) {
        return isBase ? ((FloatDatatypeValidator)this.fBaseValidator).fMaxExclusive.toString() : ((Float)this.fMaxExclusive).toString();
    }

    protected String getMinExclusive(boolean isBase) {
        return isBase ? ((FloatDatatypeValidator)this.fBaseValidator).fMinExclusive.toString() : ((Float)this.fMinExclusive).toString();
    }

    protected void checkContent(String content, Object state, Vector enumeration, boolean asBase) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            ((FloatDatatypeValidator)this.fBaseValidator).checkContent(content, state, enumeration, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(content))) {
            throw new InvalidDatatypeValueException("Value'" + content + "does not match regular expression facet" + this.fPattern);
        }
        if (asBase) {
            return;
        }
        Float f = null;
        try {
            f = FloatDatatypeValidator.fValueOf(content);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_FLOAT, 0, new Object[]{content}));
        }
        if (enumeration != null) {
            int size = enumeration.size();
            Float[] enumFloats = new Float[size];
            int i = 0;
            try {
                while (i < size) {
                    enumFloats[i] = FloatDatatypeValidator.fValueOf((String)enumeration.elementAt(i));
                    ++i;
                }
            }
            catch (NumberFormatException nfe) {
                throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.INVALID_ENUM_VALUE, 0, new Object[]{enumeration.elementAt(i)}));
            }
            this.enumCheck(f.floatValue(), enumFloats);
        }
        this.boundsCheck(f);
        if ((this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null) {
            this.enumCheck(f.floatValue(), (Float[])this.fEnumeration);
        }
    }

    protected int getInvalidFacetMsg() {
        return DatatypeMessageProvider.ILLEGAL_FLOAT_FACET;
    }

    private void enumCheck(float v, Float[] enumFloats) throws InvalidDatatypeValueException {
        int i = 0;
        while (i < enumFloats.length) {
            if (v == enumFloats[i].floatValue()) {
                return;
            }
            ++i;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_ENUM_VALUE, 0, new Object[]{new Float(v)}));
    }

    private static Float fValueOf(String s) throws NumberFormatException {
        Float f = null;
        try {
            f = Float.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            if (s.equals("INF")) {
                f = new Float(Float.POSITIVE_INFINITY);
            }
            if (s.equals("-INF")) {
                f = new Float(Float.NEGATIVE_INFINITY);
            }
            if (s.equals("NaN")) {
                f = new Float(Float.NaN);
            }
            throw nfe;
        }
        return f;
    }

    private int compareFloats(float f1, float f2) {
        int f1V = Float.floatToIntBits(f1);
        int f2V = Float.floatToIntBits(f2);
        if (f1 > f2) {
            return 1;
        }
        if (f1 < f2) {
            return -1;
        }
        if (f1V == f2V) {
            return 0;
        }
        return f1V < f2V ? -1 : 1;
    }
}

