/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.apache.xerces.utils.HexBin;
import org.apache.xerces.validators.datatype.AbstractStringValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class HexBinaryDatatypeValidator
extends AbstractStringValidator {
    public HexBinaryDatatypeValidator() throws InvalidDatatypeFacetException {
        super(null, null, false);
    }

    public HexBinaryDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        super(base, facets, derivedByList);
    }

    protected void assignAdditionalFacets(String key, Hashtable facets) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_STRING_FACET, 0, new Object[]{key}));
    }

    protected void checkValueSpace(String content) throws InvalidDatatypeValueException {
        if (this.getLength(content) < 0) {
            throw new InvalidDatatypeValueException("Value '" + content + "' is not encoded in Hex");
        }
    }

    protected int getLength(String content) {
        int x = 0;
        try {
            try {
                x = HexBin.getDecodedDataLength(content.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        catch (Throwable throwable) {}
        return x;
    }

    public Object clone() throws CloneNotSupportedException {
        HexBinaryDatatypeValidator newObj = null;
        try {
            newObj = new HexBinaryDatatypeValidator();
            newObj.fLocale = this.fLocale;
            newObj.fBaseValidator = this.fBaseValidator;
            newObj.fLength = this.fLength;
            newObj.fMaxLength = this.fMaxLength;
            newObj.fMinLength = this.fMinLength;
            newObj.fPattern = this.fPattern;
            newObj.fRegex = this.fRegex;
            newObj.fEnumeration = this.fEnumeration;
            newObj.fFacetsDefined = this.fFacetsDefined;
        }
        catch (InvalidDatatypeFacetException ex) {
            ex.printStackTrace();
        }
        return newObj;
    }

    public int compare(String value1, String value2) {
        if (value1 == null || value2 == null) {
            return -1;
        }
        if (value1 == value2 || value1.equals(value2)) {
            return 0;
        }
        byte[] data1 = HexBin.decode(value1.getBytes());
        byte[] data2 = HexBin.decode(value2.getBytes());
        if (data1 == null || data2 == null) {
            return -1;
        }
        int i = 0;
        while (i < Math.min(data1.length, data2.length)) {
            if (data1[i] < data2[i]) {
                return -1;
            }
            if (data1[i] > data2[i]) {
                return 1;
            }
            ++i;
        }
        if (data1.length == data2.length) {
            return 0;
        }
        return data1.length > data2.length ? 1 : -1;
    }
}

