/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;

public class IDDatatypeValidator
extends StringDatatypeValidator {
    private static Object fNullValue = new Object();

    public IDDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public IDDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        super(base, facets, derivedByList);
        if (derivedByList) {
            return;
        }
        if (base != null) {
            this.setTokenType(((IDDatatypeValidator)base).fTokenType);
        } else {
            this.setTokenType("ID(Name)");
        }
    }

    public short getWSFacet() {
        return 2;
    }

    public Object validate(String content, Object state) throws InvalidDatatypeValueException {
        super.validate(content, state);
        if (state != null && !this.addId(content, (Hashtable)state)) {
            InvalidDatatypeValueException error = new InvalidDatatypeValueException("ID '" + content + "'  has to be unique");
            error.setMinorCode(76);
            error.setMajorCode(76);
            throw error;
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    private boolean addId(String content, Hashtable IDList) {
        if (IDList.containsKey(content)) {
            return false;
        }
        try {
            IDList.put(content, fNullValue);
        }
        catch (OutOfMemoryError ex) {
            System.out.println("Out of Memory: Hashtable of ID's has " + IDList.size() + " Elements");
            ex.printStackTrace();
        }
        return true;
    }
}

