/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.StateMessageDatatype;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;

public class IDREFDatatypeValidator
extends StringDatatypeValidator {
    private static Object fNullValue = new Object();
    public static final int IDREF_VALIDATE = 0;
    public static final int IDREF_CHECKID = 1;

    public IDREFDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public IDREFDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        super(base, facets, derivedByList);
        if (derivedByList) {
            return;
        }
        if (base != null) {
            this.setTokenType(((IDREFDatatypeValidator)base).fTokenType);
        } else {
            this.setTokenType("IDREF(Name)");
        }
    }

    public short getWSFacet() {
        return 2;
    }

    public Object validate(String content, Object state) throws InvalidDatatypeValueException {
        StateMessageDatatype message = (StateMessageDatatype)state;
        if (message != null && message.getDatatypeState() == 1) {
            Object[] params = (Object[])message.getDatatypeObject();
            this.checkIdRefs((Hashtable)params[0], (Hashtable)params[1]);
        } else {
            super.validate(content, state);
            if (message != null && message.getDatatypeState() == 0) {
                this.addIdRef(content, (Hashtable)message.getDatatypeObject());
            }
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    private void addIdRef(String content, Hashtable IDREFList) {
        if (IDREFList.containsKey(content)) {
            return;
        }
        try {
            IDREFList.put(content, fNullValue);
        }
        catch (OutOfMemoryError ex) {
            System.out.println("Out of Memory: Hashtable of ID's has " + IDREFList.size() + " Elements");
            ex.printStackTrace();
        }
    }

    private void checkIdRefs(Hashtable IDList, Hashtable IDREFList) throws InvalidDatatypeValueException {
        Enumeration en = IDREFList.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (IDList.containsKey(key)) continue;
            InvalidDatatypeValueException error = new InvalidDatatypeValueException(key);
            error.setMinorCode(81);
            error.setMajorCode(2);
            throw error;
        }
    }
}

