/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.AbstractNumericValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class ListDatatypeValidator
extends AbstractDatatypeValidator {
    private int fLength = 0;
    private int fMaxLength = Integer.MAX_VALUE;
    private int fMinLength = 0;
    private Vector fEnumeration = null;

    public ListDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public ListDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        this.fBaseValidator = base;
        if (facets != null) {
            Enumeration e = facets.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.equals("length")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
                    String lengthValue = (String)facets.get(key);
                    try {
                        this.fLength = Integer.parseInt(lengthValue);
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidDatatypeFacetException("Length value '" + lengthValue + "' is invalid.");
                    }
                    if (this.fLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("Length value '" + lengthValue + "'  must be a nonNegativeInteger.");
                }
                if (key.equals("minLength")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
                    String minLengthValue = (String)facets.get(key);
                    try {
                        this.fMinLength = Integer.parseInt(minLengthValue);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + minLengthValue + "' is invalid.");
                    }
                }
                if (key.equals("maxLength")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
                    String maxLengthValue = (String)facets.get(key);
                    try {
                        this.fMaxLength = Integer.parseInt(maxLengthValue);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + maxLengthValue + "' is invalid.");
                    }
                }
                if (key.equals("enumeration")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    this.fEnumeration = (Vector)facets.get(key);
                    continue;
                }
                if (key.equals("pattern")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    this.fPattern = (String)facets.get(key);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_LIST_FACET, 0, new Object[]{key}));
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 4) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                }
            }
            if ((this.fFacetsDefined & 6) != 0 && this.fMinLength > this.fMaxLength) {
                throw new InvalidDatatypeFacetException("Value of minLength = " + this.fMinLength + "must be greater that the value of maxLength" + this.fMaxLength);
            }
            if (base != null && (this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null) {
                int i = 0;
                try {
                    while (i < this.fEnumeration.size()) {
                        base.validate((String)this.fEnumeration.elementAt(i), null);
                        ++i;
                    }
                }
                catch (Exception idve) {
                    throw new InvalidDatatypeFacetException("Value of enumeration = '" + this.fEnumeration.elementAt(i) + "' must be from the value space of base.");
                }
            }
        }
    }

    public Object validate(String content, Object state) throws InvalidDatatypeValueException {
        if (content == null && state != null) {
            this.fBaseValidator.validate(content, state);
        } else {
            this.checkContentEnum(content, state, null);
        }
        return null;
    }

    public Hashtable getFacets() {
        return null;
    }

    public int compare(String value1, String value2) {
        if (this.fBaseValidator instanceof ListDatatypeValidator) {
            return ((ListDatatypeValidator)this.fBaseValidator).compare(value1, value2);
        }
        StringTokenizer pList1 = new StringTokenizer(value1);
        StringTokenizer pList2 = new StringTokenizer(value2);
        int numberOfTokens = pList1.countTokens();
        if (numberOfTokens < pList2.countTokens()) {
            return -1;
        }
        if (numberOfTokens > pList2.countTokens()) {
            return 1;
        }
        int i = 0;
        while (i++ < numberOfTokens) {
            int returnValue;
            if (this.fBaseValidator == null || (returnValue = this.fBaseValidator.compare(pList1.nextToken(), pList2.nextToken())) == 0) continue;
            return returnValue;
        }
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        ListDatatypeValidator newObj = null;
        try {
            newObj = new ListDatatypeValidator();
            newObj.fLocale = this.fLocale;
            newObj.fBaseValidator = this.fBaseValidator;
            newObj.fLength = this.fLength;
            newObj.fMaxLength = this.fMaxLength;
            newObj.fMinLength = this.fMinLength;
            newObj.fPattern = this.fPattern;
            newObj.fEnumeration = this.fEnumeration;
            newObj.fFacetsDefined = this.fFacetsDefined;
        }
        catch (InvalidDatatypeFacetException ex) {
            ex.printStackTrace();
        }
        return newObj;
    }

    protected void checkContentEnum(String content, Object state, Vector enumeration) throws InvalidDatatypeValueException {
        StringTokenizer parsedList = new StringTokenizer(content);
        int numberOfTokens = parsedList.countTokens();
        if (this.fBaseValidator instanceof ListDatatypeValidator) {
            try {
                if ((this.fFacetsDefined & 4) != 0 && numberOfTokens > this.fMaxLength) {
                    throw new InvalidDatatypeValueException("Value '" + content + "' with length ='" + numberOfTokens + "' tokens" + "' exceeds maximum length facet of '" + this.fMaxLength + "' tokens.");
                }
                if ((this.fFacetsDefined & 2) != 0 && numberOfTokens < this.fMinLength) {
                    throw new InvalidDatatypeValueException("Value '" + content + "' with length ='" + numberOfTokens + "' tokens" + "' is less than minimum length facet of '" + this.fMinLength + "' tokens.");
                }
                if ((this.fFacetsDefined & 1) != 0 && numberOfTokens != this.fLength) {
                    throw new InvalidDatatypeValueException("Value '" + content + "' with length ='" + numberOfTokens + "' tokens" + "' is not equal to length facet of '" + this.fLength + "' tokens.");
                }
                if (enumeration != null) {
                    if (!this.verifyEnum(enumeration)) {
                        throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_ENUM_VALUE, 0, new Object[]{enumeration}));
                    }
                } else {
                    enumeration = this.fEnumeration != null ? this.fEnumeration : null;
                }
                ((ListDatatypeValidator)this.fBaseValidator).checkContentEnum(content, state, enumeration);
            }
            catch (NoSuchElementException e) {
                e.printStackTrace();
            }
        } else if (enumeration != null) {
            StringTokenizer eTokens = null;
            StringTokenizer cTokens = null;
            String token = null;
            String eToken = null;
            boolean valid = true;
            int eSize = enumeration.size();
            Vector<String> enumTemp = new Vector<String>();
            enumTemp.setSize(1);
            String currentEnumeration = null;
            int i = 0;
            while (i < eSize) {
                currentEnumeration = (String)enumeration.elementAt(i);
                eTokens = new StringTokenizer(currentEnumeration);
                valid = true;
                StringTokenizer stringTokenizer = cTokens = i == 0 ? parsedList : new StringTokenizer(content);
                if (numberOfTokens == eTokens.countTokens()) {
                    try {
                        if (currentEnumeration.equals(content)) {
                            int k = 0;
                            while (k < numberOfTokens) {
                                if (this.fBaseValidator != null) {
                                    this.fBaseValidator.validate(cTokens.nextToken(), state);
                                }
                                ++k;
                            }
                        } else {
                            int j = 0;
                            while (j < numberOfTokens) {
                                token = cTokens.nextToken();
                                eToken = eTokens.nextToken();
                                enumTemp.setElementAt(eToken, 0);
                                if (this.fBaseValidator instanceof AbstractNumericValidator) {
                                    ((AbstractNumericValidator)this.fBaseValidator).checkContentEnum(token, state, enumTemp);
                                } else {
                                    if (!token.equals(eToken)) {
                                        throw new InvalidDatatypeValueException("Value '" + content + "' must be one of " + enumeration);
                                    }
                                    this.fBaseValidator.validate(token, state);
                                }
                                ++j;
                            }
                        }
                    }
                    catch (InvalidDatatypeValueException e) {
                        valid = false;
                    }
                } else {
                    valid = false;
                }
                if (valid) break;
                ++i;
            }
            if (!valid) {
                throw new InvalidDatatypeValueException("Value '" + content + "' does not match list type");
            }
        } else {
            int k = 0;
            while (k < numberOfTokens) {
                if (this.fBaseValidator != null) {
                    this.fBaseValidator.validate(parsedList.nextToken(), state);
                }
                ++k;
            }
        }
    }

    private boolean verifyEnum(Vector vector) {
        if ((this.fFacetsDefined & 0x10) != 0) {
            Enumeration e = vector.elements();
            while (e.hasMoreElements()) {
                if (this.fEnumeration.contains(e.nextElement())) continue;
                return false;
            }
        }
        return true;
    }
}

