/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.text.Collator;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.validators.datatype.AbstractStringValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class QNameDatatypeValidator
extends AbstractStringValidator {
    private static DatatypeValidator fgStrValidator = null;

    public QNameDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public QNameDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        super(base, facets, derivedByList);
    }

    protected void assignAdditionalFacets(String key, Hashtable facets) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_STRING_FACET, 0, new Object[]{key}));
    }

    protected void checkValueSpace(String content) throws InvalidDatatypeValueException {
        try {
            int posColon = content.indexOf(58);
            if (posColon >= 0) {
                fgStrValidator.validate(content.substring(0, posColon), null);
            }
            fgStrValidator.validate(content.substring(posColon + 1), null);
        }
        catch (InvalidDatatypeValueException idve) {
            throw new InvalidDatatypeValueException("Value '" + content + "' is not a valid QName");
        }
    }

    public int compare(String content, String facetValue) {
        Locale loc = Locale.getDefault();
        Collator collator = Collator.getInstance(loc);
        return collator.compare(content, facetValue);
    }

    protected static void setNCNameValidator(DatatypeValidator dv) {
        if (fgStrValidator == null) {
            fgStrValidator = dv;
        }
    }
}

