/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.AbstractNumericValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.ListDatatypeValidator;

public class UnionDatatypeValidator
extends AbstractDatatypeValidator {
    private Vector fBaseValidators = null;
    private int fValidatorsSize = 0;
    private Vector fEnumeration = null;
    private StringBuffer errorMsg = null;

    public UnionDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public UnionDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedBy) throws InvalidDatatypeFacetException {
        this.fBaseValidator = base;
        if (facets != null) {
            Enumeration e = facets.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.equals("enumeration")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    this.fEnumeration = (Vector)facets.get(key);
                    continue;
                }
                if (key.equals("pattern")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    this.fPattern = (String)facets.get(key);
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_UNION_FACET, 0, new Object[]{key}));
            }
            if (base != null && (this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null) {
                int i = 0;
                try {
                    while (i < this.fEnumeration.size()) {
                        base.validate((String)this.fEnumeration.elementAt(i), null);
                        ++i;
                    }
                }
                catch (Exception idve) {
                    throw new InvalidDatatypeFacetException("Value of enumeration = '" + this.fEnumeration.elementAt(i) + "' must be from the value space of base.");
                }
            }
        }
    }

    public UnionDatatypeValidator(Vector base) {
        if (base != null) {
            this.fValidatorsSize = base.size();
            this.fBaseValidators = new Vector(this.fValidatorsSize);
            this.fBaseValidators = base;
        }
    }

    public Object validate(String content, Object state) throws InvalidDatatypeValueException {
        if (content == null && state != null) {
            this.fBaseValidator.validate(content, state);
        } else {
            this.checkContentEnum(content, state, false, null);
        }
        return null;
    }

    public Hashtable getFacets() {
        return null;
    }

    public int compare(String value1, String value2) {
        if (this.fBaseValidator != null) {
            return this.fBaseValidator.compare(value1, value2);
        }
        int index = -1;
        while (++index < this.fValidatorsSize) {
            DatatypeValidator currentDV = (DatatypeValidator)this.fBaseValidators.elementAt(index);
            if (currentDV.compare(value1, value2) != 0) continue;
            return 0;
        }
        return -1;
    }

    public Object clone() throws CloneNotSupportedException {
        UnionDatatypeValidator newObj = null;
        try {
            newObj = new UnionDatatypeValidator();
            newObj.fLocale = this.fLocale;
            newObj.fBaseValidator = this.fBaseValidator;
            newObj.fBaseValidators = (Vector)this.fBaseValidators.clone();
            newObj.fPattern = this.fPattern;
            newObj.fEnumeration = this.fEnumeration;
            newObj.fFacetsDefined = this.fFacetsDefined;
        }
        catch (InvalidDatatypeFacetException ex) {
            ex.printStackTrace();
        }
        return newObj;
    }

    public Vector getBaseValidators() {
        return this.fBaseValidators;
    }

    private boolean verifyEnum(Vector vector) {
        if ((this.fFacetsDefined & 0x10) != 0) {
            Enumeration e = vector.elements();
            while (e.hasMoreElements()) {
                if (this.fEnumeration.contains(e.nextElement())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void checkContentEnum(String content, Object state, boolean pattern, Vector enumeration) throws InvalidDatatypeValueException {
        index = -1;
        valid = false;
        currentDV = null;
        if (this.fBaseValidator == null) ** GOTO lbl42
        if ((this.fFacetsDefined & 8) != 0) {
            if (this.fRegex == null || !this.fRegex.matches(content)) {
                throw new InvalidDatatypeValueException("Value '" + content + "' does not match regular expression facet '" + this.fPattern + "'.");
            }
            pattern = true;
        }
        if (enumeration != null) {
            if (!this.verifyEnum(enumeration)) {
                throw new InvalidDatatypeValueException("Enumeration '" + enumeration + "' for value '" + content + "' is based on enumeration '" + this.fEnumeration + "'");
            }
        } else {
            enumeration = this.fEnumeration != null ? this.fEnumeration : null;
        }
        ((UnionDatatypeValidator)this.fBaseValidator).checkContentEnum(content, state, pattern, enumeration);
        return;
lbl-1000:
        // 1 sources

        {
            currentDV = (DatatypeValidator)this.fBaseValidators.elementAt(index);
            if (valid) break;
            try {
                if (currentDV instanceof ListDatatypeValidator) {
                    if (pattern) {
                        throw new InvalidDatatypeValueException("Facet \"Pattern\" can not be applied to a list datatype");
                    }
                    ((ListDatatypeValidator)currentDV).checkContentEnum(content, state, enumeration);
                } else if (currentDV instanceof UnionDatatypeValidator) {
                    ((UnionDatatypeValidator)currentDV).checkContentEnum(content, state, pattern, enumeration);
                } else if (enumeration != null) {
                    if (currentDV instanceof AbstractNumericValidator) {
                        ((AbstractNumericValidator)currentDV).checkContentEnum(content, state, enumeration);
                    } else {
                        if (!enumeration.contains(content)) {
                            throw new InvalidDatatypeValueException("Value '" + content + "' must be one of " + enumeration);
                        }
                        currentDV.validate(content, state);
                    }
                } else {
                    currentDV.validate(content, state);
                }
                valid = true;
                continue;
            }
            catch (InvalidDatatypeValueException var8_8) {
                // empty catch block
            }
lbl42:
            // 3 sources

            ** while (++index < this.fValidatorsSize)
        }
lbl43:
        // 2 sources

        if (!valid) {
            throw new InvalidDatatypeValueException("Content '" + content + "' does not match any union types");
        }
    }
}

