/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.dtd;

import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLDTDScanner;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class DTDGrammar
extends Grammar
implements XMLDTDScanner.EventHandler {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private StringPool fStringPool;
    private XMLElementDecl fElementDecl = new XMLElementDecl();
    private XMLAttributeDecl fAttributeDecl = new XMLAttributeDecl();
    private XMLContentSpec fContentSpec = new XMLContentSpec();
    private Document fGrammarDocument;
    private Element fRootElement;
    private QName fRootElementQName = new QName();
    private Element fCurrentElement;
    private int[][] fElementDeclIsExternal = new int[4][];
    private int[][] fElementDeclMap = new int[4][];
    private int[][] fAttributeDeclIsExternal = new int[4][];
    private int[][] fAttributeDeclMap = new int[4][];
    private int[][] fContentSpecMap = new int[4][];
    private QName fQName = new QName();
    private XMLContentSpec fTempContentSpec = new XMLContentSpec();

    public DTDGrammar(StringPool stringPool) {
        this.reset(stringPool);
    }

    public void reset(StringPool stringPool) {
        this.fStringPool = stringPool;
    }

    public void callStartDTD() throws Exception {
        this.setGrammarDocument(null);
        this.fGrammarDocument = new DocumentImpl();
        this.fCurrentElement = this.fRootElement = this.fGrammarDocument.createElement("dtd");
    }

    public void callEndDTD() throws Exception {
        this.setGrammarDocument(this.fGrammarDocument);
    }

    public void callTextDecl(int version, int encoding) throws Exception {
        Element textDecl = this.fGrammarDocument.createElement("textDecl");
        textDecl.setAttribute("version", this.fStringPool.toString(version));
        textDecl.setAttribute("encoding", this.fStringPool.toString(encoding));
        this.fCurrentElement.appendChild(textDecl);
    }

    public void doctypeDecl(QName rootElement, int publicId, int systemId) throws Exception {
        Element doctypeDecl = this.fGrammarDocument.createElement("doctypeDecl");
        doctypeDecl.setAttribute("name", this.fStringPool.toString(rootElement.rawname));
        if (rootElement.uri != 0) {
            doctypeDecl.setAttribute("xmlns:" + this.fStringPool.toString(rootElement.prefix), this.fStringPool.toString(rootElement.uri));
        }
        doctypeDecl.setAttribute("publicId", this.fStringPool.toString(publicId));
        doctypeDecl.setAttribute("systemId", this.fStringPool.toString(systemId));
        this.fCurrentElement.appendChild(doctypeDecl);
        this.fRootElementQName.setValues(rootElement);
    }

    public void startReadingFromExternalSubset(int publicId, int systemId) throws Exception {
        Element externalSubset = this.fGrammarDocument.createElement("external");
        externalSubset.setAttribute("publicId", this.fStringPool.toString(publicId));
        externalSubset.setAttribute("systemId", this.fStringPool.toString(systemId));
        this.fCurrentElement.appendChild(externalSubset);
        this.fCurrentElement = externalSubset;
    }

    public void stopReadingFromExternalSubset() throws Exception {
        this.fCurrentElement = (Element)this.fCurrentElement.getParentNode();
    }

    public int addElementDecl(QName elementDecl) throws Exception {
        Element elementDeclElement = this.fGrammarDocument.createElement("elementDecl");
        elementDeclElement.setAttribute("name", this.fStringPool.toString(elementDecl.localpart));
        if (elementDecl.uri != 0) {
            elementDeclElement.setAttribute("xmlns:" + this.fStringPool.toString(elementDecl.prefix), this.fStringPool.toString(elementDecl.uri));
        }
        this.fCurrentElement.appendChild(elementDeclElement);
        int elementDeclIndex = this.createElementDecl();
        this.fElementDecl.clear();
        this.fElementDecl.name.setValues(elementDecl);
        this.setElementDecl(elementDeclIndex, this.fElementDecl);
        return elementDeclIndex;
    }

    public int addElementDecl(QName elementDecl, int contentSpecType, int contentSpec, boolean isExternal) throws Exception {
        Element elementDeclElement = this.fGrammarDocument.createElement("elementDecl");
        elementDeclElement.setAttribute("name", this.fStringPool.toString(elementDecl.localpart));
        if (elementDecl.uri != 0) {
            elementDeclElement.setAttribute("xmlns:" + this.fStringPool.toString(elementDecl.prefix), this.fStringPool.toString(elementDecl.uri));
        }
        elementDeclElement.setAttribute("type", this.fStringPool.toString(contentSpecType));
        this.fCurrentElement.appendChild(elementDeclElement);
        int elementDeclIndex = this.createElementDecl();
        this.fElementDecl.clear();
        this.fElementDecl.name.setValues(elementDecl);
        this.fElementDecl.type = contentSpecType;
        this.fElementDecl.contentSpecIndex = contentSpec;
        this.setElementDecl(elementDeclIndex, this.fElementDecl);
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        this.fElementDeclIsExternal[chunk][index] = isExternal ? 1 : 0;
        return elementDeclIndex;
    }

    protected void putElementNameMapping(QName name, int scope, int elementDeclIndex) {
        this.fQName.uri = 0;
        this.fQName.localpart = name.rawname;
        super.putElementNameMapping(this.fQName, scope, elementDeclIndex);
    }

    public int getElementDeclIndex(QName element, int scopeIndex) {
        return super.getElementDeclIndex(element.rawname, -1);
    }

    public void setElementDeclDTD(int elementDeclIndex, XMLElementDecl elementDecl) {
        super.setElementDecl(elementDeclIndex, elementDecl);
    }

    public void setElementDeclIsExternal(int elementDeclIndex, boolean isExternal) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        this.fElementDeclIsExternal[chunk][index] = isExternal ? 1 : 0;
    }

    public boolean getElementDeclIsExternal(int elementDeclIndex) {
        if (elementDeclIndex < 0) {
            return false;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fElementDeclIsExternal[chunk][index] != 0;
    }

    public boolean getAttributeDeclIsExternal(int attributeDeclIndex) {
        if (attributeDeclIndex < 0) {
            return false;
        }
        int chunk = attributeDeclIndex >> 8;
        int index = attributeDeclIndex & 0xFF;
        return this.fAttributeDeclIsExternal[chunk][index] != 0;
    }

    public boolean getRootElementQName(QName root) {
        if (this.fRootElementQName.rawname == -1) {
            return false;
        }
        root.setValues(this.fRootElementQName);
        return true;
    }

    public int addAttDef(QName elementDecl, QName attributeDecl, int attType, boolean attList, int enumeration, int attDefaultType, int attDefaultValue, boolean isExternal) throws Exception {
        Element attributeDeclElement = this.fGrammarDocument.createElement("attributeDecl");
        attributeDeclElement.setAttribute("element", this.fStringPool.toString(elementDecl.localpart));
        attributeDeclElement.setAttribute("name", this.fStringPool.toString(attributeDecl.localpart));
        if (attributeDecl.uri != 0) {
            attributeDeclElement.setAttribute("xmlns:" + this.fStringPool.toString(attributeDecl.prefix), this.fStringPool.toString(attributeDecl.uri));
        }
        attributeDeclElement.setAttribute("type", this.fStringPool.toString(attType));
        attributeDeclElement.setAttribute("defaultType", this.fStringPool.toString(attDefaultType));
        attributeDeclElement.setAttribute("defaultValue", this.fStringPool.toString(attDefaultValue));
        this.fCurrentElement.appendChild(attributeDeclElement);
        int attributeDeclIndex = this.createAttributeDecl();
        String attTypeString = "";
        switch (attType) {
            case 0: {
                attTypeString = "string";
            }
            case 1: {
                attTypeString = "ENTITY";
            }
            case 2: {
                attTypeString = "ENUMERATION";
            }
            case 3: {
                attTypeString = "ID";
            }
            case 4: {
                attTypeString = "IDREF";
            }
            case 5: {
                attTypeString = "NMTOKEN";
            }
            case 6: {
                attTypeString = "NOTATION";
            }
        }
        this.fAttributeDecl.clear();
        this.fAttributeDecl.name.setValues(attributeDecl);
        this.fAttributeDecl.type = attType;
        this.fAttributeDecl.list = attList;
        this.fAttributeDecl.enumeration = enumeration;
        this.fAttributeDecl.defaultType = attDefaultType;
        this.fAttributeDecl.defaultValue = this.fStringPool.toString(attDefaultValue);
        int elementDeclIndex = this.getElementDeclIndex(elementDecl, -1);
        this.setAttributeDecl(elementDeclIndex, attributeDeclIndex, this.fAttributeDecl);
        int chunk = attributeDeclIndex >> 8;
        int index = attributeDeclIndex & 0xFF;
        this.ensureAttributeDeclCapacity(chunk);
        this.fAttributeDeclIsExternal[chunk][index] = isExternal ? 1 : 0;
        return attributeDeclIndex;
    }

    public int addUniqueLeafNode(int nameIndex) throws Exception {
        int contentSpecIndex = this.createContentSpec();
        this.fContentSpec.setValues(0, nameIndex, -1);
        this.setContentSpec(contentSpecIndex, this.fContentSpec);
        return contentSpecIndex;
    }

    public int addContentSpecNode(int nodeType, int nodeValue) throws Exception {
        int contentSpecIndex = this.createContentSpec();
        this.fContentSpec.setValues(nodeType, nodeValue, -1);
        this.setContentSpec(contentSpecIndex, this.fContentSpec);
        return contentSpecIndex;
    }

    public int addContentSpecNode(int nodeType, int leftNodeIndex, int rightNodeIndex) throws Exception {
        int contentSpecIndex = this.createContentSpec();
        this.fContentSpec.setValues(nodeType, leftNodeIndex, rightNodeIndex);
        this.setContentSpec(contentSpecIndex, this.fContentSpec);
        return contentSpecIndex;
    }

    public String getContentSpecNodeAsString(int nodeIndex) throws Exception {
        return XMLContentSpec.toString(this, this.fStringPool, nodeIndex);
    }

    public boolean startEntityDecl(boolean isPE, int entityName) throws Exception {
        Element entityDecl = this.fGrammarDocument.createElement("entityDecl");
        entityDecl.setAttribute("name", this.fStringPool.toString(entityName));
        entityDecl.setAttribute("parameter", isPE ? "true" : "false");
        this.fCurrentElement.appendChild(entityDecl);
        this.fCurrentElement = entityDecl;
        return true;
    }

    public void endEntityDecl() throws Exception {
        this.fCurrentElement = (Element)this.fCurrentElement.getParentNode();
    }

    public int addInternalPEDecl(int name, int value) throws Exception {
        Element internalPEDecl = this.fGrammarDocument.createElement("internalPEDecl");
        internalPEDecl.setAttribute("name", this.fStringPool.toString(name));
        internalPEDecl.setAttribute("value", this.fStringPool.toString(value));
        this.fCurrentElement.appendChild(internalPEDecl);
        int peDeclIndex = -1;
        return peDeclIndex;
    }

    public int addExternalPEDecl(int name, int publicId, int systemId) throws Exception {
        Element externalPEDecl = this.fGrammarDocument.createElement("externalPEDecl");
        externalPEDecl.setAttribute("name", this.fStringPool.toString(name));
        externalPEDecl.setAttribute("publicId", this.fStringPool.toString(publicId));
        externalPEDecl.setAttribute("systemId", this.fStringPool.toString(systemId));
        this.fCurrentElement.appendChild(externalPEDecl);
        int peDeclIndex = -1;
        return peDeclIndex;
    }

    public int addInternalEntityDecl(int name, int value) throws Exception {
        Element internalEntityDecl = this.fGrammarDocument.createElement("internalEntityDecl");
        internalEntityDecl.setAttribute("name", this.fStringPool.toString(name));
        internalEntityDecl.setAttribute("value", this.fStringPool.toString(value));
        this.fCurrentElement.appendChild(internalEntityDecl);
        int internalEntityDeclIndex = -1;
        return internalEntityDeclIndex;
    }

    public int addExternalEntityDecl(int name, int publicId, int systemId) throws Exception {
        Element externalEntityDecl = this.fGrammarDocument.createElement("externalEntityDecl");
        externalEntityDecl.setAttribute("name", this.fStringPool.toString(name));
        externalEntityDecl.setAttribute("publicId", this.fStringPool.toString(publicId));
        externalEntityDecl.setAttribute("systemId", this.fStringPool.toString(systemId));
        this.fCurrentElement.appendChild(externalEntityDecl);
        int externalEntityDeclIndex = -1;
        return externalEntityDeclIndex;
    }

    public int addUnparsedEntityDecl(int name, int publicId, int systemId, int notationName) throws Exception {
        Element unparsedEntityDecl = this.fGrammarDocument.createElement("unparsedEntityDecl");
        unparsedEntityDecl.setAttribute("name", this.fStringPool.toString(name));
        unparsedEntityDecl.setAttribute("publicId", this.fStringPool.toString(publicId));
        unparsedEntityDecl.setAttribute("systemId", this.fStringPool.toString(systemId));
        unparsedEntityDecl.setAttribute("notation", this.fStringPool.toString(notationName));
        this.fCurrentElement.appendChild(unparsedEntityDecl);
        int unparsedEntityDeclIndex = -1;
        return unparsedEntityDeclIndex;
    }

    public int startEnumeration() throws Exception {
        Element enumeration = this.fGrammarDocument.createElement("enumeration");
        this.fCurrentElement.appendChild(enumeration);
        this.fCurrentElement = enumeration;
        int enumIndex = this.fStringPool.startStringList();
        return enumIndex;
    }

    public void addNameToEnumeration(int enumIndex, int elementType, int attrName, int nameIndex, boolean isNotationType) throws Exception {
        Element literal = this.fGrammarDocument.createElement("literal");
        literal.setAttribute("element", this.fStringPool.toString(elementType));
        literal.setAttribute("attribute", this.fStringPool.toString(attrName));
        literal.setAttribute("name", this.fStringPool.toString(nameIndex));
        literal.setAttribute("notation", isNotationType ? "true" : "false");
        this.fCurrentElement.appendChild(literal);
        this.fStringPool.addStringToList(enumIndex, nameIndex);
    }

    public void endEnumeration(int enumIndex) throws Exception {
        this.fCurrentElement = (Element)this.fCurrentElement.getParentNode();
        this.fStringPool.finishStringList(enumIndex);
    }

    public int addNotationDecl(int notationName, int publicId, int systemId) throws Exception {
        Element notationDecl = this.fGrammarDocument.createElement("notationDecl");
        notationDecl.setAttribute("name", this.fStringPool.toString(notationName));
        notationDecl.setAttribute("publicId", this.fStringPool.toString(publicId));
        notationDecl.setAttribute("systemId", this.fStringPool.toString(systemId));
        this.fCurrentElement.appendChild(notationDecl);
        int notationDeclIndex = -1;
        return notationDeclIndex;
    }

    public void callComment(int data) throws Exception {
    }

    public void callProcessingInstruction(int piTarget, int piData) throws Exception {
        ProcessingInstruction pi = this.fGrammarDocument.createProcessingInstruction(this.fStringPool.toString(piTarget), this.fStringPool.toString(piData));
        this.fCurrentElement.appendChild(pi);
    }

    public void internalSubset(int internalSubset) throws Exception {
    }

    protected boolean isDTD() {
        return true;
    }

    private void ensureElementDeclCapacity(int chunk) {
        if (chunk >= this.fElementDeclMap.length) {
            this.fElementDeclMap = this.resize(this.fElementDeclMap, this.fElementDeclMap.length * 2);
            this.fElementDeclIsExternal = this.resize(this.fElementDeclIsExternal, this.fElementDeclIsExternal.length * 2);
        } else if (this.fElementDeclMap[chunk] != null) {
            return;
        }
        this.fElementDeclMap[chunk] = new int[256];
        this.fElementDeclIsExternal[chunk] = new int[256];
    }

    private void ensureAttributeDeclCapacity(int chunk) {
        if (chunk >= this.fAttributeDeclMap.length) {
            this.fAttributeDeclMap = this.resize(this.fAttributeDeclMap, this.fAttributeDeclMap.length * 2);
            this.fAttributeDeclIsExternal = this.resize(this.fAttributeDeclIsExternal, this.fAttributeDeclIsExternal.length * 2);
        } else if (this.fAttributeDeclMap[chunk] != null) {
            return;
        }
        this.fAttributeDeclMap[chunk] = new int[256];
        this.fAttributeDeclIsExternal[chunk] = new int[256];
    }

    private void ensureContentSpecCapacity(int chunk) {
        if (chunk >= this.fContentSpecMap.length) {
            this.fContentSpecMap = this.resize(this.fContentSpecMap, this.fContentSpecMap.length * 2);
        } else if (this.fContentSpecMap[chunk] != null) {
            return;
        }
        this.fContentSpecMap[chunk] = new int[256];
    }

    private int[][] resize(int[][] array, int newsize) {
        int[][] newarray = new int[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }
}

