/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.datatype.IDDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.schema.OneAttr;
import org.apache.xerces.validators.schema.OneElement;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SchemaMessageProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class GeneralAttrCheck {
    public static int ELE_CONTEXT_GLOBAL = 0;
    public static int ELE_CONTEXT_LOCAL = 1;
    public static int ATT_REQUIRED = 0;
    public static int ATT_OPT_DFLT = 1;
    public static int ATT_OPT_NODFLT = 2;
    protected static String PRE_GLOBAL = "G_";
    protected static String PRE_LOC_NAME = "LN_";
    protected static String PRE_LOC_REF = "LR_";
    protected static Hashtable fEleAttrsMap = new Hashtable();
    protected static DatatypeValidator[] fExtraDVs = null;
    protected static int dtCount = 0;
    protected static final int DT_ANYURI = dtCount++;
    protected static final int DT_BOOLEAN = dtCount++;
    protected static final int DT_ID = dtCount++;
    protected static final int DT_NONNEGINT = dtCount++;
    protected static final int DT_QNAME = dtCount++;
    protected static final int DT_STRING = dtCount++;
    protected static final int DT_TOKEN = dtCount++;
    protected static final int DT_NCNAME = dtCount++;
    protected static final int DT_XPATH = dtCount++;
    protected static final int DT_XPATH1 = dtCount++;
    protected static final int DT_BLOCK = -1;
    protected static final int DT_BLOCK1 = -2;
    protected static final int DT_FINAL = -3;
    protected static final int DT_FINAL1 = -4;
    protected static final int DT_FORM = -5;
    protected static final int DT_MAXOCCURS = -6;
    protected static final int DT_MAXOCCURS1 = -7;
    protected static final int DT_MEMBERTYPES = -8;
    protected static final int DT_MINOCCURS1 = -9;
    protected static final int DT_NAMESPACE = -10;
    protected static final int DT_PROCESSCONTENTS = -11;
    protected static final int DT_PUBLIC = -12;
    protected static final int DT_USE = -13;
    protected static final int DT_WHITESPACE = -14;
    private Hashtable fIdDefs = new Hashtable();
    protected XMLErrorReporter fErrorReporter = null;
    protected Hashtable fProcessedElements = new Hashtable();
    protected Hashtable fNonSchemaAttrs = new Hashtable();

    static {
        fExtraDVs = new DatatypeValidator[dtCount];
        int attCount = 0;
        int ATT_ABSTRACT_D = attCount++;
        int ATT_ATTRIBUTE_FD_D = attCount++;
        int ATT_BASE_R = attCount++;
        int ATT_BASE_N = attCount++;
        int ATT_BLOCK_N = attCount++;
        int ATT_BLOCK1_N = attCount++;
        int ATT_BLOCK_D_D = attCount++;
        int ATT_DEFAULT_N = attCount++;
        int ATT_ELEMENT_FD_D = attCount++;
        int ATT_FINAL_N = attCount++;
        int ATT_FINAL1_N = attCount++;
        int ATT_FINAL_D_D = attCount++;
        int ATT_FIXED_N = attCount++;
        int ATT_FIXED_D = attCount++;
        int ATT_FORM_N = attCount++;
        int ATT_ID_N = attCount++;
        int ATT_ITEMTYPE_N = attCount++;
        int ATT_MAXOCCURS_D = attCount++;
        int ATT_MAXOCCURS1_D = attCount++;
        int ATT_MEMBER_T_N = attCount++;
        int ATT_MINOCCURS_D = attCount++;
        int ATT_MINOCCURS1_D = attCount++;
        int ATT_MIXED_D = attCount++;
        int ATT_MIXED_N = attCount++;
        int ATT_NAME_R = attCount++;
        int ATT_NAMESPACE_D = attCount++;
        int ATT_NAMESPACE_N = attCount++;
        int ATT_NILLABLE_D = attCount++;
        int ATT_PROCESS_C_D = attCount++;
        int ATT_PUBLIC_R = attCount++;
        int ATT_REF_R = attCount++;
        int ATT_REFER_R = attCount++;
        int ATT_SCHEMA_L_R = attCount++;
        int ATT_SCHEMA_L_N = attCount++;
        int ATT_SOURCE_N = attCount++;
        int ATT_SUBSTITUTION_G_N = attCount++;
        int ATT_SYSTEM_N = attCount++;
        int ATT_TARGET_N_N = attCount++;
        int ATT_TYPE_N = attCount++;
        int ATT_USE_D = attCount++;
        int ATT_VALUE_NNI_N = attCount++;
        int ATT_VALUE_STR_N = attCount++;
        int ATT_VALUE_WS_N = attCount++;
        int ATT_VERSION_N = attCount++;
        int ATT_XPATH_R = attCount++;
        int ATT_XPATH1_R = attCount++;
        OneAttr[] allAttrs = new OneAttr[attCount];
        allAttrs[ATT_ABSTRACT_D] = new OneAttr("abstract", DT_BOOLEAN, ATT_OPT_DFLT, "false");
        allAttrs[ATT_ATTRIBUTE_FD_D] = new OneAttr("attributeFormDefault", -5, ATT_OPT_DFLT, "unqualified");
        allAttrs[ATT_BASE_R] = new OneAttr("base", DT_QNAME, ATT_REQUIRED, null);
        allAttrs[ATT_BASE_N] = new OneAttr("base", DT_QNAME, ATT_OPT_NODFLT, null);
        allAttrs[ATT_BLOCK_N] = new OneAttr("block", -1, ATT_OPT_NODFLT, null);
        allAttrs[ATT_BLOCK1_N] = new OneAttr("block", -2, ATT_OPT_NODFLT, null);
        allAttrs[ATT_BLOCK_D_D] = new OneAttr("blockDefault", -1, ATT_OPT_DFLT, "");
        allAttrs[ATT_DEFAULT_N] = new OneAttr("default", DT_STRING, ATT_OPT_NODFLT, null);
        allAttrs[ATT_ELEMENT_FD_D] = new OneAttr("elementFormDefault", -5, ATT_OPT_DFLT, "unqualified");
        allAttrs[ATT_FINAL_N] = new OneAttr("final", -3, ATT_OPT_NODFLT, null);
        allAttrs[ATT_FINAL1_N] = new OneAttr("final", -4, ATT_OPT_NODFLT, null);
        allAttrs[ATT_FINAL_D_D] = new OneAttr("finalDefault", -3, ATT_OPT_DFLT, "");
        allAttrs[ATT_FIXED_N] = new OneAttr("fixed", DT_STRING, ATT_OPT_NODFLT, null);
        allAttrs[ATT_FIXED_D] = new OneAttr("fixed", DT_BOOLEAN, ATT_OPT_DFLT, "false");
        allAttrs[ATT_FORM_N] = new OneAttr("form", -5, ATT_OPT_NODFLT, null);
        allAttrs[ATT_ID_N] = new OneAttr("id", DT_ID, ATT_OPT_NODFLT, null);
        allAttrs[ATT_ITEMTYPE_N] = new OneAttr("itemType", DT_QNAME, ATT_OPT_NODFLT, null);
        allAttrs[ATT_MAXOCCURS_D] = new OneAttr("maxOccurs", -6, ATT_OPT_DFLT, "1");
        allAttrs[ATT_MAXOCCURS1_D] = new OneAttr("maxOccurs", -7, ATT_OPT_DFLT, "1");
        allAttrs[ATT_MEMBER_T_N] = new OneAttr("memberTypes", -8, ATT_OPT_NODFLT, null);
        allAttrs[ATT_MINOCCURS_D] = new OneAttr("minOccurs", DT_NONNEGINT, ATT_OPT_DFLT, "1");
        allAttrs[ATT_MINOCCURS1_D] = new OneAttr("minOccurs", -9, ATT_OPT_DFLT, "1");
        allAttrs[ATT_MIXED_D] = new OneAttr("mixed", DT_BOOLEAN, ATT_OPT_DFLT, "false");
        allAttrs[ATT_MIXED_N] = new OneAttr("mixed", DT_BOOLEAN, ATT_OPT_NODFLT, null);
        allAttrs[ATT_NAME_R] = new OneAttr("name", DT_NCNAME, ATT_REQUIRED, null);
        allAttrs[ATT_NAMESPACE_D] = new OneAttr("namespace", -10, ATT_OPT_DFLT, "##any");
        allAttrs[ATT_NAMESPACE_N] = new OneAttr("namespace", DT_ANYURI, ATT_OPT_NODFLT, null);
        allAttrs[ATT_NILLABLE_D] = new OneAttr("nillable", DT_BOOLEAN, ATT_OPT_DFLT, "false");
        allAttrs[ATT_PROCESS_C_D] = new OneAttr("processContents", -11, ATT_OPT_DFLT, "strict");
        allAttrs[ATT_PUBLIC_R] = new OneAttr("public", -12, ATT_REQUIRED, null);
        allAttrs[ATT_REF_R] = new OneAttr("ref", DT_QNAME, ATT_REQUIRED, null);
        allAttrs[ATT_REFER_R] = new OneAttr("refer", DT_QNAME, ATT_REQUIRED, null);
        allAttrs[ATT_SCHEMA_L_R] = new OneAttr("schemaLocation", DT_ANYURI, ATT_REQUIRED, null);
        allAttrs[ATT_SCHEMA_L_N] = new OneAttr("schemaLocation", DT_ANYURI, ATT_OPT_NODFLT, null);
        allAttrs[ATT_SOURCE_N] = new OneAttr("source", DT_ANYURI, ATT_OPT_NODFLT, null);
        allAttrs[ATT_SUBSTITUTION_G_N] = new OneAttr("substitutionGroup", DT_QNAME, ATT_OPT_NODFLT, null);
        allAttrs[ATT_SYSTEM_N] = new OneAttr("system", DT_ANYURI, ATT_OPT_NODFLT, null);
        allAttrs[ATT_TARGET_N_N] = new OneAttr("targetNamespace", DT_ANYURI, ATT_OPT_NODFLT, null);
        allAttrs[ATT_TYPE_N] = new OneAttr("type", DT_QNAME, ATT_OPT_NODFLT, null);
        allAttrs[ATT_USE_D] = new OneAttr("use", -13, ATT_OPT_DFLT, "optional");
        allAttrs[ATT_VALUE_NNI_N] = new OneAttr("value", DT_NONNEGINT, ATT_OPT_NODFLT, null);
        allAttrs[ATT_VALUE_STR_N] = new OneAttr("value", DT_STRING, ATT_OPT_NODFLT, null);
        allAttrs[ATT_VALUE_WS_N] = new OneAttr("value", -14, ATT_OPT_NODFLT, null);
        allAttrs[ATT_VERSION_N] = new OneAttr("version", DT_TOKEN, ATT_OPT_NODFLT, null);
        allAttrs[ATT_XPATH_R] = new OneAttr("xpath", DT_XPATH, ATT_REQUIRED, null);
        allAttrs[ATT_XPATH1_R] = new OneAttr("xpath", DT_XPATH1, ATT_REQUIRED, null);
        Hashtable<String, OneAttr> attrList = new Hashtable<String, OneAttr>();
        attrList.put("default", allAttrs[ATT_DEFAULT_N]);
        attrList.put("fixed", allAttrs[ATT_FIXED_N]);
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("name", allAttrs[ATT_NAME_R]);
        attrList.put("type", allAttrs[ATT_TYPE_N]);
        OneElement oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_GLOBAL) + "attribute", oneEle);
        attrList = new Hashtable();
        attrList.put("default", allAttrs[ATT_DEFAULT_N]);
        attrList.put("fixed", allAttrs[ATT_FIXED_N]);
        attrList.put("form", allAttrs[ATT_FORM_N]);
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("name", allAttrs[ATT_NAME_R]);
        attrList.put("type", allAttrs[ATT_TYPE_N]);
        attrList.put("use", allAttrs[ATT_USE_D]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "attribute", oneEle);
        attrList = new Hashtable();
        attrList.put("default", allAttrs[ATT_DEFAULT_N]);
        attrList.put("fixed", allAttrs[ATT_FIXED_N]);
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("ref", allAttrs[ATT_REF_R]);
        attrList.put("use", allAttrs[ATT_USE_D]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_REF) + "attribute", oneEle);
        attrList = new Hashtable();
        attrList.put("abstract", allAttrs[ATT_ABSTRACT_D]);
        attrList.put("block", allAttrs[ATT_BLOCK_N]);
        attrList.put("default", allAttrs[ATT_DEFAULT_N]);
        attrList.put("final", allAttrs[ATT_FINAL_N]);
        attrList.put("fixed", allAttrs[ATT_FIXED_N]);
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("name", allAttrs[ATT_NAME_R]);
        attrList.put("nillable", allAttrs[ATT_NILLABLE_D]);
        attrList.put("substitutionGroup", allAttrs[ATT_SUBSTITUTION_G_N]);
        attrList.put("type", allAttrs[ATT_TYPE_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_GLOBAL) + "element", oneEle);
        attrList = new Hashtable();
        attrList.put("block", allAttrs[ATT_BLOCK_N]);
        attrList.put("default", allAttrs[ATT_DEFAULT_N]);
        attrList.put("fixed", allAttrs[ATT_FIXED_N]);
        attrList.put("form", allAttrs[ATT_FORM_N]);
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("maxOccurs", allAttrs[ATT_MAXOCCURS_D]);
        attrList.put("minOccurs", allAttrs[ATT_MINOCCURS_D]);
        attrList.put("name", allAttrs[ATT_NAME_R]);
        attrList.put("nillable", allAttrs[ATT_NILLABLE_D]);
        attrList.put("type", allAttrs[ATT_TYPE_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "element", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("maxOccurs", allAttrs[ATT_MAXOCCURS_D]);
        attrList.put("minOccurs", allAttrs[ATT_MINOCCURS_D]);
        attrList.put("ref", allAttrs[ATT_REF_R]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_REF) + "element", oneEle);
        attrList = new Hashtable();
        attrList.put("abstract", allAttrs[ATT_ABSTRACT_D]);
        attrList.put("block", allAttrs[ATT_BLOCK1_N]);
        attrList.put("final", allAttrs[ATT_FINAL_N]);
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("mixed", allAttrs[ATT_MIXED_D]);
        attrList.put("name", allAttrs[ATT_NAME_R]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_GLOBAL) + "complexType", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("mixed", allAttrs[ATT_MIXED_D]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "complexType", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "simpleContent", oneEle);
        attrList = new Hashtable();
        attrList.put("base", allAttrs[ATT_BASE_N]);
        attrList.put("id", allAttrs[ATT_ID_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "restriction", oneEle);
        attrList = new Hashtable();
        attrList.put("base", allAttrs[ATT_BASE_R]);
        attrList.put("id", allAttrs[ATT_ID_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "extension", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("ref", allAttrs[ATT_REF_R]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_REF) + "attributeGroup", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("namespace", allAttrs[ATT_NAMESPACE_D]);
        attrList.put("processContents", allAttrs[ATT_PROCESS_C_D]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "anyAttribute", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("mixed", allAttrs[ATT_MIXED_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "complexContent", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("name", allAttrs[ATT_NAME_R]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_GLOBAL) + "attributeGroup", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("name", allAttrs[ATT_NAME_R]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_GLOBAL) + "group", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("maxOccurs", allAttrs[ATT_MAXOCCURS_D]);
        attrList.put("minOccurs", allAttrs[ATT_MINOCCURS_D]);
        attrList.put("ref", allAttrs[ATT_REF_R]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_REF) + "group", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("maxOccurs", allAttrs[ATT_MAXOCCURS1_D]);
        attrList.put("minOccurs", allAttrs[ATT_MINOCCURS1_D]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "all", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("maxOccurs", allAttrs[ATT_MAXOCCURS_D]);
        attrList.put("minOccurs", allAttrs[ATT_MINOCCURS_D]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "choice", oneEle);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "sequence", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("maxOccurs", allAttrs[ATT_MAXOCCURS_D]);
        attrList.put("minOccurs", allAttrs[ATT_MINOCCURS_D]);
        attrList.put("namespace", allAttrs[ATT_NAMESPACE_D]);
        attrList.put("processContents", allAttrs[ATT_PROCESS_C_D]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "any", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("name", allAttrs[ATT_NAME_R]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "unique", oneEle);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "key", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("name", allAttrs[ATT_NAME_R]);
        attrList.put("refer", allAttrs[ATT_REFER_R]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "keyref", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("xpath", allAttrs[ATT_XPATH_R]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "selector", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("xpath", allAttrs[ATT_XPATH1_R]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "field", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("name", allAttrs[ATT_NAME_R]);
        attrList.put("public", allAttrs[ATT_PUBLIC_R]);
        attrList.put("system", allAttrs[ATT_SYSTEM_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "notation", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_GLOBAL) + "annotation", oneEle);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "annotation", oneEle);
        attrList = new Hashtable();
        attrList.put("source", allAttrs[ATT_SOURCE_N]);
        oneEle = new OneElement(attrList, false);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "appinfo", oneEle);
        attrList = new Hashtable();
        attrList.put("source", allAttrs[ATT_SOURCE_N]);
        oneEle = new OneElement(attrList, false);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "documentation", oneEle);
        attrList = new Hashtable();
        attrList.put("final", allAttrs[ATT_FINAL1_N]);
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("name", allAttrs[ATT_NAME_R]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_GLOBAL) + "simpleType", oneEle);
        attrList = new Hashtable();
        attrList.put("final", allAttrs[ATT_FINAL1_N]);
        attrList.put("id", allAttrs[ATT_ID_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "simpleType", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("itemType", allAttrs[ATT_ITEMTYPE_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "list", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("memberTypes", allAttrs[ATT_MEMBER_T_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "union", oneEle);
        attrList = new Hashtable();
        attrList.put("attributeFormDefault", allAttrs[ATT_ATTRIBUTE_FD_D]);
        attrList.put("blockDefault", allAttrs[ATT_BLOCK_D_D]);
        attrList.put("elementFormDefault", allAttrs[ATT_ELEMENT_FD_D]);
        attrList.put("finalDefault", allAttrs[ATT_FINAL_D_D]);
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("targetNamespace", allAttrs[ATT_TARGET_N_N]);
        attrList.put("version", allAttrs[ATT_VERSION_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_GLOBAL) + "schema", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("schemaLocation", allAttrs[ATT_SCHEMA_L_R]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_GLOBAL) + "include", oneEle);
        fEleAttrsMap.put(String.valueOf(PRE_GLOBAL) + "redefine", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("namespace", allAttrs[ATT_NAMESPACE_N]);
        attrList.put("schemaLocation", allAttrs[ATT_SCHEMA_L_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_GLOBAL) + "import", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("value", allAttrs[ATT_VALUE_NNI_N]);
        attrList.put("fixed", allAttrs[ATT_FIXED_D]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "length", oneEle);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "minLength", oneEle);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "maxLength", oneEle);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "totalDigits", oneEle);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "fractionDigits", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("value", allAttrs[ATT_VALUE_STR_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "pattern", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("value", allAttrs[ATT_VALUE_STR_N]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "enumeration", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("value", allAttrs[ATT_VALUE_WS_N]);
        attrList.put("fixed", allAttrs[ATT_FIXED_D]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "whiteSpace", oneEle);
        attrList = new Hashtable();
        attrList.put("id", allAttrs[ATT_ID_N]);
        attrList.put("value", allAttrs[ATT_VALUE_STR_N]);
        attrList.put("fixed", allAttrs[ATT_FIXED_D]);
        oneEle = new OneElement(attrList);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "maxInclusive", oneEle);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "maxExclusive", oneEle);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "minInclusive", oneEle);
        fEleAttrsMap.put(String.valueOf(PRE_LOC_NAME) + "minExclusive", oneEle);
    }

    private GeneralAttrCheck() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeneralAttrCheck(XMLErrorReporter er, DatatypeValidatorFactoryImpl datatypeRegistry) {
        this.fErrorReporter = er;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (fExtraDVs[DT_ANYURI] == null) {
                datatypeRegistry.expandRegistryToFullSchemaSet();
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_ANYURI] = datatypeRegistry.getDatatypeValidator("anyURI");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_BOOLEAN] = datatypeRegistry.getDatatypeValidator("boolean");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_ID] = datatypeRegistry.getDatatypeValidator("ID");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_NONNEGINT] = datatypeRegistry.getDatatypeValidator("nonNegativeInteger");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_QNAME] = datatypeRegistry.getDatatypeValidator("QName");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_STRING] = datatypeRegistry.getDatatypeValidator("string");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_TOKEN] = datatypeRegistry.getDatatypeValidator("token");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_NCNAME] = datatypeRegistry.getDatatypeValidator("NCName");
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_XPATH] = fExtraDVs[DT_STRING];
                GeneralAttrCheck.fExtraDVs[GeneralAttrCheck.DT_XPATH] = fExtraDVs[DT_STRING];
            }
        }
    }

    public Hashtable checkAttributes(Element element, int eleContext) throws Exception {
        if (element == null) {
            return null;
        }
        Hashtable<String, Object[]> attrValues = (Hashtable<String, Object[]>)this.fProcessedElements.get(element);
        if (attrValues != null) {
            return attrValues;
        }
        String elName = element.getLocalName();
        String name = eleContext == ELE_CONTEXT_GLOBAL ? String.valueOf(PRE_GLOBAL) + elName : (element.getAttributeNode("ref") == null ? String.valueOf(PRE_LOC_NAME) + elName : String.valueOf(PRE_LOC_REF) + elName);
        OneElement oneEle = (OneElement)fEleAttrsMap.get(name);
        if (oneEle == null) {
            this.reportSchemaError(53, new Object[]{elName});
            return null;
        }
        attrValues = new Hashtable<String, Object[]>();
        Hashtable attrList = oneEle.attrList;
        NamedNodeMap attrs = element.getAttributes();
        Attr sattr = null;
        int i = 0;
        while ((sattr = (Attr)attrs.item(i++)) != null) {
            String attrName = sattr.getName();
            String attrVal = sattr.getValue();
            if (attrName.toLowerCase().startsWith("xml")) {
                attrValues.put(attrName, new Object[]{sattr.getValue(), Boolean.FALSE});
                continue;
            }
            String attrURI = sattr.getNamespaceURI();
            if (attrURI != null && attrURI.length() != 0) {
                if (attrURI.equals("http://www.w3.org/2001/XMLSchema") || !oneEle.allowNonSchemaAttr) {
                    this.reportSchemaError(54, new Object[]{elName, attrName});
                    continue;
                }
                attrValues.put(attrName, new Object[]{attrVal, Boolean.FALSE});
                String attrRName = String.valueOf(attrURI) + "," + sattr.getLocalName();
                Vector<String> values = (Vector<String>)this.fNonSchemaAttrs.get(attrRName);
                if (values == null) {
                    values = new Vector<String>();
                    values.addElement(attrName);
                    values.addElement(elName);
                    values.addElement(attrVal);
                    this.fNonSchemaAttrs.put(attrRName, values);
                    continue;
                }
                values.addElement(elName);
                values.addElement(attrVal);
                continue;
            }
            OneAttr oneAttr = (OneAttr)attrList.get(attrName);
            if (oneAttr == null) {
                this.reportSchemaError(54, new Object[]{elName, attrName});
                continue;
            }
            try {
                if (oneAttr.dvIndex >= 0) {
                    if (oneAttr.dvIndex != DT_STRING && oneAttr.dvIndex != DT_XPATH && oneAttr.dvIndex != DT_XPATH1) {
                        DatatypeValidator dv = fExtraDVs[oneAttr.dvIndex];
                        if (dv instanceof IDDatatypeValidator) {
                            dv.validate(attrVal, this.fIdDefs);
                        } else {
                            dv.validate(attrVal, null);
                        }
                    }
                    attrValues.put(attrName, new Object[]{attrVal, Boolean.FALSE});
                    continue;
                }
                attrVal = this.validate(attrName, attrVal, oneAttr.dvIndex);
                attrValues.put(attrName, new Object[]{attrVal, Boolean.FALSE});
            }
            catch (InvalidDatatypeValueException ide) {
                this.reportSchemaError(56, new Object[]{elName, attrName, ide.getLocalizedMessage()});
            }
        }
        Object[] reqAttrs = oneEle.attrArray;
        i = 0;
        while (i < reqAttrs.length) {
            OneAttr oneAttr = (OneAttr)reqAttrs[i];
            if (element.getAttributeNode(oneAttr.name) == null) {
                if (oneAttr.optdflt == ATT_REQUIRED) {
                    this.reportSchemaError(55, new Object[]{elName, oneAttr.name});
                } else if (oneAttr.optdflt == ATT_OPT_DFLT) {
                    attrValues.put(oneAttr.name, new Object[]{oneAttr.dfltValue, Boolean.TRUE});
                }
            }
            ++i;
        }
        this.fProcessedElements.put(element, attrValues);
        return attrValues;
    }

    private String validate(String attr, String value, int dvIndex) throws InvalidDatatypeValueException {
        if (value == null) {
            return null;
        }
        switch (dvIndex) {
            case -1: {
                int choice = 0;
                if (value.equals("#all")) {
                    choice = 47;
                    break;
                }
                StringTokenizer t = new StringTokenizer(value, " ");
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    if (token.equals("substitution")) {
                        choice |= 0x20;
                        continue;
                    }
                    if (token.equals("extension")) {
                        choice |= 1;
                        continue;
                    }
                    if (token.equals("restriction")) {
                        choice |= 2;
                        continue;
                    }
                    if (token.equals("list")) {
                        choice |= 8;
                        continue;
                    }
                    if (token.equals("union")) {
                        choice |= 2;
                        continue;
                    }
                    throw new InvalidDatatypeValueException("the value '" + value + "' must match (#all | List of (substitution | extension | restriction | list | union))");
                }
                break;
            }
            case -3: 
            case -2: {
                int choice = 0;
                if (value.equals("#all")) {
                    choice = 3;
                    break;
                }
                StringTokenizer t = new StringTokenizer(value, " ");
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    if (token.equals("extension")) {
                        choice |= 1;
                        continue;
                    }
                    if (token.equals("restriction")) {
                        choice |= 2;
                        continue;
                    }
                    throw new InvalidDatatypeValueException("the value '" + value + "' must match (#all | List of (extension | restriction))");
                }
                break;
            }
            case -4: {
                int choice = 0;
                if (value.equals("#all")) {
                    choice = 14;
                    break;
                }
                if (value.equals("list")) {
                    choice = 8;
                    break;
                }
                if (value.equals("union")) {
                    choice = 4;
                    break;
                }
                if (value.equals("restriction")) {
                    choice = 2;
                    break;
                }
                throw new InvalidDatatypeValueException("the value '" + value + "' must match (#all | (list | union | restriction))");
            }
            case -5: {
                if (value.equals("qualified") || value.equals("unqualified")) break;
                throw new InvalidDatatypeValueException("the value '" + value + "' must match (qualified | unqualified)");
            }
            case -6: {
                if (value.equals("unbounded")) break;
                try {
                    fExtraDVs[DT_NONNEGINT].validate(value, null);
                    break;
                }
                catch (InvalidDatatypeValueException ide) {
                    throw new InvalidDatatypeValueException("the value '" + value + "' must match (nonNegativeInteger | unbounded)");
                }
            }
            case -7: {
                if (value.equals("1")) break;
                throw new InvalidDatatypeValueException("the value '" + value + "' must be '1'");
            }
            case -8: {
                try {
                    StringTokenizer t = new StringTokenizer(value, " ");
                    while (t.hasMoreTokens()) {
                        String token = t.nextToken();
                        fExtraDVs[DT_QNAME].validate(token, null);
                    }
                    break;
                }
                catch (InvalidDatatypeValueException ide) {
                    throw new InvalidDatatypeValueException("the value '" + value + "' must match (List of QName)");
                }
            }
            case -9: {
                if (value.equals("0") || value.equals("1")) break;
                throw new InvalidDatatypeValueException("the value '" + value + "' must be '0' or '1'");
            }
            case -10: {
                if (value.equals("##any") || value.equals("##other")) break;
                StringTokenizer t = new StringTokenizer(value, " ");
                try {
                    while (t.hasMoreTokens()) {
                        String token = t.nextToken();
                        if (token.equals("##targetNamespace") || token.equals("##local")) continue;
                        fExtraDVs[DT_ANYURI].validate(token, null);
                    }
                    break;
                }
                catch (InvalidDatatypeValueException ide) {
                    throw new InvalidDatatypeValueException("the value '" + value + "' must match ((##any | ##other) | List of (anyURI | (##targetNamespace | ##local)) )");
                }
            }
            case -11: {
                if (value.equals("skip") || value.equals("lax") || value.equals("strict")) break;
                throw new InvalidDatatypeValueException("the value '" + value + "' must match (lax | skip | strict)");
            }
            case -12: {
                fExtraDVs[DT_TOKEN].validate(value, null);
                break;
            }
            case -13: {
                if (value.equals("optional") || value.equals("prohibited") || value.equals("required")) break;
                throw new InvalidDatatypeValueException("the value '" + value + "' must match (optional | prohibited | required)");
            }
            case -14: {
                if (value.equals("preserve") || value.equals("replace") || value.equals("collapse")) break;
                throw new InvalidDatatypeValueException("the value '" + value + "' must match (preserve | replace | collapse)");
            }
        }
        return value;
    }

    private void reportSchemaError(int major, Object[] args) throws Exception {
        if (this.fErrorReporter == null) {
            System.out.println("__TraverseSchemaError__ : " + SchemaMessageProvider.fgMessageKeys[major]);
            int i = 0;
            while (i < args.length) {
                System.out.println((String)args[i]);
                ++i;
            }
        } else {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", major, 0, args, 1);
        }
    }

    public void checkNonSchemaAttributes(GrammarResolver grammarResolver) throws Exception {
        Enumeration enumeration = this.fNonSchemaAttrs.keys();
        while (enumeration.hasMoreElements()) {
            DatatypeValidator dv;
            XMLAttributeDecl tempAttrDecl;
            SchemaGrammar sGrammar;
            Hashtable attrRegistry;
            String attrRName = (String)enumeration.nextElement();
            String attrURI = attrRName.substring(0, attrRName.indexOf(44));
            String attrLocal = attrRName.substring(attrRName.indexOf(44) + 1);
            Grammar grammar = grammarResolver.getGrammar(attrURI);
            if (grammar == null || !(grammar instanceof SchemaGrammar) || (attrRegistry = (sGrammar = (SchemaGrammar)grammar).getAttributeDeclRegistry()) == null || (tempAttrDecl = (XMLAttributeDecl)attrRegistry.get(attrLocal)) == null || (dv = tempAttrDecl.datatypeValidator) == null) continue;
            Vector values = (Vector)this.fNonSchemaAttrs.get(attrRName);
            String attrName = (String)values.elementAt(0);
            int count = values.size();
            int i = 1;
            while (i < count) {
                String elName = (String)values.elementAt(i);
                String attrVal = this.normalize((String)values.elementAt(i + 1), dv.getWSFacet());
                try {
                    dv.validate(attrVal, null);
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportSchemaError(56, new Object[]{elName, attrName, ide.getLocalizedMessage()});
                }
                i += 2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String normalize(String content, short ws) {
        block8: {
            block7: {
                v0 = len = content == null ? 0 : content.length();
                if (len == 0 || ws == 0) {
                    return content;
                }
                sb = new StringBuffer();
                if (ws != 1) break block7;
                i = 0;
                while (i < len) {
                    ch = content.charAt(i);
                    if (ch != '\t' && ch != '\n' && ch != '\r') {
                        sb.append(ch);
                    } else {
                        sb.append(' ');
                    }
                    ++i;
                }
                break block8;
            }
            isLeading = true;
            i = 0;
            while (i < len) {
                block9: {
                    ch = content.charAt(i);
                    if (ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ') ** GOTO lbl30
                    sb.append(ch);
                    isLeading = false;
                    break block9;
                    while ((ch = content.charAt(i + 1)) == '\t' || ch == '\n' || ch == '\r' || ch == ' ') {
                        ++i;
lbl30:
                        // 2 sources

                        if (i < len - 1) continue;
                    }
                    if (i < len - 1 && !isLeading) {
                        sb.append(' ');
                    }
                }
                ++i;
            }
        }
        return sb.toString();
    }
}

