/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;
import org.apache.xerces.validators.schema.TraverseSchema;

public class SchemaGrammar
extends Grammar {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private XMLContentSpec fTempContentSpecNode = new XMLContentSpec();
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    private int[][] fScopeDefinedByElement = new int[4][];
    private String[][] fFromAnotherSchemaURI = new String[4][];
    private TraverseSchema.ComplexTypeInfo[][] fComplexTypeInfo = new TraverseSchema.ComplexTypeInfo[4][];
    private int[][] fElementDeclDefaultType = new int[4][];
    private String[][] fElementDeclDefaultValue = new String[4][];
    private String[][] fElementDeclSubGroupAffFullName = new String[4][];
    private Vector[][] fElementDeclSubGroupQNames = new Vector[4][];
    private Vector[][] fElementDeclAllSubGroupQNamesBlock = new Vector[4][];
    private Vector[][] fElementDeclAllSubGroupQNames = new Vector[4][];
    private int[][] fElementDeclBlockSet = new int[4][];
    private int[][] fElementDeclFinalSet = new int[4][];
    private int[][] fElementDeclMiscFlags = new int[4][];
    private int[][] fContentSpecMinOccurs = new int[4][];
    private int[][] fContentSpecMaxOccurs = new int[4][];
    private Hashtable fComplexTypeRegistry = null;
    private Hashtable fAttributeDeclRegistry = null;
    private DatatypeValidatorFactoryImpl fDatatypeRegistry = null;
    Hashtable topLevelGroupDecls = new Hashtable();
    Hashtable topLevelNotationDecls = new Hashtable();
    Hashtable topLevelAttrDecls = new Hashtable();
    Hashtable topLevelAttrGrpDecls = new Hashtable();
    Hashtable topLevelElemDecls = new Hashtable();
    Hashtable topLevelTypeDecls = new Hashtable();
    private NamespacesScope fNamespacesScope = null;
    private String fTargetNamespaceURI = "";
    private boolean deferContentSpecExpansion = false;
    private boolean checkUniqueParticleAttribution = false;
    private boolean checkingUPA = false;
    private int[][] fContentSpecOrgUri = new int[4][];

    public NamespacesScope getNamespacesScope() {
        return this.fNamespacesScope;
    }

    public boolean getDeferContentSpecExpansion() {
        return this.deferContentSpecExpansion;
    }

    public boolean getCheckUniqueParticleAttribution() {
        return this.checkUniqueParticleAttribution;
    }

    public String getTargetNamespaceURI() {
        return this.fTargetNamespaceURI;
    }

    public Hashtable getAttributeDeclRegistry() {
        return this.fAttributeDeclRegistry;
    }

    public Hashtable getComplexTypeRegistry() {
        return this.fComplexTypeRegistry;
    }

    public DatatypeValidatorFactoryImpl getDatatypeRegistry() {
        return this.fDatatypeRegistry;
    }

    public int getElementDefinedScope(int elementDeclIndex) {
        if (elementDeclIndex < -1) {
            return -1;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fScopeDefinedByElement[chunk][index];
    }

    public int getElementDefaultTYpe(int elementDeclIndex) {
        if (elementDeclIndex < -1) {
            return -1;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fElementDeclDefaultType[chunk][index];
    }

    public int getElementDeclBlockSet(int elementDeclIndex) {
        if (elementDeclIndex < -1) {
            return -1;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fElementDeclBlockSet[chunk][index];
    }

    public int getElementDeclFinalSet(int elementDeclIndex) {
        if (elementDeclIndex < -1) {
            return -1;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fElementDeclFinalSet[chunk][index];
    }

    public int getElementDeclMiscFlags(int elementDeclIndex) {
        if (elementDeclIndex < -1) {
            return -1;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fElementDeclMiscFlags[chunk][index];
    }

    public String getElementFromAnotherSchemaURI(int elementDeclIndex) {
        if (elementDeclIndex < 0) {
            return null;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fFromAnotherSchemaURI[chunk][index];
    }

    public String getElementDefaultValue(int elementDeclIndex) {
        if (elementDeclIndex < 0) {
            return null;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fElementDeclDefaultValue[chunk][index];
    }

    public String getElementDeclSubstitutionGroupAffFullName(int elementDeclIndex) {
        if (elementDeclIndex < 0) {
            return null;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fElementDeclSubGroupAffFullName[chunk][index];
    }

    private Vector getElementDeclSubstitutionGroupQNames(int elementDeclIndex) {
        if (elementDeclIndex < 0) {
            return null;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fElementDeclSubGroupQNames[chunk][index];
    }

    private Vector getElementDeclAllSubstitutionGroupQNamesBlock(int elementDeclIndex, GrammarResolver grammarResolver, StringPool stringPool) {
        Vector<SubGroupBlockQName> groups;
        if (elementDeclIndex < 0) {
            return null;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        if (this.fElementDeclAllSubGroupQNamesBlock[chunk][index] != null) {
            return this.fElementDeclAllSubGroupQNamesBlock[chunk][index];
        }
        this.fElementDeclAllSubGroupQNamesBlock[chunk][index] = groups = new Vector<SubGroupBlockQName>();
        TraverseSchema.ComplexTypeInfo typeInfo = this.getElementComplexTypeInfo(elementDeclIndex);
        Vector substitutionGroupQNames = this.getElementDeclSubstitutionGroupQNames(elementDeclIndex);
        int size = substitutionGroupQNames == null ? 0 : substitutionGroupQNames.size();
        int i = 0;
        while (i < size) {
            OneSubGroup oneGroup = (OneSubGroup)substitutionGroupQNames.elementAt(i);
            SchemaGrammar sGrammar = oneGroup.grammar;
            int subElementIndex = oneGroup.eleIndex;
            int devMethod = 0;
            int pDevMethod = 0;
            TraverseSchema.ComplexTypeInfo subTypeInfo = sGrammar.getElementComplexTypeInfo(subElementIndex);
            if (subTypeInfo == null) {
                XMLElementDecl tmpElementDecl = new XMLElementDecl();
                sGrammar.getElementDecl(subElementIndex, tmpElementDecl);
                DatatypeValidator subElementDV = tmpElementDecl.datatypeValidator;
                this.getElementDecl(elementDeclIndex, tmpElementDecl);
                DatatypeValidator elementDV = tmpElementDecl.datatypeValidator;
                if (subElementDV != null && subElementDV != elementDV) {
                    devMethod = 2;
                }
            } else {
                if (subTypeInfo != typeInfo) {
                    devMethod = subTypeInfo.derivedBy;
                    if (typeInfo != null) {
                        pDevMethod = typeInfo.blockSet;
                    }
                    subTypeInfo = subTypeInfo.baseComplexTypeInfo;
                }
                while (subTypeInfo != null && subTypeInfo != typeInfo) {
                    devMethod |= subTypeInfo.derivedBy;
                    pDevMethod |= subTypeInfo.blockSet;
                    subTypeInfo = subTypeInfo.baseComplexTypeInfo;
                }
            }
            SubGroupBlockQName oneName = new SubGroupBlockQName();
            oneName.name = oneGroup;
            oneName.method = devMethod;
            oneName.pmethod = pDevMethod;
            groups.addElement(oneName);
            Vector subSubGroup = sGrammar.getElementDeclAllSubstitutionGroupQNamesBlock(subElementIndex, grammarResolver, stringPool);
            int bsize = subSubGroup == null ? 0 : subSubGroup.size();
            int j = 0;
            while (j < bsize) {
                SubGroupBlockQName name = (SubGroupBlockQName)subSubGroup.elementAt(j);
                oneName = new SubGroupBlockQName();
                oneName.name = name.name;
                oneName.method = name.method | devMethod;
                oneName.pmethod = name.pmethod | pDevMethod;
                groups.addElement(oneName);
                ++j;
            }
            ++i;
        }
        return groups;
    }

    public Vector getElementDeclAllSubstitutionGroupQNames(int elementDeclIndex, GrammarResolver grammarResolver, StringPool stringPool) {
        Vector<OneSubGroup> groups;
        if (elementDeclIndex < 0) {
            return null;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        if (this.fElementDeclAllSubGroupQNames[chunk][index] != null) {
            return this.fElementDeclAllSubGroupQNames[chunk][index];
        }
        this.fElementDeclAllSubGroupQNames[chunk][index] = groups = new Vector<OneSubGroup>();
        int blockSet = this.getElementDeclBlockSet(elementDeclIndex);
        if ((blockSet & 0x20) != 0) {
            return groups;
        }
        Vector substitutionGroupQNamesBlock = this.getElementDeclAllSubstitutionGroupQNamesBlock(elementDeclIndex, grammarResolver, stringPool);
        int i = 0;
        while (i < substitutionGroupQNamesBlock.size()) {
            SubGroupBlockQName oneName = (SubGroupBlockQName)substitutionGroupQNamesBlock.elementAt(i);
            if (((blockSet | oneName.pmethod) & oneName.method) == 0) {
                groups.addElement(oneName.name);
            }
            ++i;
        }
        return groups;
    }

    public TraverseSchema.ComplexTypeInfo getElementComplexTypeInfo(int elementDeclIndex) {
        if (elementDeclIndex < -1) {
            return null;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fComplexTypeInfo[chunk][index];
    }

    protected int convertContentSpecTree(int contentSpecIndex) {
        if (!this.deferContentSpecExpansion || contentSpecIndex < 0) {
            return contentSpecIndex;
        }
        this.getContentSpec(contentSpecIndex, this.fTempContentSpecNode);
        int minOccurs = this.getContentSpecMinOccurs(contentSpecIndex);
        int maxOccurs = this.getContentSpecMaxOccurs(contentSpecIndex);
        if ((this.fTempContentSpecNode.type & 0xF) == 6 || (this.fTempContentSpecNode.type & 0xF) == 7 || (this.fTempContentSpecNode.type & 0xF) == 8 || this.fTempContentSpecNode.type == 0) {
            if (this.checkingUPA) {
                contentSpecIndex = this.addContentSpecNode(this.fTempContentSpecNode.type, this.fTempContentSpecNode.value, this.fTempContentSpecNode.otherValue, false);
                this.setContentSpecOrgUri(contentSpecIndex, this.fTempContentSpecNode.otherValue);
                this.getContentSpec(contentSpecIndex, this.fTempContentSpecNode);
                this.fTempContentSpecNode.otherValue = contentSpecIndex;
                this.setContentSpec(contentSpecIndex, this.fTempContentSpecNode);
            }
            return this.expandContentModel(contentSpecIndex, minOccurs, maxOccurs);
        }
        if (this.fTempContentSpecNode.type == 4 || this.fTempContentSpecNode.type == 9 || this.fTempContentSpecNode.type == 5) {
            int left = this.fTempContentSpecNode.value;
            int right = this.fTempContentSpecNode.otherValue;
            int type = this.fTempContentSpecNode.type;
            left = this.convertContentSpecTree(left);
            if (right == -2) {
                return this.expandContentModel(left, minOccurs, maxOccurs);
            }
            right = this.convertContentSpecTree(right);
            if (this.checkingUPA) {
                contentSpecIndex = this.addContentSpecNode(type, left, right, false);
            } else {
                this.fTempContentSpecNode.type = type;
                this.fTempContentSpecNode.value = left;
                this.fTempContentSpecNode.otherValue = right;
                this.setContentSpec(contentSpecIndex, this.fTempContentSpecNode);
            }
            return this.expandContentModel(contentSpecIndex, minOccurs, maxOccurs);
        }
        if (this.checkingUPA) {
            return this.addContentSpecNode(this.fTempContentSpecNode.type, this.convertContentSpecTree(this.fTempContentSpecNode.value), this.convertContentSpecTree(this.fTempContentSpecNode.otherValue), false);
        }
        return contentSpecIndex;
    }

    public XMLContentModel getContentModel(int contentSpecIndex, int contentType, SubstitutionGroupComparator comparator) throws Exception {
        if (this.existContentModel(contentSpecIndex)) {
            return super.getContentModel(contentSpecIndex, contentType, comparator);
        }
        if (this.checkUniqueParticleAttribution) {
            this.checkingUPA = true;
            XMLContentModel contentModel = super.getContentModel(contentSpecIndex, contentType, comparator);
            this.checkingUPA = false;
            if (contentModel != null) {
                contentModel.checkUniqueParticleAttribution(this);
                this.clearContentModel(contentSpecIndex);
            }
        }
        return super.getContentModel(contentSpecIndex, contentType, comparator);
    }

    public void setContentSpecOrgUri(int contentSpecIndex, int orgUri) {
        if (contentSpecIndex > -1) {
            int chunk = contentSpecIndex >> 8;
            int index = contentSpecIndex & 0xFF;
            this.ensureContentSpecCapacity(chunk);
            this.fContentSpecOrgUri[chunk][index] = orgUri;
        }
    }

    public int getContentSpecOrgUri(int contentSpecIndex) {
        if (contentSpecIndex > -1) {
            int chunk = contentSpecIndex >> 8;
            int index = contentSpecIndex & 0xFF;
            return this.fContentSpecOrgUri[chunk][index];
        }
        return -1;
    }

    public void setDeferContentSpecExpansion() {
        this.deferContentSpecExpansion = true;
    }

    public void setCheckUniqueParticleAttribution() {
        this.deferContentSpecExpansion = true;
        this.checkUniqueParticleAttribution = true;
    }

    protected void setAttributeDeclRegistry(Hashtable attrReg) {
        this.fAttributeDeclRegistry = attrReg;
    }

    protected void setComplexTypeRegistry(Hashtable cTypeReg) {
        this.fComplexTypeRegistry = cTypeReg;
    }

    protected void setDatatypeRegistry(DatatypeValidatorFactoryImpl dTypeReg) {
        this.fDatatypeRegistry = dTypeReg;
    }

    protected void setNamespacesScope(NamespacesScope nsScope) {
        this.fNamespacesScope = nsScope;
    }

    protected void setTargetNamespaceURI(String targetNSUri) {
        this.fTargetNamespaceURI = targetNSUri;
    }

    protected int createElementDecl() {
        return super.createElementDecl();
    }

    protected void setElementDecl(int elementDeclIndex, XMLElementDecl elementDecl) {
        super.setElementDecl(elementDeclIndex, elementDecl);
    }

    protected int createContentSpec() {
        return super.createContentSpec();
    }

    protected void setContentSpec(int contentSpecIndex, XMLContentSpec contentSpec) {
        super.setContentSpec(contentSpecIndex, contentSpec);
    }

    protected int createAttributeDecl() {
        return super.createAttributeDecl();
    }

    protected void setAttributeDecl(int elementDeclIndex, int attributeDeclIndex, XMLAttributeDecl attributeDecl) {
        super.setAttributeDecl(elementDeclIndex, attributeDeclIndex, attributeDecl);
    }

    protected void setElementDefinedScope(int elementDeclIndex, int scopeDefined) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        if (elementDeclIndex > -1) {
            this.fScopeDefinedByElement[chunk][index] = scopeDefined;
        }
    }

    protected void setElementFromAnotherSchemaURI(int elementDeclIndex, String anotherSchemaURI) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        if (elementDeclIndex > -1) {
            this.fFromAnotherSchemaURI[chunk][index] = anotherSchemaURI;
        }
    }

    protected void setElementComplexTypeInfo(int elementDeclIndex, TraverseSchema.ComplexTypeInfo typeInfo) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        if (elementDeclIndex > -1) {
            this.fComplexTypeInfo[chunk][index] = typeInfo;
        }
    }

    protected void setElementDefault(int elementDeclIndex, String defaultValue) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        if (elementDeclIndex > -1) {
            this.fElementDeclDefaultValue[chunk][index] = defaultValue;
        }
    }

    protected void setElementDeclBlockSet(int elementDeclIndex, int blockSet) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        if (elementDeclIndex > -1) {
            this.fElementDeclBlockSet[chunk][index] = blockSet;
        }
    }

    protected void setElementDeclFinalSet(int elementDeclIndex, int finalSet) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        if (elementDeclIndex > -1) {
            this.fElementDeclFinalSet[chunk][index] = finalSet;
        }
    }

    protected void setElementDeclMiscFlags(int elementDeclIndex, int miscFlags) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        if (elementDeclIndex > -1) {
            this.fElementDeclMiscFlags[chunk][index] = miscFlags;
        }
    }

    protected void setElementDeclSubstitutionGroupAffFullName(int elementDeclIndex, String substitutionGroupFullName) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        if (elementDeclIndex > -1) {
            this.fElementDeclSubGroupAffFullName[chunk][index] = substitutionGroupFullName;
        }
    }

    protected void addElementDeclOneSubstitutionGroupQName(int elementDeclIndex, QName name, SchemaGrammar grammar, int eleIndex) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        if (elementDeclIndex > -1) {
            if (this.fElementDeclSubGroupQNames[chunk][index] == null) {
                this.fElementDeclSubGroupQNames[chunk][index] = new Vector();
            }
            OneSubGroup oneGroup = new OneSubGroup();
            oneGroup.name = name;
            oneGroup.grammar = grammar;
            oneGroup.eleIndex = eleIndex;
            this.fElementDeclSubGroupQNames[chunk][index].addElement(oneGroup);
        }
    }

    protected void setContentSpecMinOccurs(int contentSpecIndex, int minOccurs) {
        if (contentSpecIndex > -1) {
            int chunk = contentSpecIndex >> 8;
            int index = contentSpecIndex & 0xFF;
            this.ensureContentSpecCapacity(chunk);
            this.fContentSpecMinOccurs[chunk][index] = minOccurs;
        }
    }

    protected int getContentSpecMinOccurs(int contentSpecIndex) {
        if (contentSpecIndex > -1) {
            int chunk = contentSpecIndex >> 8;
            int index = contentSpecIndex & 0xFF;
            return this.fContentSpecMinOccurs[chunk][index];
        }
        return -1;
    }

    protected int getContentSpecMaxOccurs(int contentSpecIndex) {
        if (contentSpecIndex > -1) {
            int chunk = contentSpecIndex >> 8;
            int index = contentSpecIndex & 0xFF;
            return this.fContentSpecMaxOccurs[chunk][index];
        }
        return -1;
    }

    protected void setContentSpecMaxOccurs(int contentSpecIndex, int maxOccurs) {
        if (contentSpecIndex > -1) {
            int chunk = contentSpecIndex >> 8;
            int index = contentSpecIndex & 0xFF;
            this.ensureContentSpecCapacity(chunk);
            this.fContentSpecMaxOccurs[chunk][index] = maxOccurs;
        }
    }

    protected int addElementDecl(QName eltQName, int enclosingScope, int scopeDefined, int contentSpecType, int contentSpecIndex, int attrListHead, DatatypeValidator dv) {
        int elementDeclIndex = this.getElementDeclIndex(eltQName, enclosingScope);
        if (elementDeclIndex == -1) {
            if (enclosingScope >= -1) {
                // empty if block
            }
            this.fTempElementDecl.name.setValues(eltQName);
            this.fTempElementDecl.enclosingScope = enclosingScope;
            this.fTempElementDecl.type = contentSpecType;
            this.fTempElementDecl.contentSpecIndex = contentSpecIndex;
            this.fTempElementDecl.datatypeValidator = dv;
            elementDeclIndex = this.createElementDecl();
            this.setElementDecl(elementDeclIndex, this.fTempElementDecl);
            this.setFirstAttributeDeclIndex(elementDeclIndex, attrListHead);
            this.setElementDefinedScope(elementDeclIndex, scopeDefined);
        }
        return elementDeclIndex;
    }

    protected int cloneElementDecl(int eltNdx, int enclosingScope, int scopeDefined) {
        this.getElementDecl(eltNdx, this.fTempElementDecl);
        TraverseSchema.ComplexTypeInfo typeInfo = this.getElementComplexTypeInfo(eltNdx);
        int blockSet = this.getElementDeclBlockSet(eltNdx);
        int finalSet = this.getElementDeclFinalSet(eltNdx);
        int elementMiscFlags = this.getElementDeclMiscFlags(eltNdx);
        String defaultStr = this.getElementDefaultValue(eltNdx);
        String subGroupName = this.getElementDeclSubstitutionGroupAffFullName(eltNdx);
        int attrListHead = this.getFirstAttributeDeclIndex(eltNdx);
        String anotherSchema = this.getElementFromAnotherSchemaURI(eltNdx);
        this.fTempElementDecl.enclosingScope = enclosingScope;
        int newElt = this.addElementDecl(this.fTempElementDecl.name, enclosingScope, scopeDefined, this.fTempElementDecl.type, this.fTempElementDecl.contentSpecIndex, attrListHead, this.fTempElementDecl.datatypeValidator);
        this.setElementComplexTypeInfo(newElt, typeInfo);
        this.setElementDeclBlockSet(newElt, blockSet);
        this.setElementDeclFinalSet(newElt, finalSet);
        this.setElementDeclMiscFlags(newElt, elementMiscFlags);
        this.setElementDefault(newElt, defaultStr);
        this.setElementFromAnotherSchemaURI(newElt, anotherSchema);
        return newElt;
    }

    protected void addAttDef(int templateElementIndex, QName attQName, int attType, int enumeration, int attDefaultType, String attDefaultValue, DatatypeValidator dv, boolean isList) {
        int attrDeclIndex = this.createAttributeDecl();
        this.fTempAttributeDecl.name.setValues(attQName);
        this.fTempAttributeDecl.datatypeValidator = dv;
        this.fTempAttributeDecl.type = attType;
        this.fTempAttributeDecl.defaultType = attDefaultType;
        this.fTempAttributeDecl.defaultValue = attDefaultValue;
        this.fTempAttributeDecl.list = isList;
        this.fTempAttributeDecl.enumeration = enumeration;
        super.setAttributeDecl(templateElementIndex, attrDeclIndex, this.fTempAttributeDecl);
    }

    public int getAttributeDeclIndex(int elementIndex, QName attribute) {
        if (elementIndex == -1) {
            return -1;
        }
        int attDefIndex = this.getFirstAttributeDeclIndex(elementIndex);
        return this.findAttributeDecl(attDefIndex, attribute);
    }

    public int findAttributeDecl(int attListHead, QName attribute) {
        int attDefIndex = attListHead;
        while (attDefIndex != -1) {
            this.getAttributeDecl(attDefIndex, this.fTempAttributeDecl);
            if (this.fTempAttributeDecl.name.localpart == attribute.localpart && this.fTempAttributeDecl.name.uri == attribute.uri) {
                return attDefIndex;
            }
            attDefIndex = this.getNextAttributeDeclIndex(attDefIndex);
        }
        return -1;
    }

    protected void setFirstAttributeDeclIndex(int eltNdx, int attListHead) {
        super.setFirstAttributeDeclIndex(eltNdx, attListHead);
    }

    protected int addContentSpecNode(int contentSpecType, int value, int otherValue, boolean mustBeUnique) {
        this.fTempContentSpecNode.type = contentSpecType;
        this.fTempContentSpecNode.value = value;
        this.fTempContentSpecNode.otherValue = otherValue;
        int contentSpecIndex = this.createContentSpec();
        this.setContentSpec(contentSpecIndex, this.fTempContentSpecNode);
        this.setContentSpecMinOccurs(contentSpecIndex, 1);
        this.setContentSpecMaxOccurs(contentSpecIndex, 1);
        return contentSpecIndex;
    }

    protected int expandContentModel(int index, int minOccurs, int maxOccurs) {
        block14: {
            int leafIndex = index;
            if (minOccurs == 1 && maxOccurs == 1) break block14;
            if (minOccurs == 0 && maxOccurs == 1) {
                index = this.addContentSpecNode(1, index, -1, false);
            } else if (minOccurs == 0 && maxOccurs == -2) {
                index = this.addContentSpecNode(2, index, -1, false);
            } else if (minOccurs == 1 && maxOccurs == -2) {
                index = this.addContentSpecNode(3, index, -1, false);
            } else if (maxOccurs == -2) {
                index = this.addContentSpecNode(3, index, -1, false);
                int i = 0;
                while (i < minOccurs - 1) {
                    index = this.addContentSpecNode(5, leafIndex, index, false);
                    ++i;
                }
            } else if (minOccurs == 0) {
                int optional;
                index = optional = this.addContentSpecNode(1, leafIndex, -1, false);
                int i = 0;
                while (i < maxOccurs - minOccurs - 1) {
                    index = this.addContentSpecNode(5, index, optional, false);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < minOccurs - 1) {
                    index = this.addContentSpecNode(5, index, leafIndex, false);
                    ++i;
                }
                int optional = this.addContentSpecNode(1, leafIndex, -1, false);
                int i2 = 0;
                while (i2 < maxOccurs - minOccurs) {
                    index = this.addContentSpecNode(5, index, optional, false);
                    ++i2;
                }
            }
        }
        return index;
    }

    private boolean ensureContentSpecCapacity(int chunk) {
        try {
            return this.fContentSpecMinOccurs[chunk][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fContentSpecMinOccurs = this.resize(this.fContentSpecMinOccurs, this.fContentSpecMinOccurs.length * 2);
            this.fContentSpecMaxOccurs = this.resize(this.fContentSpecMaxOccurs, this.fContentSpecMaxOccurs.length * 2);
            this.fContentSpecOrgUri = this.resize(this.fContentSpecOrgUri, this.fContentSpecOrgUri.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fContentSpecMinOccurs[chunk] = new int[256];
        this.fContentSpecMaxOccurs[chunk] = new int[256];
        this.fContentSpecOrgUri[chunk] = new int[256];
        return true;
    }

    private boolean ensureElementDeclCapacity(int chunk) {
        try {
            return this.fScopeDefinedByElement[chunk][0] == -2;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fScopeDefinedByElement = this.resize(this.fScopeDefinedByElement, this.fScopeDefinedByElement.length * 2);
            this.fFromAnotherSchemaURI = this.resize(this.fFromAnotherSchemaURI, this.fFromAnotherSchemaURI.length * 2);
            this.fComplexTypeInfo = this.resize(this.fComplexTypeInfo, this.fComplexTypeInfo.length * 2);
            this.fElementDeclDefaultType = this.resize(this.fElementDeclDefaultType, this.fElementDeclDefaultType.length * 2);
            this.fElementDeclDefaultValue = this.resize(this.fElementDeclDefaultValue, this.fElementDeclDefaultValue.length * 2);
            this.fElementDeclBlockSet = this.resize(this.fElementDeclBlockSet, this.fElementDeclBlockSet.length * 2);
            this.fElementDeclFinalSet = this.resize(this.fElementDeclFinalSet, this.fElementDeclFinalSet.length * 2);
            this.fElementDeclMiscFlags = this.resize(this.fElementDeclMiscFlags, this.fElementDeclMiscFlags.length * 2);
            this.fElementDeclSubGroupAffFullName = this.resize(this.fElementDeclSubGroupAffFullName, this.fElementDeclSubGroupAffFullName.length * 2);
            this.fElementDeclSubGroupQNames = this.resize(this.fElementDeclSubGroupQNames, this.fElementDeclSubGroupQNames.length * 2);
            this.fElementDeclAllSubGroupQNames = this.resize(this.fElementDeclAllSubGroupQNames, this.fElementDeclAllSubGroupQNames.length * 2);
            this.fElementDeclAllSubGroupQNamesBlock = this.resize(this.fElementDeclAllSubGroupQNamesBlock, this.fElementDeclAllSubGroupQNamesBlock.length * 2);
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        this.fScopeDefinedByElement[chunk] = new int[256];
        int i = 0;
        while (i < 256) {
            this.fScopeDefinedByElement[chunk][i] = -2;
            ++i;
        }
        this.fFromAnotherSchemaURI[chunk] = new String[256];
        this.fComplexTypeInfo[chunk] = new TraverseSchema.ComplexTypeInfo[256];
        this.fElementDeclDefaultType[chunk] = new int[256];
        this.fElementDeclDefaultValue[chunk] = new String[256];
        this.fElementDeclSubGroupAffFullName[chunk] = new String[256];
        this.fElementDeclSubGroupQNames[chunk] = new Vector[256];
        this.fElementDeclAllSubGroupQNames[chunk] = new Vector[256];
        this.fElementDeclAllSubGroupQNamesBlock[chunk] = new Vector[256];
        this.fElementDeclBlockSet[chunk] = new int[256];
        this.fElementDeclFinalSet[chunk] = new int[256];
        this.fElementDeclMiscFlags[chunk] = new int[256];
        return true;
    }

    private int[][] resize(int[][] array, int newsize) {
        int[][] newarray = new int[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private String[][] resize(String[][] array, int newsize) {
        String[][] newarray = new String[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private TraverseSchema.ComplexTypeInfo[][] resize(TraverseSchema.ComplexTypeInfo[][] array, int newsize) {
        TraverseSchema.ComplexTypeInfo[][] newarray = new TraverseSchema.ComplexTypeInfo[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private Vector[][] resize(Vector[][] array, int newsize) {
        Vector[][] newarray = new Vector[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    public class OneSubGroup {
        public QName name;
        SchemaGrammar grammar;
        int eleIndex;
    }

    private class SubGroupBlockQName {
        public OneSubGroup name;
        public int method;
        public int pmethod;

        private SubGroupBlockQName() {
        }
    }
}

