/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.util.Vector;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.TraverseSchema;
import org.xml.sax.SAXException;

public class SubstitutionGroupComparator {
    private final int TOP_LEVEL_SCOPE = -1;
    private StringPool fStringPool = null;
    private GrammarResolver fGrammarResolver = null;
    private XMLErrorReporter fErrorReporter = null;

    private SubstitutionGroupComparator() {
    }

    public SubstitutionGroupComparator(GrammarResolver grammarResolver, StringPool stringPool, XMLErrorReporter errorReporter) {
        this.fGrammarResolver = grammarResolver;
        this.fStringPool = stringPool;
        this.fErrorReporter = errorReporter;
    }

    public StringPool getStringPool() {
        return this.fStringPool;
    }

    public XMLErrorReporter getErrorReporter() {
        return this.fErrorReporter;
    }

    public boolean isEquivalentTo(QName anElement, QName exemplar) throws Exception {
        int elementIndex;
        if (anElement.localpart == exemplar.localpart && anElement.uri == exemplar.uri) {
            return true;
        }
        if (this.fGrammarResolver == null || this.fStringPool == null) {
            throw new SAXException("Internal error; tried to check an element against a substitutionGroup, but no GrammarResolver is defined");
        }
        int uriIndex = anElement.uri;
        int localpartIndex = anElement.localpart;
        String uri = this.fStringPool.toString(anElement.uri);
        String localpart = this.fStringPool.toString(anElement.localpart);
        if (uri == null) {
            return false;
        }
        SchemaGrammar sGrammar = null;
        try {
            sGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(uri);
        }
        catch (ClassCastException ce) {
            String er = "Grammar with URI " + uri + " is not a schema grammar!";
            Object[] a = new Object[]{er};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 169, 146, a, 1);
            return false;
        }
        if (sGrammar == null) {
            return false;
        }
        int anElementIndex = elementIndex = sGrammar.getElementDeclIndex(uriIndex, localpartIndex, -1);
        String substitutionGroupFullName = sGrammar.getElementDeclSubstitutionGroupAffFullName(elementIndex);
        boolean foundIt = false;
        while (substitutionGroupFullName != null) {
            int commaAt = substitutionGroupFullName.indexOf(",");
            uri = "";
            localpart = substitutionGroupFullName;
            if (commaAt >= 0) {
                if (commaAt > 0) {
                    uri = substitutionGroupFullName.substring(0, commaAt);
                }
                localpart = substitutionGroupFullName.substring(commaAt + 1);
            }
            if (uri == null) {
                return false;
            }
            try {
                sGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(uri);
            }
            catch (ClassCastException ce) {
                String er = "Grammar with URI " + uri + " is not a schema grammar!";
                Object[] a = new Object[]{er};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 169, 146, a, 1);
                return false;
            }
            if (sGrammar == null) {
                return false;
            }
            uriIndex = this.fStringPool.addSymbol(uri);
            elementIndex = sGrammar.getElementDeclIndex(uriIndex, localpartIndex = this.fStringPool.addSymbol(localpart), -1);
            if (elementIndex == -1) {
                return false;
            }
            if (uriIndex == exemplar.uri && localpartIndex == exemplar.localpart) {
                if ((sGrammar.getElementDeclBlockSet(elementIndex) & 0x20) != 0) {
                    return false;
                }
                foundIt = true;
                break;
            }
            substitutionGroupFullName = sGrammar.getElementDeclSubstitutionGroupAffFullName(elementIndex);
        }
        if (!foundIt) {
            return false;
        }
        TraverseSchema.ComplexTypeInfo aComplexType = sGrammar.getElementComplexTypeInfo(anElementIndex);
        int exemplarBlockSet = sGrammar.getElementDeclBlockSet(elementIndex);
        if (aComplexType == null) {
            XMLElementDecl anElementDecl = new XMLElementDecl();
            sGrammar.getElementDecl(anElementIndex, anElementDecl);
            DatatypeValidator anElementDV = anElementDecl.datatypeValidator;
            XMLElementDecl exemplarDecl = new XMLElementDecl();
            sGrammar.getElementDecl(elementIndex, exemplarDecl);
            DatatypeValidator exemplarDV = exemplarDecl.datatypeValidator;
            return anElementDV == null || anElementDV == exemplarDV || (exemplarBlockSet & 2) == 0;
        }
        int anElementDerivationMethod = aComplexType.derivedBy;
        if ((anElementDerivationMethod & exemplarBlockSet) != 0) {
            return false;
        }
        TraverseSchema.ComplexTypeInfo exemplarComplexType = sGrammar.getElementComplexTypeInfo(elementIndex);
        TraverseSchema.ComplexTypeInfo tempType = aComplexType;
        while (tempType != null && tempType != exemplarComplexType) {
            if ((tempType.blockSet & anElementDerivationMethod) != 0) {
                return false;
            }
            tempType = tempType.baseComplexTypeInfo;
        }
        return true;
    }

    public boolean isAllowedByWildcard(QName element, int wuri, boolean wother) throws Exception {
        if (!wother && element.uri == wuri || wother && element.uri != wuri) {
            return true;
        }
        if (this.fGrammarResolver == null || this.fStringPool == null) {
            throw new SAXException("Internal error; tried to check an element against a substitutionGroup, but no GrammarResolver is defined");
        }
        String uri = this.fStringPool.toString(element.uri);
        if (uri == null) {
            return false;
        }
        SchemaGrammar sGrammar = null;
        try {
            sGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(uri);
        }
        catch (ClassCastException ce) {
            String er = "Grammar with URI " + uri + " is not a schema grammar!";
            Object[] a = new Object[]{er};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 169, 146, a, 1);
            return false;
        }
        if (sGrammar == null) {
            return false;
        }
        int elementIndex = sGrammar.getElementDeclIndex(element, -1);
        Vector substitutionGroupQNames = sGrammar.getElementDeclAllSubstitutionGroupQNames(elementIndex, this.fGrammarResolver, this.fStringPool);
        int size = substitutionGroupQNames == null ? 0 : substitutionGroupQNames.size();
        int i = 0;
        while (i < size) {
            QName name = ((SchemaGrammar.OneSubGroup)substitutionGroupQNames.elementAt((int)i)).name;
            if (!wother && name.uri == wuri || wother && name.uri != wuri) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

