/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.AnySimpleType;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.datatype.IDDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.ListDatatypeValidator;
import org.apache.xerces.validators.datatype.NOTATIONDatatypeValidator;
import org.apache.xerces.validators.datatype.StringDatatypeValidator;
import org.apache.xerces.validators.datatype.UnionDatatypeValidator;
import org.apache.xerces.validators.schema.GeneralAttrCheck;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SchemaMessageProvider;
import org.apache.xerces.validators.schema.SubstitutionGroupComparator;
import org.apache.xerces.validators.schema.XUtil;
import org.apache.xerces.validators.schema.identity.Field;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.Key;
import org.apache.xerces.validators.schema.identity.KeyRef;
import org.apache.xerces.validators.schema.identity.Selector;
import org.apache.xerces.validators.schema.identity.Unique;
import org.apache.xerces.validators.schema.identity.XPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class TraverseSchema
implements NamespacesScope.NamespacesHandler {
    private static final int TOP_LEVEL_SCOPE = -1;
    private static final String[][] IDENTITY_CONSTRAINTS = new String[][]{{"http://www.w3.org/2001/XMLSchema", "unique"}, {"http://www.w3.org/2001/XMLSchema", "key"}, {"http://www.w3.org/2001/XMLSchema", "keyref"}};
    private static final String redefIdentifier = "_fn3dktizrknc9pi";
    private String fUnparsedExternalSchemas = null;
    private Hashtable fExternalSchemas = null;
    private String fExternalNoNamespaceSchema = null;
    private static final int NOT_ALL_CONTEXT = 0;
    private static final int PROCESSING_ALL_EL = 1;
    private static final int GROUP_REF_WITH_ALL = 2;
    private static final int CHILD_OF_GROUP = 4;
    private static final int PROCESSING_ALL_GP = 8;
    private static final boolean DEBUGGING = false;
    private static final boolean DEBUG_IDENTITY_CONSTRAINTS = false;
    private static final boolean DEBUG_NEW_GROUP = true;
    private static final boolean DEBUG_IC_DATATYPES = false;
    private boolean fFullConstraintChecking = false;
    private XMLErrorReporter fErrorReporter = null;
    private StringPool fStringPool = null;
    private GrammarResolver fGrammarResolver = null;
    private SchemaGrammar fSchemaGrammar = null;
    private Element fSchemaRootElement;
    private SchemaInfo fSchemaInfoListRoot = null;
    private SchemaInfo fCurrentSchemaInfo = null;
    private boolean fRedefineSucceeded;
    private DatatypeValidatorFactoryImpl fDatatypeRegistry = null;
    private Hashtable fComplexTypeRegistry = new Hashtable();
    private Hashtable fAttributeDeclRegistry = new Hashtable();
    private Hashtable fGroupNameRegistry = new Hashtable();
    private Hashtable fRestrictedRedefinedGroupRegistry = new Hashtable();
    private Hashtable fSimpleTypeFinalRegistry = new Hashtable();
    private Hashtable fNotationRegistry = new Hashtable();
    private Vector fIncludeLocations = new Vector();
    private Vector fImportLocations = new Vector();
    private Hashtable fRedefineLocations = new Hashtable();
    private Vector fTraversedRedefineElements = new Vector();
    private Hashtable fRedefineAttributeGroupMap = null;
    private Hashtable fFacetData = new Hashtable(10);
    private Stack fSimpleTypeNameStack = new Stack();
    private String fListName = "";
    private int fAnonTypeCount = 0;
    private int fScopeCount = 0;
    private int fCurrentScope = -1;
    private int fSimpleTypeAnonCount = 0;
    private Stack fCurrentTypeNameStack = new Stack();
    private Stack fBaseTypeNameStack = new Stack();
    private Stack fCurrentGroupNameStack = new Stack();
    private Vector fElementRecurseComplex = new Vector();
    private Vector fTopLevelElementsRefdFromGroup = new Vector();
    private Stack fCurrentAttrGroupNameStack = new Stack();
    private Vector fSubstitutionGroupRecursionRegistry = new Vector();
    private boolean fElementDefaultQualified = false;
    private boolean fAttributeDefaultQualified = false;
    private int fBlockDefault = 0;
    private int fFinalDefault = 0;
    private int fTargetNSURI;
    private String fTargetNSURIString = "";
    private NamespacesScope fNamespacesScope = null;
    private String fCurrentSchemaURL = "";
    private Stack fSchemaURLStack = new Stack();
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    private XMLAttributeDecl fTemp2AttributeDecl = new XMLAttributeDecl();
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private XMLElementDecl fTempElementDecl2 = new XMLElementDecl();
    private XMLContentSpec tempContentSpec1 = new XMLContentSpec();
    private XMLContentSpec tempContentSpec2 = new XMLContentSpec();
    private EntityResolver fEntityResolver = null;
    private SubstitutionGroupComparator fSComp = null;
    private Hashtable fIdentityConstraints = new Hashtable();
    private Hashtable fIdentityConstraintNames = new Hashtable();
    private GeneralAttrCheck fGeneralAttrCheck = null;
    private int fXsiURI;
    private static final int CT_IS_ABSTRACT = 1;
    private static final int CT_CONTAINS_ATTR_TYPE_ID = 2;
    private static final int CT_DECL_SEEN = 4;
    public static final String SchemaForSchemaURI = "http://www.w3.org/TR-1/Schema";

    private TraverseSchema() {
    }

    public void setFullConstraintCheckingEnabled() {
        this.fFullConstraintChecking = true;
    }

    public void setGrammarResolver(GrammarResolver grammarResolver) {
        this.fGrammarResolver = grammarResolver;
    }

    public void startNamespaceDeclScope(int prefix, int uri) {
    }

    public void endNamespaceDeclScope(int prefix) {
    }

    public boolean particleEmptiable(int contentSpecIndex) {
        if (!this.fFullConstraintChecking) {
            return true;
        }
        return this.minEffectiveTotalRange(contentSpecIndex) == 0;
    }

    public int minEffectiveTotalRange(int contentSpecIndex) {
        this.fSchemaGrammar.getContentSpec(contentSpecIndex, this.tempContentSpec1);
        int type = this.tempContentSpec1.type;
        if (type == 5 || type == 9) {
            return this.minEffectiveTotalRangeSeq(contentSpecIndex);
        }
        if (type == 4) {
            return this.minEffectiveTotalRangeChoice(contentSpecIndex);
        }
        return this.fSchemaGrammar.getContentSpecMinOccurs(contentSpecIndex);
    }

    private int minEffectiveTotalRangeSeq(int csIndex) {
        this.fSchemaGrammar.getContentSpec(csIndex, this.tempContentSpec1);
        int type = this.tempContentSpec1.type;
        int left = this.tempContentSpec1.value;
        int right = this.tempContentSpec1.otherValue;
        int min = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex);
        int result = right == -2 ? min * this.minEffectiveTotalRange(left) : min * (this.minEffectiveTotalRange(left) + this.minEffectiveTotalRange(right));
        return result;
    }

    private int minEffectiveTotalRangeChoice(int csIndex) {
        int minRight;
        int minLeft;
        this.fSchemaGrammar.getContentSpec(csIndex, this.tempContentSpec1);
        int type = this.tempContentSpec1.type;
        int left = this.tempContentSpec1.value;
        int right = this.tempContentSpec1.otherValue;
        int min = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex);
        int result = right == -2 ? min * this.minEffectiveTotalRange(left) : min * ((minLeft = this.minEffectiveTotalRange(left)) < (minRight = this.minEffectiveTotalRange(right)) ? minLeft : minRight);
        return result;
    }

    public int maxEffectiveTotalRange(int contentSpecIndex) {
        this.fSchemaGrammar.getContentSpec(contentSpecIndex, this.tempContentSpec1);
        int type = this.tempContentSpec1.type;
        if (type == 5 || type == 9) {
            return this.maxEffectiveTotalRangeSeq(contentSpecIndex);
        }
        if (type == 4) {
            return this.maxEffectiveTotalRangeChoice(contentSpecIndex);
        }
        return this.fSchemaGrammar.getContentSpecMaxOccurs(contentSpecIndex);
    }

    private int maxEffectiveTotalRangeSeq(int csIndex) {
        this.fSchemaGrammar.getContentSpec(csIndex, this.tempContentSpec1);
        int type = this.tempContentSpec1.type;
        int left = this.tempContentSpec1.value;
        int right = this.tempContentSpec1.otherValue;
        int max = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex);
        if (max == -2) {
            return -2;
        }
        int maxLeft = this.maxEffectiveTotalRange(left);
        if (right == -2) {
            if (maxLeft == -2) {
                return -2;
            }
            return max * maxLeft;
        }
        int maxRight = this.maxEffectiveTotalRange(right);
        if (maxLeft == -2 || maxRight == -2) {
            return -2;
        }
        return max * (maxLeft + maxRight);
    }

    private int maxEffectiveTotalRangeChoice(int csIndex) {
        this.fSchemaGrammar.getContentSpec(csIndex, this.tempContentSpec1);
        int type = this.tempContentSpec1.type;
        int left = this.tempContentSpec1.value;
        int right = this.tempContentSpec1.otherValue;
        int max = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex);
        if (max == -2) {
            return -2;
        }
        int maxLeft = this.maxEffectiveTotalRange(left);
        if (right == -2) {
            if (maxLeft == -2) {
                return -2;
            }
            return max * maxLeft;
        }
        int maxRight = this.maxEffectiveTotalRange(right);
        if (maxLeft == -2 || maxRight == -2) {
            return -2;
        }
        return max * (maxLeft > maxRight ? maxLeft : maxRight);
    }

    private String resolvePrefixToURI(String prefix) throws Exception {
        String uriStr = this.fStringPool.toString(this.fNamespacesScope.getNamespaceForPrefix(this.fStringPool.addSymbol(prefix)));
        if (uriStr.length() == 0 && prefix.length() > 0) {
            this.reportGenericSchemaError("prefix : [" + prefix + "] cannot be resolved to a URI");
            return "";
        }
        return uriStr;
    }

    public TraverseSchema(Element root, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver, XMLErrorReporter errorReporter, String schemaURL, EntityResolver entityResolver, boolean fullChecking, GeneralAttrCheck generalAttrCheck, String externalSchemaLocations, String noNamespaceSchemaLocation) throws Exception {
        StringTokenizer tokenizer;
        int tokenTotal;
        this.fErrorReporter = errorReporter;
        this.fCurrentSchemaURL = schemaURL;
        this.fFullConstraintChecking = fullChecking;
        this.fEntityResolver = entityResolver;
        this.fGeneralAttrCheck = generalAttrCheck;
        this.fUnparsedExternalSchemas = externalSchemaLocations;
        if (externalSchemaLocations != null && (tokenTotal = (tokenizer = new StringTokenizer(externalSchemaLocations, " \n\t\r", false)).countTokens()) % 2 == 0) {
            this.fExternalSchemas = new Hashtable();
            String uri = null;
            String location = null;
            while (tokenizer.hasMoreTokens()) {
                uri = tokenizer.nextToken();
                location = tokenizer.nextToken();
                this.fExternalSchemas.put(location, uri);
            }
        }
        this.fExternalNoNamespaceSchema = noNamespaceSchemaLocation;
        this.doTraverseSchema(root, stringPool, schemaGrammar, grammarResolver);
    }

    public TraverseSchema(Element root, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver, XMLErrorReporter errorReporter, String schemaURL, boolean fullChecking, GeneralAttrCheck generalAttrCheck) throws Exception {
        this.fErrorReporter = errorReporter;
        this.fCurrentSchemaURL = schemaURL;
        this.fFullConstraintChecking = fullChecking;
        this.fGeneralAttrCheck = generalAttrCheck;
        this.doTraverseSchema(root, stringPool, schemaGrammar, grammarResolver);
    }

    public TraverseSchema(Element root, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver, boolean fullChecking, GeneralAttrCheck generalAttrCheck) throws Exception {
        this.fFullConstraintChecking = fullChecking;
        this.fGeneralAttrCheck = generalAttrCheck;
        this.doTraverseSchema(root, stringPool, schemaGrammar, grammarResolver);
    }

    public void doTraverseSchema(Element root, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver) throws Exception {
        int elementIndex;
        Vector identityConstraints;
        Integer elementIndexObj;
        String name;
        this.fSchemaRootElement = root;
        this.fStringPool = stringPool;
        this.fSchemaGrammar = schemaGrammar;
        this.fNamespacesScope = new NamespacesScope(this);
        this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol("xml"), this.fStringPool.addSymbol("http://www.w3.org/XML/1998/namespace"));
        if (this.fFullConstraintChecking) {
            this.fSchemaGrammar.setDeferContentSpecExpansion();
            this.fSchemaGrammar.setCheckUniqueParticleAttribution();
        }
        this.fGrammarResolver = grammarResolver;
        this.fDatatypeRegistry = (DatatypeValidatorFactoryImpl)this.fGrammarResolver.getDatatypeRegistry();
        this.fDatatypeRegistry.expandRegistryToFullSchemaSet();
        this.fXsiURI = this.fStringPool.addSymbol("http://www.w3.org/2001/XMLSchema-instance");
        if (root == null) {
            return;
        }
        int scope = GeneralAttrCheck.ELE_CONTEXT_GLOBAL;
        Hashtable attrValues = this.generalCheck(root, scope);
        this.fTargetNSURIString = this.getTargetNamespaceString(root);
        this.fTargetNSURI = this.fStringPool.addSymbol(this.fTargetNSURIString);
        if (this.fGrammarResolver == null) {
            this.reportGenericSchemaError("Internal error: don't have a GrammarResolver for TraverseSchema");
        } else {
            if (this.fSchemaGrammar.getComplexTypeRegistry() == null) {
                this.fSchemaGrammar.setComplexTypeRegistry(this.fComplexTypeRegistry);
            } else {
                this.fComplexTypeRegistry = this.fSchemaGrammar.getComplexTypeRegistry();
            }
            if (this.fSchemaGrammar.getAttributeDeclRegistry() == null) {
                this.fSchemaGrammar.setAttributeDeclRegistry(this.fAttributeDeclRegistry);
            } else {
                this.fAttributeDeclRegistry = this.fSchemaGrammar.getAttributeDeclRegistry();
            }
            if (this.fSchemaGrammar.getNamespacesScope() == null) {
                this.fSchemaGrammar.setNamespacesScope(this.fNamespacesScope);
            } else {
                this.fNamespacesScope = this.fSchemaGrammar.getNamespacesScope();
            }
            this.fSchemaGrammar.setDatatypeRegistry(this.fDatatypeRegistry);
            this.fSchemaGrammar.setTargetNamespaceURI(this.fTargetNSURIString);
            this.fGrammarResolver.putGrammar(this.fTargetNSURIString, this.fSchemaGrammar);
        }
        NamedNodeMap schemaEltAttrs = root.getAttributes();
        int i = 0;
        Attr sattr = null;
        boolean seenXMLNS = false;
        while ((sattr = (Attr)schemaEltAttrs.item(i++)) != null) {
            String attValue;
            String attName = sattr.getName();
            if (attName.startsWith("xmlns:")) {
                attValue = sattr.getValue();
                String prefix = attName.substring(attName.indexOf(":") + 1);
                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(prefix), this.fStringPool.addSymbol(attValue));
            }
            if (!attName.equals("xmlns")) continue;
            attValue = sattr.getValue();
            this.fNamespacesScope.setNamespaceForPrefix(0, this.fStringPool.addSymbol(attValue));
            seenXMLNS = true;
        }
        if (!seenXMLNS && this.fTargetNSURIString.length() == 0) {
            this.fNamespacesScope.setNamespaceForPrefix(0, 0);
        }
        this.fElementDefaultQualified = root.getAttribute("elementFormDefault").equals("qualified");
        this.fAttributeDefaultQualified = root.getAttribute("attributeFormDefault").equals("qualified");
        Attr blockAttr = root.getAttributeNode("blockDefault");
        this.fBlockDefault = blockAttr == null ? 0 : this.parseBlockSet(blockAttr.getValue());
        Attr finalAttr = root.getAttributeNode("finalDefault");
        this.fFinalDefault = finalAttr == null ? 0 : this.parseFinalSet(finalAttr.getValue());
        this.extractTopLevel3Components(root);
        Element child = XUtil.getFirstChildElement(root);
        while (child != null) {
            name = child.getLocalName();
            if (name.equals("annotation")) {
                this.traverseAnnotationDecl(child);
            } else if (name.equals("include")) {
                this.fNamespacesScope.increaseDepth();
                this.traverseInclude(child);
                this.fNamespacesScope.decreaseDepth();
            } else if (name.equals("import")) {
                this.traverseImport(child);
            } else {
                if (!name.equals("redefine")) break;
                this.fRedefineSucceeded = true;
                this.traverseRedefine(child);
            }
            child = XUtil.getNextSiblingElement(child);
        }
        while (child != null) {
            name = child.getLocalName();
            if (name.equals("annotation")) {
                this.traverseAnnotationDecl(child);
            } else if (name.equals("simpleType")) {
                this.traverseSimpleTypeDecl(child);
            } else if (name.equals("complexType")) {
                this.traverseComplexTypeDecl(child);
            } else if (name.equals("element")) {
                this.traverseElementDecl(child);
            } else if (name.equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(child, null, null);
            } else if (name.equals("attribute")) {
                this.traverseAttributeDecl(child, null, false);
            } else if (name.equals("group")) {
                this.traverseGroupDecl(child);
            } else if (name.equals("notation")) {
                this.traverseNotationDecl(child);
            } else {
                this.reportGenericSchemaError("error in content of <schema> element information item");
            }
            child = XUtil.getNextSiblingElement(child);
        }
        Enumeration elementIndexes = this.fIdentityConstraints.keys();
        while (elementIndexes.hasMoreElements()) {
            elementIndexObj = (Integer)elementIndexes.nextElement();
            identityConstraints = (Vector)this.fIdentityConstraints.get(elementIndexObj);
            if (identityConstraints == null) continue;
            elementIndex = elementIndexObj;
            this.traverseIdentityNameConstraintsFor(elementIndex, identityConstraints);
        }
        elementIndexes = this.fIdentityConstraints.keys();
        while (elementIndexes.hasMoreElements()) {
            elementIndexObj = (Integer)elementIndexes.nextElement();
            identityConstraints = (Vector)this.fIdentityConstraints.get(elementIndexObj);
            if (identityConstraints == null) continue;
            elementIndex = elementIndexObj;
            this.traverseIdentityRefConstraintsFor(elementIndex, identityConstraints);
        }
        if (this.fFullConstraintChecking) {
            int j = 0;
            while (j < this.fTopLevelElementsRefdFromGroup.size()) {
                QName eltName = (QName)this.fTopLevelElementsRefdFromGroup.elementAt(j);
                int groupScope = (Integer)this.fTopLevelElementsRefdFromGroup.elementAt(j + 1);
                this.checkConsistentElements(eltName, groupScope);
                j += 2;
            }
            int count = this.fComplexTypeRegistry.size();
            Enumeration enumeration = this.fComplexTypeRegistry.elements();
            while (enumeration.hasMoreElements()) {
                ComplexTypeInfo typeInfo = (ComplexTypeInfo)enumeration.nextElement();
                ComplexTypeInfo baseTypeInfo = typeInfo.baseComplexTypeInfo;
                if (typeInfo.derivedBy != 2 || baseTypeInfo == null || typeInfo.contentSpecHandle <= -1) continue;
                try {
                    this.checkParticleDerivationOK(typeInfo.contentSpecHandle, typeInfo.scopeDefined, baseTypeInfo.contentSpecHandle, baseTypeInfo.scopeDefined, baseTypeInfo);
                }
                catch (ParticleRecoverableError e) {
                    String message = e.getMessage();
                    this.reportGenericSchemaError("ComplexType '" + typeInfo.typeName + "': " + message);
                }
            }
        }
    }

    private void extractTopLevel3Components(Element root) throws Exception {
        Element child = XUtil.getFirstChildElement(root);
        while (child != null) {
            String name = child.getLocalName();
            String compName = child.getAttribute("name");
            if (name.equals("element")) {
                if (this.fSchemaGrammar.topLevelElemDecls.get(compName) != null) {
                    this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for an element " + compName);
                } else {
                    this.fSchemaGrammar.topLevelElemDecls.put(compName, child);
                }
            } else if (name.equals("simpleType") || name.equals("complexType")) {
                if (this.fSchemaGrammar.topLevelTypeDecls.get(compName) != null) {
                    this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for a type " + compName);
                } else {
                    this.fSchemaGrammar.topLevelTypeDecls.put(compName, child);
                }
            } else if (name.equals("attributeGroup")) {
                if (this.fSchemaGrammar.topLevelAttrGrpDecls.get(compName) != null) {
                    this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for an attribute group " + compName);
                } else {
                    this.fSchemaGrammar.topLevelAttrGrpDecls.put(compName, child);
                }
            } else if (name.equals("attribute")) {
                if (this.fSchemaGrammar.topLevelAttrGrpDecls.get(compName) != null) {
                    this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for an attribute " + compName);
                } else {
                    this.fSchemaGrammar.topLevelAttrGrpDecls.put(compName, child);
                }
            } else if (name.equals("group")) {
                if (this.fSchemaGrammar.topLevelGroupDecls.get(compName) != null) {
                    this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for a group " + compName);
                } else {
                    this.fSchemaGrammar.topLevelGroupDecls.put(compName, child);
                }
            } else if (name.equals("notation")) {
                if (this.fSchemaGrammar.topLevelNotationDecls.get(compName) != null) {
                    this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for a notation " + compName);
                } else {
                    this.fSchemaGrammar.topLevelNotationDecls.put(compName, child);
                }
            }
            child = XUtil.getNextSiblingElement(child);
        }
    }

    private void checkConsistentElements(QName eltName, int scope) throws Exception {
        this.fTempElementDecl.clear();
        int topLevelElementNdx = this.fSchemaGrammar.getElementDeclIndex(eltName, -1);
        if (topLevelElementNdx < 0) {
            return;
        }
        this.fSchemaGrammar.getElementDecl(topLevelElementNdx, this.fTempElementDecl);
        DatatypeValidator edv = this.fTempElementDecl.datatypeValidator;
        ComplexTypeInfo eTypeInfo = this.fSchemaGrammar.getElementComplexTypeInfo(topLevelElementNdx);
        int existingEltNdx = this.fSchemaGrammar.getElementDeclIndex(eltName.uri, eltName.localpart, scope);
        if (existingEltNdx > -1 && !this.checkDuplicateElementTypes(existingEltNdx, eTypeInfo, edv)) {
            this.reportGenericSchemaError("duplicate element decl in the same scope with different types : " + this.fStringPool.toString(eltName.localpart));
        }
        Vector substitutableNames = this.fSchemaGrammar.getElementDeclAllSubstitutionGroupQNames(topLevelElementNdx, this.fGrammarResolver, this.fStringPool);
        int i = 0;
        while (i < substitutableNames.size()) {
            SchemaGrammar.OneSubGroup subGroup = (SchemaGrammar.OneSubGroup)substitutableNames.elementAt(i);
            QName substName = subGroup.name;
            int substEltNdx = subGroup.eleIndex;
            int localEltNdx = this.fSchemaGrammar.getElementDeclIndex(substName, scope);
            if (localEltNdx > -1) {
                this.fSchemaGrammar.getElementDecl(localEltNdx, this.fTempElementDecl);
                edv = this.fTempElementDecl.datatypeValidator;
                eTypeInfo = this.fSchemaGrammar.getElementComplexTypeInfo(localEltNdx);
                if (!this.checkDuplicateElementTypes(substEltNdx, eTypeInfo, edv)) {
                    this.reportGenericSchemaError("duplicate element decl in the same scope with different types : " + this.fStringPool.toString(substName.localpart));
                }
            }
            ++i;
        }
    }

    private String expandSystemId(String systemId, String currentSystemId) throws Exception {
        String id = systemId;
        if (id == null || id.length() == 0) {
            return systemId;
        }
        try {
            URL url = new URL(id);
            if (url != null) {
                return systemId;
            }
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        id = TraverseSchema.fixURI(id);
        URL base = null;
        URL url = null;
        try {
            if (currentSystemId == null) {
                String dir;
                try {
                    dir = TraverseSchema.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException se) {
                    dir = "";
                }
                if (!dir.endsWith("/")) {
                    dir = String.valueOf(dir) + "/";
                }
                base = new URL("file", "", dir);
            } else {
                base = new URL(currentSystemId);
            }
            url = new URL(base, id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (url == null) {
            return systemId;
        }
        return url.toString();
    }

    private static String fixURI(String str) {
        char ch0;
        char ch1;
        if ((str = str.replace(File.separatorChar, '/')).length() >= 2 && (ch1 = str.charAt(1)) == ':' && (ch0 = Character.toUpperCase(str.charAt(0))) >= 'A' && ch0 <= 'Z') {
            str = "/" + str;
        }
        return str;
    }

    private void traverseInclude(Element includeDecl) throws Exception {
        int scope = GeneralAttrCheck.ELE_CONTEXT_GLOBAL;
        Hashtable attrValues = this.generalCheck(includeDecl, scope);
        this.checkContent(includeDecl, XUtil.getFirstChildElement(includeDecl), true);
        Attr locationAttr = includeDecl.getAttributeNode("schemaLocation");
        if (locationAttr == null) {
            this.reportGenericSchemaError("a schemaLocation attribute must be specified on an <include> element");
            return;
        }
        String location = locationAttr.getValue();
        InputSource source = null;
        if (this.fEntityResolver != null && !this.fEntityResolver.getClass().getName().equals("org.apache.xerces.validators.common.XMLValidator$Resolver")) {
            source = this.fEntityResolver.resolveEntity("", location);
        }
        if (source == null) {
            location = this.expandSystemId(location, this.fCurrentSchemaURL);
            source = new InputSource(location);
        }
        String pubId = "";
        String sysId = "";
        if (source.getPublicId() != null) {
            pubId = source.getPublicId();
        }
        if (source.getSystemId() != null) {
            sysId = source.getSystemId();
        }
        if (pubId.length() != 0 || sysId.length() != 0) {
            location = String.valueOf(pubId) + sysId;
        }
        if (this.fIncludeLocations.contains(location)) {
            return;
        }
        this.fIncludeLocations.addElement(location);
        IgnoreWhitespaceParser parser = new IgnoreWhitespaceParser();
        parser.setEntityResolver(this.fEntityResolver != null ? this.fEntityResolver : new Resolver());
        parser.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException ex) throws SAXException {
                StringBuffer str = new StringBuffer();
                String systemId_ = ex.getSystemId();
                if (systemId_ != null) {
                    int index = systemId_.lastIndexOf(47);
                    if (index != -1) {
                        systemId_ = systemId_.substring(index + 1);
                    }
                    str.append(systemId_);
                }
                str.append(':').append(ex.getLineNumber()).append(':').append(ex.getColumnNumber());
                String message = ex.getMessage();
                if (!message.toLowerCase().trim().endsWith("not found.")) {
                    System.err.println("[Error] " + str.toString() + ":" + message);
                    throw ex;
                }
                System.err.println("[Warning] " + str.toString() + ": " + message);
            }
        });
        try {
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
        try {
            parser.parse(source);
        }
        catch (IOException e) {
        }
        catch (SAXException e) {
            // empty catch block
        }
        Document document = parser.getDocument();
        Element root = null;
        if (document != null) {
            root = document.getDocumentElement();
        }
        if (root != null) {
            String targetNSURI = this.getTargetNamespaceString(root);
            if (targetNSURI.length() > 0 && !targetNSURI.equals(this.fTargetNSURIString)) {
                this.reportGenericSchemaError("included schema '" + location + "' has a different targetNameSpace '" + targetNSURI + "'");
            } else {
                if (this.fSchemaInfoListRoot == null) {
                    this.fCurrentSchemaInfo = this.fSchemaInfoListRoot = new SchemaInfo(this.fElementDefaultQualified, this.fAttributeDefaultQualified, this.fBlockDefault, this.fFinalDefault, this.fCurrentSchemaURL, this.fSchemaRootElement, this.fNamespacesScope, null, null);
                }
                this.fSchemaRootElement = root;
                this.fSchemaURLStack.push(this.fCurrentSchemaURL);
                this.fCurrentSchemaURL = location;
                this.traverseIncludedSchemaHeader(root);
                if (this.fTargetNSURIString.length() != 0 && root.getAttributeNode("xmlns") == null) {
                    this.fNamespacesScope.setNamespaceForPrefix(0, this.fTargetNSURI);
                }
                this.fCurrentSchemaInfo = new SchemaInfo(this.fElementDefaultQualified, this.fAttributeDefaultQualified, this.fBlockDefault, this.fFinalDefault, this.fCurrentSchemaURL, this.fSchemaRootElement, this.fNamespacesScope, this.fCurrentSchemaInfo.getNext(), this.fCurrentSchemaInfo);
                this.fCurrentSchemaInfo.getPrev().setNext(this.fCurrentSchemaInfo);
                this.traverseIncludedSchema(root);
                this.fCurrentSchemaInfo = this.fCurrentSchemaInfo.getPrev();
                this.fCurrentSchemaInfo.restore();
                this.fCurrentSchemaURL = (String)this.fSchemaURLStack.pop();
            }
        }
    }

    private void traverseIncludedSchemaHeader(Element root) throws Exception {
        int scope = GeneralAttrCheck.ELE_CONTEXT_GLOBAL;
        Hashtable attrValues = this.generalCheck(root, scope);
        NamedNodeMap schemaEltAttrs = root.getAttributes();
        int i = 0;
        Attr sattr = null;
        boolean seenXMLNS = false;
        while ((sattr = (Attr)schemaEltAttrs.item(i++)) != null) {
            String attValue;
            String attName = sattr.getName();
            if (attName.startsWith("xmlns:")) {
                attValue = sattr.getValue();
                String prefix = attName.substring(attName.indexOf(":") + 1);
                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(prefix), this.fStringPool.addSymbol(attValue));
            }
            if (!attName.equals("xmlns")) continue;
            attValue = sattr.getValue();
            this.fNamespacesScope.setNamespaceForPrefix(0, this.fStringPool.addSymbol(attValue));
            seenXMLNS = true;
        }
        if (!seenXMLNS && this.fTargetNSURIString.length() == 0) {
            this.fNamespacesScope.setNamespaceForPrefix(0, 0);
        }
        this.fElementDefaultQualified = root.getAttribute("elementFormDefault").equals("qualified");
        this.fAttributeDefaultQualified = root.getAttribute("attributeFormDefault").equals("qualified");
        Attr blockAttr = root.getAttributeNode("blockDefault");
        this.fBlockDefault = blockAttr == null ? 0 : this.parseBlockSet(blockAttr.getValue());
        Attr finalAttr = root.getAttributeNode("finalDefault");
        this.fFinalDefault = finalAttr == null ? 0 : this.parseFinalSet(finalAttr.getValue());
        if (this.fTargetNSURI == 0) {
            this.fElementDefaultQualified = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void traverseIncludedSchema(Element root) throws Exception {
        String name;
        int scope = GeneralAttrCheck.ELE_CONTEXT_GLOBAL;
        Hashtable attrValues = this.generalCheck(root, scope);
        this.extractTopLevel3Components(root);
        Element child = XUtil.getFirstChildElement(root);
        while (child != null) {
            name = child.getLocalName();
            if (name.equals("annotation")) {
                this.traverseAnnotationDecl(child);
            } else if (name.equals("include")) {
                this.fNamespacesScope.increaseDepth();
                this.traverseInclude(child);
                this.fNamespacesScope.decreaseDepth();
            } else if (name.equals("import")) {
                this.traverseImport(child);
            } else {
                if (!name.equals("redefine")) break;
                this.fRedefineSucceeded = true;
                this.traverseRedefine(child);
            }
            child = XUtil.getNextSiblingElement(child);
        }
        while (child != null) {
            block18: {
                block25: {
                    String dName;
                    String bName;
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            name = child.getLocalName();
                                            if (!name.equals("annotation")) break block19;
                                            this.traverseAnnotationDecl(child);
                                            break block18;
                                        }
                                        if (!name.equals("simpleType")) break block20;
                                        this.traverseSimpleTypeDecl(child);
                                        break block18;
                                    }
                                    if (!name.equals("complexType")) break block21;
                                    this.traverseComplexTypeDecl(child);
                                    break block18;
                                }
                                if (!name.equals("element")) break block22;
                                this.traverseElementDecl(child);
                                break block18;
                            }
                            if (!name.equals("attributeGroup")) break block23;
                            if (this.fRedefineAttributeGroupMap != null && (bName = (String)this.fRedefineAttributeGroupMap.get(dName = child.getAttribute("name"))) != null) {
                                child.setAttribute("name", bName);
                                this.fSchemaGrammar.topLevelAttrGrpDecls.remove(dName);
                                ComplexTypeInfo typeInfo = new ComplexTypeInfo();
                                int templateElementNameIndex = this.fStringPool.addSymbol("$" + bName);
                                int typeNameIndex = this.fStringPool.addSymbol("%" + bName);
                                typeInfo.scopeDefined = -2;
                                typeInfo.contentSpecHandle = -1;
                                typeInfo.contentType = 5;
                                typeInfo.datatypeValidator = null;
                                typeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, templateElementNameIndex, typeNameIndex, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : -2, typeInfo.scopeDefined, typeInfo.contentType, typeInfo.contentSpecHandle, -1, typeInfo.datatypeValidator);
                                Vector anyAttDecls = new Vector();
                                this.traverseAttributeGroupDecl(child, typeInfo, anyAttDecls);
                                typeInfo.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(typeInfo.templateElementIndex);
                                this.fRedefineAttributeGroupMap.put(dName, new Object[]{typeInfo, this.fSchemaGrammar, anyAttDecls});
                                break block18;
                            } else {
                                this.traverseAttributeGroupDecl(child, null, null);
                            }
                            break block18;
                        }
                        if (!name.equals("attribute")) break block24;
                        this.traverseAttributeDecl(child, null, false);
                        break block18;
                    }
                    if (!name.equals("group")) break block25;
                    dName = child.getAttribute("name");
                    if (this.fGroupNameRegistry.get(String.valueOf(this.fTargetNSURIString) + "," + dName) == null) {
                        this.traverseGroupDecl(child);
                        break block18;
                    } else {
                        try {
                            GroupInfo gi = (GroupInfo)this.fGroupNameRegistry.get(String.valueOf(this.fTargetNSURIString) + "," + dName);
                        }
                        catch (ClassCastException c) {
                            String s = (String)this.fGroupNameRegistry.get(String.valueOf(this.fTargetNSURIString) + "," + dName);
                            if (s != null) {
                                bName = (String)this.fGroupNameRegistry.get(String.valueOf(this.fTargetNSURIString) + "," + dName);
                                if (bName != null) {
                                    child.setAttribute("name", bName);
                                }
                                this.traverseGroupDecl(child);
                            }
                            break block18;
                        }
                    }
                }
                if (name.equals("notation")) {
                    this.traverseNotationDecl(child);
                } else {
                    this.reportGenericSchemaError("error in content of included <schema> element information item");
                }
            }
            child = XUtil.getNextSiblingElement(child);
        }
    }

    private void openRedefinedSchema(Element redefineDecl, SchemaInfo store) throws Exception {
        Attr locationAttr = redefineDecl.getAttributeNode("schemaLocation");
        if (locationAttr == null) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("a schemaLocation attribute must be specified on a <redefine> element");
            return;
        }
        String location = locationAttr.getValue();
        InputSource source = null;
        if (this.fEntityResolver != null) {
            source = this.fEntityResolver.resolveEntity("", location);
        }
        if (source == null) {
            location = this.expandSystemId(location, this.fCurrentSchemaURL);
            source = new InputSource(location);
        }
        String pubId = "";
        String sysId = "";
        if (source.getPublicId() != null) {
            pubId = source.getPublicId();
        }
        if (source.getSystemId() != null) {
            sysId = source.getSystemId();
        }
        if (pubId.length() != 0 || sysId.length() != 0) {
            location = String.valueOf(location) + pubId + sysId;
        }
        if (source.getSystemId().equals(this.fCurrentSchemaURL)) {
            this.reportGenericSchemaError("src-redefine.2:  a schema cannot redefine itself");
            this.fRedefineSucceeded = false;
            return;
        }
        if (this.fRedefineLocations.get(location) != null) {
            this.fCurrentSchemaInfo = (SchemaInfo)this.fRedefineLocations.get(location);
            this.fCurrentSchemaInfo.restore();
            return;
        }
        IgnoreWhitespaceParser parser = new IgnoreWhitespaceParser();
        parser.setEntityResolver(this.fEntityResolver != null ? this.fEntityResolver : new Resolver());
        parser.setErrorHandler(new ErrorHandler());
        try {
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
        try {
            parser.parse(source);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            // empty catch block
        }
        Document document = parser.getDocument();
        Element root = null;
        if (document != null) {
            root = document.getDocumentElement();
        }
        if (root == null) {
            this.fRedefineSucceeded = false;
            return;
        }
        String redefinedTargetNSURIString = this.getTargetNamespaceString(root);
        if (redefinedTargetNSURIString.length() > 0 && !redefinedTargetNSURIString.equals(this.fTargetNSURIString)) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("redefined schema '" + location + "' has a different targetNameSpace '" + redefinedTargetNSURIString + "' from the original schema");
        } else {
            this.fSchemaRootElement = root;
            this.fCurrentSchemaURL = location;
            this.fNamespacesScope = new NamespacesScope(this);
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol("xml"), this.fStringPool.addSymbol("http://www.w3.org/XML/1998/namespace"));
            if (redefinedTargetNSURIString.length() == 0 && root.getAttributeNode("xmlns") == null) {
                this.fNamespacesScope.setNamespaceForPrefix(0, this.fTargetNSURI);
            }
            this.traverseIncludedSchemaHeader(root);
            store.setNext(new SchemaInfo(this.fElementDefaultQualified, this.fAttributeDefaultQualified, this.fBlockDefault, this.fFinalDefault, this.fCurrentSchemaURL, this.fSchemaRootElement, this.fNamespacesScope, null, store));
            store.getNext().setPrev(store);
            this.fCurrentSchemaInfo = store.getNext();
            this.fRedefineLocations.put(location, store.getNext());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void traverseRedefine(Element redefineDecl) throws Exception {
        scope = GeneralAttrCheck.ELE_CONTEXT_GLOBAL;
        attrValues = this.generalCheck(redefineDecl, scope);
        this.fRedefineAttributeGroupMap = new Hashtable<K, V>();
        saveNSScope = (NamespacesScope)this.fNamespacesScope.clone();
        if (this.fSchemaInfoListRoot == null) {
            this.fSchemaInfoListRoot = new SchemaInfo(this.fElementDefaultQualified, this.fAttributeDefaultQualified, this.fBlockDefault, this.fFinalDefault, this.fCurrentSchemaURL, this.fSchemaRootElement, this.fNamespacesScope, null, null);
            this.openRedefinedSchema(redefineDecl, this.fSchemaInfoListRoot);
            if (!this.fRedefineSucceeded) {
                return;
            }
            this.fCurrentSchemaInfo = this.fSchemaInfoListRoot.getNext();
            this.fNamespacesScope = (NamespacesScope)saveNSScope.clone();
            this.renameRedefinedComponents(redefineDecl, this.fSchemaInfoListRoot.getNext().getRoot(), this.fSchemaInfoListRoot.getNext());
        } else {
            curr = this.fSchemaInfoListRoot;
            while (curr.getNext() != null) {
                curr = curr.getNext();
            }
            this.fCurrentSchemaInfo = curr;
            this.fCurrentSchemaInfo.restore();
            this.openRedefinedSchema(redefineDecl, this.fCurrentSchemaInfo);
            if (!this.fRedefineSucceeded) {
                return;
            }
            this.fNamespacesScope = (NamespacesScope)saveNSScope.clone();
            this.renameRedefinedComponents(redefineDecl, this.fCurrentSchemaInfo.getRoot(), this.fCurrentSchemaInfo);
        }
        this.fCurrentSchemaInfo.restore();
        this.traverseIncludedSchema(this.fSchemaRootElement);
        this.fNamespacesScope = (NamespacesScope)saveNSScope.clone();
        child = XUtil.getFirstChildElement(redefineDecl);
        while (child != null) {
            block23: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                name = child.getLocalName();
                                if (!name.equals("annotation")) break block24;
                                this.traverseAnnotationDecl(child);
                                break block23;
                            }
                            if (!name.equals("simpleType")) break block25;
                            this.traverseSimpleTypeDecl(child);
                            break block23;
                        }
                        if (!name.equals("complexType")) break block26;
                        this.traverseComplexTypeDecl(child);
                        break block23;
                    }
                    if (!name.equals("group")) break block27;
                    dName = child.getAttribute("name");
                    if (this.fGroupNameRegistry.get(String.valueOf(this.fTargetNSURIString) + "," + dName) == null || this.fRestrictedRedefinedGroupRegistry.get(String.valueOf(this.fTargetNSURIString) + "," + dName) != null && !((Boolean)this.fRestrictedRedefinedGroupRegistry.get(String.valueOf(this.fTargetNSURIString) + "," + dName)).booleanValue()) {
                        this.traverseGroupDecl(child);
                    } else {
                        this.traverseGroupDecl(child);
                        bGIObj = null;
                        try {
                            bGIObj = (GroupInfo)this.fGroupNameRegistry.get(String.valueOf(this.fTargetNSURIString) + "," + dName + "_fn3dktizrknc9pi");
                        }
                        catch (ClassCastException c) {
                            this.reportGenericSchemaError("src-redefine.6.2:  a <group> within a <redefine> must either have a ref to a <group> with the same name or must restrict such an <group>");
                            break block23;
                        }
                        if (bGIObj != null) {
                            bCSIndex = bGIObj.contentSpecIndex;
                            try {
                                dGIObj = (GroupInfo)this.fGroupNameRegistry.get(String.valueOf(this.fTargetNSURIString) + "," + dName);
                            }
                            catch (ClassCastException c) {
                                break block23;
                            }
                            if (dGIObj != null) {
                                dCSIndex = dGIObj.contentSpecIndex;
                                try {
                                    this.checkParticleDerivationOK(dCSIndex, -1, bCSIndex, -1, null);
                                }
                                catch (ParticleRecoverableError e) {
                                    this.reportGenericSchemaError(e.getMessage());
                                }
                            }
                        } else {
                            this.reportGenericSchemaError("src-redefine.6.2:  a <group> within a <redefine> must either have a ref to a <group> with the same name or must restrict such an <group>");
                        }
                    }
                    break block23;
                }
                if (!name.equals("attributeGroup")) break block23;
                if (this.fRedefineAttributeGroupMap == null) ** GOTO lbl-1000
                dName = child.getAttribute("name");
                bAttGrpStore = null;
                try {
                    bAttGrpStore = (Object[])this.fRedefineAttributeGroupMap.get(dName);
                }
                catch (ClassCastException c) {
                    this.reportGenericSchemaError("src-redefine.7.2:  an <attributeGroup> within a <redefine> must either have a ref to an <attributeGroup> with the same name or must restrict such an <attributeGroup>");
                    break block23;
                }
                if (bAttGrpStore != null) {
                    bTypeInfo = (ComplexTypeInfo)bAttGrpStore[0];
                    bSchemaGrammar = (SchemaGrammar)bAttGrpStore[1];
                    bAnyAttDecls = (Vector)bAttGrpStore[2];
                    bAnyAttDecl = bAnyAttDecls.size() > 0 ? (XMLAttributeDecl)bAnyAttDecls.elementAt(0) : null;
                    dTypeInfo = new ComplexTypeInfo();
                    templateElementNameIndex = this.fStringPool.addSymbol("$" + dName);
                    dTypeNameIndex = this.fStringPool.addSymbol("%" + dName);
                    dTypeInfo.scopeDefined = -2;
                    dTypeInfo.contentSpecHandle = -1;
                    dTypeInfo.contentType = 5;
                    dTypeInfo.datatypeValidator = null;
                    dTypeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, templateElementNameIndex, dTypeNameIndex, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : -2, dTypeInfo.scopeDefined, dTypeInfo.contentType, dTypeInfo.contentSpecHandle, -1, dTypeInfo.datatypeValidator);
                    dAnyAttDecls = new Vector<E>();
                    dAnyAttDecl = dAnyAttDecls.size() > 0 ? (XMLAttributeDecl)dAnyAttDecls.elementAt(0) : null;
                    this.traverseAttributeGroupDecl(child, dTypeInfo, dAnyAttDecls);
                    dTypeInfo.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(dTypeInfo.templateElementIndex);
                    try {
                        this.checkAttributesDerivationOKRestriction(dTypeInfo.attlistHead, this.fSchemaGrammar, dAnyAttDecl, bTypeInfo.attlistHead, bSchemaGrammar, bAnyAttDecl);
                    }
                    catch (ComplexTypeRecoverableError e) {
                        message = e.getMessage();
                        this.reportGenericSchemaError("src-redefine.7.2:  redefinition failed because of " + message);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    this.traverseAttributeGroupDecl(child, null, null);
                }
            }
            child = XUtil.getNextSiblingElement(child);
        }
        this.fCurrentSchemaInfo = this.fCurrentSchemaInfo.getPrev();
        this.fCurrentSchemaInfo.restore();
    }

    private void renameRedefinedComponents(Element redefineDecl, Element schemaToRedefine, SchemaInfo currSchemaInfo) throws Exception {
        Element child = XUtil.getFirstChildElement(redefineDecl);
        while (child != null) {
            String name = child.getLocalName();
            if (!name.equals("annotation")) {
                String baseName;
                String typeName;
                if (name.equals("simpleType")) {
                    typeName = child.getAttribute("name");
                    if (!this.fTraversedRedefineElements.contains(typeName) && this.validateRedefineNameChange("simpleType", typeName, String.valueOf(typeName) + redefIdentifier, child)) {
                        this.fixRedefinedSchema("simpleType", typeName, String.valueOf(typeName) + redefIdentifier, schemaToRedefine, currSchemaInfo);
                    }
                } else if (name.equals("complexType")) {
                    typeName = child.getAttribute("name");
                    if (!this.fTraversedRedefineElements.contains(typeName) && this.validateRedefineNameChange("complexType", typeName, String.valueOf(typeName) + redefIdentifier, child)) {
                        this.fixRedefinedSchema("complexType", typeName, String.valueOf(typeName) + redefIdentifier, schemaToRedefine, currSchemaInfo);
                    }
                } else if (name.equals("attributeGroup")) {
                    baseName = child.getAttribute("name");
                    if (!this.fTraversedRedefineElements.contains(baseName) && this.validateRedefineNameChange("attributeGroup", baseName, String.valueOf(baseName) + redefIdentifier, child)) {
                        this.fixRedefinedSchema("attributeGroup", baseName, String.valueOf(baseName) + redefIdentifier, schemaToRedefine, currSchemaInfo);
                    }
                } else if (name.equals("group")) {
                    baseName = child.getAttribute("name");
                    if (!this.fTraversedRedefineElements.contains(baseName) && this.validateRedefineNameChange("group", baseName, String.valueOf(baseName) + redefIdentifier, child)) {
                        this.fixRedefinedSchema("group", baseName, String.valueOf(baseName) + redefIdentifier, schemaToRedefine, currSchemaInfo);
                    }
                } else {
                    this.fRedefineSucceeded = false;
                    this.reportGenericSchemaError("invalid top-level content for <redefine>");
                    return;
                }
            }
            child = XUtil.getNextSiblingElement(child);
        }
    }

    private int changeRedefineGroup(QName originalName, String elementSought, String newName, Element curr) throws Exception {
        int result = 0;
        Element child = XUtil.getFirstChildElement(curr);
        while (child != null) {
            String name = child.getLocalName();
            if (!name.equals(elementSought)) {
                result += this.changeRedefineGroup(originalName, elementSought, newName, child);
            } else {
                String ref = child.getAttribute("ref");
                if (ref.length() != 0) {
                    String prefix = "";
                    String localpart = ref;
                    int colonptr = ref.indexOf(":");
                    if (colonptr > 0) {
                        prefix = ref.substring(0, colonptr);
                        localpart = ref.substring(colonptr + 1);
                    }
                    String uriStr = this.resolvePrefixToURI(prefix);
                    if (originalName.equals(new QName(-1, this.fStringPool.addSymbol(localpart), this.fStringPool.addSymbol(localpart), this.fStringPool.addSymbol(uriStr)))) {
                        if (prefix.length() == 0) {
                            child.setAttribute("ref", newName);
                        } else {
                            child.setAttribute("ref", String.valueOf(prefix) + ":" + newName);
                        }
                        ++result;
                        if (elementSought.equals("group")) {
                            String minOccurs = child.getAttribute("minOccurs");
                            String maxOccurs = child.getAttribute("maxOccurs");
                            if (maxOccurs.length() != 0 && !maxOccurs.equals("1") || minOccurs.length() != 0 && !minOccurs.equals("1")) {
                                this.reportGenericSchemaError("src-redefine.6.1.2:  the group " + ref + " which contains a reference to a group being redefined must have minOccurs = maxOccurs = 1");
                            }
                        }
                    }
                }
            }
            child = XUtil.getNextSiblingElement(child);
        }
        return result;
    }

    private void fixRedefinedSchema(String eltLocalname, String oldName, String newName, Element schemaToRedefine, SchemaInfo currSchema) throws Exception {
        boolean foundIt = false;
        Element child = XUtil.getFirstChildElement(schemaToRedefine);
        while (child != null) {
            String infoItemName;
            String name = child.getLocalName();
            if (name.equals("redefine")) {
                Element redefChild = XUtil.getFirstChildElement(child);
                while (redefChild != null) {
                    String infoItemName2;
                    String redefName = redefChild.getLocalName();
                    if (redefName.equals(eltLocalname) && (infoItemName2 = redefChild.getAttribute("name")).equals(oldName)) {
                        foundIt = true;
                        this.openRedefinedSchema(child, currSchema);
                        if (!this.fRedefineSucceeded) {
                            return;
                        }
                        NamespacesScope saveNSS = (NamespacesScope)this.fNamespacesScope.clone();
                        currSchema.restore();
                        if (this.validateRedefineNameChange(eltLocalname, oldName, String.valueOf(newName) + redefIdentifier, redefChild) && currSchema.getNext() != null) {
                            currSchema.getNext().restore();
                            this.fixRedefinedSchema(eltLocalname, oldName, String.valueOf(newName) + redefIdentifier, this.fSchemaRootElement, currSchema.getNext());
                        }
                        this.fNamespacesScope = saveNSS;
                        redefChild.setAttribute("name", newName);
                        this.fTraversedRedefineElements.addElement(newName);
                        currSchema.restore();
                        this.fCurrentSchemaInfo = currSchema;
                        break;
                    }
                    redefChild = XUtil.getNextSiblingElement(redefChild);
                }
                if (foundIt) {
                    break;
                }
            } else if (name.equals(eltLocalname) && (infoItemName = child.getAttribute("name")).equals(oldName)) {
                foundIt = true;
                child.setAttribute("name", newName);
                break;
            }
            child = XUtil.getNextSiblingElement(child);
        }
        if (!foundIt) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("could not find a declaration in the schema to be redefined corresponding to " + oldName);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean validateRedefineNameChange(String eltLocalname, String oldName, String newName, Element child) throws Exception {
        if (eltLocalname.equals("simpleType")) {
            QName processedTypeName = new QName(-1, this.fStringPool.addSymbol(oldName), this.fStringPool.addSymbol(oldName), this.fTargetNSURI);
            Element grandKid = XUtil.getFirstChildElement(child);
            if (grandKid == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a simpleType child of a <redefine> must have a restriction element as a child");
                return false;
            }
            String grandKidName = grandKid.getLocalName();
            if (grandKidName.equals("annotation")) {
                grandKid = XUtil.getNextSiblingElement(grandKid);
                grandKidName = grandKid.getLocalName();
            }
            if (grandKid == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a simpleType child of a <redefine> must have a restriction element as a child");
                return false;
            }
            if (!grandKidName.equals("restriction")) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a simpleType child of a <redefine> must have a restriction element as a child");
                return false;
            }
            String derivedBase = grandKid.getAttribute("base");
            QName processedDerivedBase = this.parseBase(derivedBase);
            if (!processedTypeName.equals(processedDerivedBase)) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("the base attribute of the restriction child of a simpleType child of a redefine must have the same value as the simpleType's type attribute");
                return false;
            }
            String prefix = "";
            int colonptr = derivedBase.indexOf(":");
            if (colonptr > 0) {
                prefix = String.valueOf(derivedBase.substring(0, colonptr)) + ":";
            }
            grandKid.setAttribute("base", String.valueOf(prefix) + newName);
            return true;
        }
        if (eltLocalname.equals("complexType")) {
            QName processedTypeName = new QName(-1, this.fStringPool.addSymbol(oldName), this.fStringPool.addSymbol(oldName), this.fTargetNSURI);
            Element grandKid = XUtil.getFirstChildElement(child);
            if (grandKid == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            if (grandKid.getLocalName().equals("annotation")) {
                grandKid = XUtil.getNextSiblingElement(grandKid);
            }
            if (grandKid == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            Element greatGrandKid = XUtil.getFirstChildElement(grandKid);
            if (greatGrandKid == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            String greatGrandKidName = greatGrandKid.getLocalName();
            if (greatGrandKidName.equals("annotation")) {
                greatGrandKid = XUtil.getNextSiblingElement(greatGrandKid);
                greatGrandKidName = greatGrandKid.getLocalName();
            }
            if (greatGrandKid == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            if (!greatGrandKidName.equals("restriction") && !greatGrandKidName.equals("extension")) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            String derivedBase = greatGrandKid.getAttribute("base");
            QName processedDerivedBase = this.parseBase(derivedBase);
            if (!processedTypeName.equals(processedDerivedBase)) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("the base attribute of the restriction or extension grandchild of a complexType child of a redefine must have the same value as the complexType's type attribute");
                return false;
            }
            String prefix = "";
            int colonptr = derivedBase.indexOf(":");
            if (colonptr > 0) {
                prefix = String.valueOf(derivedBase.substring(0, colonptr)) + ":";
            }
            greatGrandKid.setAttribute("base", String.valueOf(prefix) + newName);
            return true;
        }
        if (eltLocalname.equals("attributeGroup")) {
            QName processedBaseName = new QName(-1, this.fStringPool.addSymbol(oldName), this.fStringPool.addSymbol(oldName), this.fTargetNSURI);
            int attGroupRefsCount = this.changeRedefineGroup(processedBaseName, eltLocalname, newName, child);
            if (attGroupRefsCount > 1) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("if an attributeGroup child of a <redefine> element contains an attributeGroup ref'ing itself, it must have exactly 1; this one has " + attGroupRefsCount);
                return false;
            }
            if (attGroupRefsCount == 1) {
                return true;
            }
            this.fRedefineAttributeGroupMap.put(oldName, newName);
            return false;
        }
        if (!eltLocalname.equals("group")) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("internal Xerces error; please submit a bug with schema as testcase");
            return false;
        }
        QName processedBaseName = new QName(-1, this.fStringPool.addSymbol(oldName), this.fStringPool.addSymbol(oldName), this.fTargetNSURI);
        int groupRefsCount = this.changeRedefineGroup(processedBaseName, eltLocalname, newName, child);
        String restrictedName = newName.substring(0, newName.length() - redefIdentifier.length());
        if (!this.fRedefineSucceeded) {
            this.fRestrictedRedefinedGroupRegistry.put(String.valueOf(this.fTargetNSURIString) + "," + restrictedName, new Boolean(false));
        }
        if (groupRefsCount > 1) {
            this.fRedefineSucceeded = false;
            this.fRestrictedRedefinedGroupRegistry.put(String.valueOf(this.fTargetNSURIString) + "," + restrictedName, new Boolean(false));
            this.reportGenericSchemaError("if a group child of a <redefine> element contains a group ref'ing itself, it must have exactly 1; this one has " + groupRefsCount);
            return false;
        }
        if (groupRefsCount == 1) {
            this.fRestrictedRedefinedGroupRegistry.put(String.valueOf(this.fTargetNSURIString) + "," + restrictedName, new Boolean(false));
            return true;
        }
        this.fGroupNameRegistry.put(String.valueOf(this.fTargetNSURIString) + "," + oldName, newName);
        this.fRestrictedRedefinedGroupRegistry.put(String.valueOf(this.fTargetNSURIString) + "," + restrictedName, new Boolean(true));
        return false;
    }

    private void traverseImport(Element importDecl) throws Exception {
        Attr locationAttr;
        Element root;
        SchemaGrammar importedGrammar;
        String namespaceString;
        block12: {
            block11: {
                int scope = GeneralAttrCheck.ELE_CONTEXT_GLOBAL;
                Hashtable attrValues = this.generalCheck(importDecl, scope);
                this.checkContent(importDecl, XUtil.getFirstChildElement(importDecl), true);
                namespaceString = importDecl.getAttribute("namespace");
                importedGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(namespaceString);
                if (importedGrammar != null && !namespaceString.trim().equals(this.fTargetNSURIString)) {
                    return;
                }
                importedGrammar = new SchemaGrammar();
                root = null;
                if (namespaceString.length() != 0) break block11;
                if (this.fTargetNSURI != 0) break block12;
                this.reportGenericSchemaError("src-import.1.2:  if the namespace attribute on an <import> element is not present, the <import>ing schema must have a targetNamespace");
                if (this.fExternalNoNamespaceSchema != null) {
                    root = this.openImportedSchema(this.fExternalNoNamespaceSchema);
                }
                break block12;
            }
            if (this.fTargetNSURIString.equals(namespaceString.trim())) {
                this.reportGenericSchemaError("src-import.1.1:  the namespace attribute of an <import> element must not be the same as the targetNamespace of the <import>ing schema");
                if (this.fExternalSchemas != null) {
                    Enumeration externalNamespaces = this.fExternalSchemas.keys();
                    while (externalNamespaces.hasMoreElements()) {
                        String namespace = (String)externalNamespaces.nextElement();
                        if (!namespace.trim().equals(namespaceString.trim())) continue;
                        root = this.openImportedSchema((String)this.fExternalSchemas.get(namespace));
                        break;
                    }
                }
            }
        }
        String location = "";
        if (root == null && (locationAttr = importDecl.getAttributeNode("schemaLocation")) != null) {
            location = locationAttr.getValue();
            root = this.openImportedSchema(location);
        }
        if (root != null) {
            String targetNSURI = this.getTargetNamespaceString(root);
            if (!targetNSURI.equals(namespaceString)) {
                this.reportGenericSchemaError("imported schema '" + location + "' has a different targetNameSpace '" + targetNSURI + "' from what is declared '" + namespaceString + "'.");
            } else {
                location = this.fCurrentSchemaURL;
                TraverseSchema impSchema = new TraverseSchema(root, this.fStringPool, importedGrammar, this.fGrammarResolver, this.fErrorReporter, location, this.fEntityResolver, this.fFullConstraintChecking, this.fGeneralAttrCheck, this.fUnparsedExternalSchemas, this.fExternalNoNamespaceSchema);
                this.fCurrentSchemaURL = (String)this.fSchemaURLStack.pop();
                Enumeration ics = impSchema.fIdentityConstraints.keys();
                while (ics.hasMoreElements()) {
                    Object icsKey = ics.nextElement();
                    this.fIdentityConstraints.put(icsKey, impSchema.fIdentityConstraints.get(icsKey));
                }
                Enumeration icNames = impSchema.fIdentityConstraintNames.keys();
                while (icNames.hasMoreElements()) {
                    String icsNameKey = (String)icNames.nextElement();
                    this.fIdentityConstraintNames.put(icsNameKey, impSchema.fIdentityConstraintNames.get(icsNameKey));
                }
            }
        }
    }

    private Element openImportedSchema(String location) throws Exception {
        InputSource source = null;
        if (this.fEntityResolver != null && !this.fEntityResolver.getClass().getName().equals("org.apache.xerces.validators.common.XMLValidator$Resolver")) {
            source = this.fEntityResolver.resolveEntity("", location);
        }
        if (source == null) {
            location = this.expandSystemId(location, this.fCurrentSchemaURL);
            source = new InputSource(location);
        }
        String pubId = "";
        String sysId = "";
        if (source.getPublicId() != null) {
            pubId = source.getPublicId();
        }
        if (source.getSystemId() != null) {
            sysId = source.getSystemId();
        }
        if (pubId.length() != 0 || sysId.length() != 0) {
            location = String.valueOf(pubId) + sysId;
        }
        if (this.fImportLocations.contains(location)) {
            return null;
        }
        if (source.getSystemId().equals(this.fCurrentSchemaURL)) {
            return null;
        }
        IgnoreWhitespaceParser parser = new IgnoreWhitespaceParser();
        parser.setEntityResolver(this.fEntityResolver != null ? this.fEntityResolver : new Resolver());
        parser.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException ex) throws SAXException {
                StringBuffer str = new StringBuffer();
                String systemId_ = ex.getSystemId();
                if (systemId_ != null) {
                    int index = systemId_.lastIndexOf(47);
                    if (index != -1) {
                        systemId_ = systemId_.substring(index + 1);
                    }
                    str.append(systemId_);
                }
                str.append(':').append(ex.getLineNumber()).append(':').append(ex.getColumnNumber());
                String message = ex.getMessage();
                if (!message.toLowerCase().trim().endsWith("not found.")) {
                    System.err.println("[Error] " + str.toString() + ":" + message);
                    throw ex;
                }
                System.err.println("[Warning] " + str.toString() + ": " + message);
            }
        });
        try {
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
        try {
            parser.parse(source);
        }
        catch (IOException e) {
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        Document document = parser.getDocument();
        Element root = null;
        if (document != null) {
            root = document.getDocumentElement();
        }
        if (root != null) {
            this.fImportLocations.addElement(location);
        }
        this.fSchemaURLStack.push(this.fCurrentSchemaURL);
        this.fCurrentSchemaURL = location;
        return root;
    }

    private String getTargetNamespaceString(Element root) throws Exception {
        String targetNSURI = "";
        Attr targetNSAttr = root.getAttributeNode("targetNamespace");
        if (targetNSAttr != null && (targetNSURI = targetNSAttr.getValue()).length() == 0) {
            this.reportGenericSchemaError("sch-prop-correct.1:  \"\" is not a legal value for the targetNamespace attribute; the attribute must either be absent or contain a nonempty value");
        }
        return targetNSURI;
    }

    private void traverseAnnotationDecl(Element annotationDecl) throws Exception {
        int scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(annotationDecl, scope);
        Element child = XUtil.getFirstChildElement(annotationDecl);
        while (child != null) {
            String name = child.getLocalName();
            if (!name.equals("appinfo") && !name.equals("documentation")) {
                this.reportGenericSchemaError("an <annotation> can only contain <appinfo> and <documentation> elements");
            }
            attrValues = this.generalCheck(child, scope);
            child = XUtil.getNextSiblingElement(child);
        }
    }

    private Element checkContent(Element elm, Element content, boolean isEmpty) throws Exception {
        if (content == null) {
            if (!isEmpty) {
                this.reportSchemaError(25, new Object[]{elm.getAttribute("name")});
            }
            return null;
        }
        if (content.getLocalName().equals("annotation")) {
            this.traverseAnnotationDecl(content);
            content = XUtil.getNextSiblingElement(content);
            if (content == null) {
                if (!isEmpty) {
                    this.reportSchemaError(25, new Object[]{elm.getAttribute("name")});
                }
                return null;
            }
            if (content.getLocalName().equals("annotation")) {
                this.reportSchemaError(26, new Object[]{elm.getAttribute("name")});
                return null;
            }
        }
        return content;
    }

    private DatatypeValidator findDTValidator(Element elm, String baseTypeStr, int baseRefContext) throws Exception {
        Element baseTypeNode;
        String uri;
        int baseType = this.fStringPool.addSymbol(baseTypeStr);
        String prefix = "";
        DatatypeValidator baseValidator = null;
        String localpart = baseTypeStr;
        int colonptr = baseTypeStr.indexOf(":");
        if (colonptr > 0) {
            prefix = baseTypeStr.substring(0, colonptr);
            localpart = baseTypeStr.substring(colonptr + 1);
        }
        if ((uri = this.resolvePrefixToURI(prefix)).equals("http://www.w3.org/2001/XMLSchema") && localpart.equals("anySimpleType") && baseRefContext == 2) {
            this.reportSchemaError(15, new Object[]{elm.getAttribute("base"), elm.getAttribute("name")});
            return null;
        }
        baseValidator = this.getDatatypeValidator(uri, localpart);
        if (baseValidator == null && (baseTypeNode = this.getTopLevelComponentByName("simpleType", localpart)) != null) {
            this.traverseSimpleTypeDecl(baseTypeNode);
            baseValidator = this.getDatatypeValidator(uri, localpart);
        }
        if (baseValidator == null) {
            this.reportSchemaError(15, new Object[]{elm.getAttribute("base"), elm.getAttribute("name")});
        } else {
            Integer finalValue = (Integer)this.fSimpleTypeFinalRegistry.get(String.valueOf(uri) + "," + localpart);
            if (finalValue != null && (finalValue & baseRefContext) != 0) {
                this.reportGenericSchemaError("the base type " + baseTypeStr + " does not allow itself to be used as the base for a restriction and/or as a type in a list and/or union");
                return baseValidator;
            }
        }
        return baseValidator;
    }

    private void checkEnumerationRequiredNotation(String name, String type) throws Exception {
        String localpart = type;
        int colonptr = type.indexOf(":");
        if (colonptr > 0) {
            localpart = type.substring(colonptr + 1);
        }
        if (localpart.equals("NOTATION")) {
            this.reportGenericSchemaError("[enumeration-required-notation] It is an error for NOTATION to be used directly in a schema in element/attribute '" + name + "'");
        }
    }

    private int resetSimpleTypeNameStack(int returnValue) {
        if (!this.fSimpleTypeNameStack.empty()) {
            this.fSimpleTypeNameStack.pop();
        }
        return returnValue;
    }

    private void reportCosListOfAtomic() throws Exception {
        this.reportGenericSchemaError("cos-list-of-atomic: The itemType must have a {variety} of atomic or union (in which case all the {member type definitions} must be atomic)");
        this.fListName = "";
    }

    private boolean isListDatatype(DatatypeValidator validator) {
        if (validator instanceof UnionDatatypeValidator) {
            Vector temp = ((UnionDatatypeValidator)validator).getBaseValidators();
            int i = 0;
            while (i < temp.size()) {
                if (temp.elementAt(i) instanceof ListDatatypeValidator) {
                    return true;
                }
                if (temp.elementAt(i) instanceof UnionDatatypeValidator && this.isListDatatype((DatatypeValidator)temp.elementAt(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private int traverseSimpleTypeDecl(Element simpleTypeDecl) throws Exception {
        scope = this.isTopLevel(simpleTypeDecl) != false ? GeneralAttrCheck.ELE_CONTEXT_GLOBAL : GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        attrValues = this.generalCheck(simpleTypeDecl, scope);
        qualifiedName = nameProperty = simpleTypeDecl.getAttribute("name");
        if (nameProperty.length() == 0) {
            qualifiedName = String.valueOf(this.fTargetNSURIString) + "," + "#S#" + this.fSimpleTypeAnonCount++;
            this.fStringPool.addSymbol(qualifiedName);
        } else {
            qualifiedName = String.valueOf(this.fTargetNSURIString) + "," + qualifiedName;
            this.fStringPool.addSymbol(nameProperty);
        }
        if (this.fDatatypeRegistry.getDatatypeValidator(qualifiedName) != null) {
            return this.resetSimpleTypeNameStack(this.fStringPool.addSymbol(qualifiedName));
        }
        if (this.fSimpleTypeNameStack.search(qualifiedName) != -1) {
            this.reportGenericSchemaError("cos-no-circular-unions: no circular definitions are allowed for an element '" + nameProperty + "'");
            return this.resetSimpleTypeNameStack(-1);
        }
        finalAttr = simpleTypeDecl.getAttributeNode("final");
        finalProperty = 0;
        finalProperty = finalAttr != null ? this.parseFinalSet(finalAttr.getValue()) : this.parseFinalSet(null);
        if (finalProperty != 0) {
            this.fSimpleTypeFinalRegistry.put(qualifiedName, new Integer(finalProperty));
        }
        this.fSimpleTypeNameStack.push(qualifiedName);
        content = XUtil.getFirstChildElement(simpleTypeDecl);
        content = this.checkContent(simpleTypeDecl, content, false);
        if (content == null) {
            return this.resetSimpleTypeNameStack(-1);
        }
        scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        contentAttrs = this.generalCheck(content, scope);
        varietyProperty = content.getLocalName();
        baseTypeQNameProperty = null;
        dTValidators = null;
        size = 0;
        unionMembers = null;
        list = false;
        union = false;
        restriction = false;
        numOfTypes = 0;
        if (varietyProperty.equals("list")) {
            baseTypeQNameProperty = content.getAttribute("itemType");
            list = true;
            if (this.fListName.length() != 0) {
                this.reportCosListOfAtomic();
                return this.resetSimpleTypeNameStack(-1);
            }
            this.fListName = qualifiedName;
        } else if (varietyProperty.equals("restriction")) {
            baseTypeQNameProperty = content.getAttribute("base");
            restriction = true;
        } else if (varietyProperty.equals("union")) {
            union = true;
            baseTypeQNameProperty = content.getAttribute("memberTypes");
            if (baseTypeQNameProperty.length() != 0) {
                unionMembers = new StringTokenizer(baseTypeQNameProperty);
                size = unionMembers.countTokens();
            } else {
                size = 1;
            }
            dTValidators = new Vector<DatatypeValidator>(size, 2);
        } else {
            this.reportSchemaError(7, new Object[]{varietyProperty});
            return -1;
        }
        if (XUtil.getNextSiblingElement(content) != null) {
            this.reportGenericSchemaError("error in content of simpleType");
        }
        baseValidator = null;
        if (baseTypeQNameProperty.length() != 0) ** GOTO lbl81
        content = XUtil.getFirstChildElement(content);
        if ((content = this.checkContent(simpleTypeDecl, content, false)) == null) {
            return this.resetSimpleTypeNameStack(-1);
        }
        if (content.getLocalName().equals("simpleType")) {
            typeNameIndex = this.traverseSimpleTypeDecl(content);
            if (typeNameIndex != -1 && (baseValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(typeNameIndex))) != null && union) {
                dTValidators.addElement(baseValidator);
            }
            if (typeNameIndex == -1 || baseValidator == null) {
                this.reportSchemaError(15, new Object[]{content.getAttribute("base"), content.getAttribute("name")});
                return this.resetSimpleTypeNameStack(-1);
            }
        } else {
            this.reportSchemaError(27, new Object[]{simpleTypeDecl.getAttribute("name")});
            return this.resetSimpleTypeNameStack(-1);
lbl81:
            // 1 sources

            numOfTypes = 1;
            if (union) {
                numOfTypes = size;
            }
            baseRefContext = restriction != false ? 2 : 0;
            baseRefContext |= union != false ? 4 : 0;
            baseRefContext |= list != false ? 8 : 0;
            i = 0;
            while (i < numOfTypes) {
                if (union) {
                    baseTypeQNameProperty = unionMembers.nextToken();
                }
                if ((baseValidator = this.findDTValidator(simpleTypeDecl, baseTypeQNameProperty, baseRefContext)) == null) {
                    return this.resetSimpleTypeNameStack(-1);
                }
                if (this.fListName.length() != 0) {
                    if (baseValidator instanceof ListDatatypeValidator) {
                        this.reportCosListOfAtomic();
                        return this.resetSimpleTypeNameStack(-1);
                    }
                    if (this.isListDatatype(baseValidator)) {
                        this.reportCosListOfAtomic();
                        return this.resetSimpleTypeNameStack(-1);
                    }
                }
                if (union) {
                    dTValidators.addElement(baseValidator);
                }
                ++i;
            }
        }
        content = baseTypeQNameProperty.length() == 0 ? XUtil.getNextSiblingElement(content) : XUtil.getFirstChildElement(content);
        if (union) {
            index = size;
            if (baseTypeQNameProperty.length() != 0) {
                content = this.checkContent(simpleTypeDecl, content, true);
            }
            while (content != null) {
                typeNameIndex = this.traverseSimpleTypeDecl(content);
                if (typeNameIndex != -1 && (baseValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(typeNameIndex))) != null) {
                    if (this.fListName.length() != 0 && baseValidator instanceof ListDatatypeValidator) {
                        this.reportCosListOfAtomic();
                        return this.resetSimpleTypeNameStack(-1);
                    }
                    dTValidators.addElement(baseValidator);
                }
                if (baseValidator == null || typeNameIndex == -1) {
                    this.reportSchemaError(15, new Object[]{simpleTypeDecl.getAttribute("base"), simpleTypeDecl.getAttribute("name")});
                    return -1;
                }
                content = XUtil.getNextSiblingElement(content);
            }
        }
        if (this.fListName.length() != 0 && this.fListName.equals(qualifiedName)) {
            this.fListName = "";
        }
        numFacets = 0;
        this.fFacetData.clear();
        if (restriction && content != null) {
            flags = 0;
            numEnumerationLiterals = 0;
            enumData = new Vector<String>();
            content = this.checkContent(simpleTypeDecl, content, true);
            pattern = null;
            while (content != null) {
                if (content.getNodeType() == 1) {
                    contentAttrs = this.generalCheck(content, scope);
                    ++numFacets;
                    facet = content.getLocalName();
                    if (facet.equals("enumeration")) {
                        ++numEnumerationLiterals;
                        enumVal = content.getAttribute("value");
                        if (baseValidator instanceof NOTATIONDatatypeValidator) {
                            prefix = "";
                            localpart = enumVal;
                            colonptr = enumVal.indexOf(":");
                            if (colonptr > 0) {
                                prefix = enumVal.substring(0, colonptr);
                                localpart = enumVal.substring(colonptr + 1);
                            }
                            uriStr = prefix.length() != 0 ? this.resolvePrefixToURI(prefix) : this.fTargetNSURIString;
                            nameProperty = String.valueOf(uriStr) + ":" + localpart;
                            localName = (String)this.fNotationRegistry.get(nameProperty);
                            if (localName == null && (localName = this.traverseNotationFromAnotherSchema(localpart, uriStr)) == null) {
                                this.reportGenericSchemaError("Notation '" + localpart + "' not found in the grammar " + uriStr);
                            }
                            enumVal = nameProperty;
                        }
                        enumData.addElement(enumVal);
                        this.checkContent(simpleTypeDecl, XUtil.getFirstChildElement(content), true);
                    } else if (facet.equals("annotation") || facet.equals("simpleType")) {
                        this.reportSchemaError(27, new Object[]{simpleTypeDecl.getAttribute("name")});
                    } else if (facet.equals("pattern")) {
                        if (pattern == null) {
                            pattern = new StringBuffer(content.getAttribute("value"));
                        } else {
                            pattern.append("|");
                            pattern.append(content.getAttribute("value"));
                            this.checkContent(simpleTypeDecl, XUtil.getFirstChildElement(content), true);
                        }
                    } else {
                        if (this.fFacetData.containsKey(facet)) {
                            this.reportSchemaError(21, new Object[]{"The facet '" + facet + "' is defined more than once."});
                        }
                        this.fFacetData.put(facet, content.getAttribute("value"));
                        if (content.getAttribute("fixed").equals("true") || content.getAttribute("fixed").equals("1")) {
                            if (facet.equals("minLength")) {
                                flags = (short)(flags | 2);
                            } else if (facet.equals("maxLength")) {
                                flags = (short)(flags | 4);
                            } else if (facet.equals("maxExclusive")) {
                                flags = (short)(flags | 64);
                            } else if (facet.equals("maxInclusive")) {
                                flags = (short)(flags | 32);
                            } else if (facet.equals("minExclusive")) {
                                flags = (short)(flags | 256);
                            } else if (facet.equals("minInclusive")) {
                                flags = (short)(flags | 128);
                            } else if (facet.equals("totalDigits")) {
                                flags = (short)(flags | 512);
                            } else if (facet.equals("fractionDigits")) {
                                flags = (short)(flags | 1024);
                            } else if (facet.equals("whiteSpace") && baseValidator instanceof StringDatatypeValidator) {
                                flags = (short)(flags | 16384);
                            }
                        }
                        this.checkContent(simpleTypeDecl, XUtil.getFirstChildElement(content), true);
                    }
                }
                content = XUtil.getNextSiblingElement(content);
            }
            if (numEnumerationLiterals > 0) {
                this.fFacetData.put("enumeration", enumData);
            }
            if (pattern != null) {
                this.fFacetData.put("pattern", pattern.toString());
            }
            if (flags != 0) {
                this.fFacetData.put("fixed", new Short(flags));
            }
        } else if (list && content != null) {
            if (baseTypeQNameProperty.length() != 0) {
                if ((content = this.checkContent(simpleTypeDecl, content, true)) != null) {
                    this.reportSchemaError(27, new Object[]{simpleTypeDecl.getAttribute("name")});
                }
            } else {
                this.reportSchemaError(27, new Object[]{simpleTypeDecl.getAttribute("name")});
            }
        } else if (union && content != null) {
            if (baseTypeQNameProperty.length() != 0) {
                if ((content = this.checkContent(simpleTypeDecl, content, true)) != null) {
                    this.reportSchemaError(27, new Object[]{simpleTypeDecl.getAttribute("name")});
                }
            } else {
                this.reportSchemaError(27, new Object[]{simpleTypeDecl.getAttribute("name")});
            }
        }
        try {
            newValidator = this.fDatatypeRegistry.getDatatypeValidator(qualifiedName);
            if (newValidator == null) {
                if (list) {
                    this.fDatatypeRegistry.createDatatypeValidator(qualifiedName, baseValidator, this.fFacetData, true);
                } else if (restriction) {
                    this.fDatatypeRegistry.createDatatypeValidator(qualifiedName, baseValidator, this.fFacetData, false);
                } else {
                    this.fDatatypeRegistry.createDatatypeValidator(qualifiedName, dTValidators);
                }
            }
        }
        catch (Exception e) {
            this.reportSchemaError(21, new Object[]{e.getMessage()});
        }
        return this.resetSimpleTypeNameStack(this.fStringPool.addSymbol(qualifiedName));
    }

    private int traverseAny(Element child) throws Exception {
        int scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(child, scope);
        Element annotation = this.checkContent(child, XUtil.getFirstChildElement(child), true);
        if (annotation != null) {
            this.reportGenericSchemaError("<any> elements can contain at most one <annotation> element in their children");
        }
        int anyIndex = -1;
        String namespace = child.getAttribute("namespace").trim();
        String processContents = child.getAttribute("processContents").trim();
        int processContentsAny = 6;
        int processContentsAnyOther = 7;
        int processContentsAnyLocal = 8;
        if (processContents.length() > 0 && !processContents.equals("strict")) {
            if (processContents.equals("lax")) {
                processContentsAny = 22;
                processContentsAnyOther = 23;
                processContentsAnyLocal = 24;
            } else if (processContents.equals("skip")) {
                processContentsAny = 38;
                processContentsAnyOther = 39;
                processContentsAnyLocal = 40;
            }
        }
        if (namespace.length() == 0 || namespace.equals("##any")) {
            anyIndex = this.fSchemaGrammar.addContentSpecNode(processContentsAny, -1, 0, false);
        } else if (namespace.equals("##other")) {
            String uri = this.fTargetNSURIString;
            int uriIndex = this.fStringPool.addSymbol(uri);
            anyIndex = this.fSchemaGrammar.addContentSpecNode(processContentsAnyOther, -1, uriIndex, false);
        } else if (namespace.length() > 0) {
            int uriIndex;
            StringTokenizer tokenizer = new StringTokenizer(namespace);
            String token = tokenizer.nextToken();
            if (token.equals("##local")) {
                uriIndex = 0;
            } else {
                if (token.equals("##targetNamespace")) {
                    token = this.fTargetNSURIString;
                }
                uriIndex = this.fStringPool.addSymbol(token);
            }
            int choiceIndex = this.fSchemaGrammar.addContentSpecNode(processContentsAnyLocal, -1, uriIndex, false);
            int[] uriList = new int[8];
            uriList[0] = uriIndex;
            int uriCount = 1;
            while (tokenizer.hasMoreElements()) {
                token = tokenizer.nextToken();
                if (token.equals("##local")) {
                    uriIndex = 0;
                } else {
                    if (token.equals("##targetNamespace")) {
                        token = this.fTargetNSURIString;
                    }
                    uriIndex = this.fStringPool.addSymbol(token);
                }
                int i = 0;
                while (i < uriCount) {
                    if (uriList[i] == uriIndex) {
                        // empty if block
                    }
                    ++i;
                }
                if (uriList.length == uriCount) {
                    int[] newList = new int[uriCount * 2];
                    System.arraycopy(uriList, 0, newList, 0, uriCount);
                    uriList = newList;
                }
                uriList[uriCount++] = uriIndex;
                int leafIndex = this.fSchemaGrammar.addContentSpecNode(processContentsAnyLocal, -1, uriIndex, false);
                choiceIndex = this.fSchemaGrammar.addContentSpecNode(4, choiceIndex, leafIndex, false);
            }
            anyIndex = choiceIndex;
        } else {
            this.reportGenericSchemaError("Empty namespace attribute for any element");
        }
        return anyIndex;
    }

    public DatatypeValidator getDatatypeValidator(String uri, String localpart) {
        DatatypeValidator dv = null;
        dv = uri.equals("http://www.w3.org/2001/XMLSchema") ? this.fDatatypeRegistry.getDatatypeValidator(localpart) : this.fDatatypeRegistry.getDatatypeValidator(String.valueOf(uri) + "," + localpart);
        return dv;
    }

    private XMLAttributeDecl traverseAnyAttribute(Element anyAttributeDecl) throws Exception {
        int scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(anyAttributeDecl, scope);
        Element annotation = this.checkContent(anyAttributeDecl, XUtil.getFirstChildElement(anyAttributeDecl), true);
        if (annotation != null) {
            this.reportGenericSchemaError("<anyAttribute> elements can contain at most one <annotation> element in their children");
        }
        XMLAttributeDecl anyAttDecl = new XMLAttributeDecl();
        String processContents = anyAttributeDecl.getAttribute("processContents").trim();
        String namespace = anyAttributeDecl.getAttribute("namespace").trim();
        String curTargetUri = this.fTargetNSURIString;
        if (namespace.length() == 0 || namespace.equals("##any")) {
            anyAttDecl.type = 8;
        } else if (namespace.equals("##other")) {
            anyAttDecl.type = 9;
            anyAttDecl.name.uri = this.fStringPool.addSymbol(curTargetUri);
        } else if (namespace.length() > 0) {
            anyAttDecl.type = 11;
            StringTokenizer tokenizer = new StringTokenizer(namespace);
            int aStringList = this.fStringPool.startStringList();
            Vector tokens = new Vector();
            while (tokenizer.hasMoreElements()) {
                int tokenStr;
                String token = tokenizer.nextToken();
                if (token.equals("##local")) {
                    tokenStr = 0;
                } else {
                    if (token.equals("##targetNamespace")) {
                        token = curTargetUri;
                    }
                    tokenStr = this.fStringPool.addSymbol(token);
                }
                if (this.fStringPool.addStringToList(aStringList, tokenStr)) continue;
                this.reportGenericSchemaError("Internal StringPool error when reading the namespace attribute for anyattribute declaration");
            }
            this.fStringPool.finishStringList(aStringList);
            anyAttDecl.enumeration = aStringList;
        } else {
            this.reportGenericSchemaError("Empty namespace attribute for anyattribute declaration");
        }
        anyAttDecl.defaultType = processContents.equals("skip") ? (anyAttDecl.defaultType |= 0x1000) : (processContents.equals("lax") ? (anyAttDecl.defaultType |= 0x800) : (anyAttDecl.defaultType |= 0x400));
        return anyAttDecl;
    }

    private XMLAttributeDecl AWildCardIntersection(XMLAttributeDecl oneAny, XMLAttributeDecl anotherAny) {
        if (oneAny.type == -1) {
            return oneAny;
        }
        if (anotherAny.type == -1) {
            return anotherAny;
        }
        if (oneAny.type == 8) {
            return anotherAny;
        }
        if (anotherAny.type == 8) {
            return oneAny;
        }
        if (oneAny.type == 9 && anotherAny.type == 11 || oneAny.type == 11 && anotherAny.type == 9) {
            XMLAttributeDecl anyOther;
            XMLAttributeDecl anyList;
            if (oneAny.type == 11) {
                anyList = oneAny;
                anyOther = anotherAny;
            } else {
                anyList = anotherAny;
                anyOther = oneAny;
            }
            int[] uriList = this.fStringPool.stringListAsIntArray(anyList.enumeration);
            if (this.elementInSet(anyOther.name.uri, uriList)) {
                int newList = this.fStringPool.startStringList();
                int i = 0;
                while (i < uriList.length) {
                    if (uriList[i] != anyOther.name.uri) {
                        this.fStringPool.addStringToList(newList, uriList[i]);
                    }
                    ++i;
                }
                this.fStringPool.finishStringList(newList);
                anyList.enumeration = newList;
            }
            return anyList;
        }
        if (oneAny.type == 11 && anotherAny.type == 11) {
            int[] result = this.intersect2sets(this.fStringPool.stringListAsIntArray(oneAny.enumeration), this.fStringPool.stringListAsIntArray(anotherAny.enumeration));
            int newList = this.fStringPool.startStringList();
            int i = 0;
            while (i < result.length) {
                this.fStringPool.addStringToList(newList, result[i]);
                ++i;
            }
            this.fStringPool.finishStringList(newList);
            oneAny.enumeration = newList;
            return oneAny;
        }
        if (oneAny.type == 9 && anotherAny.type == 9) {
            if (oneAny.name.uri == anotherAny.name.uri) {
                return oneAny;
            }
            oneAny.type = -1;
            return oneAny;
        }
        return oneAny;
    }

    private XMLAttributeDecl AWildCardUnion(XMLAttributeDecl oneAny, XMLAttributeDecl anotherAny) {
        if (oneAny.type == -1) {
            return oneAny;
        }
        if (anotherAny.type == -1) {
            return anotherAny;
        }
        if (oneAny.type == 8) {
            return oneAny;
        }
        if (anotherAny.type == 8) {
            return anotherAny;
        }
        if (oneAny.type == 11 && anotherAny.type == 11) {
            int[] result = this.union2sets(this.fStringPool.stringListAsIntArray(oneAny.enumeration), this.fStringPool.stringListAsIntArray(anotherAny.enumeration));
            int newList = this.fStringPool.startStringList();
            int i = 0;
            while (i < result.length) {
                this.fStringPool.addStringToList(newList, result[i]);
                ++i;
            }
            this.fStringPool.finishStringList(newList);
            oneAny.enumeration = newList;
            return oneAny;
        }
        if (oneAny.type == 9 && anotherAny.type == 9) {
            if (oneAny.name.uri == anotherAny.name.uri) {
                return oneAny;
            }
            oneAny.type = 8;
            return oneAny;
        }
        if (oneAny.type == 9 && anotherAny.type == 11 || oneAny.type == 11 && anotherAny.type == 9) {
            XMLAttributeDecl anyOther;
            XMLAttributeDecl anyList;
            if (oneAny.type == 11) {
                anyList = oneAny;
                anyOther = anotherAny;
            } else {
                anyList = anotherAny;
                anyOther = oneAny;
            }
            if (this.elementInSet(anyOther.name.uri, this.fStringPool.stringListAsIntArray(anyList.enumeration))) {
                anyOther.type = 8;
            }
            return anyOther;
        }
        return oneAny;
    }

    private boolean AWildCardSubset(XMLAttributeDecl subAny, XMLAttributeDecl superAny) {
        if (subAny.type == -1 || superAny.type == -1) {
            return false;
        }
        if (superAny.type == 8) {
            return true;
        }
        if (subAny.type == 9 && superAny.type == 9 && subAny.name.uri == superAny.name.uri) {
            return true;
        }
        if (subAny.type == 11) {
            if (superAny.type == 11 && this.subset2sets(this.fStringPool.stringListAsIntArray(subAny.enumeration), this.fStringPool.stringListAsIntArray(superAny.enumeration))) {
                return true;
            }
            if (superAny.type == 9 && !this.elementInSet(superAny.name.uri, this.fStringPool.stringListAsIntArray(superAny.enumeration))) {
                return true;
            }
        }
        return false;
    }

    private boolean AWildCardAllowsNameSpace(XMLAttributeDecl wildcard, String uri) {
        if (wildcard.type == -1) {
            return false;
        }
        if (wildcard.type == 8) {
            return true;
        }
        int uriStr = this.fStringPool.addString(uri);
        if (wildcard.type == 9 && uriStr != wildcard.name.uri && uriStr != 0) {
            return true;
        }
        return wildcard.type == 11 && this.elementInSet(uriStr, this.fStringPool.stringListAsIntArray(wildcard.enumeration));
    }

    private boolean isAWildCard(XMLAttributeDecl a) {
        return a.type == 8 || a.type == 11 || a.type == 9;
    }

    int[] intersect2sets(int[] one, int[] theOther) {
        int[] result = new int[one.length > theOther.length ? one.length : theOther.length];
        int count = 0;
        int i = 0;
        while (i < one.length) {
            if (this.elementInSet(one[i], theOther)) {
                result[count++] = one[i];
            }
            ++i;
        }
        int[] result2 = new int[count];
        System.arraycopy(result, 0, result2, 0, count);
        return result2;
    }

    int[] union2sets(int[] one, int[] theOther) {
        int[] result1 = new int[one.length];
        int count = 0;
        int i = 0;
        while (i < one.length) {
            if (!this.elementInSet(one[i], theOther)) {
                result1[count++] = one[i];
            }
            ++i;
        }
        int[] result2 = new int[count + theOther.length];
        System.arraycopy(result1, 0, result2, 0, count);
        System.arraycopy(theOther, 0, result2, count, theOther.length);
        return result2;
    }

    boolean subset2sets(int[] subSet, int[] superSet) {
        int i = 0;
        while (i < subSet.length) {
            if (!this.elementInSet(subSet[i], superSet)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean elementInSet(int ele, int[] set) {
        boolean found = false;
        int i = 0;
        while (i < set.length && !found) {
            if (ele == set[i]) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    private int traverseComplexTypeDecl(Element complexTypeDecl) throws Exception {
        return this.traverseComplexTypeDecl(complexTypeDecl, false);
    }

    private int traverseComplexTypeDecl(Element complexTypeDecl, boolean forwardRef) throws Exception {
        int scope = this.isTopLevel(complexTypeDecl) ? GeneralAttrCheck.ELE_CONTEXT_GLOBAL : GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(complexTypeDecl, scope);
        String isAbstract = complexTypeDecl.getAttribute("abstract");
        String blockSet = null;
        Attr blockAttr = complexTypeDecl.getAttributeNode("block");
        if (blockAttr != null) {
            blockSet = blockAttr.getValue();
        }
        String finalSet = null;
        Attr finalAttr = complexTypeDecl.getAttributeNode("final");
        if (finalAttr != null) {
            finalSet = finalAttr.getValue();
        }
        String typeId = complexTypeDecl.getAttribute("ID");
        String typeName = complexTypeDecl.getAttribute("name");
        String mixed = complexTypeDecl.getAttribute("mixed");
        boolean isMixed = mixed.equals("true") || mixed.equals("1");
        boolean isNamedType = false;
        Stack savedGroupNameStack = null;
        if (typeName.length() == 0) {
            typeName = this.genAnonTypeName(complexTypeDecl);
        }
        int typeNameIndex = this.fStringPool.addSymbol(typeName);
        if (this.isTopLevel(complexTypeDecl)) {
            String fullName = String.valueOf(this.fTargetNSURIString) + "," + typeName;
            ComplexTypeInfo temp = (ComplexTypeInfo)this.fComplexTypeRegistry.get(fullName);
            if (temp != null) {
                if (!forwardRef) {
                    if (temp.declSeen()) {
                        this.reportGenericSchemaError("sch-props-correct: Duplicate declaration for complexType " + typeName);
                    } else {
                        temp.setDeclSeen();
                    }
                }
                return this.fStringPool.addSymbol(fullName);
            }
            if (this.getDatatypeValidator(this.fTargetNSURIString, typeName) != null) {
                this.reportGenericSchemaError("sch-props-correct: Duplicate type declaration - type is " + typeName);
            }
        }
        this.fCurrentTypeNameStack.push(typeName);
        int scopeDefined = this.fScopeCount++;
        int previousScope = this.fCurrentScope;
        this.fCurrentScope = scopeDefined;
        if (!this.fCurrentGroupNameStack.isEmpty()) {
            savedGroupNameStack = this.fCurrentGroupNameStack;
            this.fCurrentGroupNameStack = new Stack();
        }
        Element child = null;
        ComplexTypeInfo typeInfo = new ComplexTypeInfo();
        typeInfo.scopeDefined = scopeDefined;
        try {
            child = this.checkContent(complexTypeDecl, XUtil.getFirstChildElement(complexTypeDecl), true);
            if (child == null) {
                this.processComplexContent(typeNameIndex, child, typeInfo, null, isMixed);
            } else {
                String childName = child.getLocalName();
                int index = -2;
                if (childName.equals("simpleContent")) {
                    this.traverseSimpleContentDecl(typeNameIndex, child, typeInfo);
                    if (XUtil.getNextSiblingElement(child) != null) {
                        throw new ComplexTypeRecoverableError("Invalid child following the simpleContent child in the complexType");
                    }
                } else if (childName.equals("complexContent")) {
                    this.traverseComplexContentDecl(typeNameIndex, child, typeInfo, isMixed);
                    if (XUtil.getNextSiblingElement(child) != null) {
                        throw new ComplexTypeRecoverableError("Invalid child following the complexContent child in the complexType");
                    }
                } else {
                    this.processComplexContent(typeNameIndex, child, typeInfo, null, isMixed);
                }
            }
            typeInfo.blockSet = this.parseBlockSet(blockSet);
            if (blockSet != null && blockSet.length() != 0 && !blockSet.equals("#all") && (typeInfo.blockSet & 2) == 0 && (typeInfo.blockSet & 1) == 0) {
                throw new ComplexTypeRecoverableError("The values of the 'block' attribute of a complexType must be either #all or a list of 'restriction' and 'extension'; " + blockSet + " was found");
            }
            typeInfo.finalSet = this.parseFinalSet(finalSet);
            if (finalSet != null && finalSet.length() != 0 && !finalSet.equals("#all") && (typeInfo.finalSet & 2) == 0 && (typeInfo.finalSet & 1) == 0) {
                throw new ComplexTypeRecoverableError("The values of the 'final' attribute of a complexType must be either #all or a list of 'restriction' and 'extension'; " + finalSet + " was found");
            }
        }
        catch (ComplexTypeRecoverableError e) {
            String message = e.getMessage();
            this.handleComplexTypeError(message, typeNameIndex, typeInfo);
        }
        if (isAbstract.equals("true") || isAbstract.equals("1")) {
            typeInfo.setIsAbstractType();
        }
        if (!forwardRef) {
            typeInfo.setDeclSeen();
        }
        typeName = String.valueOf(this.fTargetNSURIString) + "," + typeName;
        typeInfo.typeName = new String(typeName);
        this.fComplexTypeRegistry.put(typeName, typeInfo);
        this.fCurrentScope = previousScope;
        if (savedGroupNameStack != null) {
            this.fCurrentGroupNameStack = savedGroupNameStack;
        }
        this.fCurrentTypeNameStack.pop();
        this.checkRecursingComplexType();
        this.fSchemaGrammar.setElementComplexTypeInfo(typeInfo.templateElementIndex, typeInfo);
        typeNameIndex = this.fStringPool.addSymbol(typeName);
        return typeNameIndex;
    }

    private void traverseSimpleContentDecl(int typeNameIndex, Element simpleContentDecl, ComplexTypeInfo typeInfo) throws Exception {
        int scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(simpleContentDecl, scope);
        String typeName = this.fStringPool.toString(typeNameIndex);
        String simpleContentTypeId = simpleContentDecl.getAttribute("ID");
        typeInfo.contentType = 5;
        typeInfo.contentSpecHandle = -1;
        Element simpleContent = this.checkContent(simpleContentDecl, XUtil.getFirstChildElement(simpleContentDecl), false);
        if (simpleContent == null) {
            throw new ComplexTypeRecoverableError();
        }
        attrValues = this.generalCheck(simpleContent, scope);
        String simpleContentName = simpleContent.getLocalName();
        if (simpleContentName.equals("restriction")) {
            typeInfo.derivedBy = 2;
        } else if (simpleContentName.equals("extension")) {
            typeInfo.derivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("The content of the simpleContent element is invalid.  The content must be RESTRICTION or EXTENSION");
        }
        String base = simpleContent.getAttribute("base");
        String typeId = simpleContent.getAttribute("ID");
        Element content = this.checkContent(simpleContent, XUtil.getFirstChildElement(simpleContent), true);
        if (base.length() == 0) {
            throw new ComplexTypeRecoverableError("The BASE attribute must be specified for the RESTRICTION or EXTENSION element");
        }
        QName baseQName = this.parseBase(base);
        Integer finalValue = (Integer)this.fSimpleTypeFinalRegistry.get(String.valueOf(this.fStringPool.toString(baseQName.uri)) + "," + this.fStringPool.toString(baseQName.localpart));
        if (finalValue != null && finalValue == typeInfo.derivedBy) {
            throw new ComplexTypeRecoverableError("The simpleType " + base + " that " + typeName + " uses has a value of \"final\" which does not permit extension");
        }
        String baseTypeURI = this.fStringPool.toString(baseQName.uri);
        String baseLocalName = this.fStringPool.toString(baseQName.localpart);
        if (baseTypeURI.equals("http://www.w3.org/2001/XMLSchema") && baseLocalName.equals("anyType")) {
            throw new ComplexTypeRecoverableError("The type '" + base + "' specified as the " + "base in the simpleContent element must be a complex type with simple content");
        }
        this.processBaseTypeInfo(baseQName, typeInfo);
        if (typeInfo.baseComplexTypeInfo != null && typeInfo.baseComplexTypeInfo.contentType != 5) {
            throw new ComplexTypeRecoverableError("The type '" + base + "' specified as the " + "base in the simpleContent element must not have complexContent");
        }
        Element attrNode = null;
        if (typeInfo.derivedBy == 2) {
            if (typeInfo.baseDataTypeValidator != null) {
                throw new ComplexTypeRecoverableError("ct-props-correct.2: The type '" + base + "' is a simple type.  It cannot be used in a " + "derivation by RESTRICTION for a complexType");
            }
            typeInfo.baseDataTypeValidator = typeInfo.baseComplexTypeInfo.datatypeValidator;
            if ((typeInfo.baseComplexTypeInfo.finalSet & 2) != 0) {
                throw new ComplexTypeRecoverableError("Derivation by restriction is forbidden by either the base type " + base + " or the schema");
            }
            if (content != null && content.getLocalName().equals("simpleType")) {
                int simpleTypeNameIndex = this.traverseSimpleTypeDecl(content);
                if (simpleTypeNameIndex != -1) {
                    DatatypeValidator dv = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(simpleTypeNameIndex));
                    if (!this.checkSimpleTypeDerivationOK(dv, typeInfo.baseDataTypeValidator)) {
                        throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.1.1:  The content type is not a valid restriction of the content type of the base");
                    }
                    typeInfo.baseDataTypeValidator = dv;
                    content = XUtil.getNextSiblingElement(content);
                } else {
                    throw new ComplexTypeRecoverableError();
                }
            }
            int numEnumerationLiterals = 0;
            int numFacets = 0;
            Hashtable<String, Object> facetData = new Hashtable<String, Object>();
            Vector<String> enumData = new Vector<String>();
            scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
            Element child = content;
            while (child != null && (child.getLocalName().equals("minExclusive") || child.getLocalName().equals("minInclusive") || child.getLocalName().equals("maxExclusive") || child.getLocalName().equals("maxInclusive") || child.getLocalName().equals("totalDigits") || child.getLocalName().equals("fractionDigits") || child.getLocalName().equals("length") || child.getLocalName().equals("minLength") || child.getLocalName().equals("maxLength") || child.getLocalName().equals("enumeration") || child.getLocalName().equals("pattern") || child.getLocalName().equals("whiteSpace") || child.getLocalName().equals("annotation"))) {
                if (child.getNodeType() == 1) {
                    Element facetElt = child;
                    Hashtable contentAttrs = this.generalCheck(facetElt, scope);
                    ++numFacets;
                    if (facetElt.getLocalName().equals("enumeration")) {
                        ++numEnumerationLiterals;
                        enumData.addElement(facetElt.getAttribute("value"));
                        Element enumContent = XUtil.getFirstChildElement(facetElt);
                        if (enumContent != null && enumContent.getLocalName().equals("annotation")) {
                            this.traverseAnnotationDecl(child);
                        }
                    } else {
                        facetData.put(facetElt.getLocalName(), facetElt.getAttribute("value"));
                    }
                }
                child = XUtil.getNextSiblingElement(child);
            }
            if (numEnumerationLiterals > 0) {
                facetData.put("enumeration", enumData);
            }
            if (numFacets > 0) {
                try {
                    typeInfo.datatypeValidator = this.fDatatypeRegistry.createDatatypeValidator(typeName, typeInfo.baseDataTypeValidator, facetData, false);
                }
                catch (Exception e) {
                    throw new ComplexTypeRecoverableError(e.getMessage());
                }
            } else {
                typeInfo.datatypeValidator = typeInfo.baseDataTypeValidator;
            }
            if (child != null) {
                if (!this.isAttrOrAttrGroup(child)) {
                    throw new ComplexTypeRecoverableError("Invalid child in the RESTRICTION element of simpleContent");
                }
                attrNode = child;
            }
        } else {
            if (typeInfo.baseComplexTypeInfo != null) {
                typeInfo.baseDataTypeValidator = typeInfo.baseComplexTypeInfo.datatypeValidator;
                if ((typeInfo.baseComplexTypeInfo.finalSet & 1) != 0) {
                    throw new ComplexTypeRecoverableError("Derivation by extension is forbidden by either the base type " + base + " or the schema");
                }
            }
            typeInfo.datatypeValidator = typeInfo.baseDataTypeValidator;
            if (content != null) {
                if (!this.isAttrOrAttrGroup(content)) {
                    throw new ComplexTypeRecoverableError("Only annotations and attributes are allowed in the content of an EXTENSION element for a complexType with simpleContent");
                }
                attrNode = content;
            }
        }
        int templateElementNameIndex = this.fStringPool.addSymbol("$" + typeName);
        typeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, templateElementNameIndex, typeNameIndex, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : this.fCurrentScope, typeInfo.scopeDefined, typeInfo.contentType, typeInfo.contentSpecHandle, -1, typeInfo.datatypeValidator);
        typeInfo.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(typeInfo.templateElementIndex);
        this.processAttributes(attrNode, baseQName, typeInfo);
        if (XUtil.getNextSiblingElement(simpleContent) != null) {
            throw new ComplexTypeRecoverableError("Invalid child following the RESTRICTION or EXTENSION element in the complex type definition");
        }
    }

    private void traverseComplexContentDecl(int typeNameIndex, Element complexContentDecl, ComplexTypeInfo typeInfo, boolean mixedOnComplexTypeDecl) throws Exception {
        int scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(complexContentDecl, scope);
        String typeName = this.fStringPool.toString(typeNameIndex);
        String typeId = complexContentDecl.getAttribute("ID");
        String mixed = complexContentDecl.getAttribute("mixed");
        boolean isMixed = mixedOnComplexTypeDecl;
        if (mixed.equals("true") || mixed.equals("1")) {
            isMixed = true;
        } else if (mixed.equals("false") || mixed.equals("0")) {
            isMixed = false;
        }
        typeInfo.datatypeValidator = null;
        typeInfo.baseDataTypeValidator = null;
        Element complexContent = this.checkContent(complexContentDecl, XUtil.getFirstChildElement(complexContentDecl), false);
        if (complexContent == null) {
            throw new ComplexTypeRecoverableError();
        }
        String complexContentName = complexContent.getLocalName();
        if (complexContentName.equals("restriction")) {
            typeInfo.derivedBy = 2;
        } else if (complexContentName.equals("extension")) {
            typeInfo.derivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("The content of the complexContent element is invalid. The content must be RESTRICTION or EXTENSION");
        }
        String base = complexContent.getAttribute("base");
        String complexContentTypeId = complexContent.getAttribute("ID");
        Element content = this.checkContent(complexContent, XUtil.getFirstChildElement(complexContent), true);
        if (base.length() == 0) {
            throw new ComplexTypeRecoverableError("The BASE attribute must be specified for the RESTRICTION or EXTENSION element");
        }
        QName baseQName = this.parseBase(base);
        String baseTypeURI = this.fStringPool.toString(baseQName.uri);
        String baseLocalName = this.fStringPool.toString(baseQName.localpart);
        if (!baseTypeURI.equals("http://www.w3.org/2001/XMLSchema") || !baseLocalName.equals("anyType")) {
            this.processBaseTypeInfo(baseQName, typeInfo);
            if (typeInfo.baseComplexTypeInfo == null) {
                throw new ComplexTypeRecoverableError("The base type specified in the complexContent element must be a complexType");
            }
        }
        this.processComplexContent(typeNameIndex, content, typeInfo, baseQName, isMixed);
        if (XUtil.getNextSiblingElement(complexContent) != null) {
            throw new ComplexTypeRecoverableError("Invalid child following the RESTRICTION or EXTENSION element in the complex type definition");
        }
    }

    private void handleComplexTypeError(String message, int typeNameIndex, ComplexTypeInfo typeInfo) throws Exception {
        String typeName = this.fStringPool.toString(typeNameIndex);
        if (message != null) {
            if (typeName.startsWith("#")) {
                this.reportGenericSchemaError("Anonymous complexType: " + message);
            } else {
                this.reportGenericSchemaError("ComplexType '" + typeName + "': " + message);
            }
        }
        typeInfo.contentType = 1;
        typeInfo.contentSpecHandle = -1;
        typeInfo.derivedBy = 0;
        typeInfo.datatypeValidator = null;
        typeInfo.attlistHead = -1;
        int templateElementNameIndex = this.fStringPool.addSymbol("$" + typeName);
        typeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, templateElementNameIndex, typeNameIndex, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : this.fCurrentScope, typeInfo.scopeDefined, typeInfo.contentType, typeInfo.contentSpecHandle, -1, typeInfo.datatypeValidator);
    }

    private String genAnonTypeName(Element complexTypeDecl) throws Exception {
        Element node = complexTypeDecl;
        String typeName = "#AnonType_";
        while (!this.isTopLevel(node)) {
            node = (Element)node.getParentNode();
            typeName = String.valueOf(typeName) + node.getAttribute("name");
        }
        return typeName;
    }

    private QName parseBase(String base) throws Exception {
        String prefix = "";
        String localpart = base;
        int colonptr = base.indexOf(":");
        if (colonptr > 0) {
            prefix = base.substring(0, colonptr);
            localpart = base.substring(colonptr + 1);
        }
        int nameIndex = this.fStringPool.addSymbol(base);
        int prefixIndex = this.fStringPool.addSymbol(prefix);
        int localpartIndex = this.fStringPool.addSymbol(localpart);
        int URIindex = this.fStringPool.addSymbol(this.resolvePrefixToURI(prefix));
        return new QName(prefixIndex, localpartIndex, nameIndex, URIindex);
    }

    private boolean baseFromAnotherSchema(QName baseName) throws Exception {
        String typeURI = this.fStringPool.toString(baseName.uri);
        return !typeURI.equals(this.fTargetNSURIString) && !typeURI.equals("http://www.w3.org/2001/XMLSchema") && typeURI.length() != 0;
    }

    private void processBaseTypeInfo(QName baseName, ComplexTypeInfo typeInfo) throws Exception {
        ComplexTypeInfo baseComplexTypeInfo = null;
        DatatypeValidator baseDTValidator = null;
        String typeURI = this.fStringPool.toString(baseName.uri);
        String localpart = this.fStringPool.toString(baseName.localpart);
        String base = this.fStringPool.toString(baseName.rawname);
        if (this.baseFromAnotherSchema(baseName)) {
            baseComplexTypeInfo = this.getTypeInfoFromNS(typeURI, localpart);
            if (baseComplexTypeInfo == null) {
                baseDTValidator = this.getTypeValidatorFromNS(typeURI, localpart);
            }
        } else {
            String fullBaseName = String.valueOf(typeURI) + "," + localpart;
            baseComplexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(fullBaseName);
            if (baseComplexTypeInfo == null && (baseDTValidator = this.getDatatypeValidator(typeURI, localpart)) == null) {
                Element baseTypeNode = this.getTopLevelComponentByName("complexType", localpart);
                if (baseTypeNode != null) {
                    if (this.fBaseTypeNameStack.search(fullBaseName) > -1) {
                        throw new ComplexTypeRecoverableError("ct-props-correct.3:  Recursive type definition");
                    }
                    this.fBaseTypeNameStack.push(fullBaseName);
                    int baseTypeSymbol = this.traverseComplexTypeDecl(baseTypeNode, true);
                    this.fBaseTypeNameStack.pop();
                    baseComplexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(baseTypeSymbol));
                } else {
                    baseTypeNode = this.getTopLevelComponentByName("simpleType", localpart);
                    if (baseTypeNode != null) {
                        int baseTypeSymbol = this.traverseSimpleTypeDecl(baseTypeNode);
                        baseDTValidator = this.getDatatypeValidator(typeURI, localpart);
                    }
                }
            }
        }
        if (baseComplexTypeInfo == null && baseDTValidator == null) {
            throw new ComplexTypeRecoverableError("src-ct.2: Cannot find type definition for '" + base + "'");
        }
        typeInfo.baseComplexTypeInfo = baseComplexTypeInfo;
        typeInfo.baseDataTypeValidator = baseDTValidator;
    }

    private void processComplexContent(int typeNameIndex, Element complexContentChild, ComplexTypeInfo typeInfo, QName baseName, boolean isMixed) throws Exception {
        Element attrNode = null;
        int index = -2;
        String typeName = this.fStringPool.toString(typeNameIndex);
        if (complexContentChild != null) {
            String childName = complexContentChild.getLocalName();
            if (childName.equals("group")) {
                GroupInfo grpInfo = this.traverseGroupDecl(complexContentChild);
                int groupIndex = grpInfo != null ? grpInfo.contentSpecIndex : -2;
                index = this.handleOccurrences(groupIndex, complexContentChild, this.hasAllContent(groupIndex) ? 2 : 0);
                attrNode = XUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals("sequence")) {
                index = this.handleOccurrences(this.traverseSequence(complexContentChild), complexContentChild);
                attrNode = XUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals("choice")) {
                index = this.handleOccurrences(this.traverseChoice(complexContentChild), complexContentChild);
                attrNode = XUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals("all")) {
                index = this.handleOccurrences(this.traverseAll(complexContentChild), complexContentChild, 8);
                attrNode = XUtil.getNextSiblingElement(complexContentChild);
            } else if (this.isAttrOrAttrGroup(complexContentChild)) {
                typeInfo.contentType = 1;
                attrNode = complexContentChild;
            } else {
                throw new ComplexTypeRecoverableError("Invalid child '" + childName + "' in the complex type");
            }
        }
        typeInfo.contentSpecHandle = index;
        if (typeInfo.baseComplexTypeInfo != null) {
            int baseContentSpecHandle = typeInfo.baseComplexTypeInfo.contentSpecHandle;
            if (typeInfo.derivedBy == 2) {
                if ((typeInfo.baseComplexTypeInfo.finalSet & 2) != 0) {
                    throw new ComplexTypeRecoverableError("Derivation by restriction is forbidden by either the base type " + this.fStringPool.toString(baseName.localpart) + " or the schema");
                }
                if (typeInfo.contentSpecHandle == -2 && typeInfo.baseComplexTypeInfo.contentType != 0 && !this.particleEmptiable(baseContentSpecHandle)) {
                    throw new ComplexTypeRecoverableError("derivation-ok-restrictoin.5.2 Content type of complexType is EMPTY but base is not EMPTY or does not have a particle which is emptiable");
                }
            } else {
                if ((typeInfo.baseComplexTypeInfo.finalSet & 1) != 0) {
                    throw new ComplexTypeRecoverableError("cos-ct-extends.1.1: Derivation by extension is forbidden by either the base type " + this.fStringPool.toString(baseName.localpart) + " or the schema");
                }
                if (typeInfo.baseComplexTypeInfo.contentType != 0 && (typeInfo.baseComplexTypeInfo.contentType == 4 && isMixed || typeInfo.baseComplexTypeInfo.contentType == 3 && !isMixed)) {
                    throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.2.2.2.1: The content type of the base type " + this.fStringPool.toString(baseName.localpart) + " and derived type " + typeName + " must both be mixed or element-only");
                }
                if (this.baseFromAnotherSchema(baseName)) {
                    String baseSchemaURI = this.fStringPool.toString(baseName.uri);
                    SchemaGrammar aGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(baseSchemaURI);
                    baseContentSpecHandle = this.importContentSpec(aGrammar, baseContentSpecHandle);
                }
                if (typeInfo.contentSpecHandle == -2) {
                    typeInfo.contentSpecHandle = baseContentSpecHandle;
                } else if (baseContentSpecHandle > -1) {
                    if (typeInfo.contentSpecHandle > -1 && (this.hasAllContent(typeInfo.contentSpecHandle) || this.hasAllContent(baseContentSpecHandle))) {
                        throw new ComplexTypeRecoverableError("cos-all-limited.1.2:  An \"all\" model group that is part of a complex type definition must constitute the entire {content type} of the definition.");
                    }
                    typeInfo.contentSpecHandle = this.fSchemaGrammar.addContentSpecNode(5, baseContentSpecHandle, typeInfo.contentSpecHandle, false);
                }
            }
        } else {
            typeInfo.derivedBy = 2;
        }
        if (isMixed) {
            if (typeInfo.contentSpecHandle == -2) {
                int emptyIndex = this.fSchemaGrammar.addContentSpecNode(0, -1, 0, false);
                if (this.fSchemaGrammar.getDeferContentSpecExpansion()) {
                    this.fSchemaGrammar.setContentSpecMinOccurs(emptyIndex, 0);
                    this.fSchemaGrammar.setContentSpecMaxOccurs(emptyIndex, 1);
                    typeInfo.contentSpecHandle = emptyIndex;
                } else {
                    typeInfo.contentSpecHandle = this.fSchemaGrammar.expandContentModel(emptyIndex, 0, 1);
                }
                typeInfo.contentType = 2;
            } else {
                typeInfo.contentType = 3;
            }
        } else {
            typeInfo.contentType = typeInfo.contentSpecHandle == -2 ? 0 : 4;
        }
        int templateElementNameIndex = this.fStringPool.addSymbol("$" + typeName);
        typeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, templateElementNameIndex, typeNameIndex, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : this.fCurrentScope, typeInfo.scopeDefined, typeInfo.contentType, typeInfo.contentSpecHandle, -1, typeInfo.datatypeValidator);
        typeInfo.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(typeInfo.templateElementIndex);
        if (attrNode != null) {
            if (!this.isAttrOrAttrGroup(attrNode)) {
                throw new ComplexTypeRecoverableError("Invalid child " + attrNode.getLocalName() + " in the complexType or complexContent");
            }
            this.processAttributes(attrNode, baseName, typeInfo);
        } else if (typeInfo.baseComplexTypeInfo != null) {
            this.processAttributes(null, baseName, typeInfo);
        }
    }

    private void processAttributes(Element attrNode, QName baseName, ComplexTypeInfo typeInfo) throws Exception {
        XMLAttributeDecl attWildcard = null;
        Vector anyAttDecls = new Vector();
        Element child = attrNode;
        while (child != null) {
            String childName = child.getLocalName();
            if (childName.equals("attribute")) {
                this.traverseAttributeDecl(child, typeInfo, false);
            } else if (childName.equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(child, typeInfo, anyAttDecls);
            } else if (childName.equals("anyAttribute")) {
                attWildcard = this.traverseAnyAttribute(child);
            } else {
                throw new ComplexTypeRecoverableError("Invalid child among the children of the complexType definition");
            }
            child = XUtil.getNextSiblingElement(child);
        }
        if (attWildcard != null) {
            XMLAttributeDecl fromGroup = null;
            int count = anyAttDecls.size();
            if (count > 0) {
                fromGroup = (XMLAttributeDecl)anyAttDecls.elementAt(0);
                int i = 1;
                while (i < count) {
                    fromGroup = this.AWildCardIntersection(fromGroup, (XMLAttributeDecl)anyAttDecls.elementAt(i));
                    ++i;
                }
            }
            if (fromGroup != null) {
                int saveProcessContents = attWildcard.defaultType;
                attWildcard = this.AWildCardIntersection(attWildcard, fromGroup);
                attWildcard.defaultType = saveProcessContents;
            }
        } else if (anyAttDecls.size() > 0) {
            attWildcard = (XMLAttributeDecl)anyAttDecls.elementAt(0);
        }
        XMLAttributeDecl baseAttWildcard = null;
        ComplexTypeInfo baseTypeInfo = typeInfo.baseComplexTypeInfo;
        SchemaGrammar aGrammar = null;
        if (baseTypeInfo != null && baseTypeInfo.attlistHead > -1) {
            String baseTypeSchemaURI;
            int attDefIndex = baseTypeInfo.attlistHead;
            aGrammar = this.fSchemaGrammar;
            String string = baseTypeSchemaURI = this.baseFromAnotherSchema(baseName) ? this.fStringPool.toString(baseName.uri) : null;
            if (baseTypeSchemaURI != null) {
                aGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(baseTypeSchemaURI);
            }
            if (aGrammar != null) {
                while (attDefIndex > -1) {
                    this.fTempAttributeDecl.clear();
                    aGrammar.getAttributeDecl(attDefIndex, this.fTempAttributeDecl);
                    if (this.fTempAttributeDecl.type == 8 || this.fTempAttributeDecl.type == 11 || this.fTempAttributeDecl.type == 9) {
                        if (attWildcard == null) {
                            baseAttWildcard = this.fTempAttributeDecl;
                        }
                        attDefIndex = aGrammar.getNextAttributeDeclIndex(attDefIndex);
                        continue;
                    }
                    int temp = this.fSchemaGrammar.getAttributeDeclIndex(typeInfo.templateElementIndex, this.fTempAttributeDecl.name);
                    if (temp > -1) {
                        if (typeInfo.derivedBy == 1) {
                            throw new ComplexTypeRecoverableError("Attribute " + this.fStringPool.toString(this.fTempAttributeDecl.name.localpart) + " that appeared in the base should not appear in a derivation by extension");
                        }
                        attDefIndex = this.fSchemaGrammar.getNextAttributeDeclIndex(attDefIndex);
                        continue;
                    }
                    this.fSchemaGrammar.addAttDef(typeInfo.templateElementIndex, this.fTempAttributeDecl.name, this.fTempAttributeDecl.type, this.fTempAttributeDecl.enumeration, this.fTempAttributeDecl.defaultType, this.fTempAttributeDecl.defaultValue, this.fTempAttributeDecl.datatypeValidator, this.fTempAttributeDecl.list);
                    attDefIndex = aGrammar.getNextAttributeDeclIndex(attDefIndex);
                }
            }
        }
        if (attWildcard != null) {
            if (attWildcard.type != -1) {
                this.fSchemaGrammar.addAttDef(typeInfo.templateElementIndex, attWildcard.name, attWildcard.type, attWildcard.enumeration, attWildcard.defaultType, attWildcard.defaultValue, attWildcard.datatypeValidator, attWildcard.list);
            } else {
                this.reportGenericSchemaError("The intensional intersection for {attribute wildcard}s must be expressible");
            }
        } else if (baseAttWildcard != null) {
            this.fSchemaGrammar.addAttDef(typeInfo.templateElementIndex, baseAttWildcard.name, baseAttWildcard.type, baseAttWildcard.enumeration, baseAttWildcard.defaultType, baseAttWildcard.defaultValue, baseAttWildcard.datatypeValidator, baseAttWildcard.list);
        }
        typeInfo.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(typeInfo.templateElementIndex);
        if (typeInfo.derivedBy == 2 && typeInfo.attlistHead > -1 && baseTypeInfo != null) {
            this.checkAttributesDerivationOKRestriction(typeInfo.attlistHead, this.fSchemaGrammar, attWildcard, baseTypeInfo.attlistHead, aGrammar, baseAttWildcard);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkAttributesDerivationOKRestriction(int dAttListHead, SchemaGrammar dGrammar, XMLAttributeDecl dAttWildCard, int bAttListHead, SchemaGrammar bGrammar, XMLAttributeDecl bAttWildCard) throws ComplexTypeRecoverableError {
        attDefIndex = dAttListHead;
        if (bAttListHead >= 0) ** GOTO lbl25
        throw new ComplexTypeRecoverableError("derivation-ok-restriction.2:  Base type definition does not have any attributes");
lbl-1000:
        // 1 sources

        {
            this.fTempAttributeDecl.clear();
            dGrammar.getAttributeDecl(attDefIndex, this.fTempAttributeDecl);
            if (this.isAWildCard(this.fTempAttributeDecl)) {
                attDefIndex = dGrammar.getNextAttributeDeclIndex(attDefIndex);
                continue;
            }
            bAttDefIndex = bGrammar.findAttributeDecl(bAttListHead, this.fTempAttributeDecl.name);
            if (bAttDefIndex > -1) {
                this.fTemp2AttributeDecl.clear();
                bGrammar.getAttributeDecl(bAttDefIndex, this.fTemp2AttributeDecl);
                if ((this.fTemp2AttributeDecl.defaultType & 2) > 0 && (this.fTempAttributeDecl.defaultType & 2) <= 0) {
                    throw new ComplexTypeRecoverableError("derivation-ok-restriction.2.1.1:  Attribute '" + this.fStringPool.toString(this.fTempAttributeDecl.name.localpart) + "' in derivation has an inconsistent REQUIRED setting to that of attribute in base");
                }
                if (!this.checkSimpleTypeDerivationOK(this.fTempAttributeDecl.datatypeValidator, this.fTemp2AttributeDecl.datatypeValidator)) {
                    throw new ComplexTypeRecoverableError("derivation-ok-restriction.2.1.2:  Type of attribute '" + this.fStringPool.toString(this.fTempAttributeDecl.name.localpart) + "' in derivation must be a restriction of type of attribute in base");
                }
                if (!((this.fTemp2AttributeDecl.defaultType & 16) <= 0 || (this.fTempAttributeDecl.defaultType & 16) > 0 && this.fTempAttributeDecl.defaultValue.equals(this.fTemp2AttributeDecl.defaultValue))) {
                    throw new ComplexTypeRecoverableError("derivation-ok-restriction.2.1.3:  Attribute '" + this.fStringPool.toString(this.fTempAttributeDecl.name.localpart) + "' is either not fixed, or is not fixed with the same value as the attribute in the base");
                }
            } else if (bAttWildCard == null || !this.AWildCardAllowsNameSpace(bAttWildCard, dGrammar.getTargetNamespaceURI())) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.2.2:  Attribute '" + this.fStringPool.toString(this.fTempAttributeDecl.name.localpart) + "' has a target namespace which is not valid with respect to a base type definition's wildcard or, the base does not contain a wildcard");
            }
            attDefIndex = dGrammar.getNextAttributeDeclIndex(attDefIndex);
lbl25:
            // 3 sources

            ** while (attDefIndex > -1)
        }
lbl26:
        // 1 sources

        if (dAttWildCard != null) {
            if (bAttWildCard == null) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.4.1: An attribute wildcard is present in the derived type, but not the base");
            }
            if (!this.AWildCardSubset(dAttWildCard, bAttWildCard)) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.4.2: The attribute wildcard in the derived type is not a valid subset of that in the base");
            }
        }
    }

    private boolean isAttrOrAttrGroup(Element e) {
        String elementName = e.getLocalName();
        return elementName.equals("attribute") || elementName.equals("attributeGroup") || elementName.equals("anyAttribute");
    }

    private void checkRecursingComplexType() throws Exception {
        if (this.fCurrentTypeNameStack.empty() && !this.fElementRecurseComplex.isEmpty()) {
            int count = this.fElementRecurseComplex.size();
            int i = 0;
            while (i < count) {
                ElementInfo eobj = (ElementInfo)this.fElementRecurseComplex.elementAt(i);
                int elementIndex = eobj.elementIndex;
                String typeName = eobj.typeName;
                ComplexTypeInfo typeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(String.valueOf(this.fTargetNSURIString) + "," + typeName);
                if (typeInfo == null) {
                    throw new Exception("Internal Error in void checkRecursingComplexType(). ");
                }
                this.fSchemaGrammar.getElementDecl(elementIndex, this.fTempElementDecl);
                this.fTempElementDecl.type = typeInfo.contentType;
                this.fTempElementDecl.contentSpecIndex = typeInfo.contentSpecHandle;
                this.fTempElementDecl.datatypeValidator = typeInfo.datatypeValidator;
                this.fSchemaGrammar.setElementDecl(elementIndex, this.fTempElementDecl);
                this.fSchemaGrammar.setFirstAttributeDeclIndex(elementIndex, typeInfo.attlistHead);
                this.fSchemaGrammar.setElementComplexTypeInfo(elementIndex, typeInfo);
                this.fSchemaGrammar.setElementDefinedScope(elementIndex, typeInfo.scopeDefined);
                ++i;
            }
            this.fElementRecurseComplex.removeAllElements();
        }
    }

    private void checkParticleDerivationOK(int derivedContentSpecIndex, int derivedScope, int baseContentSpecIndex, int baseScope, ComplexTypeInfo bInfo) throws Exception {
        if (!this.fFullConstraintChecking) {
            return;
        }
        int csIndex1 = derivedContentSpecIndex;
        this.fSchemaGrammar.getContentSpec(csIndex1, this.tempContentSpec1);
        int csIndex2 = baseContentSpecIndex;
        this.fSchemaGrammar.getContentSpec(csIndex2, this.tempContentSpec2);
        Vector tempVector1 = new Vector();
        Vector tempVector2 = new Vector();
        if (this.tempContentSpec1.type == 5 || this.tempContentSpec1.type == 4 || this.tempContentSpec1.type == 9) {
            csIndex1 = this.checkForPointlessOccurrences(csIndex1, tempVector1);
        }
        if (this.tempContentSpec2.type == 5 || this.tempContentSpec2.type == 4 || this.tempContentSpec2.type == 9) {
            csIndex2 = this.checkForPointlessOccurrences(csIndex2, tempVector2);
        }
        this.fSchemaGrammar.getContentSpec(csIndex1, this.tempContentSpec1);
        this.fSchemaGrammar.getContentSpec(csIndex2, this.tempContentSpec2);
        switch (this.tempContentSpec1.type & 0xF) {
            case 0: {
                switch (this.tempContentSpec2.type & 0xF) {
                    case 0: {
                        this.checkNameAndTypeOK(csIndex1, derivedScope, csIndex2, baseScope, bInfo);
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.checkNSCompat(csIndex1, derivedScope, csIndex2);
                        return;
                    }
                    case 4: 
                    case 5: 
                    case 9: {
                        this.checkRecurseAsIfGroup(csIndex1, derivedScope, csIndex2, tempVector2, baseScope, bInfo);
                        return;
                    }
                }
                throw new ParticleRecoverableError("internal Xerces error");
            }
            case 6: 
            case 7: 
            case 8: {
                switch (this.tempContentSpec2.type & 0xF) {
                    case 6: 
                    case 7: 
                    case 8: {
                        this.checkNSSubset(csIndex1, csIndex2);
                        return;
                    }
                    case 0: 
                    case 4: 
                    case 5: 
                    case 9: {
                        throw new ParticleRecoverableError("cos-particle-restrict: Forbidden restriction: Any: Choice,Seq,All,Elt");
                    }
                }
                throw new ParticleRecoverableError("internal Xerces error");
            }
            case 9: {
                switch (this.tempContentSpec2.type & 0xF) {
                    case 6: 
                    case 7: 
                    case 8: {
                        this.checkNSRecurseCheckCardinality(csIndex1, tempVector1, derivedScope, csIndex2);
                        return;
                    }
                    case 9: {
                        this.checkRecurse(csIndex1, tempVector1, derivedScope, csIndex2, tempVector2, baseScope, bInfo);
                        return;
                    }
                    case 0: 
                    case 4: 
                    case 5: {
                        throw new ParticleRecoverableError("cos-particle-restrict: Forbidden restriction: All:Choice,Seq,Elt");
                    }
                }
                throw new ParticleRecoverableError("internal Xerces error");
            }
            case 4: {
                switch (this.tempContentSpec2.type & 0xF) {
                    case 6: 
                    case 7: 
                    case 8: {
                        this.checkNSRecurseCheckCardinality(csIndex1, tempVector1, derivedScope, csIndex2);
                        return;
                    }
                    case 4: {
                        this.checkRecurseLax(csIndex1, tempVector1, derivedScope, csIndex2, tempVector2, baseScope, bInfo);
                        return;
                    }
                    case 0: 
                    case 5: 
                    case 9: {
                        throw new ParticleRecoverableError("cos-particle-restrict: Forbidden restriction: Choice:All,Seq,Leaf");
                    }
                }
                throw new ParticleRecoverableError("internal Xerces error");
            }
            case 5: {
                switch (this.tempContentSpec2.type & 0xF) {
                    case 6: 
                    case 7: 
                    case 8: {
                        this.checkNSRecurseCheckCardinality(csIndex1, tempVector1, derivedScope, csIndex2);
                        return;
                    }
                    case 9: {
                        this.checkRecurseUnordered(csIndex1, tempVector1, derivedScope, csIndex2, tempVector2, baseScope, bInfo);
                        return;
                    }
                    case 5: {
                        this.checkRecurse(csIndex1, tempVector1, derivedScope, csIndex2, tempVector2, baseScope, bInfo);
                        return;
                    }
                    case 4: {
                        this.checkMapAndSum(csIndex1, tempVector1, derivedScope, csIndex2, tempVector2, baseScope, bInfo);
                        return;
                    }
                    case 0: {
                        throw new ParticleRecoverableError("cos-particle-restrict: Forbidden restriction: Seq:Elt");
                    }
                }
                throw new ParticleRecoverableError("internal Xerces error");
            }
        }
    }

    private int checkForPointlessOccurrences(int csIndex, Vector tempVector) {
        this.fSchemaGrammar.getContentSpec(csIndex, this.tempContentSpec1);
        if (this.tempContentSpec1.otherValue == -2) {
            this.gatherChildren(this.tempContentSpec1.type, this.tempContentSpec1.value, tempVector);
            if (tempVector.size() == 1) {
                Integer returnVal = (Integer)tempVector.elementAt(0);
                return returnVal;
            }
            return csIndex;
        }
        int type = this.tempContentSpec1.type;
        int value = this.tempContentSpec1.value;
        int otherValue = this.tempContentSpec1.otherValue;
        this.gatherChildren(type, value, tempVector);
        this.gatherChildren(type, otherValue, tempVector);
        return csIndex;
    }

    private void gatherChildren(int parentType, int csIndex, Vector tempVector) {
        this.fSchemaGrammar.getContentSpec(csIndex, this.tempContentSpec1);
        int min = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex);
        int max = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex);
        int left = this.tempContentSpec1.value;
        int right = this.tempContentSpec1.otherValue;
        int type = this.tempContentSpec1.type;
        if (type == 0 || (type & 0xF) == 6 || (type & 0xF) == 8 || (type & 0xF) == 7) {
            tempVector.addElement(new Integer(csIndex));
        } else if (min != 1 || max != 1) {
            tempVector.addElement(new Integer(csIndex));
        } else if (right == -2) {
            this.gatherChildren(type, left, tempVector);
        } else if (parentType == type) {
            this.gatherChildren(type, left, tempVector);
            this.gatherChildren(type, right, tempVector);
        } else {
            tempVector.addElement(new Integer(csIndex));
        }
    }

    private void checkNameAndTypeOK(int csIndex1, int derivedScope, int csIndex2, int baseScope, ComplexTypeInfo bInfo) throws Exception {
        int blockSet2;
        int eltndx1;
        this.fSchemaGrammar.getContentSpec(csIndex1, this.tempContentSpec1);
        this.fSchemaGrammar.getContentSpec(csIndex2, this.tempContentSpec2);
        int localpart1 = this.tempContentSpec1.value;
        int uri1 = this.tempContentSpec1.otherValue;
        int localpart2 = this.tempContentSpec2.value;
        int uri2 = this.tempContentSpec2.otherValue;
        int min1 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex1);
        int max1 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex1);
        int min2 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex2);
        int max2 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex2);
        if (localpart1 != localpart2 || uri1 != uri2) {
            if (this.fSComp == null) {
                this.fSComp = new SubstitutionGroupComparator(this.fGrammarResolver, this.fStringPool, this.fErrorReporter);
            }
            if (!this.checkSubstitutionGroups(localpart1, uri1, localpart2, uri2)) {
                throw new ParticleRecoverableError("rcase-nameAndTypeOK.1:  Element name/uri in restriction does not match that of corresponding base element");
            }
        }
        if (!this.checkOccurrenceRange(min1, max1, min2, max2)) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.3:  Element occurrence range not a restriction of base element's range: element is " + this.fStringPool.toString(localpart1));
        }
        SchemaGrammar aGrammar = this.fSchemaGrammar;
        String schemaURI = this.fStringPool.toString(uri1);
        if (!schemaURI.equals(this.fTargetNSURIString) && schemaURI.length() != 0) {
            aGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(schemaURI);
        }
        if ((eltndx1 = this.findElement(derivedScope, uri1, localpart1, aGrammar, null)) < 0) {
            return;
        }
        int eltndx2 = this.findElement(baseScope, uri2, localpart2, aGrammar, bInfo);
        if (eltndx2 < 0) {
            return;
        }
        int miscFlags1 = aGrammar.getElementDeclMiscFlags(eltndx1);
        int miscFlags2 = aGrammar.getElementDeclMiscFlags(eltndx2);
        boolean element1IsNillable = (miscFlags1 & 1) != 0;
        boolean element2IsNillable = (miscFlags2 & 1) != 0;
        boolean element2IsFixed = (miscFlags2 & 4) != 0;
        boolean element1IsFixed = (miscFlags1 & 4) != 0;
        String element1Value = aGrammar.getElementDefaultValue(eltndx1);
        String element2Value = aGrammar.getElementDefaultValue(eltndx2);
        if (!element2IsNillable && element1IsNillable) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.2:  Element " + this.fStringPool.toString(localpart1) + " is nillable in the restriction but not the base");
        }
        if (!(element2Value == null || !element2IsFixed || element1IsFixed && element1Value.equals(element2Value))) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.4:  Element " + this.fStringPool.toString(localpart1) + " is either not fixed, or is not fixed with the same value as in the base");
        }
        int blockSet1 = aGrammar.getElementDeclBlockSet(eltndx1);
        if ((blockSet1 & (blockSet2 = aGrammar.getElementDeclBlockSet(eltndx2))) != blockSet2 || blockSet1 == 0 && blockSet2 != 0) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.6:  Element " + this.fStringPool.toString(localpart1) + "'s disallowed subsitutions are not a superset of those of the base element's");
        }
        aGrammar.getElementDecl(eltndx1, this.fTempElementDecl);
        aGrammar.getElementDecl(eltndx2, this.fTempElementDecl2);
        this.checkIDConstraintRestriction(this.fTempElementDecl, this.fTempElementDecl2, aGrammar, localpart1, localpart2);
        this.checkTypesOK(this.fTempElementDecl, this.fTempElementDecl2, eltndx1, eltndx2, aGrammar, this.fStringPool.toString(localpart1));
    }

    /*
     * Unable to fully structure code
     */
    private void checkTypesOK(XMLElementDecl derived, XMLElementDecl base, int dndx, int bndx, SchemaGrammar aGrammar, String elementName) throws Exception {
        tempType = aGrammar.getElementComplexTypeInfo(dndx);
        bType = aGrammar.getElementComplexTypeInfo(bndx);
        if (derived.type != 5) ** GOTO lbl14
        if (base.type != 5 && base.type != 1) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.6:  Derived element " + elementName + " has a type that does not derive from that of the base");
        }
        if (tempType != null) ** GOTO lbl14
        if (!(this.checkSimpleTypeDerivationOK(derived.datatypeValidator, base.datatypeValidator) || bType == null && base.datatypeValidator == null)) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.6:  Derived element " + elementName + " has a type that does not derive from that of the base");
        }
        return;
        while (bType == null || !tempType.typeName.equals(bType.typeName)) {
            if (tempType.derivedBy != 2) {
                throw new ParticleRecoverableError("rcase-nameAndTypeOK.6:  Derived element " + elementName + " has a type that does not derive from that of the base");
            }
            tempType = tempType.baseComplexTypeInfo;
lbl14:
            // 3 sources

            if (tempType != null) continue;
        }
        if (tempType == null && (bType != null || base.datatypeValidator != null)) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.6:  Derived element " + elementName + " has a type that does not derive from that of the base");
        }
    }

    private void checkIDConstraintRestriction(XMLElementDecl derivedElemDecl, XMLElementDecl baseElemDecl, SchemaGrammar grammar, int derivedElemName, int baseElemName) throws Exception {
        Vector derivedUnique = derivedElemDecl.unique;
        Vector baseUnique = baseElemDecl.unique;
        if (derivedUnique.size() > baseUnique.size()) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.5:  derived element " + this.fStringPool.toString(derivedElemName) + " has fewer <unique> Identity Constraints than the base element" + this.fStringPool.toString(baseElemName));
        }
        boolean found = true;
        int i = 0;
        while (i < derivedUnique.size() && found) {
            Unique id = (Unique)derivedUnique.elementAt(i);
            found = false;
            int j = 0;
            while (j < baseUnique.size()) {
                if (id.equals((Unique)baseUnique.elementAt(j))) {
                    found = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (!found) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.5:  derived element " + this.fStringPool.toString(derivedElemName) + " has a <unique> Identity Constraint that does not appear on the base element" + this.fStringPool.toString(baseElemName));
        }
        Vector derivedKey = derivedElemDecl.key;
        Vector baseKey = baseElemDecl.key;
        if (derivedKey.size() > baseKey.size()) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.5:  derived element " + this.fStringPool.toString(derivedElemName) + " has fewer <key> Identity Constraints than the base element" + this.fStringPool.toString(baseElemName));
        }
        boolean found2 = true;
        int i2 = 0;
        while (i2 < derivedKey.size() && found2) {
            Key id = (Key)derivedKey.elementAt(i2);
            found2 = false;
            int j = 0;
            while (j < baseKey.size()) {
                if (id.equals((Key)baseKey.elementAt(j))) {
                    found2 = true;
                    break;
                }
                ++j;
            }
            ++i2;
        }
        if (!found2) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.5:  derived element " + this.fStringPool.toString(derivedElemName) + " has a <key> Identity Constraint that does not appear on the base element" + this.fStringPool.toString(baseElemName));
        }
        Vector derivedKeyRef = derivedElemDecl.keyRef;
        Vector baseKeyRef = baseElemDecl.keyRef;
        if (derivedKeyRef.size() > baseKeyRef.size()) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.5:  derived element " + this.fStringPool.toString(derivedElemName) + " has fewer <keyref> Identity Constraints than the base element" + this.fStringPool.toString(baseElemName));
        }
        boolean found3 = true;
        int i3 = 0;
        while (i3 < derivedKeyRef.size() && found3) {
            KeyRef id = (KeyRef)derivedKeyRef.elementAt(i3);
            found3 = false;
            int j = 0;
            while (j < baseKeyRef.size()) {
                if (id.equals((KeyRef)baseKeyRef.elementAt(j))) {
                    found3 = true;
                    break;
                }
                ++j;
            }
            ++i3;
        }
        if (!found3) {
            throw new ParticleRecoverableError("rcase-nameAndTypeOK.5:  derived element " + this.fStringPool.toString(derivedElemName) + " has a <keyref> Identity Constraint that does not appear on the base element" + this.fStringPool.toString(baseElemName));
        }
    }

    private boolean checkSubstitutionGroups(int local1, int uri1, int local2, int uri2) throws Exception {
        QName name1 = new QName(-1, local1, local1, uri1);
        QName name2 = new QName(-1, local2, local2, uri2);
        return this.fSComp.isEquivalentTo(name1, name2) || this.fSComp.isEquivalentTo(name2, name1);
    }

    private boolean checkOccurrenceRange(int min1, int max1, int min2, int max2) {
        return min1 >= min2 && (max2 == -2 || max1 != -2 && max1 <= max2);
    }

    private int findElement(int scope, int uriIndex, int nameIndex, SchemaGrammar gr, ComplexTypeInfo bInfo) {
        int elementDeclIndex = gr.getElementDeclIndex(uriIndex, nameIndex, scope);
        if (elementDeclIndex == -1 && (elementDeclIndex = gr.getElementDeclIndex(nameIndex, -1)) == -1 && bInfo != null) {
            ComplexTypeInfo baseInfo = bInfo;
            while (baseInfo != null) {
                elementDeclIndex = gr.getElementDeclIndex(nameIndex, baseInfo.scopeDefined);
                if (elementDeclIndex > -1) break;
                baseInfo = baseInfo.baseComplexTypeInfo;
            }
        }
        return elementDeclIndex;
    }

    private void checkNSCompat(int csIndex1, int derivedScope, int csIndex2) throws Exception {
        int max2;
        int min2;
        int max1;
        int min1 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex1);
        if (!this.checkOccurrenceRange(min1, max1 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex1), min2 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex2), max2 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex2))) {
            throw new ParticleRecoverableError("rcase-NSCompat.2:  Element occurrence range not a restriction of base any element's range");
        }
        this.fSchemaGrammar.getContentSpec(csIndex1, this.tempContentSpec1);
        int uri = this.tempContentSpec1.otherValue;
        if (!this.wildcardEltAllowsNamespace(csIndex2, uri)) {
            throw new ParticleRecoverableError("rcase-NSCompat.1:  Element's namespace not allowed by wildcard in base");
        }
    }

    private boolean wildcardEltAllowsNamespace(int wildcardNode, int uriIndex) {
        this.fSchemaGrammar.getContentSpec(wildcardNode, this.tempContentSpec1);
        if ((this.tempContentSpec1.type & 0xF) == 6) {
            return true;
        }
        return (this.tempContentSpec1.type & 0xF) == 8 ? uriIndex == this.tempContentSpec1.otherValue : uriIndex != this.tempContentSpec1.otherValue && uriIndex != 0;
    }

    private void checkNSSubset(int csIndex1, int csIndex2) throws Exception {
        int max2;
        int min2;
        int max1;
        int min1 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex1);
        if (!this.checkOccurrenceRange(min1, max1 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex1), min2 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex2), max2 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex2))) {
            throw new ParticleRecoverableError("rcase-NSSubset.2:  Wildcard's occurrence range not a restriction of base wildcard's range");
        }
        if (!this.wildcardEltSubset(csIndex1, csIndex2)) {
            throw new ParticleRecoverableError("rcase-NSSubset.1:  Wildcard is not a subset of corresponding wildcard in base");
        }
    }

    private boolean wildcardEltSubset(int wildcardNode, int wildcardBaseNode) {
        this.fSchemaGrammar.getContentSpec(wildcardNode, this.tempContentSpec1);
        this.fSchemaGrammar.getContentSpec(wildcardBaseNode, this.tempContentSpec2);
        if ((this.tempContentSpec2.type & 0xF) == 6) {
            return true;
        }
        if ((this.tempContentSpec1.type & 0xF) == 7 && (this.tempContentSpec2.type & 0xF) == 7 && this.tempContentSpec1.otherValue == this.tempContentSpec2.otherValue) {
            return true;
        }
        if ((this.tempContentSpec1.type & 0xF) == 8) {
            if ((this.tempContentSpec2.type & 0xF) == 8 && this.tempContentSpec1.otherValue == this.tempContentSpec2.otherValue) {
                return true;
            }
            if ((this.tempContentSpec2.type & 0xF) == 7 && this.tempContentSpec1.otherValue != this.tempContentSpec2.otherValue) {
                return true;
            }
        }
        return false;
    }

    private void checkRecurseAsIfGroup(int csIndex1, int derivedScope, int csIndex2, Vector tempVector2, int baseScope, ComplexTypeInfo bInfo) throws Exception {
        this.fSchemaGrammar.getContentSpec(csIndex2, this.tempContentSpec2);
        int indexOfGrp = this.fSchemaGrammar.addContentSpecNode(this.tempContentSpec2.type, csIndex1, -2, false);
        Vector<Integer> tmpVector = new Vector<Integer>();
        tmpVector.addElement(new Integer(csIndex1));
        if (this.tempContentSpec2.type == 9 || this.tempContentSpec2.type == 5) {
            this.checkRecurse(indexOfGrp, tmpVector, derivedScope, csIndex2, tempVector2, baseScope, bInfo);
        } else {
            this.checkRecurseLax(indexOfGrp, tmpVector, derivedScope, csIndex2, tempVector2, baseScope, bInfo);
        }
        tmpVector = null;
    }

    private void checkNSRecurseCheckCardinality(int csIndex1, Vector tempVector1, int derivedScope, int csIndex2) throws Exception {
        int max2;
        int min2;
        int max1;
        int min1 = this.minEffectiveTotalRange(csIndex1);
        if (!this.checkOccurrenceRange(min1, max1 = this.maxEffectiveTotalRange(csIndex1), min2 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex2), max2 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex2))) {
            throw new ParticleRecoverableError("rcase-NSSubset.2:  Wildcard's occurrence range not a restriction of base wildcard's range");
        }
        if (!this.wildcardEltSubset(csIndex1, csIndex2)) {
            throw new ParticleRecoverableError("rcase-NSSubset.1:  Wildcard is not a subset of corresponding wildcard in base");
        }
        int count = tempVector1.size();
        int i = 0;
        while (i < count) {
            Integer particle1 = (Integer)tempVector1.elementAt(i);
            this.checkParticleDerivationOK(particle1, derivedScope, csIndex2, -1, null);
            ++i;
        }
    }

    private void checkRecurse(int csIndex1, Vector tempVector1, int derivedScope, int csIndex2, Vector tempVector2, int baseScope, ComplexTypeInfo bInfo) throws Exception {
        int max2;
        int min2;
        int max1;
        int min1 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex1);
        if (!this.checkOccurrenceRange(min1, max1 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex1), min2 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex2), max2 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex2))) {
            throw new ParticleRecoverableError("rcase-Recurse.1:  Occurrence range of group is not a valid restriction of occurence range of base group");
        }
        int count1 = tempVector1.size();
        int count2 = tempVector2.size();
        int current = 0;
        int i = 0;
        while (i < count1) {
            block8: {
                Integer particle1 = (Integer)tempVector1.elementAt(i);
                int j = current;
                while (j < count2) {
                    Integer particle2 = (Integer)tempVector2.elementAt(j);
                    ++current;
                    try {
                        this.checkParticleDerivationOK(particle1, derivedScope, particle2, baseScope, bInfo);
                        break block8;
                    }
                    catch (ParticleRecoverableError e) {
                        if (!this.particleEmptiable(particle2)) {
                            throw new ParticleRecoverableError("rcase-Recurse.2:  There is not a complete functional mapping between the particles");
                        }
                        ++j;
                    }
                }
                throw new ParticleRecoverableError("rcase-Recurse.2:  There is not a complete functional mapping between the particles");
            }
            ++i;
        }
        int j = current;
        while (j < count2) {
            Integer particle2 = (Integer)tempVector2.elementAt(j);
            if (!this.particleEmptiable(particle2)) {
                throw new ParticleRecoverableError("rcase-Recurse.2:  There is not a complete functional mapping between the particles");
            }
            ++j;
        }
    }

    private void checkRecurseUnordered(int csIndex1, Vector tempVector1, int derivedScope, int csIndex2, Vector tempVector2, int baseScope, ComplexTypeInfo bInfo) throws Exception {
        int max2;
        int min2;
        int max1;
        int min1 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex1);
        if (!this.checkOccurrenceRange(min1, max1 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex1), min2 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex2), max2 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex2))) {
            throw new ParticleRecoverableError("rcase-RecurseUnordered.1:  Occurrence range of group is not a valid restriction of occurence range of base group");
        }
        int count1 = tempVector1.size();
        int count2 = tempVector2.size();
        boolean[] foundIt = new boolean[count2];
        int i = 0;
        while (i < count1) {
            block6: {
                Integer particle1 = (Integer)tempVector1.elementAt(i);
                int j = 0;
                while (j < count2) {
                    Integer particle2 = (Integer)tempVector2.elementAt(j);
                    try {
                        this.checkParticleDerivationOK(particle1, derivedScope, particle2, baseScope, bInfo);
                        if (foundIt[j]) {
                            throw new ParticleRecoverableError("rcase-RecurseUnordered.2:  There is not a complete functional mapping between the particles");
                        }
                        foundIt[j] = true;
                        break block6;
                    }
                    catch (ParticleRecoverableError particleRecoverableError) {
                        ++j;
                    }
                }
                throw new ParticleRecoverableError("rcase-RecurseUnordered.2:  There is not a complete functional mapping between the particles");
            }
            ++i;
        }
    }

    private void checkRecurseLax(int csIndex1, Vector tempVector1, int derivedScope, int csIndex2, Vector tempVector2, int baseScope, ComplexTypeInfo bInfo) throws Exception {
        int max2;
        int min2;
        int max1;
        int min1 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex1);
        if (!this.checkOccurrenceRange(min1, max1 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex1), min2 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex2), max2 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex2))) {
            throw new ParticleRecoverableError("rcase-RecurseLax.1:  Occurrence range of group is not a valid restriction of occurence range of base group");
        }
        int count1 = tempVector1.size();
        int count2 = tempVector2.size();
        int current = 0;
        int i = 0;
        while (i < count1) {
            block5: {
                Integer particle1 = (Integer)tempVector1.elementAt(i);
                int j = current;
                while (j < count2) {
                    Integer particle2 = (Integer)tempVector2.elementAt(j);
                    ++current;
                    try {
                        this.checkParticleDerivationOK(particle1, derivedScope, particle2, baseScope, bInfo);
                        break block5;
                    }
                    catch (ParticleRecoverableError particleRecoverableError) {
                        ++j;
                    }
                }
                throw new ParticleRecoverableError("rcase-Recurse.2:  There is not a complete functional mapping between the particles");
            }
            ++i;
        }
    }

    private void checkMapAndSum(int csIndex1, Vector tempVector1, int derivedScope, int csIndex2, Vector tempVector2, int baseScope, ComplexTypeInfo bInfo) throws Exception {
        int max2;
        int min2;
        int count1 = tempVector1.size();
        int count2 = tempVector2.size();
        int min1 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex1) * count1;
        int max1 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex1);
        if (max1 != -2) {
            max1 *= count1;
        }
        if (!this.checkOccurrenceRange(min1, max1, min2 = this.fSchemaGrammar.getContentSpecMinOccurs(csIndex2), max2 = this.fSchemaGrammar.getContentSpecMaxOccurs(csIndex2))) {
            throw new ParticleRecoverableError("rcase-MapAndSum.2:  Occurrence range of group is not a valid restriction of occurence range of base group");
        }
        int i = 0;
        while (i < count1) {
            block6: {
                Integer particle1 = (Integer)tempVector1.elementAt(i);
                int j = 0;
                while (j < count2) {
                    Integer particle2 = (Integer)tempVector2.elementAt(j);
                    try {
                        this.checkParticleDerivationOK(particle1, derivedScope, particle2, baseScope, bInfo);
                        break block6;
                    }
                    catch (ParticleRecoverableError particleRecoverableError) {
                        ++j;
                    }
                }
                throw new ParticleRecoverableError("rcase-MapAndSum.1:  There is not a complete functional mapping between the particles");
            }
            ++i;
        }
    }

    private int importContentSpec(SchemaGrammar aGrammar, int contentSpecHead) throws Exception {
        XMLContentSpec ctsp = new XMLContentSpec();
        aGrammar.getContentSpec(contentSpecHead, ctsp);
        int left = -1;
        int right = -1;
        if (ctsp.type == 0 || (ctsp.type & 0xF) == 6 || (ctsp.type & 0xF) == 8 || (ctsp.type & 0xF) == 7) {
            left = this.fSchemaGrammar.addContentSpecNode(ctsp.type, ctsp.value, ctsp.otherValue, false);
        } else {
            if (ctsp.type == -1) {
                return -2;
            }
            left = ctsp.value == -1 ? -1 : this.importContentSpec(aGrammar, ctsp.value);
            right = ctsp.otherValue == -1 ? -1 : this.importContentSpec(aGrammar, ctsp.otherValue);
            left = this.fSchemaGrammar.addContentSpecNode(ctsp.type, left, right, false);
        }
        if (this.fFullConstraintChecking) {
            this.fSchemaGrammar.setContentSpecMaxOccurs(left, aGrammar.getContentSpecMaxOccurs(contentSpecHead));
            this.fSchemaGrammar.setContentSpecMinOccurs(left, aGrammar.getContentSpecMinOccurs(contentSpecHead));
        }
        return left;
    }

    private int handleOccurrences(int index, Element particle) throws Exception {
        return this.handleOccurrences(index, particle, 0);
    }

    private int handleOccurrences(int index, Element particle, int allContextFlags) throws Exception {
        boolean isGroupChild;
        if (index < 0) {
            return index;
        }
        String minOccurs = particle.getAttribute("minOccurs").trim();
        String maxOccurs = particle.getAttribute("maxOccurs").trim();
        boolean processingAllEl = (allContextFlags & 1) != 0;
        boolean processingAllGP = (allContextFlags & 8) != 0;
        boolean groupRefWithAll = (allContextFlags & 2) != 0;
        boolean bl = isGroupChild = (allContextFlags & 4) != 0;
        if (isGroupChild && (minOccurs.length() != 0 || maxOccurs.length() != 0)) {
            Element group = (Element)particle.getParentNode();
            Object[] args = new Object[]{group.getAttribute("name"), particle.getNodeName()};
            this.reportSchemaError(49, args);
            maxOccurs = "1";
            minOccurs = "1";
        }
        if (minOccurs.equals("0") && maxOccurs.equals("0")) {
            return -2;
        }
        int min = 1;
        int max = 1;
        if (minOccurs.length() == 0) {
            minOccurs = "1";
        }
        if (maxOccurs.length() == 0) {
            maxOccurs = "1";
        }
        if (processingAllEl || groupRefWithAll || processingAllGP) {
            if ((processingAllGP || groupRefWithAll || !minOccurs.equals("0")) && !minOccurs.equals("1")) {
                int minMsg = processingAllEl ? 44 : (processingAllGP ? 50 : 45);
                this.reportSchemaError(minMsg, new Object[]{"minOccurs", minOccurs});
                minOccurs = "1";
            }
            if (!maxOccurs.equals("1")) {
                int maxMsg = processingAllEl ? 44 : (processingAllGP ? 50 : 45);
                this.reportSchemaError(maxMsg, new Object[]{"maxOccurs", maxOccurs});
                maxOccurs = "1";
            }
        }
        try {
            min = Integer.parseInt(minOccurs);
        }
        catch (Exception e) {
            this.reportSchemaError(23, new Object[]{"illegal value for minOccurs or maxOccurs : '" + e.getMessage() + "' "});
        }
        if (maxOccurs.equals("unbounded")) {
            max = -2;
        } else {
            try {
                max = Integer.parseInt(maxOccurs);
            }
            catch (Exception e) {
                this.reportSchemaError(23, new Object[]{"illegal value for minOccurs or maxOccurs : '" + e.getMessage() + "' "});
            }
            if (min > max) {
                this.reportGenericSchemaError("p-props-correct:2.1 Value of minOccurs '" + minOccurs + "' must not be greater than value of maxOccurs '" + maxOccurs + "'");
            }
            if (max < 1) {
                this.reportGenericSchemaError("p-props-correct:2.2 Value of maxOccurs " + maxOccurs + " is invalid.  It must be greater than or equal to 1");
            }
        }
        if (this.fSchemaGrammar.getDeferContentSpecExpansion()) {
            this.fSchemaGrammar.setContentSpecMinOccurs(index, min);
            this.fSchemaGrammar.setContentSpecMaxOccurs(index, max);
            return index;
        }
        return this.fSchemaGrammar.expandContentModel(index, min, max);
    }

    private int traverseAttributeDecl(Element attrDecl, ComplexTypeInfo typeInfo, boolean referredTo) throws Exception {
        DatatypeValidator dv;
        int attType;
        QName attQName;
        StringBuffer errorContext;
        boolean isAttrTopLevel;
        int attValueConstraint;
        int attValueAndUseType;
        boolean dvIsDerivedFromID;
        int dataTypeSymbol;
        boolean attIsList;
        String attNameStr;
        block83: {
            int uriIndex;
            int scope = this.isTopLevel(attrDecl) ? GeneralAttrCheck.ELE_CONTEXT_GLOBAL : GeneralAttrCheck.ELE_CONTEXT_LOCAL;
            Hashtable attrValues = this.generalCheck(attrDecl, scope);
            String defaultStr = attrDecl.getAttribute("default");
            String fixedStr = attrDecl.getAttribute("fixed");
            String formStr = attrDecl.getAttribute("form");
            attNameStr = attrDecl.getAttribute("name");
            String refStr = attrDecl.getAttribute("ref");
            String datatypeStr = attrDecl.getAttribute("type");
            String useStr = attrDecl.getAttribute("use");
            Element simpleTypeChild = this.findAttributeSimpleType(attrDecl);
            Attr defaultAtt = attrDecl.getAttributeNode("default");
            Attr fixedAtt = attrDecl.getAttributeNode("fixed");
            Attr formAtt = attrDecl.getAttributeNode("form");
            Attr attNameAtt = attrDecl.getAttributeNode("name");
            Attr refAtt = attrDecl.getAttributeNode("ref");
            Attr datatypeAtt = attrDecl.getAttributeNode("type");
            Attr useAtt = attrDecl.getAttributeNode("use");
            this.checkEnumerationRequiredNotation(attNameStr, datatypeStr);
            attIsList = false;
            dataTypeSymbol = -1;
            String localpart = null;
            dvIsDerivedFromID = false;
            attValueAndUseType = 0;
            attValueConstraint = -1;
            isAttrTopLevel = this.isTopLevel(attrDecl);
            boolean isOptional = false;
            boolean isProhibited = false;
            boolean isRequired = false;
            errorContext = new StringBuffer(30);
            errorContext.append(" -- ");
            if (typeInfo == null) {
                errorContext.append("(global attribute) ");
            } else if (typeInfo.typeName == null) {
                errorContext.append("(local attribute) ");
            } else {
                errorContext.append("(attribute) ").append(typeInfo.typeName).append("/");
            }
            errorContext.append(attNameStr).append(' ').append(refStr);
            if (useStr.length() == 0 || useStr.equals("optional")) {
                attValueAndUseType |= 1;
                isOptional = true;
            } else if (useStr.equals("prohibited")) {
                attValueAndUseType |= 4;
                isProhibited = true;
            } else if (useStr.equals("required")) {
                attValueAndUseType |= 2;
                isRequired = true;
            } else {
                this.reportGenericSchemaError("An attribute cannot declare \"use\" as \"" + useStr + "\"" + errorContext);
            }
            if (defaultAtt != null && fixedAtt != null) {
                this.reportGenericSchemaError("src-attribute.1: \"default\" and \"fixed\" cannot be both present" + errorContext);
            } else if (defaultAtt != null && !isOptional) {
                this.reportGenericSchemaError("src-attribute.2: If both \"default\" and \"use\" are present for an attribute declaration, \"use\" can only be \"optional\", not \"" + useStr + "\"." + errorContext);
            }
            if (!isAttrTopLevel) {
                if (refAtt == null == (attNameAtt == null)) {
                    this.reportGenericSchemaError("src-attribute.3.1: When the attribute's parent is not <schema> , one of \"ref\" and \"name\" should be declared, but not both." + errorContext);
                    return -1;
                }
                if (refAtt != null && (simpleTypeChild != null || formAtt != null || datatypeAtt != null)) {
                    this.reportGenericSchemaError("src-attribute.3.2: When the attribute's parent is not <schema> and \"ref\" is present, all of <simpleType>, form and type must be absent." + errorContext);
                }
            }
            if (datatypeAtt != null && simpleTypeChild != null) {
                this.reportGenericSchemaError("src-attribute.4: \"type\" and <simpleType> cannot both be present" + errorContext);
            }
            if (isAttrTopLevel) {
                int attName = this.fStringPool.addSymbol(attNameStr);
                uriIndex = this.fTargetNSURIString.length() == 0 ? 0 : this.fTargetNSURI;
                attQName = new QName();
                attQName.setValues(-1, attName, attName, uriIndex);
            } else if (refAtt == null) {
                int attName = this.fStringPool.addSymbol(attNameStr);
                uriIndex = formStr.length() > 0 && formStr.equals("qualified") || formStr.length() == 0 && this.fAttributeDefaultQualified ? this.fTargetNSURI : 0;
                attQName = new QName();
                attQName.setValues(-1, attName, attName, uriIndex);
            } else {
                String prefix;
                int colonptr = refStr.indexOf(":");
                if (colonptr > 0) {
                    prefix = refStr.substring(0, colonptr);
                    localpart = refStr.substring(colonptr + 1);
                } else {
                    prefix = "";
                    localpart = refStr;
                }
                String uriStr = this.resolvePrefixToURI(prefix);
                if (!uriStr.equals(this.fTargetNSURIString)) {
                    this.addAttributeDeclFromAnotherSchema(localpart, uriStr, typeInfo, defaultAtt != null, fixedAtt != null, fixedStr, attValueAndUseType);
                    return 0;
                }
                Element referredAttribute = this.getTopLevelComponentByName("attribute", localpart);
                if (referredAttribute != null) {
                    String referFixed;
                    this.traverseAttributeDecl(referredAttribute, typeInfo, true);
                    Attr referFixedAttr = referredAttribute.getAttributeNode("fixed");
                    String string = referFixed = referFixedAttr == null ? null : referFixedAttr.getValue();
                    if (referFixed != null && (defaultAtt != null || fixedAtt != null && !referFixed.equals(fixedStr))) {
                        this.reportGenericSchemaError("au-props-correct.2: If the {attribute declaration} has a fixed {value constraint}, then if the attribute use itself has a {value constraint}, it must also be fixed and its value must match that of the {attribute declaration}'s {value constraint}" + errorContext);
                    }
                    if (!(typeInfo == null || isOptional && fixedStr.length() <= 0)) {
                        int referredAttName = this.fStringPool.addSymbol(referredAttribute.getAttribute("name"));
                        int uriIndex2 = 0;
                        if (this.fTargetNSURIString.length() > 0) {
                            uriIndex2 = this.fTargetNSURI;
                        }
                        QName referredAttQName = new QName(-1, referredAttName, referredAttName, uriIndex2);
                        int tempIndex = this.fSchemaGrammar.getAttributeDeclIndex(typeInfo.templateElementIndex, referredAttQName);
                        XMLAttributeDecl referredAttrDecl = new XMLAttributeDecl();
                        this.fSchemaGrammar.getAttributeDecl(tempIndex, referredAttrDecl);
                        boolean updated = false;
                        int useDigits = 7;
                        int valueDigits = 24;
                        if (!isOptional && (referredAttrDecl.defaultType & useDigits) != (attValueAndUseType & useDigits) && referredAttrDecl.defaultType != 4) {
                            referredAttrDecl.defaultType |= useDigits;
                            referredAttrDecl.defaultType ^= useDigits;
                            referredAttrDecl.defaultType |= attValueAndUseType & useDigits;
                            updated = true;
                        }
                        if (fixedStr.length() > 0 && (referredAttrDecl.defaultType & 0x10) == 0) {
                            referredAttrDecl.defaultType |= valueDigits;
                            referredAttrDecl.defaultType ^= valueDigits;
                            referredAttrDecl.defaultType |= 0x10;
                            referredAttrDecl.defaultValue = fixedStr;
                            updated = true;
                        }
                        if (updated) {
                            this.fSchemaGrammar.setAttributeDecl(typeInfo.templateElementIndex, tempIndex, referredAttrDecl);
                        }
                    }
                } else if (this.fAttributeDeclRegistry.get(localpart) != null) {
                    this.addAttributeDeclFromAnotherSchema(localpart, uriStr, typeInfo, defaultAtt != null, fixedAtt != null, fixedStr, attValueAndUseType);
                } else {
                    this.reportGenericSchemaError("Couldn't find top level attribute " + refStr + errorContext);
                }
                return 0;
            }
            if (uriIndex == this.fXsiURI) {
                this.reportGenericSchemaError("no-xsi: The {target namespace} of an attribute declaration must not match http://www.w3.org/2001/XMLSchema-instance" + errorContext);
            }
            if (simpleTypeChild != null) {
                attType = 7;
                dataTypeSymbol = this.traverseSimpleTypeDecl(simpleTypeChild);
                localpart = this.fStringPool.toString(dataTypeSymbol);
                dv = this.fDatatypeRegistry.getDatatypeValidator(localpart);
            } else if (datatypeStr.length() != 0) {
                String prefix;
                dataTypeSymbol = this.fStringPool.addSymbol(datatypeStr);
                int colonptr = datatypeStr.indexOf(":");
                if (colonptr > 0) {
                    prefix = datatypeStr.substring(0, colonptr);
                    localpart = datatypeStr.substring(colonptr + 1);
                } else {
                    prefix = "";
                    localpart = datatypeStr;
                }
                String typeURI = this.resolvePrefixToURI(prefix);
                if (typeURI.equals("http://www.w3.org/2001/XMLSchema")) {
                    dv = this.getDatatypeValidator("http://www.w3.org/2001/XMLSchema", localpart);
                    if (localpart.equals("ID")) {
                        attType = 3;
                    } else if (localpart.equals("IDREF")) {
                        attType = 4;
                    } else if (localpart.equals("IDREFS")) {
                        attType = 4;
                        attIsList = true;
                    } else if (localpart.equals("ENTITY")) {
                        attType = 1;
                    } else if (localpart.equals("ENTITIES")) {
                        attType = 1;
                        attIsList = true;
                    } else if (localpart.equals("NMTOKEN")) {
                        attType = 5;
                    } else if (localpart.equals("NMTOKENS")) {
                        attType = 5;
                        attIsList = true;
                    } else if (localpart.equals("notation")) {
                        attType = 6;
                    } else {
                        attType = 7;
                        if (dv == null && !referredTo) {
                            this.reportGenericSchemaError("attribute " + attNameStr + " has a type (" + datatypeStr + ") which is not recognized as one of the predefined schema datatypes");
                        }
                    }
                } else {
                    attType = 7;
                    dv = this.getDatatypeValidator(typeURI, localpart);
                    if (dv == null && typeURI.equals(this.fTargetNSURIString)) {
                        Element topleveltype = this.getTopLevelComponentByName("simpleType", localpart);
                        if (topleveltype != null) {
                            this.traverseSimpleTypeDecl(topleveltype);
                            dv = this.getDatatypeValidator(typeURI, localpart);
                        } else if (!referredTo) {
                            this.reportGenericSchemaError("simpleType not found : (" + typeURI + ":" + localpart + ")" + errorContext);
                        }
                    }
                    if (dv == null && !referredTo) {
                        this.reportGenericSchemaError("attribute " + attNameStr + " has an unrecognized type " + datatypeStr);
                    }
                }
            } else {
                attType = 7;
                localpart = "string";
                dataTypeSymbol = this.fStringPool.addSymbol(localpart);
                dv = this.fDatatypeRegistry.getDatatypeValidator(localpart);
            }
            if (defaultStr.length() > 0) {
                attValueAndUseType |= 8;
                attValueConstraint = this.fStringPool.addString(defaultStr);
            } else if (fixedStr.length() > 0) {
                attValueAndUseType |= 0x10;
                attValueConstraint = this.fStringPool.addString(fixedStr);
            }
            if (attType == 7 && attValueConstraint != -1) {
                try {
                    if (dv != null) {
                        if (defaultStr.length() > 0) {
                            dv.validate(defaultStr, null);
                        } else {
                            dv.validate(fixedStr, null);
                        }
                    } else if (!referredTo) {
                        this.reportSchemaError(2, new Object[]{datatypeStr});
                    }
                }
                catch (InvalidDatatypeValueException idve) {
                    if (referredTo) break block83;
                    this.reportSchemaError(18, new Object[]{attrDecl.getAttribute("name"), idve.getMessage()});
                }
            }
        }
        boolean bl = dvIsDerivedFromID = dv != null && dv instanceof IDDatatypeValidator;
        if (dvIsDerivedFromID && attValueConstraint != -1) {
            this.reportGenericSchemaError("a-props-correct.3: If type definition is or is derived from ID ,there must not be a value constraint" + errorContext);
        }
        if (attNameStr.equals("xmlns")) {
            this.reportGenericSchemaError("no-xmlns: The {name} of an attribute declaration must not match 'xmlns'" + errorContext);
        }
        if (isAttrTopLevel) {
            this.fTempAttributeDecl.datatypeValidator = dv;
            this.fTempAttributeDecl.name.setValues(attQName);
            this.fTempAttributeDecl.type = attType;
            this.fTempAttributeDecl.defaultType = attValueAndUseType;
            this.fTempAttributeDecl.list = attIsList;
            this.fTempAttributeDecl.defaultValue = attValueConstraint != -1 ? this.fStringPool.toString(attValueConstraint) : null;
            this.fAttributeDeclRegistry.put(attNameStr, new XMLAttributeDecl(this.fTempAttributeDecl));
        }
        if (typeInfo != null) {
            int temp = this.fSchemaGrammar.getAttributeDeclIndex(typeInfo.templateElementIndex, attQName);
            if (temp > -1) {
                this.reportGenericSchemaError("ct-props-correct.4:  Duplicate attribute " + this.fStringPool.toString(attQName.rawname) + " in type definition");
            }
            if (dvIsDerivedFromID) {
                if (typeInfo.containsAttrTypeID()) {
                    this.reportGenericSchemaError("ct-props-correct.5: More than one attribute derived from type ID cannot appear in the same complex type definition.");
                }
                typeInfo.setContainsAttrTypeID();
            }
            this.fSchemaGrammar.addAttDef(typeInfo.templateElementIndex, attQName, attType, dataTypeSymbol, attValueAndUseType, this.fStringPool.toString(attValueConstraint), dv, attIsList);
        }
        return 0;
    }

    private int addAttributeDeclFromAnotherSchema(String name, String uriStr, ComplexTypeInfo typeInfo) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(uriStr);
        if (uriStr == null || !(grammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("no attribute named \"" + name + "\" was defined in schema : " + uriStr);
            return -1;
        }
        SchemaGrammar aGrammar = (SchemaGrammar)grammar;
        Hashtable attrRegistry = aGrammar.getAttributeDeclRegistry();
        if (attrRegistry == null) {
            this.reportGenericSchemaError("no attribute named \"" + name + "\" was defined in schema : " + uriStr);
            return -1;
        }
        XMLAttributeDecl referredAttrDecl = (XMLAttributeDecl)attrRegistry.get(name);
        if (referredAttrDecl == null) {
            this.reportGenericSchemaError("no attribute named \"" + name + "\" was defined in schema : " + uriStr);
            return -1;
        }
        if (typeInfo != null) {
            int temp = this.fSchemaGrammar.getAttributeDeclIndex(typeInfo.templateElementIndex, referredAttrDecl.name);
            if (temp > -1) {
                this.reportGenericSchemaError("ct-props-correct.4:  Duplicate attribute " + this.fStringPool.toString(referredAttrDecl.name.rawname) + " in type definition");
            }
            if (referredAttrDecl.datatypeValidator != null && referredAttrDecl.datatypeValidator instanceof IDDatatypeValidator) {
                if (typeInfo.containsAttrTypeID()) {
                    this.reportGenericSchemaError("ct-props-correct.5: More than one attribute derived from type ID cannot appear in the same complex type definition");
                }
                typeInfo.setContainsAttrTypeID();
            }
            this.fSchemaGrammar.addAttDef(typeInfo.templateElementIndex, referredAttrDecl.name, referredAttrDecl.type, -1, referredAttrDecl.defaultType, referredAttrDecl.defaultValue, referredAttrDecl.datatypeValidator, referredAttrDecl.list);
        }
        return 0;
    }

    private int addAttributeDeclFromAnotherSchema(String name, String uriStr, ComplexTypeInfo typeInfo, boolean hasDefault, boolean hasFixed, String fixedValue, int attValueAndUseType) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(uriStr);
        if (uriStr == null || !(grammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("no attribute named \"" + name + "\" was defined in schema : " + uriStr);
            return -1;
        }
        SchemaGrammar aGrammar = (SchemaGrammar)grammar;
        Hashtable attrRegistry = aGrammar.getAttributeDeclRegistry();
        if (attrRegistry == null) {
            this.reportGenericSchemaError("no attribute named \"" + name + "\" was defined in schema : " + uriStr);
            return -1;
        }
        XMLAttributeDecl referredAttrDecl = (XMLAttributeDecl)attrRegistry.get(name);
        if (referredAttrDecl == null) {
            this.reportGenericSchemaError("no attribute named \"" + name + "\" was defined in schema : " + uriStr);
            return -1;
        }
        referredAttrDecl = new XMLAttributeDecl(referredAttrDecl);
        if (typeInfo != null) {
            String referFixed;
            int temp = this.fSchemaGrammar.getAttributeDeclIndex(typeInfo.templateElementIndex, referredAttrDecl.name);
            if (temp > -1) {
                this.reportGenericSchemaError("ct-props-correct.4:  Duplicate attribute " + this.fStringPool.toString(referredAttrDecl.name.rawname) + " in type definition");
            }
            if (referredAttrDecl.datatypeValidator != null && referredAttrDecl.datatypeValidator instanceof IDDatatypeValidator) {
                if (typeInfo.containsAttrTypeID()) {
                    this.reportGenericSchemaError("ct-props-correct.5: More than one attribute derived from type ID cannot appear in the same complex type definition");
                }
                typeInfo.setContainsAttrTypeID();
            }
            boolean isReferFixed = (referredAttrDecl.defaultType & 0x10) != 0;
            String string = referFixed = isReferFixed ? null : referredAttrDecl.defaultValue;
            if (referFixed != null && (hasDefault || hasFixed && !referFixed.equals(fixedValue))) {
                this.reportGenericSchemaError("au-props-correct.2: If the {attribute declaration} has a fixed {value constraint}, then if the attribute use itself has a {value constraint}, it must also be fixed and its value must match that of the {attribute declaration}'s {value constraint}");
            }
            if ((attValueAndUseType & 1) == 0 || fixedValue.length() > 0) {
                int useDigits = 7;
                int valueDigits = 24;
                if ((attValueAndUseType & 1) == 0 && (referredAttrDecl.defaultType & useDigits) != (attValueAndUseType & useDigits) && referredAttrDecl.defaultType != 4) {
                    referredAttrDecl.defaultType |= useDigits;
                    referredAttrDecl.defaultType ^= useDigits;
                    referredAttrDecl.defaultType |= attValueAndUseType & useDigits;
                }
                if (fixedValue.length() > 0 && (referredAttrDecl.defaultType & 0x10) == 0) {
                    referredAttrDecl.defaultType |= valueDigits;
                    referredAttrDecl.defaultType ^= valueDigits;
                    referredAttrDecl.defaultType |= 0x10;
                    referredAttrDecl.defaultValue = fixedValue;
                }
            }
            this.fSchemaGrammar.addAttDef(typeInfo.templateElementIndex, referredAttrDecl.name, referredAttrDecl.type, -1, referredAttrDecl.defaultType, referredAttrDecl.defaultValue, referredAttrDecl.datatypeValidator, referredAttrDecl.list);
        }
        return 0;
    }

    private int traverseAttributeGroupDecl(Element attrGrpDecl, ComplexTypeInfo typeInfo, Vector anyAttDecls) throws Exception {
        int scope = this.isTopLevel(attrGrpDecl) ? GeneralAttrCheck.ELE_CONTEXT_GLOBAL : GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(attrGrpDecl, scope);
        String attGrpNameStr = attrGrpDecl.getAttribute("name");
        int attGrpName = this.fStringPool.addSymbol(attGrpNameStr);
        String ref = attrGrpDecl.getAttribute("ref");
        Element child = this.checkContent(attrGrpDecl, XUtil.getFirstChildElement(attrGrpDecl), true);
        if (ref.length() != 0) {
            String uriStr;
            if (this.isTopLevel(attrGrpDecl)) {
                this.reportGenericSchemaError("An attributeGroup with \"ref\" present must not have <schema> or <redefine> as its parent");
            }
            if (attGrpNameStr.length() != 0) {
                this.reportGenericSchemaError("attributeGroup " + attGrpNameStr + " cannot refer to another attributeGroup, but it refers to " + ref);
            }
            if (child != null) {
                this.reportGenericSchemaError("An attributeGroup with \"ref\" present must be empty");
            }
            String prefix = "";
            String localpart = ref;
            int colonptr = ref.indexOf(":");
            if (colonptr > 0) {
                prefix = ref.substring(0, colonptr);
                localpart = ref.substring(colonptr + 1);
            }
            if (!(uriStr = this.resolvePrefixToURI(prefix)).equals(this.fTargetNSURIString)) {
                this.traverseAttributeGroupDeclFromAnotherSchema(localpart, uriStr, typeInfo, anyAttDecls);
                return -1;
            }
            Element parent = (Element)attrGrpDecl.getParentNode();
            if (this.fCurrentAttrGroupNameStack.search(localpart) > -1) {
                if (!((Element)parent.getParentNode()).getLocalName().equals("redefine")) {
                    this.reportGenericSchemaError("src-attribute_group.3: Circular attribute group reference is disallowed outside <redefine> -- " + ref);
                }
                return -1;
            }
            if (typeInfo != null) {
                Element referredAttrGrp = this.getTopLevelComponentByName("attributeGroup", localpart);
                if (referredAttrGrp != null) {
                    this.traverseAttributeGroupDecl(referredAttrGrp, typeInfo, anyAttDecls);
                } else {
                    this.reportGenericSchemaError("Couldn't find top level attributeGroup " + ref);
                }
                return -1;
            }
        } else if (attGrpNameStr.length() == 0) {
            this.reportGenericSchemaError("an attributeGroup must have a name or a ref attribute present");
        }
        this.fCurrentAttrGroupNameStack.push(attGrpNameStr);
        while (child != null) {
            if (child.getLocalName().equals("attribute")) {
                this.traverseAttributeDecl(child, typeInfo, false);
            } else {
                if (!child.getLocalName().equals("attributeGroup")) break;
                NamespacesScope currScope = (NamespacesScope)this.fNamespacesScope.clone();
                this.traverseAttributeGroupDecl(child, typeInfo, anyAttDecls);
                this.fNamespacesScope = currScope;
            }
            child = XUtil.getNextSiblingElement(child);
        }
        this.fCurrentAttrGroupNameStack.pop();
        if (child != null) {
            if (child.getLocalName().equals("anyAttribute")) {
                if (anyAttDecls != null) {
                    anyAttDecls.addElement(this.traverseAnyAttribute(child));
                }
                if (XUtil.getNextSiblingElement(child) != null) {
                    this.reportGenericSchemaError("src-attribute_group.0: The content of an attributeGroup declaration must match (annotation?, ((attribute | attributeGroup)*, anyAttribute?))");
                }
                return -1;
            }
            this.reportGenericSchemaError("src-attribute_group.0: The content of an attributeGroup declaration must match (annotation?, ((attribute | attributeGroup)*, anyAttribute?))");
        }
        return -1;
    }

    private int traverseAttributeGroupDeclFromAnotherSchema(String attGrpName, String uriStr, ComplexTypeInfo typeInfo, Vector anyAttDecls) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(uriStr);
        if (uriStr == null || grammar == null || !(grammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseAttributeGroupDeclFromAnotherSchema, schema uri : " + uriStr);
            return -1;
        }
        SchemaGrammar aGrammar = (SchemaGrammar)grammar;
        Element attGrpDecl = (Element)aGrammar.topLevelAttrGrpDecls.get(attGrpName);
        if (attGrpDecl == null) {
            this.reportGenericSchemaError("no attribute group named \"" + attGrpName + "\" was defined in schema : " + uriStr);
            return -1;
        }
        NamespacesScope saveNSMapping = this.fNamespacesScope;
        int saveTargetNSUri = this.fTargetNSURI;
        this.fTargetNSURI = this.fStringPool.addSymbol(aGrammar.getTargetNamespaceURI());
        this.fNamespacesScope = aGrammar.getNamespacesScope();
        int attType = -1;
        int enumeration = -1;
        Element child = this.checkContent(attGrpDecl, XUtil.getFirstChildElement(attGrpDecl), true);
        while (child != null) {
            if (child.getLocalName().equals("attribute")) {
                String childAttName = child.getAttribute("name");
                if (childAttName.length() > 0) {
                    Hashtable attDeclRegistry = aGrammar.getAttributeDeclRegistry();
                    if (attDeclRegistry != null && attDeclRegistry.get(childAttName) != null) {
                        this.addAttributeDeclFromAnotherSchema(childAttName, uriStr, typeInfo);
                        this.fNamespacesScope = saveNSMapping;
                        this.fTargetNSURI = saveTargetNSUri;
                        return -1;
                    }
                    this.traverseAttributeDecl(child, typeInfo, false);
                } else {
                    this.traverseAttributeDecl(child, typeInfo, false);
                }
            } else if (child.getLocalName().equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(child, typeInfo, anyAttDecls);
            } else {
                if (child.getLocalName().equals("anyAttribute")) {
                    anyAttDecls.addElement(this.traverseAnyAttribute(child));
                    break;
                }
                this.reportGenericSchemaError("Invalid content for attributeGroup");
            }
            child = XUtil.getNextSiblingElement(child);
        }
        this.fNamespacesScope = saveNSMapping;
        this.fTargetNSURI = saveTargetNSUri;
        if (child != null) {
            this.reportGenericSchemaError("Invalid content for attributeGroup");
        }
        return -1;
    }

    private Element findAttributeSimpleType(Element attrDecl) throws Exception {
        Element child = this.checkContent(attrDecl, XUtil.getFirstChildElement(attrDecl), true);
        if (child == null) {
            return null;
        }
        if (!child.getLocalName().equals("simpleType") || XUtil.getNextSiblingElement(child) != null) {
            this.reportGenericSchemaError("src-attribute.0: the content must match (annotation?, (simpleType?)) -- attribute declaration '" + attrDecl.getAttribute("name") + "'");
        }
        if (child.getLocalName().equals("simpleType")) {
            return child;
        }
        return null;
    }

    private QName traverseElementDecl(Element elementDecl) throws Exception {
        Element ic;
        int elementNameIndex;
        int scope = this.isTopLevel(elementDecl) ? GeneralAttrCheck.ELE_CONTEXT_GLOBAL : GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(elementDecl, scope);
        int contentSpecType = -1;
        int contentSpecNodeIndex = -1;
        int typeNameIndex = -1;
        int scopeDefined = -2;
        DatatypeValidator dv = null;
        String abstractStr = elementDecl.getAttribute("abstract");
        String blockStr = elementDecl.getAttribute("block");
        String defaultStr = elementDecl.getAttribute("default");
        String finalStr = elementDecl.getAttribute("final");
        String fixedStr = elementDecl.getAttribute("fixed");
        String formStr = elementDecl.getAttribute("form");
        String maxOccursStr = elementDecl.getAttribute("maxOccurs");
        String minOccursStr = elementDecl.getAttribute("minOccurs");
        String nameStr = elementDecl.getAttribute("name");
        String nillableStr = elementDecl.getAttribute("nillable");
        String refStr = elementDecl.getAttribute("ref");
        String substitutionGroupStr = elementDecl.getAttribute("substitutionGroup");
        String typeStr = elementDecl.getAttribute("type");
        this.checkEnumerationRequiredNotation(nameStr, typeStr);
        Attr abstractAtt = elementDecl.getAttributeNode("abstract");
        Attr blockAtt = elementDecl.getAttributeNode("block");
        Attr defaultAtt = elementDecl.getAttributeNode("default");
        Attr finalAtt = elementDecl.getAttributeNode("final");
        Attr fixedAtt = elementDecl.getAttributeNode("fixed");
        Attr formAtt = elementDecl.getAttributeNode("form");
        Attr maxOccursAtt = elementDecl.getAttributeNode("maxOccurs");
        Attr minOccursAtt = elementDecl.getAttributeNode("minOccurs");
        Attr nameAtt = elementDecl.getAttributeNode("name");
        Attr nillableAtt = elementDecl.getAttributeNode("nillable");
        Attr refAtt = elementDecl.getAttributeNode("ref");
        Attr substitutionGroupAtt = elementDecl.getAttributeNode("substitutionGroup");
        Attr typeAtt = elementDecl.getAttributeNode("type");
        if (defaultAtt != null && fixedAtt != null) {
            this.reportGenericSchemaError("src-element.1: an element cannot have both \"fixed\" and \"default\" present at the same time");
        }
        String fromAnotherSchema = null;
        if (this.isTopLevel(elementDecl)) {
            if (nameAtt == null) {
                this.reportGenericSchemaError("globally-declared element must have a name");
            } else if (refAtt != null) {
                this.reportGenericSchemaError("globally-declared element " + nameStr + " cannot have a ref attribute");
            }
            int nameIndex = this.fStringPool.addSymbol(nameStr);
            int eltKey = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, nameIndex, -1);
            if (eltKey > -1) {
                return new QName(-1, nameIndex, nameIndex, this.fTargetNSURI);
            }
        }
        if (blockAtt == null) {
            blockStr = null;
        }
        int blockSet = this.parseBlockSet(blockStr);
        if (blockStr != null && blockStr.length() != 0 && !blockStr.equals("#all") && (blockSet & 2) == 0 && (blockSet & 1) == 0 && (blockSet & 0x20) == 0) {
            this.reportGenericSchemaError("The values of the 'block' attribute of an element must be either #all or a list of 'substitution', 'restriction' and 'extension'; " + blockStr + " was found");
        }
        if (finalAtt == null) {
            finalStr = null;
        }
        int finalSet = this.parseFinalSet(finalStr);
        if (finalStr != null && finalStr.length() != 0 && !finalStr.equals("#all") && (finalSet & 2) == 0 && (finalSet & 1) == 0) {
            this.reportGenericSchemaError("The values of the 'final' attribute of an element must be either #all or a list of 'restriction' and 'extension'; " + finalStr + " was found");
        }
        boolean isNillable = nillableStr.equals("true") || nillableStr.equals("1");
        boolean isAbstract = abstractStr.equals("true") || abstractStr.equals("1");
        int elementMiscFlags = 0;
        if (isNillable) {
            ++elementMiscFlags;
        }
        if (isAbstract) {
            elementMiscFlags += 2;
        }
        if (fixedAtt != null) {
            elementMiscFlags += 4;
        }
        if (refAtt != null) {
            Element targetElement;
            Element child;
            if (abstractAtt != null || blockAtt != null || defaultAtt != null || finalAtt != null || fixedAtt != null || formAtt != null || nillableAtt != null || substitutionGroupAtt != null || typeAtt != null) {
                this.reportSchemaError(16, null);
            }
            if (nameAtt != null) {
                this.reportGenericSchemaError("src-element.2.1: element " + nameStr + " cannot also have a ref attribute");
            }
            if ((child = XUtil.getFirstChildElement(elementDecl)) != null && child.getLocalName().equals("annotation")) {
                if (XUtil.getNextSiblingElement(child) != null) {
                    this.reportSchemaError(17, null);
                } else {
                    this.traverseAnnotationDecl(child);
                }
            } else if (child != null) {
                this.reportSchemaError(17, null);
            }
            String prefix = "";
            String localpart = refStr;
            int colonptr = refStr.indexOf(":");
            if (colonptr > 0) {
                prefix = refStr.substring(0, colonptr);
                localpart = refStr.substring(colonptr + 1);
            }
            int localpartIndex = this.fStringPool.addSymbol(localpart);
            String uriString = this.resolvePrefixToURI(prefix);
            QName eltName = new QName(prefix != null ? this.fStringPool.addSymbol(prefix) : -1, localpartIndex, this.fStringPool.addSymbol(refStr), uriString != null ? this.fStringPool.addSymbol(uriString) : 0);
            if (!uriString.equals(this.fTargetNSURIString)) {
                return eltName;
            }
            int elementIndex = this.fSchemaGrammar.getElementDeclIndex(eltName, -1);
            if (elementIndex == -1 && (targetElement = this.getTopLevelComponentByName("element", localpart)) == null) {
                this.reportGenericSchemaError("Element " + localpart + " not found in the Schema");
                return eltName;
            }
            if (this.fCurrentScope != -1 && this.fFullConstraintChecking) {
                this.fTopLevelElementsRefdFromGroup.addElement(eltName);
                this.fTopLevelElementsRefdFromGroup.addElement(new Integer(this.fCurrentScope));
            }
            return eltName;
        }
        if (nameAtt == null) {
            this.reportGenericSchemaError("src-element.2.1: a local element must have a name or a ref attribute present");
        }
        Element substitutionGroupElementDecl = null;
        int substitutionGroupElementDeclIndex = -1;
        boolean noErrorSoFar = true;
        ComplexTypeInfo typeInfo = null;
        Element child = XUtil.getFirstChildElement(elementDecl);
        if (child != null && child.getLocalName().equals("annotation")) {
            this.traverseAnnotationDecl(child);
            child = XUtil.getNextSiblingElement(child);
        }
        if (child != null && child.getLocalName().equals("annotation")) {
            this.reportGenericSchemaError("element declarations can contain at most one annotation Element Information Item");
        }
        boolean haveAnonType = false;
        if (child != null) {
            String childName = child.getLocalName();
            if (childName.equals("complexType")) {
                if (child.getAttribute("name").length() > 0) {
                    noErrorSoFar = false;
                    this.reportGenericSchemaError("anonymous complexType in element '" + nameStr + "' has a name attribute");
                } else {
                    String anonTypeName = this.genAnonTypeName(child);
                    if (this.fCurrentTypeNameStack.search(anonTypeName) > -1) {
                        int uriInd = 0;
                        if (formStr.equals("qualified") || this.fElementDefaultQualified) {
                            uriInd = this.fTargetNSURI;
                        }
                        int nameIndex = this.fStringPool.addSymbol(nameStr);
                        QName tempQName = new QName(-1, nameIndex, nameIndex, uriInd);
                        int eltIndex = this.fSchemaGrammar.addElementDecl(tempQName, this.fCurrentScope, this.fCurrentScope, -1, -1, -1, null);
                        this.fElementRecurseComplex.addElement(new ElementInfo(eltIndex, anonTypeName));
                        return tempQName;
                    }
                    typeNameIndex = this.traverseComplexTypeDecl(child);
                    if (typeNameIndex != -1) {
                        typeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(typeNameIndex));
                    } else {
                        noErrorSoFar = false;
                        this.reportGenericSchemaError("traverse complexType error in element '" + nameStr + "'");
                    }
                }
                haveAnonType = true;
                child = XUtil.getNextSiblingElement(child);
            } else if (childName.equals("simpleType")) {
                if (child.getAttribute("name").length() > 0) {
                    noErrorSoFar = false;
                    this.reportGenericSchemaError("anonymous simpleType in element '" + nameStr + "' has a name attribute");
                } else {
                    typeNameIndex = this.traverseSimpleTypeDecl(child);
                }
                if (typeNameIndex != -1) {
                    dv = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(typeNameIndex));
                } else {
                    noErrorSoFar = false;
                    this.reportGenericSchemaError("traverse simpleType error in element '" + nameStr + "'");
                }
                contentSpecType = 5;
                haveAnonType = true;
                child = XUtil.getNextSiblingElement(child);
            } else if (typeAtt == null) {
                contentSpecType = 1;
                contentSpecNodeIndex = -1;
            }
            if (child != null) {
                childName = child.getLocalName();
            }
            while (child != null && (childName.equals("key") || childName.equals("keyref") || childName.equals("unique"))) {
                if ((child = XUtil.getNextSiblingElement(child)) == null) continue;
                childName = child.getLocalName();
            }
            if (child != null) {
                noErrorSoFar = false;
                this.reportGenericSchemaError("src-element.0: the content of an element information item must match (annotation?, (simpleType | complexType)?, (unique | key | keyref)*)");
            }
        }
        if (haveAnonType && typeAtt != null) {
            noErrorSoFar = false;
            this.reportGenericSchemaError("src-element.3: Element '" + nameStr + "' have both a type attribute and a annoymous type child");
        } else if (typeAtt != null) {
            String typeURI;
            String prefix = "";
            String localpart = typeStr;
            int colonptr = typeStr.indexOf(":");
            if (colonptr > 0) {
                prefix = typeStr.substring(0, colonptr);
                localpart = typeStr.substring(colonptr + 1);
            }
            if (!(typeURI = this.resolvePrefixToURI(prefix)).equals("http://www.w3.org/2001/XMLSchema") || !localpart.equals("anyType")) {
                if (!typeURI.equals(this.fTargetNSURIString) && !typeURI.equals("http://www.w3.org/2001/XMLSchema")) {
                    fromAnotherSchema = typeURI;
                    typeInfo = this.getTypeInfoFromNS(typeURI, localpart);
                    if (typeInfo == null && (dv = this.getTypeValidatorFromNS(typeURI, localpart)) == null) {
                        noErrorSoFar = false;
                        this.reportGenericSchemaError("Could not find type " + localpart + " in schema " + typeURI);
                    }
                } else {
                    typeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(String.valueOf(typeURI) + "," + localpart);
                    if (typeInfo == null && (dv = this.getDatatypeValidator(typeURI, localpart)) == null) {
                        if (typeURI.equals("http://www.w3.org/2001/XMLSchema") && !this.fTargetNSURIString.equals("http://www.w3.org/2001/XMLSchema")) {
                            noErrorSoFar = false;
                            this.reportGenericSchemaError("type not found : " + typeURI + ":" + localpart);
                        } else {
                            Element topleveltype = this.getTopLevelComponentByName("complexType", localpart);
                            if (topleveltype != null) {
                                if (this.fCurrentTypeNameStack.search(localpart) > -1) {
                                    int uriInd = 0;
                                    if (formStr.equals("qualified") || this.fElementDefaultQualified) {
                                        uriInd = this.fTargetNSURI;
                                    }
                                    int nameIndex = this.fStringPool.addSymbol(nameStr);
                                    QName tempQName = new QName(-1, nameIndex, nameIndex, uriInd);
                                    int eltIndex = this.fSchemaGrammar.addElementDecl(tempQName, this.fCurrentScope, this.fCurrentScope, -1, -1, -1, null);
                                    this.fElementRecurseComplex.addElement(new ElementInfo(eltIndex, localpart));
                                    return tempQName;
                                }
                                Stack savedbaseNameStack = null;
                                if (!this.fBaseTypeNameStack.isEmpty()) {
                                    savedbaseNameStack = this.fBaseTypeNameStack;
                                    this.fBaseTypeNameStack = new Stack();
                                }
                                typeNameIndex = this.traverseComplexTypeDecl(topleveltype, true);
                                if (savedbaseNameStack != null) {
                                    this.fBaseTypeNameStack = savedbaseNameStack;
                                }
                                typeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(typeNameIndex));
                            } else {
                                topleveltype = this.getTopLevelComponentByName("simpleType", localpart);
                                if (topleveltype != null) {
                                    typeNameIndex = this.traverseSimpleTypeDecl(topleveltype);
                                    dv = this.getDatatypeValidator(typeURI, localpart);
                                } else {
                                    noErrorSoFar = false;
                                    this.reportGenericSchemaError("type not found : " + typeURI + ":" + localpart);
                                }
                            }
                        }
                    }
                }
            }
        }
        String substitutionGroupUri = null;
        String substitutionGroupLocalpart = null;
        String substitutionGroupFullName = null;
        ComplexTypeInfo substitutionGroupEltTypeInfo = null;
        DatatypeValidator substitutionGroupEltDV = null;
        SchemaGrammar subGrammar = this.fSchemaGrammar;
        boolean ignoreSub = false;
        if (substitutionGroupStr.length() > 0) {
            if (refAtt != null) {
                this.reportGenericSchemaError("a local element cannot have a substitutionGroup");
            }
            substitutionGroupUri = this.resolvePrefixToURI(this.getPrefix(substitutionGroupStr));
            substitutionGroupLocalpart = this.getLocalPart(substitutionGroupStr);
            substitutionGroupFullName = String.valueOf(substitutionGroupUri) + "," + substitutionGroupLocalpart;
            if (!substitutionGroupUri.equals(this.fTargetNSURIString)) {
                Grammar grammar = this.fGrammarResolver.getGrammar(substitutionGroupUri);
                if (grammar != null && grammar instanceof SchemaGrammar) {
                    subGrammar = (SchemaGrammar)grammar;
                    substitutionGroupElementDeclIndex = subGrammar.getElementDeclIndex(this.fStringPool.addSymbol(substitutionGroupUri), this.fStringPool.addSymbol(substitutionGroupLocalpart), -1);
                    if (substitutionGroupElementDeclIndex <= -1) {
                        noErrorSoFar = false;
                        this.reportGenericSchemaError("couldn't find substitutionGroup " + substitutionGroupLocalpart + " referenced by element " + nameStr + " in the SchemaGrammar " + substitutionGroupUri);
                    } else {
                        substitutionGroupEltTypeInfo = this.getElementDeclTypeInfoFromNS(substitutionGroupUri, substitutionGroupLocalpart);
                        if (substitutionGroupEltTypeInfo == null) {
                            substitutionGroupEltDV = this.getElementDeclTypeValidatorFromNS(substitutionGroupUri, substitutionGroupLocalpart);
                        }
                    }
                } else {
                    noErrorSoFar = false;
                    this.reportGenericSchemaError("couldn't find a schema grammar with target namespace '" + substitutionGroupUri + "' for element '" + substitutionGroupStr + "'");
                }
            } else {
                substitutionGroupElementDecl = this.getTopLevelComponentByName("element", substitutionGroupLocalpart);
                if (substitutionGroupElementDecl == null) {
                    substitutionGroupElementDeclIndex = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(substitutionGroupStr), -1);
                    if (substitutionGroupElementDeclIndex == -1) {
                        noErrorSoFar = false;
                        this.reportGenericSchemaError("unable to locate substitutionGroup affiliation element " + substitutionGroupStr + " in element declaration " + nameStr);
                    }
                } else {
                    substitutionGroupElementDeclIndex = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(substitutionGroupStr), -1);
                    if (substitutionGroupElementDeclIndex == -1) {
                        if (this.fSubstitutionGroupRecursionRegistry.contains(String.valueOf(this.fTargetNSURIString) + "," + substitutionGroupElementDecl.getAttribute("name"))) {
                            ignoreSub = true;
                        } else {
                            this.fSubstitutionGroupRecursionRegistry.addElement(String.valueOf(this.fTargetNSURIString) + "," + substitutionGroupElementDecl.getAttribute("name"));
                            this.traverseElementDecl(substitutionGroupElementDecl);
                            substitutionGroupElementDeclIndex = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(substitutionGroupStr), -1);
                            this.fSubstitutionGroupRecursionRegistry.removeElement(this.fTargetNSURIString + "," + substitutionGroupElementDecl.getAttribute("name"));
                        }
                    }
                }
                if (!ignoreSub && substitutionGroupElementDeclIndex != -1 && (substitutionGroupEltTypeInfo = this.fSchemaGrammar.getElementComplexTypeInfo(substitutionGroupElementDeclIndex)) == null) {
                    this.fSchemaGrammar.getElementDecl(substitutionGroupElementDeclIndex, this.fTempElementDecl);
                    substitutionGroupEltDV = this.fTempElementDecl.datatypeValidator;
                }
            }
            if (substitutionGroupElementDeclIndex <= -1) {
                ignoreSub = true;
            }
            if (!ignoreSub) {
                this.checkSubstitutionGroupOK(elementDecl, substitutionGroupElementDecl, noErrorSoFar, substitutionGroupElementDeclIndex, subGrammar, typeInfo, substitutionGroupEltTypeInfo, dv, substitutionGroupEltDV);
            }
        }
        if (noErrorSoFar && typeInfo == null && dv == null) {
            typeInfo = substitutionGroupEltTypeInfo;
            dv = substitutionGroupEltDV;
        }
        boolean isAnyType = false;
        if (typeInfo == null && dv == null) {
            if (noErrorSoFar) {
                isAnyType = true;
                contentSpecType = 1;
            } else {
                noErrorSoFar = false;
                this.reportGenericSchemaError("untyped element : " + nameStr);
            }
        }
        if (typeInfo != null) {
            contentSpecNodeIndex = typeInfo.contentSpecHandle;
            contentSpecType = typeInfo.contentType;
            scopeDefined = typeInfo.scopeDefined;
            dv = typeInfo.datatypeValidator;
        }
        if (dv != null) {
            contentSpecType = 5;
            if (typeInfo == null) {
                fromAnotherSchema = null;
            }
        }
        if (fixedAtt != null) {
            defaultStr = fixedStr;
        }
        if (defaultStr.length() != 0) {
            if (typeInfo != null && typeInfo.contentType != 2 && typeInfo.contentType != 3 && typeInfo.contentType != 5) {
                this.reportGenericSchemaError("e-props-correct.2.1: element " + nameStr + " has a fixed or default value and must have a mixed or simple content model");
            }
            if (!(typeInfo == null || typeInfo.contentType != 2 && typeInfo.contentType != 3 || this.particleEmptiable(typeInfo.contentSpecHandle))) {
                this.reportGenericSchemaError("e-props-correct.2.2.2: for element " + nameStr + ", the {content type} is mixed, then the {content type}'s particle must be emptiable");
            }
            try {
                if (dv != null) {
                    dv.validate(defaultStr, null);
                }
            }
            catch (InvalidDatatypeValueException ide) {
                this.reportGenericSchemaError("e-props-correct.2: invalid fixed or default value '" + defaultStr + "' in element " + nameStr);
            }
        }
        if (defaultStr.length() != 0 && dv != null && dv instanceof IDDatatypeValidator) {
            this.reportGenericSchemaError("e-props-correct.4: If the {type definition} or {type definition}'s {content type} is or is derived from ID then there must not be a {value constraint} -- element " + nameStr);
        }
        int localpartIndex = elementNameIndex = this.fStringPool.addSymbol(nameStr);
        int uriIndex = 0;
        int enclosingScope = this.fCurrentScope;
        if (this.isTopLevel(elementDecl)) {
            uriIndex = this.fTargetNSURI;
            enclosingScope = -1;
        } else if (!formStr.equals("unqualified") && (formStr.equals("qualified") || this.fElementDefaultQualified)) {
            uriIndex = this.fTargetNSURI;
        }
        QName eltQName = new QName(-1, localpartIndex, elementNameIndex, uriIndex);
        int existingEltNdx = this.fSchemaGrammar.getElementDeclIndex(eltQName.uri, eltQName.localpart, enclosingScope);
        if (existingEltNdx > -1 && !this.checkDuplicateElementTypes(existingEltNdx, typeInfo, dv)) {
            noErrorSoFar = false;
            this.reportGenericSchemaError("duplicate element decl in the same scope with different types : " + this.fStringPool.toString(localpartIndex));
        }
        int attrListHead = -1;
        if (typeInfo != null) {
            attrListHead = typeInfo.attlistHead;
        }
        int elementIndex = this.fSchemaGrammar.addElementDecl(eltQName, enclosingScope, scopeDefined, contentSpecType, contentSpecNodeIndex, attrListHead, dv);
        if (isAnyType) {
            this.fSchemaGrammar.addAttDef(elementIndex, new QName(), 8, -1, 1024, null, null, false);
        }
        this.fSchemaGrammar.setElementComplexTypeInfo(elementIndex, typeInfo);
        this.fSchemaGrammar.setElementFromAnotherSchemaURI(elementIndex, fromAnotherSchema);
        this.fSchemaGrammar.setElementDeclBlockSet(elementIndex, blockSet);
        this.fSchemaGrammar.setElementDeclFinalSet(elementIndex, finalSet);
        this.fSchemaGrammar.setElementDeclMiscFlags(elementIndex, elementMiscFlags);
        this.fSchemaGrammar.setElementDefault(elementIndex, defaultStr);
        this.fSchemaGrammar.setElementDeclSubstitutionGroupAffFullName(elementIndex, substitutionGroupFullName);
        if (substitutionGroupStr.length() > 0 && !ignoreSub) {
            subGrammar.addElementDeclOneSubstitutionGroupQName(substitutionGroupElementDeclIndex, eltQName, this.fSchemaGrammar, elementIndex);
        }
        if ((ic = XUtil.getFirstChildElementNS(elementDecl, IDENTITY_CONSTRAINTS)) != null) {
            Integer elementIndexObj = new Integer(elementIndex);
            Vector<Element> identityConstraints = (Vector<Element>)this.fIdentityConstraints.get(elementIndexObj);
            if (identityConstraints == null) {
                identityConstraints = new Vector<Element>();
                this.fIdentityConstraints.put(elementIndexObj, identityConstraints);
            }
            while (ic != null) {
                identityConstraints.addElement(ic);
                ic = XUtil.getNextSiblingElementNS(ic, IDENTITY_CONSTRAINTS);
            }
        }
        return eltQName;
    }

    private boolean checkDuplicateElementTypes(int eltNdx, ComplexTypeInfo typeInfo, DatatypeValidator dv) {
        this.fSchemaGrammar.getElementDecl(eltNdx, this.fTempElementDecl);
        DatatypeValidator edv = this.fTempElementDecl.datatypeValidator;
        ComplexTypeInfo eTypeInfo = this.fSchemaGrammar.getElementComplexTypeInfo(eltNdx);
        return (eTypeInfo == null || eTypeInfo == typeInfo) && (edv == null || edv == dv);
    }

    private void traverseIdentityNameConstraintsFor(int elementIndex, Vector identityConstraints) throws Exception {
        int size;
        int n = size = identityConstraints != null ? identityConstraints.size() : 0;
        if (size > 0) {
            XMLElementDecl edecl = new XMLElementDecl();
            this.fSchemaGrammar.getElementDecl(elementIndex, edecl);
            int i = 0;
            while (i < size) {
                Element ic = (Element)identityConstraints.elementAt(i);
                String icName = ic.getLocalName();
                if (icName.equals("key")) {
                    this.traverseKey(ic, edecl);
                } else if (icName.equals("unique")) {
                    this.traverseUnique(ic, edecl);
                }
                this.fSchemaGrammar.setElementDecl(elementIndex, edecl);
                ++i;
            }
        }
    }

    private void traverseIdentityRefConstraintsFor(int elementIndex, Vector identityConstraints) throws Exception {
        int size;
        int n = size = identityConstraints != null ? identityConstraints.size() : 0;
        if (size > 0) {
            XMLElementDecl edecl = new XMLElementDecl();
            this.fSchemaGrammar.getElementDecl(elementIndex, edecl);
            int i = 0;
            while (i < size) {
                Element ic = (Element)identityConstraints.elementAt(i);
                String icName = ic.getLocalName();
                if (icName.equals("keyref")) {
                    this.traverseKeyRef(ic, edecl);
                }
                this.fSchemaGrammar.setElementDecl(elementIndex, edecl);
                ++i;
            }
        }
    }

    private void traverseUnique(Element uElem, XMLElementDecl eDecl) throws Exception {
        int scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(uElem, scope);
        String uName = uElem.getAttribute("name");
        String eName = this.getElementNameFor(uElem);
        Unique unique = new Unique(uName, eName);
        if (this.fIdentityConstraintNames.get(String.valueOf(this.fTargetNSURIString) + "," + uName) != null) {
            this.reportGenericSchemaError("More than one identity constraint named " + uName);
        }
        this.fIdentityConstraintNames.put(String.valueOf(this.fTargetNSURIString) + "," + uName, unique);
        this.traverseIdentityConstraint(unique, uElem);
        eDecl.unique.addElement(unique);
    }

    private void traverseKey(Element kElem, XMLElementDecl eDecl) throws Exception {
        int scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(kElem, scope);
        String kName = kElem.getAttribute("name");
        String eName = this.getElementNameFor(kElem);
        Key key = new Key(kName, eName);
        if (this.fIdentityConstraintNames.get(String.valueOf(this.fTargetNSURIString) + "," + kName) != null) {
            this.reportGenericSchemaError("More than one identity constraint named " + kName);
        }
        this.fIdentityConstraintNames.put(String.valueOf(this.fTargetNSURIString) + "," + kName, key);
        this.traverseIdentityConstraint(key, kElem);
        eDecl.key.addElement(key);
    }

    private void traverseKeyRef(Element krElem, XMLElementDecl eDecl) throws Exception {
        String uriStr;
        IdentityConstraint kId;
        int scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(krElem, scope);
        String krName = krElem.getAttribute("name");
        String kName = krElem.getAttribute("refer");
        if (this.fIdentityConstraintNames.get(String.valueOf(this.fTargetNSURIString) + "," + krName) != null) {
            this.reportGenericSchemaError("More than one identity constraint named " + krName);
        }
        String prefix = "";
        String localpart = kName;
        int colonptr = kName.indexOf(":");
        if (colonptr > 0) {
            prefix = kName.substring(0, colonptr);
            localpart = kName.substring(colonptr + 1);
        }
        if ((kId = (IdentityConstraint)this.fIdentityConstraintNames.get(String.valueOf(uriStr = this.resolvePrefixToURI(prefix)) + "," + localpart)) == null) {
            this.reportSchemaError(37, new Object[]{krName, kName});
            return;
        }
        String eName = this.getElementNameFor(krElem);
        KeyRef keyRef = new KeyRef(krName, kId, eName);
        this.traverseIdentityConstraint(keyRef, krElem);
        if (keyRef.getFieldCount() != kId.getFieldCount()) {
            this.reportSchemaError(57, new Object[]{krName, kName});
            return;
        }
        eDecl.keyRef.addElement(keyRef);
        this.fIdentityConstraintNames.put(String.valueOf(this.fTargetNSURIString) + "," + krName, keyRef);
    }

    private void traverseIdentityConstraint(IdentityConstraint ic, Element icElem) throws Exception {
        int scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(icElem, scope);
        Element sElem = XUtil.getFirstChildElement(icElem);
        if (sElem == null) {
            this.reportGenericSchemaError("The content of an identity constraint must match (annotation?, selector, field+)");
            return;
        }
        sElem = this.checkContent(icElem, sElem, false);
        attrValues = this.generalCheck(sElem, scope);
        if (!sElem.getLocalName().equals("selector")) {
            this.reportGenericSchemaError("The content of an identity constraint must match (annotation?, selector, field+)");
        }
        this.checkContent(icElem, XUtil.getFirstChildElement(sElem), true);
        String sText = sElem.getAttribute("xpath");
        sText = sText.trim();
        Selector.XPath sXpath = null;
        try {
            sXpath = new Selector.XPath(sText, this.fStringPool, this.fNamespacesScope);
            Selector selector = new Selector(sXpath, ic);
            ic.setSelector(selector);
        }
        catch (XPathException e) {
            this.reportGenericSchemaError(e.getMessage());
            return;
        }
        Element fElem = XUtil.getNextSiblingElement(sElem);
        if (fElem == null) {
            this.reportGenericSchemaError("The content of an identity constraint must match (annotation?, selector, field+)");
        }
        while (fElem != null) {
            attrValues = this.generalCheck(fElem, scope);
            if (!fElem.getLocalName().equals("field")) {
                this.reportGenericSchemaError("The content of an identity constraint must match (annotation?, selector, field+)");
            }
            this.checkContent(icElem, XUtil.getFirstChildElement(fElem), true);
            String fText = fElem.getAttribute("xpath");
            fText = fText.trim();
            try {
                Field.XPath fXpath = new Field.XPath(fText, this.fStringPool, this.fNamespacesScope);
                Field field = new Field(fXpath, ic);
                ic.addField(field);
            }
            catch (XPathException e) {
                this.reportGenericSchemaError(e.getMessage());
                return;
            }
            fElem = XUtil.getNextSiblingElement(fElem);
        }
    }

    private String getElementNameFor(Element icnode) {
        Element enode = (Element)icnode.getParentNode();
        String ename = enode.getAttribute("name");
        if (ename.length() == 0) {
            ename = enode.getAttribute("ref");
        }
        return ename;
    }

    int getLocalPartIndex(String fullName) {
        int colonAt = fullName.indexOf(":");
        String localpart = fullName;
        if (colonAt > -1) {
            localpart = fullName.substring(colonAt + 1);
        }
        return this.fStringPool.addSymbol(localpart);
    }

    String getLocalPart(String fullName) {
        int colonAt = fullName.indexOf(":");
        String localpart = fullName;
        if (colonAt > -1) {
            localpart = fullName.substring(colonAt + 1);
        }
        return localpart;
    }

    int getPrefixIndex(String fullName) {
        int colonAt = fullName.indexOf(":");
        String prefix = "";
        if (colonAt > -1) {
            prefix = fullName.substring(0, colonAt);
        }
        return this.fStringPool.addSymbol(prefix);
    }

    String getPrefix(String fullName) {
        int colonAt = fullName.indexOf(":");
        String prefix = "";
        if (colonAt > -1) {
            prefix = fullName.substring(0, colonAt);
        }
        return prefix;
    }

    private void checkSubstitutionGroupOK(Element elementDecl, Element substitutionGroupElementDecl, boolean noErrorSoFar, int substitutionGroupElementDeclIndex, SchemaGrammar substitutionGroupGrammar, ComplexTypeInfo typeInfo, ComplexTypeInfo substitutionGroupEltTypeInfo, DatatypeValidator dv, DatatypeValidator substitutionGroupEltDV) throws Exception {
        int finalSet = substitutionGroupGrammar.getElementDeclFinalSet(substitutionGroupElementDeclIndex);
        if ((finalSet & 2) != 0 && (finalSet & 1) != 0) {
            this.reportGenericSchemaError("element " + elementDecl.getAttribute("name") + " cannot be part of the substitution group headed by " + substitutionGroupElementDecl.getAttribute("name"));
        }
        if (typeInfo != null) {
            if (substitutionGroupEltTypeInfo == typeInfo) {
                return;
            }
            int derivationMethod = typeInfo.derivedBy;
            if (typeInfo.baseComplexTypeInfo == null) {
                if (typeInfo.baseDataTypeValidator != null) {
                    if (!(this.checkSimpleTypeDerivationOK(typeInfo.baseDataTypeValidator, substitutionGroupEltDV) || substitutionGroupEltTypeInfo == null && substitutionGroupEltDV == null)) {
                        this.reportGenericSchemaError("Element " + elementDecl.getAttribute("name") + " has a type which does not derive from the type of the element at the head of the substitution group");
                        noErrorSoFar = false;
                    } else if ((derivationMethod & finalSet) != 0) {
                        noErrorSoFar = false;
                        this.reportGenericSchemaError("element " + elementDecl.getAttribute("name") + " cannot be part of the substitution group headed by " + substitutionGroupElementDecl.getAttribute("name"));
                    }
                } else if (substitutionGroupEltTypeInfo != null || substitutionGroupEltDV != null) {
                    this.reportGenericSchemaError("Element " + elementDecl.getAttribute("name") + " which is part of a substitution must have a type which derives from the type of the element at the head of the substitution group");
                    noErrorSoFar = false;
                }
            } else {
                ComplexTypeInfo subTypeInfo = typeInfo;
                while (subTypeInfo != null && substitutionGroupEltTypeInfo != null && subTypeInfo != substitutionGroupEltTypeInfo) {
                    subTypeInfo = subTypeInfo.baseComplexTypeInfo;
                }
                if (subTypeInfo == null || substitutionGroupEltTypeInfo == null && substitutionGroupEltDV != null) {
                    this.reportGenericSchemaError("Element " + elementDecl.getAttribute("name") + " has a type which does not derive from the type of the element at the head of the substitution group");
                    noErrorSoFar = false;
                } else if ((derivationMethod & finalSet) != 0) {
                    noErrorSoFar = false;
                    this.reportGenericSchemaError("element " + elementDecl.getAttribute("name") + " cannot be part of the substitution group headed by " + substitutionGroupElementDecl.getAttribute("name"));
                }
            }
        } else if (dv != null) {
            if (dv == substitutionGroupEltDV) {
                return;
            }
            if (!(this.checkSimpleTypeDerivationOK(dv, substitutionGroupEltDV) || substitutionGroupEltTypeInfo == null && substitutionGroupEltDV == null)) {
                this.reportGenericSchemaError("Element " + elementDecl.getAttribute("name") + " has a type which does not derive from the type of the element at the head of the substitution group");
                noErrorSoFar = false;
            } else if ((2 & finalSet) != 0) {
                noErrorSoFar = false;
                this.reportGenericSchemaError("element " + elementDecl.getAttribute("name") + " cannot be part of the substitution group headed by " + substitutionGroupElementDecl.getAttribute("name"));
            }
        }
    }

    private boolean checkSimpleTypeDerivationOK(DatatypeValidator d, DatatypeValidator b) {
        if (b instanceof AnySimpleType) {
            return true;
        }
        DatatypeValidator dTemp = d;
        while (dTemp != null) {
            if (dTemp == b) break;
            dTemp = dTemp.getBaseValidator();
        }
        if (dTemp == null) {
            if (b instanceof UnionDatatypeValidator) {
                Vector subUnionMemberDV = ((UnionDatatypeValidator)b).getBaseValidators();
                int subUnionSize = subUnionMemberDV.size();
                boolean found = false;
                int i = 0;
                while (i < subUnionSize && !found) {
                    DatatypeValidator dTempSub = (DatatypeValidator)subUnionMemberDV.elementAt(i);
                    if (dTempSub instanceof AnySimpleType) {
                        return true;
                    }
                    DatatypeValidator dTempOrig = d;
                    while (dTempOrig != null) {
                        if (dTempSub == dTempOrig) {
                            found = true;
                            break;
                        }
                        dTempOrig = dTempOrig.getBaseValidator();
                    }
                    ++i;
                }
                if (!found) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private Element getTopLevelComponentByName(String componentCategory, String name) throws Exception {
        child = null;
        curr = this.fSchemaInfoListRoot;
        while (curr != null || curr == this.fSchemaInfoListRoot) {
            block17: {
                if (curr != null) {
                    curr.restore();
                }
                if (componentCategory.equals("group")) {
                    child = (Element)this.fSchemaGrammar.topLevelGroupDecls.get(name);
                } else if (componentCategory.equals("attributeGroup") && this.fSchemaInfoListRoot == null) {
                    child = (Element)this.fSchemaGrammar.topLevelAttrGrpDecls.get(name);
                } else if (componentCategory.equals("attribute")) {
                    child = (Element)this.fSchemaGrammar.topLevelAttrDecls.get(name);
                }
                if (child != null) break;
                child = XUtil.getFirstChildElement(this.fSchemaRootElement);
                if (child != null) ** GOTO lbl32
                break block17;
lbl-1000:
                // 1 sources

                {
                    if (child.getLocalName().equals(componentCategory)) {
                        if (child.getAttribute("name").equals(name)) {
                            break;
                        }
                    } else if (this.fRedefineSucceeded && child.getLocalName().equals("redefine")) {
                        gChild = XUtil.getFirstChildElement(child);
                        while (gChild != null) {
                            if (gChild.getLocalName().equals(componentCategory) && gChild.getAttribute("name").equals(name)) break;
                            gChild = XUtil.getNextSiblingElement(gChild);
                        }
                        if (gChild != null) {
                            child = gChild;
                            break;
                        }
                    }
                    child = XUtil.getNextSiblingElement(child);
lbl32:
                    // 2 sources

                    ** while (child != null)
                }
lbl33:
                // 3 sources

                if (child != null || this.fSchemaInfoListRoot == null) break;
            }
            curr = curr.getNext();
        }
        if (curr != null) {
            curr.restore();
        } else if (this.fSchemaInfoListRoot != null) {
            this.fSchemaInfoListRoot.restore();
        }
        return child;
    }

    private boolean isTopLevel(Element component) {
        String parentName = component.getParentNode().getLocalName();
        return parentName.endsWith("schema") || parentName.endsWith("redefine");
    }

    DatatypeValidator getTypeValidatorFromNS(String newSchemaURI, String localpart) throws Exception {
        return this.getDatatypeValidator(newSchemaURI, localpart);
    }

    ComplexTypeInfo getTypeInfoFromNS(String newSchemaURI, String localpart) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(newSchemaURI);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar sGrammar = (SchemaGrammar)grammar;
            ComplexTypeInfo typeInfo = (ComplexTypeInfo)sGrammar.getComplexTypeRegistry().get(String.valueOf(newSchemaURI) + "," + localpart);
            return typeInfo;
        }
        this.reportGenericSchemaError("could not resolve URI : " + newSchemaURI + " to a SchemaGrammar in getTypeInfoFromNS");
        return null;
    }

    DatatypeValidator getElementDeclTypeValidatorFromNS(String newSchemaURI, String localpart) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(newSchemaURI);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar sGrammar = (SchemaGrammar)grammar;
            int eltIndex = sGrammar.getElementDeclIndex(this.fStringPool.addSymbol(newSchemaURI), this.fStringPool.addSymbol(localpart), -1);
            DatatypeValidator dv = null;
            if (eltIndex > -1) {
                sGrammar.getElementDecl(eltIndex, this.fTempElementDecl);
                dv = this.fTempElementDecl.datatypeValidator;
            } else {
                this.reportGenericSchemaError("could not find global element : '" + localpart + " in the SchemaGrammar " + newSchemaURI);
            }
            return dv;
        }
        this.reportGenericSchemaError("could not resolve URI : " + newSchemaURI + " to a SchemaGrammar in getELementDeclTypeValidatorFromNS");
        return null;
    }

    ComplexTypeInfo getElementDeclTypeInfoFromNS(String newSchemaURI, String localpart) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(newSchemaURI);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar sGrammar = (SchemaGrammar)grammar;
            int eltIndex = sGrammar.getElementDeclIndex(this.fStringPool.addSymbol(newSchemaURI), this.fStringPool.addSymbol(localpart), -1);
            ComplexTypeInfo typeInfo = null;
            if (eltIndex > -1) {
                typeInfo = sGrammar.getElementComplexTypeInfo(eltIndex);
            } else {
                this.reportGenericSchemaError("could not find global element : '" + localpart + " in the SchemaGrammar " + newSchemaURI);
            }
            return typeInfo;
        }
        this.reportGenericSchemaError("could not resolve URI : " + newSchemaURI + " to a SchemaGrammar in getElementDeclTypeInfoFromNS");
        return null;
    }

    private String traverseNotationDecl(Element notation) throws Exception {
        String name;
        int scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(notation, scope);
        String qualifiedName = name = notation.getAttribute("name");
        if (this.fTargetNSURIString.length() != 0) {
            qualifiedName = String.valueOf(this.fTargetNSURIString) + ":" + name;
        }
        if (this.fNotationRegistry.get(qualifiedName) != null) {
            return name;
        }
        String publicId = notation.getAttribute("public");
        String systemId = notation.getAttribute("system");
        if (publicId.length() == 0 && systemId.length() == 0) {
            this.reportGenericSchemaError("<notation> declaration is invalid");
        }
        if (name.length() == 0) {
            this.reportGenericSchemaError("<notation> declaration does not have a name");
        }
        this.fNotationRegistry.put(qualifiedName, name);
        this.checkContent(notation, XUtil.getFirstChildElement(notation), true);
        return name;
    }

    private String traverseNotationFromAnotherSchema(String notationName, String uriStr) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(uriStr);
        if (uriStr == null || grammar == null || !(grammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseNotationDeclFromAnotherSchema, schema uri: " + uriStr + ", groupName: " + notationName);
            return "";
        }
        SchemaGrammar aGrammar = (SchemaGrammar)grammar;
        String savedNSURIString = this.fTargetNSURIString;
        this.fTargetNSURIString = this.fStringPool.toString(this.fStringPool.addSymbol(aGrammar.getTargetNamespaceURI()));
        String qualifiedName = String.valueOf(this.fTargetNSURIString) + ":" + notationName;
        String localName = (String)this.fNotationRegistry.get(qualifiedName);
        if (localName != null) {
            return localName;
        }
        Element notationDecl = (Element)aGrammar.topLevelNotationDecls.get(notationName);
        if (notationDecl == null) {
            this.reportGenericSchemaError("no notation named \"" + notationName + "\" was defined in schema : " + uriStr);
            return "";
        }
        localName = this.traverseNotationDecl(notationDecl);
        this.fTargetNSURIString = savedNSURIString;
        return localName;
    }

    private GroupInfo traverseGroupDecl(Element groupDecl) throws Exception {
        String childName;
        int scope = this.isTopLevel(groupDecl) ? GeneralAttrCheck.ELE_CONTEXT_GLOBAL : GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(groupDecl, scope);
        String groupName = groupDecl.getAttribute("name");
        String ref = groupDecl.getAttribute("ref");
        GroupInfo gInfo = null;
        Element child = this.checkContent(groupDecl, XUtil.getFirstChildElement(groupDecl), true);
        if (ref.length() != 0) {
            if (this.isTopLevel(groupDecl)) {
                this.reportGenericSchemaError("A group with \"ref\" present must not have <schema> or <redefine> as its parent");
            }
            if (groupName.length() != 0) {
                this.reportGenericSchemaError("group " + groupName + " cannot refer to another group, but it refers to " + ref);
            }
            if (XUtil.getFirstChildElement(groupDecl) != null) {
                this.reportGenericSchemaError("A group with \"ref\" present must not have children");
            }
            String prefix = "";
            String localpart = ref;
            int colonptr = ref.indexOf(":");
            if (colonptr > 0) {
                prefix = ref.substring(0, colonptr);
                localpart = ref.substring(colonptr + 1);
            }
            int localpartIndex = this.fStringPool.addSymbol(localpart);
            String uriStr = this.resolvePrefixToURI(prefix);
            if (!uriStr.equals(this.fTargetNSURIString)) {
                gInfo = this.traverseGroupDeclFromAnotherSchema(localpart, uriStr);
                if (gInfo != null) {
                    this.findAndCreateElements(gInfo.contentSpecIndex, gInfo.scope);
                }
                return gInfo;
            }
            try {
                gInfo = (GroupInfo)this.fGroupNameRegistry.get(String.valueOf(uriStr) + "," + localpart);
                if (gInfo != null) {
                    this.findAndCreateElements(gInfo.contentSpecIndex, gInfo.scope);
                    return gInfo;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (this.fCurrentGroupNameStack.search(localpart) > -1) {
                this.reportGenericSchemaError("mg-props-correct: Circular definition for group " + localpart);
                return null;
            }
            int contentSpecIndex = -1;
            Element referredGroup = this.getTopLevelComponentByName("group", localpart);
            if (referredGroup == null) {
                this.reportGenericSchemaError("Group " + localpart + " not found in the Schema");
            } else {
                gInfo = this.traverseGroupDecl(referredGroup);
            }
            if (gInfo != null) {
                this.findAndCreateElements(gInfo.contentSpecIndex, gInfo.scope);
            }
            return gInfo;
        }
        if (groupName.length() == 0) {
            this.reportGenericSchemaError("a <group> must have a name or a ref present");
        }
        String qualifiedGroupName = String.valueOf(this.fTargetNSURIString) + "," + groupName;
        try {
            gInfo = (GroupInfo)this.fGroupNameRegistry.get(qualifiedGroupName);
            if (gInfo != null) {
                this.findAndCreateElements(gInfo.contentSpecIndex, gInfo.scope);
                return gInfo;
            }
        }
        catch (ClassCastException localpart) {
            // empty catch block
        }
        this.fCurrentGroupNameStack.push(groupName);
        int savedScope = this.fCurrentScope;
        this.fCurrentScope = this.fScopeCount++;
        int index = -2;
        boolean illegalChild = false;
        String string = childName = child != null ? child.getLocalName() : "";
        if (childName.equals("all")) {
            index = this.traverseAll(child);
        } else if (childName.equals("choice")) {
            index = this.traverseChoice(child);
        } else if (childName.equals("sequence")) {
            index = this.traverseSequence(child);
        } else if (childName.length() != 0 || child != null && XUtil.getNextSiblingElement(child) != null) {
            illegalChild = true;
            this.reportSchemaError(14, new Object[]{"group", childName});
        }
        if (child == null) {
            this.reportGenericSchemaError("Named group must contain an 'all', 'choice' or 'sequence' child");
        } else if (XUtil.getNextSiblingElement(child) != null) {
            illegalChild = true;
            this.reportSchemaError(14, new Object[]{"group", childName});
        }
        if (!illegalChild && child != null) {
            index = this.handleOccurrences(index, child, 4);
        }
        gInfo = new GroupInfo();
        gInfo.contentSpecIndex = index;
        gInfo.scope = this.fCurrentScope;
        this.fCurrentScope = savedScope;
        this.fCurrentGroupNameStack.pop();
        this.fGroupNameRegistry.put(qualifiedGroupName, gInfo);
        return gInfo;
    }

    private void findAndCreateElements(int csIndex, int scope) {
        if (csIndex < 0 || this.fCurrentScope == -1) {
            return;
        }
        this.fSchemaGrammar.getContentSpec(csIndex, this.tempContentSpec1);
        int type = this.tempContentSpec1.type;
        int left = this.tempContentSpec1.value;
        int right = this.tempContentSpec1.otherValue;
        if (type == 0) {
            int eltNdx = this.fSchemaGrammar.getElementDeclIndex(right, left, scope);
            if (eltNdx < 0) {
                return;
            }
            ComplexTypeInfo typeInfo = this.fSchemaGrammar.getElementComplexTypeInfo(eltNdx);
            int scopeDefined = typeInfo != null ? typeInfo.scopeDefined : this.fCurrentScope;
            int newIdx = this.fSchemaGrammar.cloneElementDecl(eltNdx, this.fCurrentScope, scopeDefined);
            int count = this.fElementRecurseComplex.size();
            int i = 0;
            while (i < count) {
                ElementInfo eobj = (ElementInfo)this.fElementRecurseComplex.elementAt(i);
                if (eobj.elementIndex == eltNdx) {
                    this.fElementRecurseComplex.addElement(new ElementInfo(newIdx, eobj.typeName));
                    break;
                }
                ++i;
            }
        } else if (type == 4 || type == 9 || type == 5) {
            this.findAndCreateElements(left, scope);
            if (right != -2) {
                this.findAndCreateElements(right, scope);
            }
        } else if (type == 2 || type == 1 || type == 3) {
            this.findAndCreateElements(left, scope);
        }
    }

    private GroupInfo traverseGroupDeclFromAnotherSchema(String groupName, String uriStr) throws Exception {
        String childName;
        GroupInfo gInfo = null;
        Grammar grammar = this.fGrammarResolver.getGrammar(uriStr);
        if (uriStr == null || grammar == null || !(grammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseGroupDeclFromAnotherSchema, schema uri: " + uriStr + ", groupName: " + groupName);
            return null;
        }
        SchemaGrammar aGrammar = (SchemaGrammar)grammar;
        Element groupDecl = (Element)aGrammar.topLevelGroupDecls.get(groupName);
        if (groupDecl == null) {
            this.reportGenericSchemaError("no group named \"" + groupName + "\" was defined in schema : " + uriStr);
            return null;
        }
        NamespacesScope saveNSMapping = this.fNamespacesScope;
        int saveTargetNSUri = this.fTargetNSURI;
        this.fTargetNSURI = this.fStringPool.addSymbol(aGrammar.getTargetNamespaceURI());
        this.fNamespacesScope = aGrammar.getNamespacesScope();
        Element child = this.checkContent(groupDecl, XUtil.getFirstChildElement(groupDecl), true);
        String qualifiedGroupName = String.valueOf(this.fTargetNSURIString) + "," + groupName;
        try {
            gInfo = (GroupInfo)this.fGroupNameRegistry.get(qualifiedGroupName);
            if (gInfo != null) {
                return gInfo;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        int index = -2;
        int savedScope = this.fCurrentScope;
        this.fCurrentScope = this.fScopeCount++;
        boolean illegalChild = false;
        String string = childName = child != null ? child.getLocalName() : "";
        if (childName.equals("all")) {
            index = this.traverseAll(child);
        } else if (childName.equals("choice")) {
            index = this.traverseChoice(child);
        } else if (childName.equals("sequence")) {
            index = this.traverseSequence(child);
        } else if (childName.length() != 0 || child != null && XUtil.getNextSiblingElement(child) != null) {
            illegalChild = true;
            this.reportSchemaError(14, new Object[]{"group", childName});
        }
        if (!illegalChild && child != null) {
            index = this.handleOccurrences(index, child);
        }
        gInfo = new GroupInfo();
        gInfo.contentSpecIndex = index;
        gInfo.scope = this.fCurrentScope;
        this.fCurrentScope = savedScope;
        this.fGroupNameRegistry.put(qualifiedGroupName, gInfo);
        this.fNamespacesScope = saveNSMapping;
        this.fTargetNSURI = saveTargetNSUri;
        return gInfo;
    }

    /*
     * Unable to fully structure code
     */
    int traverseSequence(Element sequenceDecl) throws Exception {
        scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        attrValues = this.generalCheck(sequenceDecl, scope);
        child = this.checkContent(sequenceDecl, XUtil.getFirstChildElement(sequenceDecl), true);
        csnType = 5;
        left = -2;
        right = -2;
        hadContent = false;
        while (child != null) {
            block13: {
                block15: {
                    block14: {
                        block11: {
                            block12: {
                                block10: {
                                    index = -2;
                                    seeParticle = false;
                                    childName = child.getLocalName();
                                    if (!childName.equals("element")) break block10;
                                    eltQName = this.traverseElementDecl(child);
                                    index = this.fSchemaGrammar.addContentSpecNode(0, eltQName.localpart, eltQName.uri, false);
                                    seeParticle = true;
                                    ** GOTO lbl43
                                }
                                if (!childName.equals("group")) break block11;
                                grpInfo = this.traverseGroupDecl(child);
                                v0 = index = grpInfo != null ? grpInfo.contentSpecIndex : -2;
                                if (!this.hasAllContent(index)) break block12;
                                this.reportSchemaError(48, new Object[]{"sequence"});
                                break block13;
                            }
                            seeParticle = true;
                            ** GOTO lbl43
                        }
                        if (!childName.equals("choice")) break block14;
                        index = this.traverseChoice(child);
                        seeParticle = true;
                        ** GOTO lbl43
                    }
                    if (!childName.equals("sequence")) break block15;
                    index = this.traverseSequence(child);
                    seeParticle = true;
                    ** GOTO lbl43
                }
                if (!childName.equals("any")) {
                    this.reportSchemaError(46, new Object[]{"sequence", childName});
                } else {
                    index = this.traverseAny(child);
                    seeParticle = true;
lbl43:
                    // 5 sources

                    if (index != -2) {
                        hadContent = true;
                    }
                    if (seeParticle) {
                        index = this.handleOccurrences(index, child);
                    }
                    if (left == -2) {
                        left = index;
                    } else if (right == -2) {
                        right = index;
                    } else {
                        left = this.fSchemaGrammar.addContentSpecNode(csnType, left, right, false);
                        right = index;
                    }
                }
            }
            child = XUtil.getNextSiblingElement(child);
        }
        if (hadContent && (right != -2 || this.fSchemaGrammar.getDeferContentSpecExpansion())) {
            left = this.fSchemaGrammar.addContentSpecNode(csnType, left, right, false);
        }
        return left;
    }

    /*
     * Unable to fully structure code
     */
    int traverseChoice(Element choiceDecl) throws Exception {
        scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        attrValues = this.generalCheck(choiceDecl, scope);
        child = this.checkContent(choiceDecl, XUtil.getFirstChildElement(choiceDecl), true);
        csnType = 4;
        left = -2;
        right = -2;
        hadContent = false;
        while (child != null) {
            block13: {
                block15: {
                    block14: {
                        block11: {
                            block12: {
                                block10: {
                                    index = -2;
                                    seeParticle = false;
                                    childName = child.getLocalName();
                                    if (!childName.equals("element")) break block10;
                                    eltQName = this.traverseElementDecl(child);
                                    index = this.fSchemaGrammar.addContentSpecNode(0, eltQName.localpart, eltQName.uri, false);
                                    seeParticle = true;
                                    ** GOTO lbl43
                                }
                                if (!childName.equals("group")) break block11;
                                grpInfo = this.traverseGroupDecl(child);
                                v0 = index = grpInfo != null ? grpInfo.contentSpecIndex : -2;
                                if (!this.hasAllContent(index)) break block12;
                                this.reportSchemaError(48, new Object[]{"choice"});
                                break block13;
                            }
                            seeParticle = true;
                            ** GOTO lbl43
                        }
                        if (!childName.equals("choice")) break block14;
                        index = this.traverseChoice(child);
                        seeParticle = true;
                        ** GOTO lbl43
                    }
                    if (!childName.equals("sequence")) break block15;
                    index = this.traverseSequence(child);
                    seeParticle = true;
                    ** GOTO lbl43
                }
                if (!childName.equals("any")) {
                    this.reportSchemaError(46, new Object[]{"choice", childName});
                } else {
                    index = this.traverseAny(child);
                    seeParticle = true;
lbl43:
                    // 5 sources

                    if (index != -2) {
                        hadContent = true;
                    }
                    if (seeParticle) {
                        index = this.handleOccurrences(index, child);
                    }
                    if (left == -2) {
                        left = index;
                    } else if (right == -2) {
                        right = index;
                    } else {
                        left = this.fSchemaGrammar.addContentSpecNode(csnType, left, right, false);
                        right = index;
                    }
                }
            }
            child = XUtil.getNextSiblingElement(child);
        }
        if (hadContent && (right != -2 || this.fSchemaGrammar.getDeferContentSpecExpansion())) {
            left = this.fSchemaGrammar.addContentSpecNode(csnType, left, right, false);
        }
        return left;
    }

    int traverseAll(Element allDecl) throws Exception {
        int scope = GeneralAttrCheck.ELE_CONTEXT_LOCAL;
        Hashtable attrValues = this.generalCheck(allDecl, scope);
        Element child = this.checkContent(allDecl, XUtil.getFirstChildElement(allDecl), true);
        int csnType = 9;
        int left = -2;
        int right = -2;
        boolean hadContent = false;
        while (child != null) {
            int index = -2;
            String childName = child.getLocalName();
            if (!childName.equals("element")) {
                this.reportSchemaError(47, new Object[]{childName});
            } else {
                QName eltQName = this.traverseElementDecl(child);
                index = this.fSchemaGrammar.addContentSpecNode(0, eltQName.localpart, eltQName.uri, false);
                index = this.handleOccurrences(index, child, 1);
                hadContent = true;
                if (left == -2) {
                    left = index;
                } else if (right == -2) {
                    right = index;
                } else {
                    left = this.fSchemaGrammar.addContentSpecNode(csnType, left, right, false);
                    right = index;
                }
            }
            child = XUtil.getNextSiblingElement(child);
        }
        if (hadContent && (right != -2 || this.fSchemaGrammar.getDeferContentSpecExpansion())) {
            left = this.fSchemaGrammar.addContentSpecNode(csnType, left, right, false);
        }
        return left;
    }

    private boolean hasAllContent(int contentSpecIndex) {
        if (contentSpecIndex > -1) {
            XMLContentSpec content = new XMLContentSpec();
            this.fSchemaGrammar.getContentSpec(contentSpecIndex, content);
            if (content.type == 1) {
                this.fSchemaGrammar.getContentSpec(content.value, content);
            }
            return content.type == 9;
        }
        return false;
    }

    private Hashtable generalCheck(Element element, int scope) throws Exception {
        String uri = element.getNamespaceURI();
        if (uri == null || !uri.equals("http://www.w3.org/2001/XMLSchema")) {
            this.reportGenericSchemaError("The namespce name for '" + element.getLocalName() + "' must be " + "http://www.w3.org/2001/XMLSchema");
        }
        return this.fGeneralAttrCheck.checkAttributes(element, scope);
    }

    private int parseInt(String intString) throws Exception {
        if (intString.equals("*")) {
            return -1;
        }
        return Integer.parseInt(intString);
    }

    private int parseSimpleFinal(String finalString) throws Exception {
        if (finalString.equals("#all")) {
            return 26;
        }
        int enumerate = 0;
        int restrict = 0;
        int list = 0;
        StringTokenizer t = new StringTokenizer(finalString, " ");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (token.equals("restriction")) {
                if (restrict == 0) {
                    restrict = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction in set twice");
                continue;
            }
            if (token.equals("list")) {
                if (list == 0) {
                    list = 8;
                    continue;
                }
                this.reportGenericSchemaError("list in set twice");
                continue;
            }
            this.reportGenericSchemaError("Invalid value (" + finalString + ")");
        }
        return enumerate + list;
    }

    private int parseDerivationSet(String finalString) throws Exception {
        if (finalString.equals("#all")) {
            return 3;
        }
        int extend = 0;
        int restrict = 0;
        StringTokenizer t = new StringTokenizer(finalString, " ");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (token.equals("extension")) {
                if (extend == 0) {
                    extend = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (token.equals("restriction")) {
                if (restrict == 0) {
                    restrict = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + finalString + ")");
        }
        return extend + restrict;
    }

    private int parseBlockSet(String blockString) throws Exception {
        if (blockString == null) {
            return this.fBlockDefault;
        }
        if (blockString.equals("#all")) {
            return 35;
        }
        int extend = 0;
        int restrict = 0;
        int substitute = 0;
        StringTokenizer t = new StringTokenizer(blockString, " ");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (token.equals("substitution")) {
                if (substitute == 0) {
                    substitute = 32;
                    continue;
                }
                this.reportGenericSchemaError("The value 'substitution' already in the list");
                continue;
            }
            if (token.equals("extension")) {
                if (extend == 0) {
                    extend = 1;
                    continue;
                }
                this.reportGenericSchemaError("The value 'extension' is already in the list");
                continue;
            }
            if (token.equals("restriction")) {
                if (restrict == 0) {
                    restrict = 2;
                    continue;
                }
                this.reportGenericSchemaError("The value 'restriction' is already in the list");
                continue;
            }
            this.reportGenericSchemaError("Invalid block value (" + blockString + ")");
        }
        int defaultVal = extend + restrict + substitute;
        return defaultVal == 0 ? this.fBlockDefault : defaultVal;
    }

    private int parseFinalSet(String finalString) throws Exception {
        if (finalString == null) {
            return this.fFinalDefault;
        }
        if (finalString.equals("#all")) {
            return 15;
        }
        int extend = 0;
        int restrict = 0;
        int list = 0;
        int union = 0;
        StringTokenizer t = new StringTokenizer(finalString, " ");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (token.equals("union")) {
                if (union == 0) {
                    union = 4;
                    continue;
                }
                this.reportGenericSchemaError("The value 'union' is already in the list");
                continue;
            }
            if (token.equals("extension")) {
                if (extend == 0) {
                    extend = 1;
                    continue;
                }
                this.reportGenericSchemaError("The value 'extension' is already in the list");
                continue;
            }
            if (token.equals("list")) {
                if (list == 0) {
                    list = 8;
                    continue;
                }
                this.reportGenericSchemaError("The value 'list' is already in the list");
                continue;
            }
            if (token.equals("restriction")) {
                if (restrict == 0) {
                    restrict = 2;
                    continue;
                }
                this.reportGenericSchemaError("The value 'restriction' is already in the list");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + finalString + ")");
        }
        int defaultVal = extend + restrict + list + union;
        return defaultVal == 0 ? this.fFinalDefault : defaultVal;
    }

    private void reportGenericSchemaError(String error) throws Exception {
        if (this.fErrorReporter == null) {
            System.err.println("__TraverseSchemaError__ : " + error);
        } else {
            this.reportSchemaError(23, new Object[]{error});
        }
    }

    private void reportSchemaError(int major, Object[] args) throws Exception {
        if (this.fErrorReporter == null) {
            System.out.println("__TraverseSchemaError__ : " + SchemaMessageProvider.fgMessageKeys[major]);
            int i = 0;
            while (i < args.length) {
                System.out.println((String)args[i]);
                ++i;
            }
        } else {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", major, 0, args, 1);
        }
    }

    public class ComplexTypeInfo {
        public String typeName;
        public DatatypeValidator baseDataTypeValidator;
        public ComplexTypeInfo baseComplexTypeInfo;
        public int derivedBy = 0;
        public int blockSet = 0;
        public int finalSet = 0;
        public int miscFlags = 0;
        public int scopeDefined = -1;
        public int contentType;
        public int contentSpecHandle = -1;
        public int templateElementIndex = -1;
        public int attlistHead = -1;
        public DatatypeValidator datatypeValidator;

        public boolean isAbstractType() {
            return (this.miscFlags & 1) != 0;
        }

        public boolean containsAttrTypeID() {
            return (this.miscFlags & 2) != 0;
        }

        public boolean declSeen() {
            return (this.miscFlags & 4) != 0;
        }

        public void setIsAbstractType() {
            this.miscFlags |= 1;
        }

        public void setContainsAttrTypeID() {
            this.miscFlags |= 2;
        }

        public void setDeclSeen() {
            this.miscFlags |= 4;
        }
    }

    private class ComplexTypeRecoverableError
    extends Exception {
        ComplexTypeRecoverableError() {
        }

        ComplexTypeRecoverableError(String s) {
            super(s);
        }
    }

    private class ElementInfo {
        int elementIndex;
        String typeName;

        private ElementInfo(int i, String name) {
            this.elementIndex = i;
            this.typeName = name;
        }
    }

    static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        ErrorHandler() {
        }

        public void warning(SAXParseException ex) {
            System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        public void error(SAXParseException ex) throws SAXException {
            System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
            throw ex;
        }

        private String getLocationString(SAXParseException ex) {
            StringBuffer str = new StringBuffer();
            String systemId_ = ex.getSystemId();
            if (systemId_ != null) {
                int index = systemId_.lastIndexOf(47);
                if (index != -1) {
                    systemId_ = systemId_.substring(index + 1);
                }
                str.append(systemId_);
            }
            str.append(':');
            str.append(ex.getLineNumber());
            str.append(':');
            str.append(ex.getColumnNumber());
            return str.toString();
        }
    }

    private class GroupInfo {
        int contentSpecIndex = -1;
        int scope = -1;

        private GroupInfo() {
        }
    }

    static class IgnoreWhitespaceParser
    extends DOMParser {
        IgnoreWhitespaceParser() {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        public void ignorableWhitespace(int dataIdx) {
        }
    }

    private class ParticleRecoverableError
    extends Exception {
        ParticleRecoverableError(String s) {
            super(s);
        }
    }

    static class Resolver
    implements EntityResolver {
        private static final String[] SYSTEM = new String[]{"http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/structures.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/datatypes.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/versionInfo.ent"};
        private static final String[] PATH = new String[]{"structures.dtd", "datatypes.dtd", "versionInfo.ent"};

        Resolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws IOException {
            int i = 0;
            while (i < SYSTEM.length) {
                if (systemId.equals(SYSTEM[i])) {
                    InputSource source = new InputSource(this.getClass().getResourceAsStream(PATH[i]));
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    return source;
                }
                ++i;
            }
            return null;
        }
    }

    public class SchemaInfo {
        private Element saveRoot;
        private SchemaInfo nextRoot;
        private SchemaInfo prevRoot;
        private String savedSchemaURL;
        private boolean saveElementDefaultQualified;
        private boolean saveAttributeDefaultQualified;
        private int saveBlockDefault;
        private int saveFinalDefault;
        private NamespacesScope saveNamespacesScope;

        public SchemaInfo(boolean saveElementDefaultQualified, boolean saveAttributeDefaultQualified, int saveBlockDefault, int saveFinalDefault, String savedSchemaURL, Element saveRoot, NamespacesScope saveNamespacesScope, SchemaInfo nextRoot, SchemaInfo prevRoot) {
            this.savedSchemaURL = TraverseSchema.this.fCurrentSchemaURL;
            this.saveElementDefaultQualified = TraverseSchema.this.fElementDefaultQualified;
            this.saveAttributeDefaultQualified = TraverseSchema.this.fAttributeDefaultQualified;
            this.saveBlockDefault = TraverseSchema.this.fBlockDefault;
            this.saveFinalDefault = TraverseSchema.this.fFinalDefault;
            this.saveNamespacesScope = TraverseSchema.this.fNamespacesScope;
            this.saveElementDefaultQualified = saveElementDefaultQualified;
            this.saveAttributeDefaultQualified = saveAttributeDefaultQualified;
            this.saveBlockDefault = saveBlockDefault;
            this.saveFinalDefault = saveFinalDefault;
            this.savedSchemaURL = savedSchemaURL;
            this.saveRoot = saveRoot;
            if (saveNamespacesScope != null) {
                this.saveNamespacesScope = (NamespacesScope)saveNamespacesScope.clone();
            }
            this.nextRoot = nextRoot;
            this.prevRoot = prevRoot;
        }

        public void setNext(SchemaInfo next) {
            this.nextRoot = next;
        }

        public SchemaInfo getNext() {
            return this.nextRoot;
        }

        public void setPrev(SchemaInfo prev) {
            this.prevRoot = prev;
        }

        public String getCurrentSchemaURL() {
            return this.savedSchemaURL;
        }

        public SchemaInfo getPrev() {
            return this.prevRoot;
        }

        public Element getRoot() {
            return this.saveRoot;
        }

        public void restore() {
            TraverseSchema.this.fCurrentSchemaURL = this.savedSchemaURL;
            TraverseSchema.this.fElementDefaultQualified = this.saveElementDefaultQualified;
            TraverseSchema.this.fAttributeDefaultQualified = this.saveAttributeDefaultQualified;
            TraverseSchema.this.fBlockDefault = this.saveBlockDefault;
            TraverseSchema.this.fFinalDefault = this.saveFinalDefault;
            TraverseSchema.this.fNamespacesScope = (NamespacesScope)this.saveNamespacesScope.clone();
            TraverseSchema.this.fSchemaRootElement = this.saveRoot;
        }
    }
}

