/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XUtil {
    protected XUtil() {
    }

    public static void copyInto(Node src, Node dest) throws DOMException {
        Document factory = dest.getOwnerDocument();
        boolean domimpl = factory instanceof DocumentImpl;
        Node start = src;
        Node parent = src;
        Node place = src;
        while (place != null) {
            Node node = null;
            short type = place.getNodeType();
            switch (type) {
                case 4: {
                    node = factory.createCDATASection(place.getNodeValue());
                    break;
                }
                case 8: {
                    node = factory.createComment(place.getNodeValue());
                    break;
                }
                case 1: {
                    Element element = factory.createElement(place.getNodeName());
                    node = element;
                    NamedNodeMap attrs = place.getAttributes();
                    int attrCount = attrs.getLength();
                    int i = 0;
                    while (i < attrCount) {
                        Attr attr = (Attr)attrs.item(i);
                        String attrName = attr.getNodeName();
                        String attrValue = attr.getNodeValue();
                        element.setAttribute(attrName, attrValue);
                        if (domimpl && !attr.getSpecified()) {
                            ((AttrImpl)element.getAttributeNode(attrName)).setSpecified(false);
                        }
                        ++i;
                    }
                    break;
                }
                case 5: {
                    node = factory.createEntityReference(place.getNodeName());
                    break;
                }
                case 7: {
                    node = factory.createProcessingInstruction(place.getNodeName(), place.getNodeValue());
                    break;
                }
                case 3: {
                    node = factory.createTextNode(place.getNodeValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("can't copy node type, " + type + " (" + node.getNodeName() + ')');
                }
            }
            dest.appendChild(node);
            if (place.hasChildNodes()) {
                parent = place;
                place = place.getFirstChild();
                dest = node;
                continue;
            }
            place = place.getNextSibling();
            while (place == null && parent != start) {
                place = parent.getNextSibling();
                parent = parent.getParentNode();
                dest = dest.getParentNode();
            }
        }
    }

    public static Element getFirstChildElement(Node parent) {
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static Element getLastChildElement(Node parent) {
        Node child = parent.getLastChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                return (Element)child;
            }
            child = child.getPreviousSibling();
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node) {
        Node sibling = node.getNextSibling();
        while (sibling != null) {
            if (sibling.getNodeType() == 1) {
                return (Element)sibling;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Element getFirstChildElement(Node parent, String elemName) {
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && child.getNodeName().equals(elemName)) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static Element getLastChildElement(Node parent, String elemName) {
        Node child = parent.getLastChild();
        while (child != null) {
            if (child.getNodeType() == 1 && child.getNodeName().equals(elemName)) {
                return (Element)child;
            }
            child = child.getPreviousSibling();
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node, String elemName) {
        Node sibling = node.getNextSibling();
        while (sibling != null) {
            if (sibling.getNodeType() == 1 && sibling.getNodeName().equals(elemName)) {
                return (Element)sibling;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Element getFirstChildElementNS(Node parent, String uri, String localpart) {
        Node child = parent.getFirstChild();
        while (child != null) {
            String childURI;
            if (child.getNodeType() == 1 && (childURI = child.getNamespaceURI()) != null && childURI.equals(uri) && child.getLocalName().equals(localpart)) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static Element getLastChildElementNS(Node parent, String uri, String localpart) {
        Node child = parent.getLastChild();
        while (child != null) {
            String childURI;
            if (child.getNodeType() == 1 && (childURI = child.getNamespaceURI()) != null && childURI.equals(uri) && child.getLocalName().equals(localpart)) {
                return (Element)child;
            }
            child = child.getPreviousSibling();
        }
        return null;
    }

    public static Element getNextSiblingElementNS(Node node, String uri, String localpart) {
        Node sibling = node.getNextSibling();
        while (sibling != null) {
            String siblingURI;
            if (sibling.getNodeType() == 1 && (siblingURI = sibling.getNamespaceURI()) != null && siblingURI.equals(uri) && sibling.getLocalName().equals(localpart)) {
                return (Element)sibling;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Element getFirstChildElement(Node parent, String[] elemNames) {
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                int i = 0;
                while (i < elemNames.length) {
                    if (child.getNodeName().equals(elemNames[i])) {
                        return (Element)child;
                    }
                    ++i;
                }
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static Element getLastChildElement(Node parent, String[] elemNames) {
        Node child = parent.getLastChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                int i = 0;
                while (i < elemNames.length) {
                    if (child.getNodeName().equals(elemNames[i])) {
                        return (Element)child;
                    }
                    ++i;
                }
            }
            child = child.getPreviousSibling();
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node, String[] elemNames) {
        Node sibling = node.getNextSibling();
        while (sibling != null) {
            if (sibling.getNodeType() == 1) {
                int i = 0;
                while (i < elemNames.length) {
                    if (sibling.getNodeName().equals(elemNames[i])) {
                        return (Element)sibling;
                    }
                    ++i;
                }
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Element getFirstChildElementNS(Node parent, String[][] elemNames) {
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                int i = 0;
                while (i < elemNames.length) {
                    String uri = child.getNamespaceURI();
                    if (uri != null && uri.equals(elemNames[i][0]) && child.getLocalName().equals(elemNames[i][1])) {
                        return (Element)child;
                    }
                    ++i;
                }
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static Element getLastChildElementNS(Node parent, String[][] elemNames) {
        Node child = parent.getLastChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                int i = 0;
                while (i < elemNames.length) {
                    String uri = child.getNamespaceURI();
                    if (uri != null && uri.equals(elemNames[i][0]) && child.getLocalName().equals(elemNames[i][1])) {
                        return (Element)child;
                    }
                    ++i;
                }
            }
            child = child.getPreviousSibling();
        }
        return null;
    }

    public static Element getNextSiblingElementNS(Node node, String[][] elemNames) {
        Node sibling = node.getNextSibling();
        while (sibling != null) {
            if (sibling.getNodeType() == 1) {
                int i = 0;
                while (i < elemNames.length) {
                    String uri = sibling.getNamespaceURI();
                    if (uri != null && uri.equals(elemNames[i][0]) && sibling.getLocalName().equals(elemNames[i][1])) {
                        return (Element)sibling;
                    }
                    ++i;
                }
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Element getFirstChildElement(Node parent, String elemName, String attrName, String attrValue) {
        Node child = parent.getFirstChild();
        while (child != null) {
            Element element;
            if (child.getNodeType() == 1 && (element = (Element)child).getNodeName().equals(elemName) && element.getAttribute(attrName).equals(attrValue)) {
                return element;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static Element getLastChildElement(Node parent, String elemName, String attrName, String attrValue) {
        Node child = parent.getLastChild();
        while (child != null) {
            Element element;
            if (child.getNodeType() == 1 && (element = (Element)child).getNodeName().equals(elemName) && element.getAttribute(attrName).equals(attrValue)) {
                return element;
            }
            child = child.getPreviousSibling();
        }
        return null;
    }

    public static Element getNextSiblingElement(Node node, String elemName, String attrName, String attrValue) {
        Node sibling = node.getNextSibling();
        while (sibling != null) {
            Element element;
            if (sibling.getNodeType() == 1 && (element = (Element)sibling).getNodeName().equals(elemName) && element.getAttribute(attrName).equals(attrValue)) {
                return element;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static String getChildText(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        Node child = node.getFirstChild();
        while (child != null) {
            short type = child.getNodeType();
            if (type == 3) {
                str.append(child.getNodeValue());
            } else if (type == 4) {
                str.append(XUtil.getChildText(child));
            }
            child = child.getNextSibling();
        }
        return str.toString();
    }
}

