/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.schema.identity.IDValue;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.ValueStore;
import org.apache.xerces.validators.schema.identity.XPathException;
import org.apache.xerces.validators.schema.identity.XPathMatcher;

public class Field {
    protected XPath fXPath;
    protected IdentityConstraint fIdentityConstraint;
    protected boolean mayMatch = true;

    public Field(XPath xpath, IdentityConstraint identityConstraint) {
        this.fXPath = xpath;
        this.fIdentityConstraint = identityConstraint;
    }

    public void setMayMatch(boolean b) {
        this.mayMatch = b;
    }

    public boolean mayMatch() {
        return this.mayMatch;
    }

    public org.apache.xerces.validators.schema.identity.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.fIdentityConstraint;
    }

    public XPathMatcher createMatcher(ValueStore store) {
        return new Matcher(this.fXPath, store);
    }

    public String toString() {
        return this.fXPath.toString();
    }

    protected class Matcher
    extends XPathMatcher {
        protected ValueStore fStore;

        public Matcher(XPath xpath, ValueStore store) {
            super(xpath, true, null);
            this.fStore = store;
        }

        protected void matched(String content, DatatypeValidator val, boolean isNil) throws Exception {
            super.matched(content, val, isNil);
            if (isNil) {
                this.fStore.reportNilError(Field.this.fIdentityConstraint);
            }
            this.fStore.addValue(Field.this, new IDValue(content, val));
            Field.this.mayMatch = false;
        }
    }

    public static class XPath
    extends org.apache.xerces.validators.schema.identity.XPath {
        public XPath(String xpath, StringPool stringPool, NamespacesScope context) throws XPathException {
            super(xpath.trim().startsWith("/") || xpath.trim().startsWith(".") ? xpath : "./" + xpath, stringPool, context);
        }
    }
}

