/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import org.apache.xerces.validators.schema.identity.Field;
import org.apache.xerces.validators.schema.identity.Selector;

public abstract class IdentityConstraint {
    public static final short UNIQUE = 0;
    public static final short KEY = 1;
    public static final short KEYREF = 2;
    protected String fIdentityConstraintName;
    protected String fElementName;
    protected Selector fSelector;
    protected int fFieldCount;
    protected Field[] fFields;

    protected IdentityConstraint(String identityConstraintName, String elementName) {
        this.fIdentityConstraintName = identityConstraintName;
        this.fElementName = elementName;
    }

    public abstract short getType();

    public String getIdentityConstraintName() {
        return this.fIdentityConstraintName;
    }

    public String getElementName() {
        return this.fElementName;
    }

    public void setSelector(Selector selector) {
        this.fSelector = selector;
    }

    public Selector getSelector() {
        return this.fSelector;
    }

    public void addField(Field field) {
        try {
            this.fFields[this.fFieldCount] = null;
        }
        catch (NullPointerException e) {
            this.fFields = new Field[4];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Field[] newfields = new Field[this.fFields.length * 2];
            System.arraycopy(this.fFields, 0, newfields, 0, this.fFields.length);
            this.fFields = newfields;
        }
        this.fFields[this.fFieldCount++] = field;
    }

    public int getFieldCount() {
        return this.fFieldCount;
    }

    public Field getFieldAt(int index) {
        return this.fFields[index];
    }

    public String toString() {
        String s = super.toString();
        int index1 = s.lastIndexOf(36);
        if (index1 != -1) {
            return s.substring(index1 + 1);
        }
        int index2 = s.lastIndexOf(46);
        if (index2 != -1) {
            return s.substring(index2 + 1);
        }
        return s;
    }

    public boolean equals(IdentityConstraint id) {
        boolean areEqual = this.fIdentityConstraintName.equals(id.fIdentityConstraintName);
        if (!areEqual) {
            return false;
        }
        areEqual = this.fSelector.toString().equals(id.fSelector.toString());
        if (!areEqual) {
            return false;
        }
        boolean bl = areEqual = this.fFieldCount == id.fFieldCount;
        if (!areEqual) {
            return false;
        }
        int i = 0;
        while (i < this.fFieldCount) {
            if (!this.fFields[i].toString().equals(id.fFields[i].toString())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

