/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.identity.Field;
import org.apache.xerces.validators.schema.identity.FieldActivator;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.XPath;
import org.apache.xerces.validators.schema.identity.XPathException;
import org.apache.xerces.validators.schema.identity.XPathMatcher;

public class Selector {
    protected XPath fXPath;
    protected IdentityConstraint fIdentityConstraint;

    public Selector(XPath xpath, IdentityConstraint identityConstraint) {
        this.fXPath = xpath;
        this.fIdentityConstraint = identityConstraint;
    }

    public org.apache.xerces.validators.schema.identity.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.fIdentityConstraint;
    }

    public XPathMatcher createMatcher(FieldActivator activator) {
        return new Matcher(this.fXPath, activator);
    }

    public String toString() {
        return this.fXPath.toString();
    }

    protected class Matcher
    extends XPathMatcher {
        protected FieldActivator fFieldActivator;
        protected int fElementDepth;
        protected int fMatchedDepth;

        public Matcher(XPath xpath, FieldActivator activator) {
            super(xpath, false, Selector.this.fIdentityConstraint);
            this.fFieldActivator = activator;
        }

        public void startDocumentFragment(StringPool stringPool) throws Exception {
            super.startDocumentFragment(stringPool);
            this.fElementDepth = 0;
            this.fMatchedDepth = -1;
        }

        public void startElement(QName element, XMLAttrList attributes, int handle, int elemIndex, SchemaGrammar grammar) throws Exception {
            super.startElement(element, attributes, handle, elemIndex, grammar);
            ++this.fElementDepth;
            if (this.fMatchedDepth == -1 && this.isMatched()) {
                this.fMatchedDepth = this.fElementDepth;
                this.fFieldActivator.startValueScopeFor(Selector.this.fIdentityConstraint);
                int count = Selector.this.fIdentityConstraint.getFieldCount();
                int i = 0;
                while (i < count) {
                    Field field = Selector.this.fIdentityConstraint.getFieldAt(i);
                    XPathMatcher matcher = this.fFieldActivator.activateField(field);
                    matcher.startElement(element, attributes, handle, elemIndex, grammar);
                    ++i;
                }
            }
        }

        public void endElement(QName element, int elemIndex, SchemaGrammar grammar) throws Exception {
            super.endElement(element, elemIndex, grammar);
            if (this.fElementDepth-- == this.fMatchedDepth) {
                this.fMatchedDepth = -1;
                this.fFieldActivator.endValueScopeFor(Selector.this.fIdentityConstraint);
            }
        }
    }

    public static class XPath
    extends org.apache.xerces.validators.schema.identity.XPath {
        public XPath(String xpath, StringPool stringPool, NamespacesScope context) throws XPathException {
            super(xpath.trim().startsWith("/") || xpath.trim().startsWith(".") ? xpath : "./" + xpath, stringPool, context);
            int i = 0;
            while (i < this.fLocationPaths.length) {
                XPath.Axis axis = this.fLocationPaths[i].steps[this.fLocationPaths[i].steps.length - 1].axis;
                if (axis.type == 2) {
                    throw new XPathException("selectors cannot select attributes");
                }
                ++i;
            }
        }
    }
}

