/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import java.util.Vector;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.validators.schema.identity.XPathException;

public class XPath {
    private static final boolean DEBUG_ALL = false;
    private static final boolean DEBUG_XPATH_PARSE = false;
    private static final boolean DEBUG_ANY = false;
    protected String fExpression;
    protected StringPool fStringPool;
    protected LocationPath[] fLocationPaths;

    public XPath(String xpath, StringPool stringPool, NamespacesScope context) throws XPathException {
        XMLCharacterProperties.initCharFlags();
        this.fExpression = xpath;
        this.fStringPool = stringPool;
        this.parseExpression(context);
    }

    public LocationPath getLocationPath() {
        return (LocationPath)this.fLocationPaths[0].clone();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.fLocationPaths.length) {
            if (i > 0) {
                buf.append("|");
            }
            buf.append(this.fLocationPaths[i].toString());
            ++i;
        }
        return buf.toString();
    }

    private void parseExpression(NamespacesScope context) throws XPathException {
        Tokens xtokens = new Tokens(this.fStringPool);
        Scanner scanner = new Scanner(this.fStringPool){

            protected void addToken(Tokens tokens, int token) throws XPathException {
                if (token == 6 || token == 35 || token == 36 || token == 8 || token == 11 || token == 21 || token == 4 || token == 9 || token == 10 || token == 22 || token == 23) {
                    super.addToken(tokens, token);
                    return;
                }
                StringBuffer str = new StringBuffer();
                str.append("token not supported: ");
                String tokenName = tokens.getTokenName(token);
                if (tokenName != null) {
                    str.append('\"');
                    str.append(tokenName);
                    str.append('\"');
                } else {
                    str.append('(');
                    str.append(token);
                    str.append(')');
                }
                String message = str.toString();
                throw new XPathException(message);
            }
        };
        int length = this.fExpression.length();
        boolean success = scanner.scanExpr(this.fStringPool, xtokens, this.fExpression, 0, length);
        Vector<Step> stepsVector = new Vector<Step>();
        Vector<LocationPath> locationPathsVector = new Vector<LocationPath>();
        int tokenCount = xtokens.getTokenCount();
        boolean firstTokenOfLocationPath = true;
        int i = 0;
        while (i < tokenCount) {
            int token = xtokens.getToken(i);
            boolean isNamespace = false;
            switch (token) {
                case 23: {
                    if (i == 0) {
                        throw new XPathException("not allowed to have '|' at the beginning of an xpath value");
                    }
                    int size = stepsVector.size();
                    if (size == 0) {
                        throw new XPathException("not allowed to have '||'");
                    }
                    Object[] steps = new Step[size];
                    stepsVector.copyInto(steps);
                    locationPathsVector.addElement(new LocationPath((Step[])steps));
                    stepsVector.removeAllElements();
                    firstTokenOfLocationPath = true;
                    break;
                }
                case 35: {
                    ++i;
                }
                case 6: {
                    if (i == tokenCount - 1) {
                        throw new XPathException("missing attribute name");
                    }
                    if ((token = xtokens.getToken(++i)) != 11 && token != 9 && token != 10) {
                        throw new XPathException("expected \"" + xtokens.getTokenName(11) + "\" or \"" + xtokens.getTokenName(9) + "\" or \"" + xtokens.getTokenName(10) + "\", found " + xtokens.getTokenName(token));
                    }
                    boolean isNamespaceAtt = false;
                    switch (token) {
                        case 9: {
                            Axis axis = new Axis(2);
                            NodeTest nodeTest = new NodeTest(2);
                            Step step = new Step(axis, nodeTest);
                            stepsVector.addElement(step);
                            break;
                        }
                        case 10: {
                            isNamespaceAtt = true;
                        }
                        case 11: {
                            token = xtokens.getToken(++i);
                            int prefix = xtokens.getTokenString(token);
                            int uri = 0;
                            if (context != null && prefix != -1) {
                                uri = context.getNamespaceForPrefix(prefix);
                            }
                            if (prefix != -1 && context != null && uri == 0) {
                                throw new XPathException("prefix " + this.fStringPool.toString(prefix) + " not bound to namespace URI");
                            }
                            if (isNamespaceAtt) {
                                Axis axis = new Axis(2);
                                NodeTest nodeTest = new NodeTest(this.fStringPool, prefix, uri);
                                Step step = new Step(axis, nodeTest);
                                stepsVector.addElement(step);
                                break;
                            }
                            token = xtokens.getToken(++i);
                            int localpart = xtokens.getTokenString(token);
                            int rawname = prefix != -1 ? this.fStringPool.addSymbol(String.valueOf(this.fStringPool.toString(prefix)) + ':' + this.fStringPool.toString(localpart)) : localpart;
                            Axis axis = new Axis(2);
                            NodeTest nodeTest = new NodeTest(this.fStringPool, new QName(prefix, localpart, rawname, uri));
                            Step step = new Step(axis, nodeTest);
                            stepsVector.addElement(step);
                        }
                    }
                    firstTokenOfLocationPath = false;
                    break;
                }
                case 8: {
                    throw new XPathException("Not allowed to have double colon here");
                }
                case 36: {
                    if (++i == tokenCount - 1) {
                        throw new XPathException("expected step following '" + xtokens.getTokenName(36) + "::'");
                    }
                    firstTokenOfLocationPath = false;
                    break;
                }
                case 9: {
                    Axis axis = new Axis(1);
                    NodeTest nodeTest = new NodeTest(2);
                    Step step = new Step(axis, nodeTest);
                    stepsVector.addElement(step);
                    firstTokenOfLocationPath = false;
                    break;
                }
                case 10: {
                    isNamespace = true;
                }
                case 11: {
                    token = xtokens.getToken(++i);
                    int prefix = xtokens.getTokenString(token);
                    int uri = 0;
                    if (context != null && prefix != -1) {
                        uri = context.getNamespaceForPrefix(prefix);
                    }
                    if (prefix != -1 && context != null && uri == 0) {
                        throw new XPathException("prefix " + this.fStringPool.toString(prefix) + " not bound to namespace URI");
                    }
                    if (isNamespace) {
                        Axis axis = new Axis(1);
                        NodeTest nodeTest = new NodeTest(this.fStringPool, prefix, uri);
                        Step step = new Step(axis, nodeTest);
                        stepsVector.addElement(step);
                        break;
                    }
                    token = xtokens.getToken(++i);
                    int localpart = xtokens.getTokenString(token);
                    int rawname = prefix != -1 ? this.fStringPool.addSymbol(String.valueOf(this.fStringPool.toString(prefix)) + ':' + this.fStringPool.toString(localpart)) : localpart;
                    Axis axis = new Axis(1);
                    NodeTest nodeTest = new NodeTest(this.fStringPool, new QName(prefix, localpart, rawname, uri));
                    Step step = new Step(axis, nodeTest);
                    stepsVector.addElement(step);
                    firstTokenOfLocationPath = false;
                    break;
                }
                case 4: {
                    Axis axis = new Axis(3);
                    NodeTest nodeTest = new NodeTest(3);
                    Step step = new Step(axis, nodeTest);
                    stepsVector.addElement(step);
                    if (firstTokenOfLocationPath && i + 1 < tokenCount && (token = xtokens.getToken(i + 1)) == 22) {
                        if (++i == tokenCount - 1) {
                            throw new XPathException("expected step following '//'");
                        }
                        if (i + 1 < tokenCount && (token = xtokens.getToken(i + 1)) == 21) {
                            throw new XPathException("'/' not allowed after '//'");
                        }
                        axis = new Axis(4);
                        nodeTest = new NodeTest(3);
                        step = new Step(axis, nodeTest);
                        stepsVector.addElement(step);
                    }
                    firstTokenOfLocationPath = false;
                    break;
                }
                case 22: {
                    throw new XPathException("'//' only allowed after '.' at the beginning of an xpath");
                }
                case 21: {
                    if (i == 0) {
                        throw new XPathException("not allowed to have '/' at the beginning of an xpath value");
                    }
                    if (firstTokenOfLocationPath) {
                        throw new XPathException("not allowed to select the root");
                    }
                    if (i == tokenCount - 1) {
                        throw new XPathException("expected step following '/'");
                    }
                    firstTokenOfLocationPath = false;
                    break;
                }
                default: {
                    firstTokenOfLocationPath = false;
                }
            }
            ++i;
        }
        int size = stepsVector.size();
        if (size == 0) {
            if (locationPathsVector.size() == 0) {
                throw new XPathException("empty xpath expression");
            }
            throw new XPathException("xpath cannot end with '|'");
        }
        Object[] steps = new Step[size];
        stepsVector.copyInto(steps);
        locationPathsVector.addElement(new LocationPath((Step[])steps));
        this.fLocationPaths = new LocationPath[locationPathsVector.size()];
        locationPathsVector.copyInto(this.fLocationPaths);
    }

    public static void main(String[] argv) throws Exception {
        int i = 0;
        while (i < argv.length) {
            String expression = argv[i];
            System.out.println("# XPath expression: \"" + expression + '\"');
            try {
                StringPool stringPool = new StringPool();
                XPath xpath = new XPath(expression, stringPool, null);
                System.out.println("expanded xpath: \"" + xpath.toString() + '\"');
            }
            catch (XPathException e) {
                System.out.println("error: " + e.getMessage());
            }
            ++i;
        }
    }

    public LocationPath[] getLocationPaths() {
        LocationPath[] ret = new LocationPath[this.fLocationPaths.length];
        int i = 0;
        while (i < this.fLocationPaths.length) {
            ret[i] = (LocationPath)this.fLocationPaths[i].clone();
            ++i;
        }
        return ret;
    }

    public static class Axis
    implements Cloneable {
        public static final short CHILD = 1;
        public static final short ATTRIBUTE = 2;
        public static final short SELF = 3;
        public static final short DESCENDANT = 4;
        public short type;

        public Axis(short type) {
            this.type = type;
        }

        protected Axis(Axis axis) {
            this.type = axis.type;
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    return "child";
                }
                case 2: {
                    return "attribute";
                }
                case 3: {
                    return "self";
                }
                case 4: {
                    return "descendant";
                }
            }
            return "???";
        }

        public Object clone() {
            return new Axis(this);
        }
    }

    public static class LocationPath
    implements Cloneable {
        public Step[] steps;

        public LocationPath(Step[] steps) {
            this.steps = steps;
        }

        protected LocationPath(LocationPath path) {
            this.steps = new Step[path.steps.length];
            int i = 0;
            while (i < this.steps.length) {
                this.steps[i] = (Step)path.steps[i].clone();
                ++i;
            }
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            int i = 0;
            while (i < this.steps.length) {
                if (i > 0 && this.steps[i - 1].axis.type != 4 && this.steps[i].axis.type != 4) {
                    str.append('/');
                }
                str.append(this.steps[i].toString());
                ++i;
            }
            return str.toString();
        }

        public Object clone() {
            return new LocationPath(this);
        }
    }

    public static class NodeTest
    implements Cloneable {
        public static final short QNAME = 1;
        public static final short WILDCARD = 2;
        public static final short NODE = 3;
        public static final short NAMESPACE = 4;
        protected StringPool fStringPool;
        public short type;
        public final QName name = new QName();

        public NodeTest(short type) {
            this.type = type;
        }

        public NodeTest(StringPool stringPool, QName name) {
            this.fStringPool = stringPool;
            this.type = 1;
            this.name.setValues(name);
        }

        public NodeTest(StringPool stringPool, int prefix, int uri) {
            this.fStringPool = stringPool;
            this.type = (short)4;
            this.name.setValues(prefix, -1, -1, uri);
        }

        public NodeTest(NodeTest nodeTest) {
            this.fStringPool = nodeTest.fStringPool;
            this.type = nodeTest.type;
            this.name.setValues(nodeTest.name);
        }

        public String toString() {
            switch (this.type) {
                case 1: {
                    if (this.name.prefix != -1) {
                        if (this.name.uri == 0) {
                            return String.valueOf(this.fStringPool.toString(this.name.prefix)) + ':' + this.fStringPool.toString(this.name.localpart);
                        }
                        return "{" + this.fStringPool.toString(this.name.uri) + '}' + this.fStringPool.toString(this.name.prefix) + ':' + this.fStringPool.toString(this.name.localpart);
                    }
                    return this.fStringPool.toString(this.name.localpart);
                }
                case 4: {
                    if (this.name.prefix != -1) {
                        if (this.name.uri == 0) {
                            return String.valueOf(this.fStringPool.toString(this.name.prefix)) + ":*";
                        }
                        return "{" + this.fStringPool.toString(this.name.uri) + '}' + this.fStringPool.toString(this.name.prefix) + ":*";
                    }
                    return "???:*";
                }
                case 2: {
                    return "*";
                }
                case 3: {
                    return "node()";
                }
            }
            return "???";
        }

        public Object clone() {
            return new NodeTest(this);
        }
    }

    private static class Scanner {
        private static final byte CHARTYPE_INVALID = 0;
        private static final byte CHARTYPE_OTHER = 1;
        private static final byte CHARTYPE_WHITESPACE = 2;
        private static final byte CHARTYPE_EXCLAMATION = 3;
        private static final byte CHARTYPE_QUOTE = 4;
        private static final byte CHARTYPE_DOLLAR = 5;
        private static final byte CHARTYPE_OPEN_PAREN = 6;
        private static final byte CHARTYPE_CLOSE_PAREN = 7;
        private static final byte CHARTYPE_STAR = 8;
        private static final byte CHARTYPE_PLUS = 9;
        private static final byte CHARTYPE_COMMA = 10;
        private static final byte CHARTYPE_MINUS = 11;
        private static final byte CHARTYPE_PERIOD = 12;
        private static final byte CHARTYPE_SLASH = 13;
        private static final byte CHARTYPE_DIGIT = 14;
        private static final byte CHARTYPE_COLON = 15;
        private static final byte CHARTYPE_LESS = 16;
        private static final byte CHARTYPE_EQUAL = 17;
        private static final byte CHARTYPE_GREATER = 18;
        private static final byte CHARTYPE_ATSIGN = 19;
        private static final byte CHARTYPE_LETTER = 20;
        private static final byte CHARTYPE_OPEN_BRACKET = 21;
        private static final byte CHARTYPE_CLOSE_BRACKET = 22;
        private static final byte CHARTYPE_UNDERSCORE = 23;
        private static final byte CHARTYPE_UNION = 24;
        private static final byte CHARTYPE_NONASCII = 25;
        private static byte[] fASCIICharMap;
        private StringPool fStringPool;
        private int fAndSymbol;
        private int fOrSymbol;
        private int fModSymbol;
        private int fDivSymbol;
        private int fCommentSymbol;
        private int fTextSymbol;
        private int fPISymbol;
        private int fNodeSymbol;
        private int fAncestorSymbol;
        private int fAncestorOrSelfSymbol;
        private int fAttributeSymbol;
        private int fChildSymbol;
        private int fDescendantSymbol;
        private int fDescendantOrSelfSymbol;
        private int fFollowingSymbol;
        private int fFollowingSiblingSymbol;
        private int fNamespaceSymbol;
        private int fParentSymbol;
        private int fPrecedingSymbol;
        private int fPrecedingSiblingSymbol;
        private int fSelfSymbol;

        static {
            byte[] byArray = new byte[128];
            byArray[9] = 2;
            byArray[10] = 2;
            byArray[13] = 2;
            byArray[32] = 2;
            byArray[33] = 3;
            byArray[34] = 4;
            byArray[35] = 1;
            byArray[36] = 5;
            byArray[37] = 1;
            byArray[38] = 1;
            byArray[39] = 4;
            byArray[40] = 6;
            byArray[41] = 7;
            byArray[42] = 8;
            byArray[43] = 9;
            byArray[44] = 10;
            byArray[45] = 11;
            byArray[46] = 12;
            byArray[47] = 13;
            byArray[48] = 14;
            byArray[49] = 14;
            byArray[50] = 14;
            byArray[51] = 14;
            byArray[52] = 14;
            byArray[53] = 14;
            byArray[54] = 14;
            byArray[55] = 14;
            byArray[56] = 14;
            byArray[57] = 14;
            byArray[58] = 15;
            byArray[59] = 1;
            byArray[60] = 16;
            byArray[61] = 17;
            byArray[62] = 18;
            byArray[63] = 1;
            byArray[64] = 19;
            byArray[65] = 20;
            byArray[66] = 20;
            byArray[67] = 20;
            byArray[68] = 20;
            byArray[69] = 20;
            byArray[70] = 20;
            byArray[71] = 20;
            byArray[72] = 20;
            byArray[73] = 20;
            byArray[74] = 20;
            byArray[75] = 20;
            byArray[76] = 20;
            byArray[77] = 20;
            byArray[78] = 20;
            byArray[79] = 20;
            byArray[80] = 20;
            byArray[81] = 20;
            byArray[82] = 20;
            byArray[83] = 20;
            byArray[84] = 20;
            byArray[85] = 20;
            byArray[86] = 20;
            byArray[87] = 20;
            byArray[88] = 20;
            byArray[89] = 20;
            byArray[90] = 20;
            byArray[91] = 21;
            byArray[92] = 1;
            byArray[93] = 22;
            byArray[94] = 1;
            byArray[95] = 23;
            byArray[96] = 1;
            byArray[97] = 20;
            byArray[98] = 20;
            byArray[99] = 20;
            byArray[100] = 20;
            byArray[101] = 20;
            byArray[102] = 20;
            byArray[103] = 20;
            byArray[104] = 20;
            byArray[105] = 20;
            byArray[106] = 20;
            byArray[107] = 20;
            byArray[108] = 20;
            byArray[109] = 20;
            byArray[110] = 20;
            byArray[111] = 20;
            byArray[112] = 20;
            byArray[113] = 20;
            byArray[114] = 20;
            byArray[115] = 20;
            byArray[116] = 20;
            byArray[117] = 20;
            byArray[118] = 20;
            byArray[119] = 20;
            byArray[120] = 20;
            byArray[121] = 20;
            byArray[122] = 20;
            byArray[123] = 1;
            byArray[124] = 24;
            byArray[125] = 1;
            byArray[126] = 1;
            byArray[127] = 1;
            fASCIICharMap = byArray;
        }

        public Scanner(StringPool stringPool) {
            this.fStringPool = stringPool;
            this.fAndSymbol = this.fStringPool.addSymbol("and");
            this.fOrSymbol = this.fStringPool.addSymbol("or");
            this.fModSymbol = this.fStringPool.addSymbol("mod");
            this.fDivSymbol = this.fStringPool.addSymbol("div");
            this.fCommentSymbol = this.fStringPool.addSymbol("comment");
            this.fTextSymbol = this.fStringPool.addSymbol("text");
            this.fPISymbol = this.fStringPool.addSymbol("processing-instruction");
            this.fNodeSymbol = this.fStringPool.addSymbol("node");
            this.fAncestorSymbol = this.fStringPool.addSymbol("ancestor");
            this.fAncestorOrSelfSymbol = this.fStringPool.addSymbol("ancestor-or-self");
            this.fAttributeSymbol = this.fStringPool.addSymbol("attribute");
            this.fChildSymbol = this.fStringPool.addSymbol("child");
            this.fDescendantSymbol = this.fStringPool.addSymbol("descendant");
            this.fDescendantOrSelfSymbol = this.fStringPool.addSymbol("descendant-or-self");
            this.fFollowingSymbol = this.fStringPool.addSymbol("following");
            this.fFollowingSiblingSymbol = this.fStringPool.addSymbol("following-sibling");
            this.fNamespaceSymbol = this.fStringPool.addSymbol("namespace");
            this.fParentSymbol = this.fStringPool.addSymbol("parent");
            this.fPrecedingSymbol = this.fStringPool.addSymbol("preceding");
            this.fPrecedingSiblingSymbol = this.fStringPool.addSymbol("preceding-sibling");
            this.fSelfSymbol = this.fStringPool.addSymbol("self");
        }

        public boolean scanExpr(StringPool stringPool, Tokens tokens, String data, int currentOffset, int endOffset) throws XPathException {
            boolean starIsMultiplyOperator = false;
            while (currentOffset != endOffset) {
                int ch = data.charAt(currentOffset);
                while (ch == 32 || ch == 10 || ch == 9 || ch == 13) {
                    if (++currentOffset == endOffset) break;
                    ch = data.charAt(currentOffset);
                }
                if (currentOffset == endOffset) break;
                int chartype = ch >= 128 ? 25 : fASCIICharMap[ch];
                switch (chartype) {
                    case 6: {
                        this.addToken(tokens, 0);
                        starIsMultiplyOperator = false;
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 7: {
                        this.addToken(tokens, 1);
                        starIsMultiplyOperator = true;
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 21: {
                        this.addToken(tokens, 2);
                        starIsMultiplyOperator = false;
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 22: {
                        this.addToken(tokens, 3);
                        starIsMultiplyOperator = true;
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 12: {
                        if (currentOffset + 1 == endOffset) {
                            this.addToken(tokens, 4);
                            starIsMultiplyOperator = true;
                            ++currentOffset;
                            break;
                        }
                        ch = data.charAt(currentOffset + 1);
                        if (ch == 46) {
                            this.addToken(tokens, 5);
                            starIsMultiplyOperator = true;
                            currentOffset += 2;
                        } else if (ch >= 48 && ch <= 57) {
                            this.addToken(tokens, 47);
                            starIsMultiplyOperator = true;
                            currentOffset = this.scanNumber(tokens, data, endOffset, currentOffset);
                        } else if (ch == 47) {
                            this.addToken(tokens, 4);
                            starIsMultiplyOperator = true;
                            ++currentOffset;
                        } else {
                            throw new XPathException("Invalid character following '.'");
                        }
                        if (currentOffset != endOffset) break;
                        break;
                    }
                    case 19: {
                        this.addToken(tokens, 6);
                        starIsMultiplyOperator = false;
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 10: {
                        this.addToken(tokens, 7);
                        starIsMultiplyOperator = false;
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 15: {
                        if (++currentOffset == endOffset) {
                            return false;
                        }
                        ch = data.charAt(currentOffset);
                        if (ch != 58) {
                            return false;
                        }
                        this.addToken(tokens, 8);
                        starIsMultiplyOperator = false;
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 13: {
                        if (++currentOffset == endOffset) {
                            this.addToken(tokens, 21);
                            starIsMultiplyOperator = false;
                            break;
                        }
                        ch = data.charAt(currentOffset);
                        if (ch == 47) {
                            this.addToken(tokens, 22);
                            starIsMultiplyOperator = false;
                            if (++currentOffset != endOffset) break;
                            break;
                        }
                        this.addToken(tokens, 21);
                        starIsMultiplyOperator = false;
                        break;
                    }
                    case 24: {
                        this.addToken(tokens, 23);
                        starIsMultiplyOperator = false;
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 9: {
                        this.addToken(tokens, 24);
                        starIsMultiplyOperator = false;
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 11: {
                        this.addToken(tokens, 25);
                        starIsMultiplyOperator = false;
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 17: {
                        this.addToken(tokens, 26);
                        starIsMultiplyOperator = false;
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 3: {
                        if (++currentOffset == endOffset) {
                            return false;
                        }
                        ch = data.charAt(currentOffset);
                        if (ch != 61) {
                            return false;
                        }
                        this.addToken(tokens, 27);
                        starIsMultiplyOperator = false;
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 16: {
                        if (++currentOffset == endOffset) {
                            this.addToken(tokens, 28);
                            starIsMultiplyOperator = false;
                            break;
                        }
                        ch = data.charAt(currentOffset);
                        if (ch == 61) {
                            this.addToken(tokens, 29);
                            starIsMultiplyOperator = false;
                            if (++currentOffset != endOffset) break;
                            break;
                        }
                        this.addToken(tokens, 28);
                        starIsMultiplyOperator = false;
                        break;
                    }
                    case 18: {
                        if (++currentOffset == endOffset) {
                            this.addToken(tokens, 30);
                            starIsMultiplyOperator = false;
                            break;
                        }
                        ch = data.charAt(currentOffset);
                        if (ch == 61) {
                            this.addToken(tokens, 31);
                            starIsMultiplyOperator = false;
                            if (++currentOffset != endOffset) break;
                            break;
                        }
                        this.addToken(tokens, 30);
                        starIsMultiplyOperator = false;
                        break;
                    }
                    case 4: {
                        int qchar = ch;
                        if (++currentOffset == endOffset) {
                            return false;
                        }
                        ch = data.charAt(currentOffset);
                        int litOffset = currentOffset;
                        while (ch != qchar) {
                            if (++currentOffset == endOffset) {
                                return false;
                            }
                            ch = data.charAt(currentOffset);
                        }
                        int litLength = currentOffset - litOffset;
                        this.addToken(tokens, 46);
                        starIsMultiplyOperator = true;
                        tokens.addToken(stringPool.addSymbol(data.substring(litOffset, litOffset + litLength)));
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 14: {
                        this.addToken(tokens, 47);
                        starIsMultiplyOperator = true;
                        currentOffset = this.scanNumber(tokens, data, endOffset, currentOffset);
                        break;
                    }
                    case 5: {
                        int prefixHandle;
                        if (++currentOffset == endOffset) {
                            return false;
                        }
                        int nameOffset = currentOffset;
                        if ((currentOffset = this.scanNCName(data, endOffset, currentOffset)) == nameOffset) {
                            return false;
                        }
                        ch = currentOffset < endOffset ? (int)data.charAt(currentOffset) : -1;
                        int nameHandle = stringPool.addSymbol(data.substring(nameOffset, currentOffset));
                        if (ch != 58) {
                            prefixHandle = -1;
                        } else {
                            prefixHandle = nameHandle;
                            if (++currentOffset == endOffset) {
                                return false;
                            }
                            nameOffset = currentOffset;
                            if ((currentOffset = this.scanNCName(data, endOffset, currentOffset)) == nameOffset) {
                                return false;
                            }
                            ch = currentOffset < endOffset ? (int)data.charAt(currentOffset) : -1;
                            nameHandle = stringPool.addSymbol(data.substring(nameOffset, currentOffset));
                        }
                        this.addToken(tokens, 48);
                        starIsMultiplyOperator = true;
                        tokens.addToken(prefixHandle);
                        tokens.addToken(nameHandle);
                        break;
                    }
                    case 8: {
                        if (starIsMultiplyOperator) {
                            this.addToken(tokens, 20);
                            starIsMultiplyOperator = false;
                        } else {
                            this.addToken(tokens, 9);
                            starIsMultiplyOperator = true;
                        }
                        if (++currentOffset != endOffset) break;
                        break;
                    }
                    case 20: 
                    case 23: 
                    case 25: {
                        int nameOffset = currentOffset;
                        currentOffset = this.scanNCName(data, endOffset, currentOffset);
                        if (currentOffset == nameOffset) {
                            return false;
                        }
                        ch = currentOffset < endOffset ? (int)data.charAt(currentOffset) : -1;
                        int nameHandle = stringPool.addSymbol(data.substring(nameOffset, currentOffset));
                        boolean isNameTestNCName = false;
                        boolean isAxisName = false;
                        int prefixHandle = -1;
                        if (ch == 58) {
                            if (++currentOffset == endOffset) {
                                return false;
                            }
                            ch = data.charAt(currentOffset);
                            if (ch == 42) {
                                if (++currentOffset < endOffset) {
                                    ch = data.charAt(currentOffset);
                                }
                                isNameTestNCName = true;
                            } else if (ch == 58) {
                                if (++currentOffset < endOffset) {
                                    ch = data.charAt(currentOffset);
                                }
                                isAxisName = true;
                            } else {
                                prefixHandle = nameHandle;
                                nameOffset = currentOffset;
                                if ((currentOffset = this.scanNCName(data, endOffset, currentOffset)) == nameOffset) {
                                    return false;
                                }
                                ch = currentOffset < endOffset ? (int)data.charAt(currentOffset) : -1;
                                nameHandle = stringPool.addSymbol(data.substring(nameOffset, currentOffset));
                            }
                        }
                        while (ch == 32 || ch == 10 || ch == 9 || ch == 13) {
                            if (++currentOffset == endOffset) break;
                            ch = data.charAt(currentOffset);
                        }
                        if (starIsMultiplyOperator) {
                            if (nameHandle == this.fAndSymbol) {
                                this.addToken(tokens, 16);
                                starIsMultiplyOperator = false;
                            } else if (nameHandle == this.fOrSymbol) {
                                this.addToken(tokens, 17);
                                starIsMultiplyOperator = false;
                            } else if (nameHandle == this.fModSymbol) {
                                this.addToken(tokens, 18);
                                starIsMultiplyOperator = false;
                            } else if (nameHandle == this.fDivSymbol) {
                                this.addToken(tokens, 19);
                                starIsMultiplyOperator = false;
                            } else {
                                return false;
                            }
                            if (isNameTestNCName) {
                                return false;
                            }
                            if (!isAxisName) break;
                            return false;
                        }
                        if (ch == 40 && !isNameTestNCName && !isAxisName) {
                            if (nameHandle == this.fCommentSymbol) {
                                this.addToken(tokens, 12);
                            } else if (nameHandle == this.fTextSymbol) {
                                this.addToken(tokens, 13);
                            } else if (nameHandle == this.fPISymbol) {
                                this.addToken(tokens, 14);
                            } else if (nameHandle == this.fNodeSymbol) {
                                this.addToken(tokens, 15);
                            } else {
                                this.addToken(tokens, 32);
                                tokens.addToken(prefixHandle);
                                tokens.addToken(nameHandle);
                            }
                            this.addToken(tokens, 0);
                            starIsMultiplyOperator = false;
                            if (++currentOffset != endOffset) break;
                            break;
                        }
                        if (isAxisName || ch == 58 && currentOffset + 1 < endOffset && data.charAt(currentOffset + 1) == ':') {
                            if (nameHandle == this.fAncestorSymbol) {
                                this.addToken(tokens, 33);
                            } else if (nameHandle == this.fAncestorOrSelfSymbol) {
                                this.addToken(tokens, 34);
                            } else if (nameHandle == this.fAttributeSymbol) {
                                this.addToken(tokens, 35);
                            } else if (nameHandle == this.fChildSymbol) {
                                this.addToken(tokens, 36);
                            } else if (nameHandle == this.fDescendantSymbol) {
                                this.addToken(tokens, 37);
                            } else if (nameHandle == this.fDescendantOrSelfSymbol) {
                                this.addToken(tokens, 38);
                            } else if (nameHandle == this.fFollowingSymbol) {
                                this.addToken(tokens, 39);
                            } else if (nameHandle == this.fFollowingSiblingSymbol) {
                                this.addToken(tokens, 40);
                            } else if (nameHandle == this.fNamespaceSymbol) {
                                this.addToken(tokens, 41);
                            } else if (nameHandle == this.fParentSymbol) {
                                this.addToken(tokens, 42);
                            } else if (nameHandle == this.fPrecedingSymbol) {
                                this.addToken(tokens, 43);
                            } else if (nameHandle == this.fPrecedingSiblingSymbol) {
                                this.addToken(tokens, 44);
                            } else if (nameHandle == this.fSelfSymbol) {
                                this.addToken(tokens, 45);
                            } else {
                                return false;
                            }
                            if (isNameTestNCName) {
                                return false;
                            }
                            this.addToken(tokens, 8);
                            starIsMultiplyOperator = false;
                            if (isAxisName) break;
                            ++currentOffset;
                            if (++currentOffset != endOffset) break;
                            break;
                        }
                        if (isNameTestNCName) {
                            this.addToken(tokens, 10);
                            starIsMultiplyOperator = true;
                            tokens.addToken(nameHandle);
                            break;
                        }
                        this.addToken(tokens, 11);
                        starIsMultiplyOperator = true;
                        tokens.addToken(prefixHandle);
                        tokens.addToken(nameHandle);
                    }
                }
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        int scanNCName(String data, int endOffset, int currentOffset) {
            ch = data.charAt(currentOffset);
            if (!(ch >= '\u0080' ? (XMLCharacterProperties.fgCharFlags[ch] & 2) == 0 : (chartype = Scanner.fASCIICharMap[ch]) != 20 && chartype != 23)) ** GOTO lbl-1000
            return currentOffset;
            while (!((ch = data.charAt(currentOffset)) < '\u0080' ? (chartype = Scanner.fASCIICharMap[ch]) != 20 && chartype != 14 && chartype != 12 && chartype != 11 && chartype != 23 : (XMLCharacterProperties.fgCharFlags[ch] & 4) == 0)) lbl-1000:
            // 2 sources

            {
                if (++currentOffset < endOffset) continue;
            }
            return currentOffset;
        }

        private int scanNumber(Tokens tokens, String data, int endOffset, int currentOffset) {
            char ch = data.charAt(currentOffset);
            int whole = 0;
            int part = 0;
            while (ch >= '0' && ch <= '9') {
                whole = whole * 10 + (ch - 48);
                if (++currentOffset == endOffset) break;
                ch = data.charAt(currentOffset);
            }
            if (ch == '.' && ++currentOffset < endOffset) {
                int start = currentOffset;
                ch = data.charAt(currentOffset);
                while (ch >= '0' && ch <= '9') {
                    part = part * 10 + (ch - 48);
                    if (++currentOffset == endOffset) break;
                    ch = data.charAt(currentOffset);
                }
                if (part != 0) {
                    throw new RuntimeException("find a solution!");
                }
            }
            tokens.addToken(whole);
            tokens.addToken(part);
            return currentOffset;
        }

        protected void addToken(Tokens tokens, int token) throws XPathException {
            tokens.addToken(token);
        }
    }

    public static class Step
    implements Cloneable {
        public Axis axis;
        public NodeTest nodeTest;

        public Step(Axis axis, NodeTest nodeTest) {
            this.axis = axis;
            this.nodeTest = nodeTest;
        }

        protected Step(Step step) {
            this.axis = (Axis)step.axis.clone();
            this.nodeTest = (NodeTest)step.nodeTest.clone();
        }

        public String toString() {
            if (this.axis.type == 3) {
                return ".";
            }
            if (this.axis.type == 2) {
                return "@" + this.nodeTest.toString();
            }
            if (this.axis.type == 1) {
                return this.nodeTest.toString();
            }
            if (this.axis.type == 4) {
                return "//";
            }
            return "??? (" + this.axis.type + ')';
        }

        public Object clone() {
            return new Step(this);
        }
    }

    private static final class Tokens {
        static final boolean DUMP_TOKENS = false;
        public static final int EXPRTOKEN_OPEN_PAREN = 0;
        public static final int EXPRTOKEN_CLOSE_PAREN = 1;
        public static final int EXPRTOKEN_OPEN_BRACKET = 2;
        public static final int EXPRTOKEN_CLOSE_BRACKET = 3;
        public static final int EXPRTOKEN_PERIOD = 4;
        public static final int EXPRTOKEN_DOUBLE_PERIOD = 5;
        public static final int EXPRTOKEN_ATSIGN = 6;
        public static final int EXPRTOKEN_COMMA = 7;
        public static final int EXPRTOKEN_DOUBLE_COLON = 8;
        public static final int EXPRTOKEN_NAMETEST_ANY = 9;
        public static final int EXPRTOKEN_NAMETEST_NAMESPACE = 10;
        public static final int EXPRTOKEN_NAMETEST_QNAME = 11;
        public static final int EXPRTOKEN_NODETYPE_COMMENT = 12;
        public static final int EXPRTOKEN_NODETYPE_TEXT = 13;
        public static final int EXPRTOKEN_NODETYPE_PI = 14;
        public static final int EXPRTOKEN_NODETYPE_NODE = 15;
        public static final int EXPRTOKEN_OPERATOR_AND = 16;
        public static final int EXPRTOKEN_OPERATOR_OR = 17;
        public static final int EXPRTOKEN_OPERATOR_MOD = 18;
        public static final int EXPRTOKEN_OPERATOR_DIV = 19;
        public static final int EXPRTOKEN_OPERATOR_MULT = 20;
        public static final int EXPRTOKEN_OPERATOR_SLASH = 21;
        public static final int EXPRTOKEN_OPERATOR_DOUBLE_SLASH = 22;
        public static final int EXPRTOKEN_OPERATOR_UNION = 23;
        public static final int EXPRTOKEN_OPERATOR_PLUS = 24;
        public static final int EXPRTOKEN_OPERATOR_MINUS = 25;
        public static final int EXPRTOKEN_OPERATOR_EQUAL = 26;
        public static final int EXPRTOKEN_OPERATOR_NOT_EQUAL = 27;
        public static final int EXPRTOKEN_OPERATOR_LESS = 28;
        public static final int EXPRTOKEN_OPERATOR_LESS_EQUAL = 29;
        public static final int EXPRTOKEN_OPERATOR_GREATER = 30;
        public static final int EXPRTOKEN_OPERATOR_GREATER_EQUAL = 31;
        public static final int EXPRTOKEN_FUNCTION_NAME = 32;
        public static final int EXPRTOKEN_AXISNAME_ANCESTOR = 33;
        public static final int EXPRTOKEN_AXISNAME_ANCESTOR_OR_SELF = 34;
        public static final int EXPRTOKEN_AXISNAME_ATTRIBUTE = 35;
        public static final int EXPRTOKEN_AXISNAME_CHILD = 36;
        public static final int EXPRTOKEN_AXISNAME_DESCENDANT = 37;
        public static final int EXPRTOKEN_AXISNAME_DESCENDANT_OR_SELF = 38;
        public static final int EXPRTOKEN_AXISNAME_FOLLOWING = 39;
        public static final int EXPRTOKEN_AXISNAME_FOLLOWING_SIBLING = 40;
        public static final int EXPRTOKEN_AXISNAME_NAMESPACE = 41;
        public static final int EXPRTOKEN_AXISNAME_PARENT = 42;
        public static final int EXPRTOKEN_AXISNAME_PRECEDING = 43;
        public static final int EXPRTOKEN_AXISNAME_PRECEDING_SIBLING = 44;
        public static final int EXPRTOKEN_AXISNAME_SELF = 45;
        public static final int EXPRTOKEN_LITERAL = 46;
        public static final int EXPRTOKEN_NUMBER = 47;
        public static final int EXPRTOKEN_VARIABLE_REFERENCE = 48;
        public static final String[] fgTokenNames = new String[]{"EXPRTOKEN_OPEN_PAREN", "EXPRTOKEN_CLOSE_PAREN", "EXPRTOKEN_OPEN_BRACKET", "EXPRTOKEN_CLOSE_BRACKET", "EXPRTOKEN_PERIOD", "EXPRTOKEN_DOUBLE_PERIOD", "EXPRTOKEN_ATSIGN", "EXPRTOKEN_COMMA", "EXPRTOKEN_DOUBLE_COLON", "EXPRTOKEN_NAMETEST_ANY", "EXPRTOKEN_NAMETEST_NAMESPACE", "EXPRTOKEN_NAMETEST_QNAME", "EXPRTOKEN_NODETYPE_COMMENT", "EXPRTOKEN_NODETYPE_TEXT", "EXPRTOKEN_NODETYPE_PI", "EXPRTOKEN_NODETYPE_NODE", "EXPRTOKEN_OPERATOR_AND", "EXPRTOKEN_OPERATOR_OR", "EXPRTOKEN_OPERATOR_MOD", "EXPRTOKEN_OPERATOR_DIV", "EXPRTOKEN_OPERATOR_MULT", "EXPRTOKEN_OPERATOR_SLASH", "EXPRTOKEN_OPERATOR_DOUBLE_SLASH", "EXPRTOKEN_OPERATOR_UNION", "EXPRTOKEN_OPERATOR_PLUS", "EXPRTOKEN_OPERATOR_MINUS", "EXPRTOKEN_OPERATOR_EQUAL", "EXPRTOKEN_OPERATOR_NOT_EQUAL", "EXPRTOKEN_OPERATOR_LESS", "EXPRTOKEN_OPERATOR_LESS_EQUAL", "EXPRTOKEN_OPERATOR_GREATER", "EXPRTOKEN_OPERATOR_GREATER_EQUAL", "EXPRTOKEN_FUNCTION_NAME", "EXPRTOKEN_AXISNAME_ANCESTOR", "EXPRTOKEN_AXISNAME_ANCESTOR_OR_SELF", "EXPRTOKEN_AXISNAME_ATTRIBUTE", "EXPRTOKEN_AXISNAME_CHILD", "EXPRTOKEN_AXISNAME_DESCENDANT", "EXPRTOKEN_AXISNAME_DESCENDANT_OR_SELF", "EXPRTOKEN_AXISNAME_FOLLOWING", "EXPRTOKEN_AXISNAME_FOLLOWING_SIBLING", "EXPRTOKEN_AXISNAME_NAMESPACE", "EXPRTOKEN_AXISNAME_PARENT", "EXPRTOKEN_AXISNAME_PRECEDING", "EXPRTOKEN_AXISNAME_PRECEDING_SIBLING", "EXPRTOKEN_AXISNAME_SELF", "EXPRTOKEN_LITERAL", "EXPRTOKEN_NUMBER", "EXPRTOKEN_VARIABLE_REFERENCE"};
        private static final int INITIAL_TOKEN_COUNT = 256;
        private int[] fTokens = new int[256];
        private int fTokenCount = 0;
        private StringPool fStringPool;

        public Tokens(StringPool stringPool) {
            this.fStringPool = stringPool;
        }

        public String getTokenName(int token) {
            if (token < 0 || token >= fgTokenNames.length) {
                return null;
            }
            return fgTokenNames[token];
        }

        public int getTokenString(int token) {
            return token;
        }

        public void addToken(int token) {
            try {
                this.fTokens[this.fTokenCount] = token;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                int[] oldList = this.fTokens;
                this.fTokens = new int[this.fTokenCount << 1];
                System.arraycopy(oldList, 0, this.fTokens, 0, this.fTokenCount);
                this.fTokens[this.fTokenCount] = token;
            }
            ++this.fTokenCount;
        }

        public int getTokenCount() {
            return this.fTokenCount;
        }

        public int getToken(int tokenIndex) {
            return this.fTokens[tokenIndex];
        }

        public void dumpTokens() {
            int i = 0;
            while (i < this.fTokenCount) {
                switch (this.fTokens[i]) {
                    case 0: {
                        System.out.print("<OPEN_PAREN/>");
                        break;
                    }
                    case 1: {
                        System.out.print("<CLOSE_PAREN/>");
                        break;
                    }
                    case 2: {
                        System.out.print("<OPEN_BRACKET/>");
                        break;
                    }
                    case 3: {
                        System.out.print("<CLOSE_BRACKET/>");
                        break;
                    }
                    case 4: {
                        System.out.print("<PERIOD/>");
                        break;
                    }
                    case 5: {
                        System.out.print("<DOUBLE_PERIOD/>");
                        break;
                    }
                    case 6: {
                        System.out.print("<ATSIGN/>");
                        break;
                    }
                    case 7: {
                        System.out.print("<COMMA/>");
                        break;
                    }
                    case 8: {
                        System.out.print("<DOUBLE_COLON/>");
                        break;
                    }
                    case 9: {
                        System.out.print("<NAMETEST_ANY/>");
                        break;
                    }
                    case 10: {
                        System.out.print("<NAMETEST_NAMESPACE");
                        System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[++i]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case 11: {
                        System.out.print("<NAMETEST_QNAME");
                        if (this.fTokens[++i] != -1) {
                            System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[i]) + "\"");
                        }
                        System.out.print(" localpart=\"" + this.getTokenString(this.fTokens[++i]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case 12: {
                        System.out.print("<NODETYPE_COMMENT/>");
                        break;
                    }
                    case 13: {
                        System.out.print("<NODETYPE_TEXT/>");
                        break;
                    }
                    case 14: {
                        System.out.print("<NODETYPE_PI/>");
                        break;
                    }
                    case 15: {
                        System.out.print("<NODETYPE_NODE/>");
                        break;
                    }
                    case 16: {
                        System.out.print("<OPERATOR_AND/>");
                        break;
                    }
                    case 17: {
                        System.out.print("<OPERATOR_OR/>");
                        break;
                    }
                    case 18: {
                        System.out.print("<OPERATOR_MOD/>");
                        break;
                    }
                    case 19: {
                        System.out.print("<OPERATOR_DIV/>");
                        break;
                    }
                    case 20: {
                        System.out.print("<OPERATOR_MULT/>");
                        break;
                    }
                    case 21: {
                        System.out.print("<OPERATOR_SLASH/>");
                        if (i + 1 >= this.fTokenCount) break;
                        System.out.println();
                        System.out.print("  ");
                        break;
                    }
                    case 22: {
                        System.out.print("<OPERATOR_DOUBLE_SLASH/>");
                        break;
                    }
                    case 23: {
                        System.out.print("<OPERATOR_UNION/>");
                        break;
                    }
                    case 24: {
                        System.out.print("<OPERATOR_PLUS/>");
                        break;
                    }
                    case 25: {
                        System.out.print("<OPERATOR_MINUS/>");
                        break;
                    }
                    case 26: {
                        System.out.print("<OPERATOR_EQUAL/>");
                        break;
                    }
                    case 27: {
                        System.out.print("<OPERATOR_NOT_EQUAL/>");
                        break;
                    }
                    case 28: {
                        System.out.print("<OPERATOR_LESS/>");
                        break;
                    }
                    case 29: {
                        System.out.print("<OPERATOR_LESS_EQUAL/>");
                        break;
                    }
                    case 30: {
                        System.out.print("<OPERATOR_GREATER/>");
                        break;
                    }
                    case 31: {
                        System.out.print("<OPERATOR_GREATER_EQUAL/>");
                        break;
                    }
                    case 32: {
                        System.out.print("<FUNCTION_NAME");
                        if (this.fTokens[++i] != -1) {
                            System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[i]) + "\"");
                        }
                        System.out.print(" localpart=\"" + this.getTokenString(this.fTokens[++i]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case 33: {
                        System.out.print("<AXISNAME_ANCESTOR/>");
                        break;
                    }
                    case 34: {
                        System.out.print("<AXISNAME_ANCESTOR_OR_SELF/>");
                        break;
                    }
                    case 35: {
                        System.out.print("<AXISNAME_ATTRIBUTE/>");
                        break;
                    }
                    case 36: {
                        System.out.print("<AXISNAME_CHILD/>");
                        break;
                    }
                    case 37: {
                        System.out.print("<AXISNAME_DESCENDANT/>");
                        break;
                    }
                    case 38: {
                        System.out.print("<AXISNAME_DESCENDANT_OR_SELF/>");
                        break;
                    }
                    case 39: {
                        System.out.print("<AXISNAME_FOLLOWING/>");
                        break;
                    }
                    case 40: {
                        System.out.print("<AXISNAME_FOLLOWING_SIBLING/>");
                        break;
                    }
                    case 41: {
                        System.out.print("<AXISNAME_NAMESPACE/>");
                        break;
                    }
                    case 42: {
                        System.out.print("<AXISNAME_PARENT/>");
                        break;
                    }
                    case 43: {
                        System.out.print("<AXISNAME_PRECEDING/>");
                        break;
                    }
                    case 44: {
                        System.out.print("<AXISNAME_PRECEDING_SIBLING/>");
                        break;
                    }
                    case 45: {
                        System.out.print("<AXISNAME_SELF/>");
                        break;
                    }
                    case 46: {
                        System.out.print("<LITERAL");
                        System.out.print(" value=\"" + this.getTokenString(this.fTokens[++i]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case 47: {
                        System.out.print("<NUMBER");
                        System.out.print(" whole=\"" + this.getTokenString(this.fTokens[++i]) + "\"");
                        System.out.print(" part=\"" + this.getTokenString(this.fTokens[++i]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    case 48: {
                        System.out.print("<VARIABLE_REFERENCE");
                        if (this.fTokens[++i] != -1) {
                            System.out.print(" prefix=\"" + this.getTokenString(this.fTokens[i]) + "\"");
                        }
                        System.out.print(" localpart=\"" + this.getTokenString(this.fTokens[++i]) + "\"");
                        System.out.print("/>");
                        break;
                    }
                    default: {
                        System.out.println("<???/>");
                    }
                }
                ++i;
            }
            System.out.println();
        }
    }
}

