/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.utils.IntStack;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.XPath;

public class XPathMatcher {
    protected static final boolean DEBUG_ALL = false;
    protected static final boolean DEBUG_METHODS = false;
    protected static final boolean DEBUG_METHODS2 = false;
    protected static final boolean DEBUG_METHODS3 = false;
    protected static final boolean DEBUG_MATCH = false;
    protected static final boolean DEBUG_STACK = false;
    protected static final boolean DEBUG_ANY = false;
    private XPath.LocationPath[] fLocationPaths;
    private boolean fShouldBufferContent;
    private boolean fBufferContent;
    private StringBuffer fMatchedBuffer = new StringBuffer();
    private boolean[] fMatched;
    private String fMatchedString;
    private IntStack[] fStepIndexes;
    private int[] fCurrentStep;
    private int[] fNoMatchDepth;
    protected StringPool fStringPool;
    protected NamespacesScope fNamespacesScope;
    protected IdentityConstraint fIDConstraint;

    public XPathMatcher(XPath xpath) {
        this(xpath, false, null);
    }

    public XPathMatcher(XPath xpath, boolean shouldBufferContent, IdentityConstraint idConstraint) {
        this.fLocationPaths = xpath.getLocationPaths();
        this.fShouldBufferContent = shouldBufferContent;
        this.fIDConstraint = idConstraint;
        this.fStepIndexes = new IntStack[this.fLocationPaths.length];
        int i = 0;
        while (i < this.fStepIndexes.length) {
            this.fStepIndexes[i] = new IntStack();
            ++i;
        }
        this.fCurrentStep = new int[this.fLocationPaths.length];
        this.fNoMatchDepth = new int[this.fLocationPaths.length];
        this.fMatched = new boolean[this.fLocationPaths.length];
    }

    public boolean isMatched() {
        int i = 0;
        while (i < this.fLocationPaths.length) {
            if (this.fMatched[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean getIsSelector() {
        return this.fIDConstraint == null;
    }

    public IdentityConstraint getIDConstraint() {
        return this.fIDConstraint;
    }

    public String getMatchedString() {
        return this.fMatchedString;
    }

    protected void matched(String content, DatatypeValidator val, boolean isNil) throws Exception {
    }

    public void startDocumentFragment(StringPool stringPool) throws Exception {
        this.clear();
        int i = 0;
        while (i < this.fLocationPaths.length) {
            this.fStepIndexes[i].clear();
            this.fCurrentStep[i] = 0;
            this.fNoMatchDepth[i] = 0;
            this.fMatched[i] = false;
            ++i;
        }
        this.fStringPool = stringPool;
    }

    /*
     * Unable to fully structure code
     */
    public void startElement(QName element, XMLAttrList attributes, int handle, int eIndex, SchemaGrammar grammar) throws Exception {
        i = 0;
        while (i < this.fLocationPaths.length) {
            block22: {
                block24: {
                    block23: {
                        block21: {
                            startStep = this.fCurrentStep[i];
                            this.fStepIndexes[i].push(startStep);
                            if (!this.fMatched[i] && this.fNoMatchDepth[i] <= 0) break block21;
                            v0 = i;
                            this.fNoMatchDepth[v0] = this.fNoMatchDepth[v0] + 1;
                            break block22;
                        }
                        steps = this.fLocationPaths[i].steps;
                        while (this.fCurrentStep[i] < steps.length && steps[this.fCurrentStep[i]].axis.type == 3) {
                            v1 = i;
                            this.fCurrentStep[v1] = this.fCurrentStep[v1] + 1;
                        }
                        if (this.fCurrentStep[i] != steps.length) break block23;
                        this.fMatched[i] = true;
                        j = 0;
                        while (j < i && !this.fMatched[j]) {
                            ++j;
                        }
                        if (j == i) {
                            this.fBufferContent = this.fShouldBufferContent;
                        }
                        break block22;
                    }
                    descendantStep = this.fCurrentStep[i];
                    while (this.fCurrentStep[i] < steps.length && steps[this.fCurrentStep[i]].axis.type == 4) {
                        v2 = i;
                        this.fCurrentStep[v2] = this.fCurrentStep[v2] + 1;
                    }
                    if (this.fCurrentStep[i] != steps.length) break block24;
                    v3 = i;
                    this.fNoMatchDepth[v3] = this.fNoMatchDepth[v3] + 1;
                    break block22;
                }
                if (this.fCurrentStep[i] != startStep && this.fCurrentStep[i] <= descendantStep || steps[this.fCurrentStep[i]].axis.type != 1) ** GOTO lbl47
                step = steps[this.fCurrentStep[i]];
                nodeTest = step.nodeTest;
                if (nodeTest.type == 1 && !nodeTest.name.equals(element)) {
                    if (this.fCurrentStep[i] > descendantStep) {
                        this.fCurrentStep[i] = descendantStep;
                    } else {
                        v4 = i;
                        this.fNoMatchDepth[v4] = this.fNoMatchDepth[v4] + 1;
                    }
                } else {
                    v5 = i;
                    this.fCurrentStep[v5] = this.fCurrentStep[v5] + 1;
lbl47:
                    // 2 sources

                    if (this.fCurrentStep[i] == steps.length) {
                        this.fMatched[i] = true;
                        j = 0;
                        while (j < i && !this.fMatched[j]) {
                            ++j;
                        }
                        if (j == i) {
                            this.fBufferContent = this.fShouldBufferContent;
                        }
                    } else if (this.fCurrentStep[i] < steps.length && steps[this.fCurrentStep[i]].axis.type == 2) {
                        aindex = attributes.getFirstAttr(handle);
                        if (aindex != -1) {
                            nodeTest = steps[this.fCurrentStep[i]].nodeTest;
                            aname = new QName();
                            while (aindex != -1) {
                                aprefix = attributes.getAttrPrefix(aindex);
                                alocalpart = attributes.getAttrLocalpart(aindex);
                                arawname = attributes.getAttrName(aindex);
                                auri = attributes.getAttrURI(aindex);
                                aname.setValues(aprefix, alocalpart, arawname, auri);
                                if (nodeTest.type != 1 || nodeTest.name.equals(aname)) {
                                    v6 = i;
                                    this.fCurrentStep[v6] = this.fCurrentStep[v6] + 1;
                                    if (this.fCurrentStep[i] != steps.length) break;
                                    this.fMatched[i] = true;
                                    j = 0;
                                    while (j < i && !this.fMatched[j]) {
                                        ++j;
                                    }
                                    if (j != i) break;
                                    avalue = attributes.getAttValue(aindex);
                                    this.fMatchedString = this.fStringPool.toString(avalue);
                                    attIndex = grammar.getAttributeDeclIndex(eIndex, aname);
                                    tempAttDecl = new XMLAttributeDecl();
                                    grammar.getAttributeDecl(attIndex, tempAttDecl);
                                    aValidator = tempAttDecl.datatypeValidator;
                                    this.matched(this.fMatchedString, aValidator, false);
                                    break;
                                }
                                aindex = attributes.getNextAttr(aindex);
                            }
                        }
                        if (!this.fMatched[i]) {
                            if (this.fCurrentStep[i] > descendantStep) {
                                this.fCurrentStep[i] = descendantStep;
                            } else {
                                v7 = i;
                                this.fNoMatchDepth[v7] = this.fNoMatchDepth[v7] + 1;
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void characters(char[] ch, int offset, int length) throws Exception {
        int i = 0;
        while (i < this.fLocationPaths.length) {
            if (this.fBufferContent && this.fNoMatchDepth[i] == 0) {
                this.fMatchedBuffer.append(ch, offset, length);
                break;
            }
            ++i;
        }
    }

    public void endElement(QName element, int eIndex, SchemaGrammar grammar) throws Exception {
        int i = 0;
        while (i < this.fLocationPaths.length) {
            block10: {
                block9: {
                    block8: {
                        if (this.fNoMatchDepth[i] <= 0) break block8;
                        int n = i;
                        this.fNoMatchDepth[n] = this.fNoMatchDepth[n] - 1;
                        break block9;
                    }
                    int j = 0;
                    while (j < i && !this.fMatched[j]) {
                        ++j;
                    }
                    if (j < i) break block10;
                    if (this.fBufferContent) {
                        this.fBufferContent = false;
                        this.fMatchedString = this.fMatchedBuffer.toString();
                        XMLElementDecl temp = new XMLElementDecl();
                        grammar.getElementDecl(eIndex, temp);
                        DatatypeValidator val = temp.datatypeValidator;
                        if (temp != null) {
                            this.matched(this.fMatchedString, val, (grammar.getElementDeclMiscFlags(eIndex) & 1) != 0);
                        } else {
                            this.matched(this.fMatchedString, null, false);
                        }
                    }
                    this.clear();
                }
                this.fCurrentStep[i] = this.fStepIndexes[i].pop();
            }
            ++i;
        }
    }

    public void endDocumentFragment() throws Exception {
        this.clear();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        String s = super.toString();
        int index2 = s.lastIndexOf(46);
        if (index2 != -1) {
            s = s.substring(index2 + 1);
        }
        str.append(s);
        int i = 0;
        while (i < this.fLocationPaths.length) {
            str.append('[');
            XPath.Step[] steps = this.fLocationPaths[i].steps;
            int j = 0;
            while (j < steps.length) {
                if (j == this.fCurrentStep[i]) {
                    str.append('^');
                }
                str.append(steps[i].toString());
                if (j < steps.length - 1) {
                    str.append('/');
                }
                ++j;
            }
            if (this.fCurrentStep[i] == steps.length) {
                str.append('^');
            }
            str.append(']');
            str.append(',');
            ++i;
        }
        return str.toString();
    }

    private void clear() {
        this.fBufferContent = false;
        this.fMatchedBuffer.setLength(0);
        this.fMatchedString = null;
        int i = 0;
        while (i < this.fLocationPaths.length) {
            this.fMatched[i] = false;
            ++i;
        }
    }

    private String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    str.append("\\n");
                    break;
                }
                default: {
                    str.append(c);
                }
            }
            ++i;
        }
        return str.toString();
    }
}

