/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import mx.viewer.gui.MainContainer;
import mx.viewer.gui.ToolBar;
import mx.viewer.gui.ToolBarButton;
import mx.viewer.gui.ToolBarCombo;
import mx.viewer.manager.ViewerManager;

public class NavigationToolBar
extends ToolBar {
    private static final long serialVersionUID = 6778906408964443221L;
    private static final String FIRST = "first";
    private static final String PREVIOUS = "previous";
    private static final String NEXT = "next";
    private static final String LAST = "last";
    private static final String CBCAMBIA = "cbcambia";
    private ToolBarButton buttonFirst;
    private ToolBarButton buttonPrevious;
    private ToolBarCombo comboImages;
    private ToolBarButton buttonNext;
    private ToolBarButton buttonLast;
    private boolean visibleAuto = false;

    public NavigationToolBar(MainContainer mainContainer, ViewerManager viewerManager, String constraints, int orientation) {
        super(mainContainer, viewerManager, constraints, orientation);
    }

    protected void initialize() {
        super.initialize();
        this.toolBar.setName("Navigazione");
        this.buttonFirst = ToolBarButton.makeButton(this, "btn_First", FIRST, "Prima Pagina", "F");
        this.toolBar.add(this.buttonFirst);
        this.buttonFirst.setEnabled(false);
        this.buttonPrevious = ToolBarButton.makeButton(this, "btn_Prev", PREVIOUS, "Pagina Precedente", "P");
        this.toolBar.add(this.buttonPrevious);
        this.buttonPrevious.setEnabled(false);
        this.toolBar.addSeparator();
        this.comboImages = ToolBarCombo.makeCombo(this, CBCAMBIA);
        this.toolBar.add(this.comboImages);
        this.toolBar.addSeparator();
        this.buttonNext = ToolBarButton.makeButton(this, "btn_Next", NEXT, "Pagina Successiva", "N");
        this.toolBar.add(this.buttonNext);
        this.buttonLast = ToolBarButton.makeButton(this, "btn_Last", LAST, "Ultima Pagina", "L");
        this.toolBar.add(this.buttonLast);
        this.add((Component)this.toolBar, "Center");
    }

    public void addImage(String caption) {
        this.comboImages.addItem(ToolBarCombo.makeObj(caption));
    }

    public void setCurrentImage(int current) {
        if (!this.visibleAuto) {
            this.comboImages.setCurrent(current);
        }
        if (current == 0) {
            this.buttonFirst.setEnabled(false);
            this.buttonPrevious.setEnabled(false);
        } else {
            this.buttonFirst.setEnabled(true);
            this.buttonPrevious.setEnabled(true);
        }
        if (current == this.viewerManager.getToolBarNavigazione().imageCount() - 1) {
            this.buttonNext.setEnabled(false);
            this.buttonLast.setEnabled(false);
        } else {
            this.buttonNext.setEnabled(true);
            this.buttonLast.setEnabled(true);
        }
    }

    public void clearImgAll() {
        this.comboImages.removeAllItems();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (FIRST.equals(cmd)) {
            this.viewerManager.getToolBarNavigazione().moveFirst();
        }
        if (PREVIOUS.equals(cmd)) {
            this.viewerManager.getToolBarNavigazione().movePrevious();
        }
        if (NEXT.equals(cmd)) {
            this.viewerManager.getToolBarNavigazione().moveNext();
        }
        if (LAST.equals(cmd)) {
            this.viewerManager.getToolBarNavigazione().moveLast();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        ToolBarCombo cb = (ToolBarCombo)e.getSource();
        if (e.getStateChange() == 1) {
            this.viewerManager.getToolBarNavigazione().setCurrent(cb.getSelectedIndex());
        }
    }

    public boolean isVisibleAuto() {
        return this.visibleAuto;
    }

    public void setVisibleAuto(boolean visibleAuto) {
        this.visibleAuto = visibleAuto;
        this.comboImages.setVisible(false);
    }
}

