/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import mx.viewer.gui.MainContainer;
import mx.viewer.gui.ToolBar;
import mx.viewer.gui.ToolBarButton;
import mx.viewer.gui.ToolBarToggleButton;
import mx.viewer.manager.ViewerManager;

public class ToolToolBar
extends ToolBar {
    private static final long serialVersionUID = -4259934482258639755L;
    private static final String SAVEAS = "saveas";
    private static final String PRINT = "print";
    private static final String PRINTSEL = "printsel";
    private static final String FITWINDOW = "fitwindow";
    private static final String FITHORIZONTAL = "fithorizontal";
    private static final String FITVERTICAL = "fitvertical";
    private static final String ACTUALSIZE = "actualsize";
    private static final String ZOOMPLUS = "zoomplus";
    private static final String ZOOMMINUS = "zoomminus";
    private static final String ZOOMRECT = "zoomrect";
    private static final String INVERT = "invert";
    private static final String ROTATESX = "rotatesx";
    private static final String ROTATEDX = "rotatedx";
    private static final String CUSTOMFUNC = "customfunc";
    private ToolBarButton buttonSave;
    private ToolBarButton buttonPrint;
    private ToolBarToggleButton buttonPrintSel;
    private ToolBarButton buttonFitWindow;
    private ToolBarButton buttonFitHorizontal;
    private ToolBarButton buttonFitVertical;
    private ToolBarButton buttonActualSize;
    private ToolBarToggleButton buttonInvert;
    private ToolBarButton buttonRotateSx;
    private ToolBarButton buttonRotateDx;
    private ToolBarButton buttonZoomPlus;
    private ToolBarButton buttonZoomMinus;
    private ToolBarToggleButton buttonZoomRect;
    private ToolBarButton buttonCustom;

    public ToolToolBar(MainContainer mainContainer, ViewerManager viewerManager, String constraints, int orientation) {
        super(mainContainer, viewerManager, constraints, orientation);
    }

    protected void initialize() {
        super.initialize();
        this.toolBar.setName("Strumenti");
        this.buttonSave = ToolBarButton.makeButton(this, "btn_Save", SAVEAS, "Salva con nome...", "Salva");
        this.toolBar.add(this.buttonSave);
        this.buttonPrint = ToolBarButton.makeButton(this, "btn_Printer", PRINT, "Stampa", "Stampa");
        this.toolBar.add(this.buttonPrint);
        this.buttonPrintSel = ToolBarToggleButton.makeButton(this, "btn_Print_Selection", PRINTSEL, "Seleziona e stampa", "Seleziona e stampa");
        this.toolBar.add(this.buttonPrintSel);
        this.toolBar.addSeparator();
        this.buttonFitWindow = ToolBarButton.makeButton(this, "btn_Winscale", FITWINDOW, "Adatta alla finestra", "Adatta alla finestra");
        this.toolBar.add(this.buttonFitWindow);
        this.buttonFitHorizontal = ToolBarButton.makeButton(this, "btn_Horscale", FITHORIZONTAL, "Adatta orizzontale", "Adatta orizzontale");
        this.toolBar.add(this.buttonFitHorizontal);
        this.buttonFitVertical = ToolBarButton.makeButton(this, "btn_Verscale", FITVERTICAL, "Adatta Verticale", "Adatta verticale");
        this.toolBar.add(this.buttonFitVertical);
        this.buttonActualSize = ToolBarButton.makeButton(this, "btn_1to1", ACTUALSIZE, "Dimensioni reali", "Dimensioni reali");
        this.toolBar.add(this.buttonActualSize);
        this.toolBar.addSeparator();
        this.buttonInvert = ToolBarToggleButton.makeButton(this, "btn_Invert", INVERT, "Inverti", "Inverti");
        this.toolBar.add(this.buttonInvert);
        this.toolBar.addSeparator();
        this.buttonRotateDx = ToolBarButton.makeButton(this, "btn_RotationDX", ROTATEDX, "Ruota 90\u221e a destra", "Ruota 90\u221e a destra");
        this.toolBar.add(this.buttonRotateDx);
        this.buttonRotateSx = ToolBarButton.makeButton(this, "btn_RotationSX", ROTATESX, "Ruota 90\u221e a sinistra", "Ruota 90\u221e a sinistra");
        this.toolBar.add(this.buttonRotateSx);
        this.toolBar.addSeparator();
        this.buttonZoomRect = ToolBarToggleButton.makeButton(this, "btn_Rectangle", ZOOMRECT, "Ingrandisci selezione", "Ingrandisci selezione");
        this.toolBar.add(this.buttonZoomRect);
        this.toolBar.addSeparator();
        this.buttonZoomPlus = ToolBarButton.makeButton(this, "btn_Zoomplus", ZOOMPLUS, "Maggior dettaglio", "Maggior dettaglio");
        this.toolBar.add(this.buttonZoomPlus);
        this.buttonZoomMinus = ToolBarButton.makeButton(this, "btn_Zoomminus", ZOOMMINUS, "Minor dettaglio", "Minor dettaglio");
        this.toolBar.add(this.buttonZoomMinus);
        this.toolBar.addSeparator();
        this.buttonCustom = ToolBarButton.makeButton(this, "btn_InOut", CUSTOMFUNC, "Massimizza/minimizza", "Massimizza/minimizza");
        this.toolBar.add(this.buttonCustom);
        this.add((Component)this.toolBar, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (SAVEAS.equals(cmd)) {
            this.viewerManager.save();
        }
        if (PRINT.equals(cmd)) {
            this.viewerManager.printFull();
        }
        if (PRINTSEL.equals(cmd)) {
            if (this.buttonPrintSel.isSelected()) {
                this.viewerManager.setMouseMode(2);
            } else if (this.buttonZoomRect.isSelected()) {
                this.viewerManager.setMouseMode(1);
            } else {
                this.viewerManager.setMouseMode(0);
            }
        }
        if (FITWINDOW.equals(cmd)) {
            this.viewerManager.setDisplayMode(1);
        }
        if (FITHORIZONTAL.equals(cmd)) {
            this.viewerManager.setDisplayMode(2);
        }
        if (FITVERTICAL.equals(cmd)) {
            this.viewerManager.setDisplayMode(3);
        }
        if (ACTUALSIZE.equals(cmd)) {
            this.viewerManager.setDisplayMode(0);
        }
        if (INVERT.equals(cmd)) {
            this.viewerManager.invertBitmap();
        }
        if (ROTATESX.equals(cmd)) {
            this.viewerManager.rotateBitmap(-1);
        }
        if (ROTATEDX.equals(cmd)) {
            this.viewerManager.rotateBitmap(1);
        }
        if (ZOOMRECT.equals(cmd)) {
            if (this.buttonZoomRect.isSelected()) {
                this.viewerManager.setMouseMode(1);
            } else if (this.buttonPrintSel.isSelected()) {
                this.viewerManager.setMouseMode(2);
            } else {
                this.viewerManager.setMouseMode(0);
            }
        }
        if (ZOOMPLUS.equals(cmd)) {
            this.viewerManager.zoomUp();
        }
        if (ZOOMMINUS.equals(cmd)) {
            this.viewerManager.zoomDown();
        }
        if (CUSTOMFUNC.equals(cmd)) {
            this.viewerManager.toggleFrame();
        }
    }

    public void setPrintVisible(boolean visible) {
        this.buttonPrint.setVisible(visible);
        this.buttonPrintSel.setVisible(visible);
    }

    public void setSaveVisible(boolean visible) {
        this.buttonSave.setVisible(visible);
    }

    public void setFullScreenVisible(boolean visible) {
        this.buttonCustom.setVisible(visible);
    }
}

