/*
 * Decompiled with CFR 0.152.
 */
package mx.encrypter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import mx.encrypter.LogCipherInputStream;
import mx.encrypter.LogCipherOutputStream;

public class Encrypter {
    private Cipher blowfish;
    private SecretKeySpec key;

    public Encrypter(byte[] key) {
        this.key = new SecretKeySpec(key, "Blowfish");
        this.loadBlowfish();
    }

    public Encrypter() {
        this.loadBlowfish();
    }

    private void loadBlowfish() {
        try {
            this.blowfish = Cipher.getInstance("Blowfish");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("[Encrypter][loadBlowfish] NoSuchAlgorithmException : " + e);
        }
        catch (NoSuchPaddingException e) {
            System.err.println("[Encrypter][loadBlowfish] NoSuchAlgorithmException : " + e);
        }
    }

    public static byte[] generateKey() {
        byte[] raw = null;
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("Blowfish");
            SecretKey skey = kgen.generateKey();
            raw = skey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("[Encrypter][generateKey]" + e);
            e.printStackTrace();
        }
        return raw;
    }

    public void setKey(byte[] key) {
        this.key = new SecretKeySpec(key, "Blowfish");
    }

    public void encryptFile(File inputFile, File outputFile) {
        try {
            this.blowfish.init(1, this.key);
            FileOutputStream fOS = new FileOutputStream(outputFile);
            CipherOutputStream oS = new CipherOutputStream(fOS, this.blowfish);
            FileInputStream fIS = new FileInputStream(inputFile);
            int numRead = 0;
            while ((numRead = ((InputStream)fIS).read()) != -1) {
                ((OutputStream)oS).write(numRead);
            }
            ((InputStream)fIS).close();
            ((OutputStream)oS).close();
            fOS.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("[Encrypter][encryptFile] FileNotFoundException : " + e);
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            System.err.println("[Encrypter][encryptFile] InvalidKeyException : " + e);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("[Encrypter][encryptFile] IOException : " + e);
            e.printStackTrace();
        }
    }

    public void decryptFile(File inputFile, File outputFile) {
        try {
            this.blowfish.init(2, this.key);
            FileInputStream fIS = new FileInputStream(inputFile);
            CipherInputStream iS = new CipherInputStream(fIS, this.blowfish);
            FileOutputStream fOS = new FileOutputStream(outputFile);
            int numRead = 0;
            while ((numRead = iS.read()) != -1) {
                fOS.write(numRead);
            }
            iS.close();
            ((InputStream)fIS).close();
            fOS.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("[Encrypter][encryptFile] FileNotFoundException : " + e);
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            System.err.println("[Encrypter][encryptFile] InvalidKeyException : " + e);
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("[Encrypter][encryptFile] IOException : " + e);
            e.printStackTrace();
        }
    }

    public LogCipherInputStream decryptStream(InputStream fIS) {
        LogCipherInputStream iS = null;
        try {
            this.blowfish.init(2, this.key);
            iS = new LogCipherInputStream(fIS, this.blowfish);
        }
        catch (InvalidKeyException e) {
            System.err.println("[Encrypter][decryptStream] InvalidKeyException : " + e);
            e.printStackTrace();
        }
        return iS;
    }

    public LogCipherOutputStream encryptStream(OutputStream fOS) {
        LogCipherOutputStream oS = null;
        try {
            this.blowfish.init(1, this.key);
            oS = new LogCipherOutputStream(fOS, this.blowfish);
        }
        catch (InvalidKeyException e) {
            System.err.println("[Encrypter][encryptStream] InvalidKeyException : " + e);
            e.printStackTrace();
        }
        return oS;
    }
}

