/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.applet;

import java.applet.Applet;
import java.awt.Container;
import java.util.Vector;
import javax.swing.JApplet;
import mx.viewer.applet.ImageInfo;
import mx.viewer.manager.ImageManager;
import mx.viewer.manager.ViewerManager;
import mx.viewer.toolBar.ToolBarNavigazioneJavascript;
import mx.viewer.util.GenPassword;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class SftViewerApplet
extends JApplet {
    private static final long serialVersionUID = 8315394329203222885L;
    private ViewerManager vm = null;
    private int imageLayout = 1;
    private Vector images = null;
    private String imageDir = "";
    private boolean isEmbedded = true;
    private int panelCount = 1;
    private int displayMode = 1;
    private int current = -1;
    private boolean viewSave = false;
    private boolean viewPrint = false;
    private boolean viewToolbarNavigation = false;
    private boolean viewToolbarNavigationAuto = false;
    private String toolBarNavigationChiamate = "";
    private boolean viewToolbarTools = false;
    private boolean fullScreenVisual = true;
    private String title = "Visualizzatore";

    public void init() {
        JSObject win = null;
        this.vm = new ViewerManager();
        this.parseParameters();
        if (this.viewToolbarNavigationAuto) {
            try {
                win = JSObject.getWindow((Applet)this);
            }
            catch (JSException e) {
                e.printStackTrace();
            }
            this.vm.setNavigationToolBarAutomatic(this.viewToolbarNavigationAuto, new ToolBarNavigazioneJavascript(win, this.toolBarNavigationChiamate, this.vm.getMainContainer()));
        }
        this.vm.setImageLayout(this.imageLayout);
        this.vm.setDisplayMode(this.displayMode);
        int i = 0;
        while (i < this.images.size()) {
            ImageInfo immagine = (ImageInfo)this.images.get(i);
            this.vm.getToolBarNavigazione().addImage(new ImageManager(this.imageDir, immagine.getCaption(), immagine.getFileName(), immagine.getPassword(), immagine.isOtp(), this.getContentPane()));
            ++i;
        }
        i = 0;
        while (i < this.panelCount) {
            this.vm.addPanel();
            ++i;
        }
        Container contentPane = this.getContentPane();
        this.vm.setContainer(contentPane, "Center");
        this.vm.setTitle(this.title);
        this.vm.setSaveVisible(this.viewSave);
        this.vm.setPrintVisible(this.viewPrint);
        this.vm.setFullScreenVisible(this.fullScreenVisual);
        this.vm.setNavigationToolBarVisible(this.viewToolbarNavigation);
        this.vm.setToolToolBarVisible(this.viewToolbarTools);
    }

    public void setCurrent(int current) {
        this.current = current;
        if (current >= 0) {
            this.vm.getToolBarNavigazione().setCurrent(current);
        }
    }

    public void viewImage(String fileNames) {
        this.vm.viewImage(this.imageDir, fileNames, "", false);
    }

    public void destroy() {
        this.vm.closeMe();
    }

    public void start() {
        if (!this.isEmbedded) {
            this.vm.toggleFrame();
        }
        if (this.current >= 0) {
            this.vm.getToolBarNavigazione().setCurrent(this.current);
        }
    }

    protected void parseParameters() {
        String paramValue;
        int i = 0;
        this.images = new Vector();
        String paramName = "IMAGE" + i;
        ImageInfo image = null;
        while ((paramValue = this.getParameter(paramName)) != null) {
            image = new ImageInfo(paramValue);
            paramName = "CAPTION" + i;
            paramValue = this.getParameter(paramName);
            if (paramValue != null) {
                image.setCaption(paramValue);
            }
            if ((paramValue = this.getParameter(paramName = "PASSWORD" + i)) != null) {
                image.setPassword(paramValue);
            } else {
                paramName = "PASSWORD";
                paramValue = this.getParameter(paramName);
                if (paramValue != null) {
                    if (paramValue.equalsIgnoreCase("OTP")) {
                        paramValue = GenPassword.getPassword();
                        image.setOtp(true);
                    }
                    image.setPassword(paramValue);
                }
            }
            this.images.addElement(image);
            paramName = "IMAGE" + ++i;
        }
        String imageDir = this.getParameter("IMAGEDIR");
        this.imageDir = imageDir != null ? imageDir : "";
        paramName = "TITLE";
        paramValue = this.getParameter(paramName);
        if (this.title != null) {
            this.title = paramValue;
        }
        if ((paramValue = this.getParameter(paramName = "LAYOUT")) != null) {
            this.imageLayout = Integer.parseInt(paramValue);
        }
        if ((paramValue = this.getParameter(paramName = "PANELS")) != null) {
            this.panelCount = Integer.parseInt(paramValue);
        }
        if ((paramValue = this.getParameter(paramName = "EMBED")) != null) {
            boolean bl = this.isEmbedded = Integer.parseInt(paramValue) == 1;
        }
        if ((paramValue = this.getParameter(paramName = "CURRENT")) != null) {
            this.current = Integer.parseInt(paramValue);
        }
        if ((paramValue = this.getParameter(paramName = "DISPLAYMODE")) != null) {
            this.displayMode = Integer.parseInt(paramValue);
        }
        if ((paramValue = this.getParameter(paramName = "BUTTONSAVE")) != null) {
            this.viewSave = paramValue.equals("1");
        }
        if ((paramValue = this.getParameter(paramName = "BUTTONPRINT")) != null) {
            this.viewPrint = paramValue.equals("1");
        }
        if ((paramValue = this.getParameter(paramName = "TOOLBARNAVIGATION")) != null) {
            if (paramValue.equals("Auto")) {
                this.viewToolbarNavigation = false;
                this.viewToolbarNavigationAuto = true;
                this.toolBarNavigationChiamate = this.getParameter("TOOLBAR_NAVIGATION_CHIAMATE") == null || this.getParameter("TOOLBAR_NAVIGATION_CHIAMATE").equals("") ? "" : this.getParameter("TOOLBAR_NAVIGATION_CHIAMATE");
            } else {
                this.viewToolbarNavigation = paramValue.equals("1");
                this.viewToolbarNavigationAuto = false;
            }
        }
        if ((paramValue = this.getParameter(paramName = "TOOLBARTOOLS")) != null) {
            this.viewToolbarTools = paramValue.equals("1");
        }
        if ((paramValue = this.getParameter(paramName = "FULLSCREEN")) != null && !this.viewToolbarNavigationAuto) {
            this.fullScreenVisual = paramValue.equals("1");
        }
    }
}

