/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.application;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import mx.viewer.application.ImageInfo;
import mx.viewer.manager.ImageManager;
import mx.viewer.manager.ViewerManager;
import mx.viewer.util.GenPassword;

public class SftViewerApplication
extends JFrame {
    private static final long serialVersionUID = 7258481811948057465L;
    private ViewerManager vm = null;
    private int imageLayout = 1;
    private Vector images = null;
    private String imageDir = "";
    private boolean isEmbedded = true;
    private int panelCount = 1;
    private int displayMode = 1;
    private int current = -1;
    private boolean viewSave = false;
    private boolean viewPrint = false;
    private boolean viewToolbarNavigation = true;
    private boolean viewToolbarTools = true;
    private int width = 500;
    private int height = 500;
    private Properties properties = new Properties();
    private Container contentPane;
    private String title = "Visualizzatore";
    private JMenuBar menuBar = null;
    private JMenu mFile = null;
    private JMenuItem miOpen = null;
    private JMenuItem miQuit = null;

    public static void main(String[] args) {
        SftViewerApplication view = null;
        try {
            view = new SftViewerApplication(args[0]);
            view.init();
            view.start();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SftViewerApplication() throws FileNotFoundException, IOException {
        this("NewSftViewer.properties");
        this.init();
    }

    public SftViewerApplication(String propertiesFileName) throws FileNotFoundException, IOException {
        this(new FileInputStream(propertiesFileName));
    }

    public SftViewerApplication(FileInputStream propertyFileStream) throws IOException {
        this.properties.load(propertyFileStream);
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
    }

    public void viewImage(String fileNames) {
        this.vm.viewImage(this.imageDir, fileNames, "", false);
    }

    protected void viewImage(File fileName) {
        this.imageDir = "file:///" + fileName.getParent().replaceAll("\\", "/") + "/";
        this.viewImage(fileName.getName());
    }

    public void viewImage(String pathImg, String fileNames) {
        this.imageDir = pathImg;
        this.viewImage(fileNames);
    }

    public void init() {
        this.vm = new ViewerManager();
        this.parseParameters();
        this.setTitle(this.title);
        this.vm.setImageLayout(this.imageLayout);
        this.vm.setDisplayMode(this.displayMode);
        int i = 0;
        while (i < this.images.size()) {
            ImageInfo immagine = (ImageInfo)this.images.get(i);
            this.vm.getToolBarNavigazione().addImage(new ImageManager(this.imageDir, immagine.getCaption(), immagine.getFileName(), immagine.getPassword(), immagine.isOtp(), this.contentPane));
            ++i;
        }
        i = 0;
        while (i < this.panelCount) {
            this.vm.addPanel();
            ++i;
        }
        this.vm.setContainer(this.contentPane, "Center");
        this.vm.setTitle(this.title);
    }

    public void start() {
        this.vm.setSaveVisible(this.viewSave);
        this.vm.setPrintVisible(this.viewPrint);
        this.vm.setNavigationToolBarVisible(this.viewToolbarNavigation);
        this.vm.setToolToolBarVisible(this.viewToolbarTools);
        this.setSize(this.width, this.height);
        this.setVisible(true);
        if (!this.isEmbedded) {
            this.vm.toggleFrame();
        }
        if (this.current >= 0) {
            this.vm.getToolBarNavigazione().setCurrent(this.current);
        }
        this.menuBar = new JMenuBar();
        this.mFile = new JMenu("File");
        this.mFile.setMnemonic(70);
        this.menuBar.add(this.mFile);
        this.miOpen = new JMenuItem("Open");
        this.miOpen.setMnemonic(79);
        this.miOpen.addActionListener(new BrowserFile(this));
        this.mFile.add(this.miOpen);
        this.mFile.addSeparator();
        this.miQuit = new JMenuItem("Quit");
        this.miQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.miQuit.setMnemonic(81);
        this.mFile.add(this.miQuit);
        this.setJMenuBar(this.menuBar);
    }

    public void RunMe() {
        this.init();
        this.start();
    }

    protected void parseParameters() {
        String paramValue;
        int i = 0;
        this.images = new Vector();
        String paramName = "IMAGE" + i;
        ImageInfo image = null;
        while ((paramValue = this.getParameter(paramName)) != null) {
            image = new ImageInfo(paramValue);
            paramName = "CAPTION" + i;
            paramValue = this.getParameter(paramName);
            if (paramValue != null) {
                image.setCaption(paramValue);
            }
            if ((paramValue = this.getParameter(paramName = "PASSWORD" + i)) != null) {
                image.setPassword(paramValue);
            } else {
                paramName = "PASSWORD";
                paramValue = this.getParameter(paramName);
                if (paramValue != null) {
                    if (paramValue.equalsIgnoreCase("OTP")) {
                        paramValue = GenPassword.getPassword();
                        image.setOtp(true);
                    }
                    image.setPassword(paramValue);
                }
            }
            this.images.addElement(image);
            paramName = "IMAGE" + ++i;
        }
        String imageDir = this.getParameter("IMAGEDIR");
        this.imageDir = imageDir != null ? imageDir : "";
        paramName = "WIDTH";
        paramValue = this.getParameter(paramName);
        if (paramValue != null) {
            this.width = Integer.parseInt(paramValue);
        }
        if ((paramValue = this.getParameter(paramName = "HEIGHT")) != null) {
            this.height = Integer.parseInt(paramValue);
        }
        paramName = "TITLE";
        paramValue = this.getParameter(paramName);
        if (this.title != null) {
            this.title = paramValue;
        }
        if ((paramValue = this.getParameter(paramName = "LAYOUT")) != null) {
            this.imageLayout = Integer.parseInt(paramValue);
        }
        if ((paramValue = this.getParameter(paramName = "PANELS")) != null) {
            this.panelCount = Integer.parseInt(paramValue);
        }
        if ((paramValue = this.getParameter(paramName = "EMBED")) != null) {
            boolean bl = this.isEmbedded = Integer.parseInt(paramValue) == 1;
        }
        if ((paramValue = this.getParameter(paramName = "CURRENT")) != null) {
            this.current = Integer.parseInt(paramValue);
        }
        if ((paramValue = this.getParameter(paramName = "DISPLAYMODE")) != null) {
            this.displayMode = Integer.parseInt(paramValue);
        }
        if ((paramValue = this.getParameter(paramName = "BUTTONSAVE")) != null) {
            this.viewSave = paramValue.equals("1");
        }
        if ((paramValue = this.getParameter(paramName = "BUTTONPRINT")) != null) {
            this.viewPrint = paramValue.equals("1");
        }
        if ((paramValue = this.getParameter(paramName = "TOOLBARNAVIGATION")) != null) {
            this.viewToolbarNavigation = paramValue.equals("1");
        }
        if ((paramValue = this.getParameter(paramName = "TOOLBARTOOLS")) != null) {
            this.viewToolbarTools = paramValue.equals("1");
        }
    }

    private String getParameter(String paramName) {
        return this.properties.getProperty(paramName);
    }

    class BrowserFile
    implements ActionListener {
        private SftViewerApplication parent = null;

        public BrowserFile(SftViewerApplication parent) {
            this.parent = parent;
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setCurrentDirectory(new File(this.parent.imageDir.replaceAll("file:///", "")));
            int returnVal = chooser.showOpenDialog(this.parent);
            if (returnVal == 0) {
                this.parent.viewImage(chooser.getSelectedFile());
            }
        }
    }
}

