/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import mx.viewer.gui.IconPanelToolPopupMenu;
import mx.viewer.gui.IconScrollPanel;
import mx.viewer.manager.DisplayIconManager;
import mx.viewer.manager.PanManager;
import mx.viewer.manager.Pannable;
import mx.viewer.manager.Selectable;
import mx.viewer.manager.SelectionManager;

public class IconLabel
extends JLabel
implements Pannable,
Selectable {
    private static final long serialVersionUID = -5572637017723579881L;
    public static final int MM_PAN = 0;
    public static final int MM_SELECT = 1;
    public static final int MM_PRINTSELECT = 2;
    public static final int MINZOOM = 5;
    public static final int MAXZOOM = 5000;
    private IconScrollPanel iconScrollPanel = null;
    private DisplayIconManager labelIcon = null;
    private PanManager panManager = null;
    private SelectionManager selectionManager = null;
    private IconPanelToolPopupMenu iconPanelToolPopupMenu = null;
    private int mouseMode = 0;
    private Rectangle paintRect = null;
    private int requestScrollX = -1;
    private int requestScrollY = -1;

    public IconLabel(IconScrollPanel iconScrollPanel) {
        this.iconScrollPanel = iconScrollPanel;
        this.panManager = new PanManager(this);
        this.selectionManager = new SelectionManager(this);
        this.iconPanelToolPopupMenu = new IconPanelToolPopupMenu(this);
        this.initialize();
    }

    protected void initialize() {
        this.requestScrollX = -1;
        this.requestScrollY = -1;
        this.setHorizontalAlignment(0);
        this.panManager.activate();
    }

    public void setIcon(DisplayIconManager icon) {
        this.labelIcon = icon;
        super.setIcon(icon);
    }

    public Icon getIcon() {
        return this.labelIcon;
    }

    private Rectangle getIconRect() {
        return this.labelIcon.getImageRect();
    }

    public int getMouseMode() {
        return this.mouseMode;
    }

    public void setMouseMode(int mouseMode) {
        if (this.getMouseMode() == 0) {
            this.panManager.deActivate();
        }
        if (this.getMouseMode() == 1) {
            this.selectionManager.deActivate();
        }
        if (this.getMouseMode() == 2) {
            this.selectionManager.deActivate();
        }
        this.mouseMode = mouseMode;
        if (this.getMouseMode() == 0) {
            this.panManager.activate();
        }
        if (this.getMouseMode() == 1) {
            this.selectionManager.activate();
        }
        if (this.getMouseMode() == 2) {
            this.selectionManager.activate();
        }
    }

    public void setToolPopupMenuEnable(boolean enable) {
        this.iconPanelToolPopupMenu.setActive(enable);
    }

    public void setPrintVisible(boolean visible) {
        this.iconPanelToolPopupMenu.setPrintVisible(visible);
    }

    public void setSaveVisible(boolean visible) {
        this.iconPanelToolPopupMenu.setSaveVisible(visible);
    }

    public void setDisplayMode(int displayMode) {
        this.iconScrollPanel.setDisplayMode(displayMode);
    }

    public void save() {
        this.iconScrollPanel.save();
    }

    public void printFull() {
        this.iconScrollPanel.printPage();
    }

    public void zoomUp() {
        this.iconScrollPanel.zoomUp();
    }

    public void zoomDown() {
        this.iconScrollPanel.zoomDown();
    }

    public void invertBitmap() {
        this.iconScrollPanel.invertBitmap();
    }

    public void rotateBitmap(int direction) {
        this.iconScrollPanel.rotateBitmap(direction);
    }

    void showInfo() {
        this.iconScrollPanel.showInfo();
    }

    public void scrollImage(int x, int y) {
        this.iconScrollPanel.scrollPanel(x, y);
    }

    public boolean isInImageRect(Point p) {
        return this.getIconRect().contains(p);
    }

    public void beginSelection(Rectangle paintRect) {
    }

    public void setSelectionRect(Rectangle paintRect) {
        this.paintRect = paintRect;
    }

    public void endSelection(Rectangle paintRect) {
        int newZoom = 0;
        this.paintRect = null;
        if (this.getIcon() != null) {
            if (this.getMouseMode() == 1) {
                paintRect.x -= this.labelIcon.getOriginX();
                paintRect.y -= this.labelIcon.getOriginY();
                newZoom = this.labelIcon.getZoomToRect(paintRect, this.iconScrollPanel.getClientWidth(), this.iconScrollPanel.getClientHeight());
                if (newZoom < 5000) {
                    this.iconScrollPanel.setZoom(newZoom);
                    this.requestScrollX = new Float((float)paintRect.x * this.labelIcon.getXScaleFactor()).intValue();
                    this.requestScrollY = new Float((float)paintRect.y * this.labelIcon.getYScaleFactor()).intValue();
                }
            }
            if (this.getMouseMode() == 2) {
                paintRect.x = new Float((float)(paintRect.x - this.labelIcon.getOriginX()) / this.labelIcon.getXScaleFactor()).intValue();
                paintRect.y = new Float((float)(paintRect.y - this.labelIcon.getOriginY()) / this.labelIcon.getYScaleFactor()).intValue();
                paintRect.width = new Float((float)paintRect.width / this.labelIcon.getXScaleFactor()).intValue();
                paintRect.height = new Float((float)paintRect.height / this.labelIcon.getYScaleFactor()).intValue();
                this.iconScrollPanel.printSelection(paintRect);
            }
        } else {
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.paintRect != null) {
            g.setColor(Color.red);
            g.drawRect(this.paintRect.x, this.paintRect.y, this.paintRect.width, this.paintRect.height);
        }
        if (this.requestScrollX >= 0 && this.requestScrollY >= 0) {
            this.iconScrollPanel.scrollPanelTo(this.requestScrollX, this.requestScrollY);
            this.requestScrollX = -1;
            this.requestScrollY = -1;
        }
    }
}

