/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.manager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.swing.Icon;

public class DisplayIconManager
implements Icon {
    public static final int IM_DISPLAY_ACTUAL_SIZE = 0;
    public static final int IM_DISPLAY_FIT_TO_WINDOW = 1;
    public static final int IM_DISPLAY_FIT_TO_WIDTH = 2;
    public static final int IM_DISPLAY_FIT_TO_HEIGHT = 3;
    public static final int IM_DISPLAY_FIT_TO_ZOOM = 4;
    protected RenderedImage im;
    protected SampleModel sampleModel;
    protected ColorModel colorModel;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected Rectangle imageBounds;
    protected int minTileX;
    protected int maxTileX;
    protected int minTileY;
    protected int maxTileY;
    protected int tileWidth;
    protected int tileHeight;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    private Color backgroundColor = null;
    private Rectangle imageRect = new Rectangle(-1, -1, 0, 0);
    private float xScaleFactor = 0.0f;
    private float yScaleFactor = 0.0f;
    private int zoom;

    public DisplayIconManager(RenderedImage anImage, ParameterBlock pbInput) {
        this.im = anImage;
        this.computeScaleFactor(anImage, pbInput);
        this.sampleModel = this.im.getSampleModel();
        this.colorModel = this.im.getColorModel();
        if (this.colorModel == null) {
            this.colorModel = PlanarImage.createColorModel((SampleModel)this.im.getSampleModel());
        }
        if (this.colorModel == null) {
            throw new IllegalArgumentException("Formato immagine non supportato.");
        }
        if (this.colorModel.getTransparency() != 1) {
            Object col = this.im.getProperty("background_color");
            this.backgroundColor = col != null ? (Color)col : new Color(0, 0, 0);
        }
        this.minX = this.im.getMinX();
        this.minY = this.im.getMinY();
        this.width = this.im.getWidth();
        this.height = this.im.getHeight();
        this.imageBounds = new Rectangle(this.minX, this.minY, this.width, this.height);
        this.minTileX = this.im.getMinTileX();
        this.maxTileX = this.im.getMinTileX() + this.im.getNumXTiles() - 1;
        this.minTileY = this.im.getMinTileY();
        this.maxTileY = this.im.getMinTileY() + this.im.getNumYTiles() - 1;
        this.tileWidth = this.im.getTileWidth();
        this.tileHeight = this.im.getTileHeight();
        this.tileGridXOffset = this.im.getTileGridXOffset();
        this.tileGridYOffset = this.im.getTileGridYOffset();
    }

    private void computeScaleFactor(RenderedImage anImage, ParameterBlock pbInput) {
        float realImgHeight;
        int dm = pbInput.getIntParameter(0);
        float DevWidth = pbInput.getFloatParameter(1);
        float DevHeight = pbInput.getFloatParameter(2);
        Dimension dimScrollBars = (Dimension)pbInput.getObjectParameter(3);
        int Zoom = pbInput.getIntParameter(4);
        float realImgWidth = pbInput.getFloatParameter(5);
        if (realImgWidth == -1.0f) {
            realImgWidth = anImage.getWidth();
        }
        if ((realImgHeight = pbInput.getFloatParameter(6)) == -1.0f) {
            realImgHeight = anImage.getHeight();
        }
        float ImgWidth = realImgWidth;
        float ImgHeight = realImgHeight;
        if (dm == 0) {
            ImgWidth = realImgWidth;
            ImgHeight = realImgHeight;
        }
        if (dm == 1) {
            if (ImgHeight / DevHeight > ImgWidth / DevWidth) {
                ImgWidth = ImgWidth * DevHeight / ImgHeight;
                ImgHeight = DevHeight;
            } else {
                ImgHeight = ImgHeight * DevWidth / ImgWidth;
                ImgWidth = DevWidth;
            }
        }
        if (dm == 2) {
            ImgHeight = ImgHeight * DevWidth / ImgWidth;
            ImgWidth = DevWidth;
            if (ImgHeight > DevHeight) {
                ImgHeight = ImgHeight * (DevWidth -= (float)dimScrollBars.width) / ImgWidth;
                ImgWidth = DevWidth;
                while (ImgHeight < DevHeight) {
                    ImgHeight = ImgHeight * (DevWidth += 1.0f) / ImgWidth;
                    ImgWidth = DevWidth;
                }
                if (ImgHeight > DevHeight) {
                    ImgHeight = ImgHeight * (DevWidth -= 1.0f) / ImgWidth;
                    ImgWidth = DevWidth;
                }
            }
        }
        if (dm == 3) {
            ImgWidth = ImgWidth * DevHeight / ImgHeight;
            ImgHeight = DevHeight;
            if (ImgWidth > DevWidth) {
                ImgWidth = ImgWidth * (DevHeight -= (float)dimScrollBars.height) / ImgHeight;
                ImgHeight = DevHeight;
                while (ImgWidth < DevWidth) {
                    ImgWidth = ImgWidth * (DevHeight += 1.0f) / ImgHeight;
                    ImgHeight = DevHeight;
                }
                if (ImgWidth > DevWidth) {
                    ImgWidth = ImgWidth * (DevHeight -= 1.0f) / ImgHeight;
                    ImgHeight = DevHeight;
                }
            }
        }
        if (dm == 4) {
            ImgHeight = ImgHeight * (float)Zoom / 100.0f;
            ImgWidth = ImgWidth * (float)Zoom / 100.0f;
        }
        this.setXScaleFactor(ImgWidth / realImgWidth);
        this.setYScaleFactor(ImgHeight / realImgHeight);
        this.setZoom(new Float(this.getXScaleFactor() * 100.0f).intValue());
    }

    public RenderedImage createScaledImage(RenderedImage anImage, ParameterBlock pbInput) {
        RenderedOp newImage = null;
        this.computeScaleFactor(anImage, pbInput);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(anImage);
        pb.add(this.getXScaleFactor());
        pb.add(this.getYScaleFactor());
        pb.add(0.0f);
        pb.add(0.0f);
        newImage = JAI.create((String)"scale", (ParameterBlock)pb);
        return newImage;
    }

    public int getZoomToRect(Rectangle selection, float DevWidth, float DevHeight) {
        float ImgWidth;
        selection.x = new Float((float)selection.x / this.getXScaleFactor()).intValue();
        selection.y = new Float((float)selection.y / this.getYScaleFactor()).intValue();
        float realImgWidth = (float)selection.width / this.getXScaleFactor();
        float realImgHeight = (float)selection.height / this.getYScaleFactor();
        float ImgHeight = realImgHeight;
        if (ImgHeight / DevHeight > (ImgWidth = realImgWidth) / DevWidth) {
            ImgWidth = ImgWidth * DevHeight / ImgHeight;
            ImgHeight = DevHeight;
        } else {
            ImgHeight = ImgHeight * DevWidth / ImgWidth;
            ImgWidth = DevWidth;
        }
        return new Float(ImgWidth / realImgWidth * 100.0f).intValue();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2D = null;
        if (!(g instanceof Graphics2D)) {
            System.err.println("Not Graphics2D.");
            return;
        }
        g2D = (Graphics2D)g;
        Rectangle clipBounds = g.getClipBounds();
        if (clipBounds == null) {
            clipBounds = new Rectangle(0, 0, c.getWidth(), c.getHeight());
        }
        double xRatio = this.getXScaleFactor();
        double yRatio = this.getYScaleFactor();
        AffineTransform at = new AffineTransform();
        at.translate(x, y);
        at.scale(xRatio, yRatio);
        g2D.drawRenderedImage(this.im, at);
        this.setImageRect(x, y, this.getIconWidth(), this.getIconHeight());
    }

    private void setImageRect(int x, int y, int width, int height) {
        this.imageRect = new Rectangle(x, y, width, height);
    }

    public Rectangle getImageRect() {
        return this.imageRect;
    }

    public Point getOrigin() {
        return new Point(this.imageRect.x, this.imageRect.y);
    }

    public int getOriginX() {
        return this.imageRect.x;
    }

    public int getOriginY() {
        return this.imageRect.y;
    }

    public int getIconWidth() {
        return new Float((float)this.im.getWidth() * this.getXScaleFactor()).intValue();
    }

    public int getIconHeight() {
        return new Float((float)this.im.getHeight() * this.getYScaleFactor()).intValue();
    }

    public float getXScaleFactor() {
        return this.xScaleFactor;
    }

    public void setXScaleFactor(float xScaleFactor) {
        this.xScaleFactor = xScaleFactor;
    }

    public float getYScaleFactor() {
        return this.yScaleFactor;
    }

    public void setYScaleFactor(float yScaleFactor) {
        this.yScaleFactor = yScaleFactor;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        this.zoom = zoom;
    }
}

