/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.manager;

import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Vector;
import mx.viewer.manager.IconManager;

public class ImageManager {
    private String caption = "";
    private Vector iconList = null;
    private String password = "";
    private boolean load;

    private void initialize() {
        this.iconList = new Vector();
    }

    public ImageManager(String basePath, String caption, String fileNames, String password, Component component) {
        this.counstruct(basePath, caption, fileNames, password, false, component);
    }

    public ImageManager(String basePath, String caption, String fileNames, String password, boolean otp, Component component) {
        this.counstruct(basePath, caption, fileNames, password, otp, component);
    }

    private void counstruct(String basePath, String caption, String fileNames, String password, boolean otp, Component componet) {
        String fileName = "";
        this.initialize();
        this.setCaption(caption);
        this.setPassword(password);
        this.setLoad(false);
        String[] listOfFileNames = fileNames.split(";");
        int i = 0;
        while (i < listOfFileNames.length) {
            fileName = String.valueOf(basePath) + listOfFileNames[i];
            if (otp) {
                try {
                    fileName = String.valueOf(fileName) + "&pwd=" + URLEncoder.encode(this.getPassword(), "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    fileName = String.valueOf(fileName) + "&pwd=" + this.getPassword();
                }
            }
            this.addIcon(new IconManager(fileName, this.getPassword(), componet));
            ++i;
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLoad(boolean load) {
        if (!load && this.isLoad()) {
            int i = 0;
            while (i < this.iconCount()) {
                if (this.getIcon(i).getBitmap() != null) {
                    this.getIcon(i).setBitmap(null);
                }
                ++i;
            }
        }
        this.load = load;
    }

    public boolean isLoad() {
        return this.load;
    }

    public int addIcon(IconManager icon) {
        this.iconList.add(icon);
        return this.iconList.size();
    }

    public IconManager getIcon(int n) {
        return (IconManager)this.iconList.get(n);
    }

    public int iconCount() {
        return this.iconList.size();
    }
}

