/*
 * Decompiled with CFR 0.152.
 */
package mx.viewer.manager;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import mx.viewer.manager.CursorManager;
import mx.viewer.manager.Pannable;

public class PanManager
implements MouseListener,
MouseMotionListener {
    private Pannable panel = null;
    private Point mouseOrigin = null;
    private boolean isPanning = false;
    private Cursor handCursor = null;
    private Cursor handCursorClosed = null;
    private Cursor oldPanelCursor = null;
    private boolean activated = false;

    public PanManager(Pannable panel) {
        this.panel = panel;
        this.initialize();
    }

    private void initialize() {
        this.mouseOrigin = new Point(0, 0);
        this.handCursor = CursorManager.loadMouseCursor("crs_hand");
        this.handCursorClosed = CursorManager.loadMouseCursor("crs_hand_closed");
        this.panel.addMouseListener(this);
        this.panel.addMouseMotionListener(this);
    }

    public void activate() {
        this.oldPanelCursor = this.panel.getCursor();
        this.panel.setCursor(this.handCursor);
        this.activated = true;
    }

    public void deActivate() {
        this.panel.setCursor(this.oldPanelCursor);
        this.activated = false;
    }

    private void setMouseOrigin(MouseEvent e) {
        Component comp = e.getComponent();
        Point onScreen = comp.getLocationOnScreen();
        this.mouseOrigin.x = e.getX() + onScreen.x;
        this.mouseOrigin.y = e.getY() + onScreen.y;
    }

    private Point getMousePosition(MouseEvent e) {
        Component comp = e.getComponent();
        Point onScreen = comp.getLocationOnScreen();
        return new Point(e.getX() + onScreen.x, e.getY() + onScreen.y);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.activated) {
            this.setMouseOrigin(e);
            this.panel.setCursor(this.handCursorClosed);
            this.isPanning = true;
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.activated) {
            this.isPanning = false;
            this.panel.setCursor(this.handCursor);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.activated) {
            Point mousePosition = null;
            int x = 0;
            int y = 0;
            if (this.isPanning) {
                mousePosition = this.getMousePosition(e);
                x = mousePosition.x - this.mouseOrigin.x;
                y = mousePosition.y - this.mouseOrigin.y;
                this.setMouseOrigin(e);
                this.panel.scrollImage(-x, -y);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }
}

